/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleFactor3NTTStrategy
extends DoubleModMath
implements ParallelNTTStrategy {
    private NTTStrategy factor2Strategy;

    public DoubleFactor3NTTStrategy(NTTStrategy nTTStrategy) {
        this.factor2Strategy = nTTStrategy;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        if (this.factor2Strategy instanceof ParallelNTTStrategy) {
            ((ParallelNTTStrategy)this.factor2Strategy).setParallelRunner(parallelRunner);
        }
    }

    public void transform(DataStorage dataStorage, int n) throws ApfloatRuntimeException {
        long l = dataStorage.getSize();
        long l2 = l & -l;
        if (l > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + l + " > " + 0x180000000000L);
        }
        if (l == l2) {
            this.factor2Strategy.transform(dataStorage, n);
        } else {
            assert (l == 3L * l2);
            this.setModulus(DoubleModConstants.MODULUS[n]);
            double d = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], l);
            double d2 = this.modPow(d, l2);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l2);
            DataStorage dataStorage3 = dataStorage.subsequence(l2, l2);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l2, l2);
            this.transformColumns(false, dataStorage2, dataStorage3, dataStorage4, l2, d, d2);
            this.factor2Strategy.transform(dataStorage2, n);
            this.factor2Strategy.transform(dataStorage3, n);
            this.factor2Strategy.transform(dataStorage4, n);
        }
    }

    public void inverseTransform(DataStorage dataStorage, int n, long l) throws ApfloatRuntimeException {
        long l2 = dataStorage.getSize();
        long l3 = l2 & -l2;
        if (Math.max(l2, l) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(l2, l) + " > " + 0x180000000000L);
        }
        if (l2 == l3) {
            this.factor2Strategy.inverseTransform(dataStorage, n, l);
        } else {
            assert (l2 == 3L * l3);
            this.setModulus(DoubleModConstants.MODULUS[n]);
            double d = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[n], l2);
            double d2 = this.modPow(d, l3);
            DataStorage dataStorage2 = dataStorage.subsequence(0L, l3);
            DataStorage dataStorage3 = dataStorage.subsequence(l3, l3);
            DataStorage dataStorage4 = dataStorage.subsequence(2L * l3, l3);
            this.factor2Strategy.inverseTransform(dataStorage2, n, l);
            this.factor2Strategy.inverseTransform(dataStorage3, n, l);
            this.factor2Strategy.inverseTransform(dataStorage4, n, l);
            this.transformColumns(true, dataStorage2, dataStorage3, dataStorage4, l3, d, d2);
        }
    }

    public long getTransformLength(long l) {
        return Util.round23up(l);
    }

    private void transformColumns(boolean bl, DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, long l, double d, double d2) throws ApfloatRuntimeException {
        DataStorage.Iterator iterator = dataStorage.iterator(3, 0L, l);
        DataStorage.Iterator iterator2 = dataStorage2.iterator(3, 0L, l);
        DataStorage.Iterator iterator3 = dataStorage3.iterator(3, 0L, l);
        double d3 = this.modMultiply(d, d);
        double d4 = this.negate(this.modDivide(3.0, 2.0));
        double d5 = this.modAdd(d2, this.modDivide(1.0, 2.0));
        double d6 = 1.0;
        double d7 = 1.0;
        while (l > 0L) {
            double d8 = iterator.getDouble();
            double d9 = iterator2.getDouble();
            double d10 = iterator3.getDouble();
            if (bl) {
                d9 = this.modMultiply(d9, d6);
                d10 = this.modMultiply(d10, d7);
            }
            double d11 = this.modAdd(d9, d10);
            d10 = this.modSubtract(d9, d10);
            d8 = this.modAdd(d8, d11);
            d11 = this.modMultiply(d11, d4);
            d10 = this.modMultiply(d10, d5);
            d11 = this.modAdd(d11, d8);
            d9 = this.modAdd(d11, d10);
            d10 = this.modSubtract(d11, d10);
            if (!bl) {
                d9 = this.modMultiply(d9, d6);
                d10 = this.modMultiply(d10, d7);
            }
            iterator.setDouble(d8);
            iterator2.setDouble(d9);
            iterator3.setDouble(d10);
            iterator.next();
            iterator2.next();
            iterator3.next();
            d6 = this.modMultiply(d6, d);
            d7 = this.modMultiply(d7, d3);
            --l;
        }
    }
}

