/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DiskDataStorage;
import org.apfloat.internal.DoubleMatrix;
import org.apfloat.internal.DoubleMemoryArrayAccess;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;

public class DoubleDiskDataStorage
extends DiskDataStorage {
    private static final long serialVersionUID = 342871486421108657L;

    public DoubleDiskDataStorage() throws ApfloatRuntimeException {
    }

    protected DoubleDiskDataStorage(DoubleDiskDataStorage doubleDiskDataStorage, long l, long l2) {
        super(doubleDiskDataStorage, l, l2);
    }

    protected DataStorage implSubsequence(long l, long l2) throws ApfloatRuntimeException {
        return new DoubleDiskDataStorage(this, l + this.getOffset(), l2);
    }

    protected ArrayAccess implGetArray(int n, long l, int n2) throws ApfloatRuntimeException {
        return new DoubleDiskArrayAccess(n, this.getOffset() + l, n2);
    }

    protected synchronized ArrayAccess implGetTransposedArray(int n, int n2, int n3, int n4) throws ApfloatRuntimeException {
        TransposedMemoryArrayAccess transposedMemoryArrayAccess;
        block8: {
            int n5 = (int)(this.getSize() / (long)n4);
            if (n3 != (n3 & -n3) || n4 != (n4 & -n4) || n2 + n3 > n5) {
                throw new ApfloatInternalException("Invalid size");
            }
            int n6 = n3 * n4;
            int n7 = Math.min(n3, n4);
            transposedMemoryArrayAccess = new TransposedMemoryArrayAccess(n, new double[n6], n2, n3, n4);
            if ((n & 1) == 0) break block8;
            if (n3 < n4) {
                long l = n2;
                for (int i = 0; i < n4; i += n7) {
                    int n8 = i;
                    for (int j = 0; j < n7; ++j) {
                        this.readToArray(l, transposedMemoryArrayAccess, n8, n7);
                        l += (long)n5;
                        n8 += n4;
                    }
                    ArrayAccess arrayAccess = ((ArrayAccess)transposedMemoryArrayAccess).subsequence(i, n6 - i);
                    DoubleMatrix.transposeSquare(arrayAccess, n7, n4);
                }
            } else {
                int n9;
                for (n9 = 0; n9 < n7; ++n9) {
                    long l = n2 + n9 * n5;
                    int n10 = n9 * n7;
                    for (int i = 0; i < n3; i += n7) {
                        this.readToArray(l, transposedMemoryArrayAccess, n10, n7);
                        l += (long)n7;
                        n10 += n7 * n7;
                    }
                }
                for (n9 = 0; n9 < n6; n9 += n7 * n7) {
                    ArrayAccess arrayAccess = ((ArrayAccess)transposedMemoryArrayAccess).subsequence(n9, n6 - n9);
                    DoubleMatrix.transposeSquare(arrayAccess, n7, n7);
                }
            }
        }
        return transposedMemoryArrayAccess;
    }

    private synchronized void setTransposedArray(ArrayAccess arrayAccess, int n, int n2, int n3) throws ApfloatRuntimeException {
        int n4 = (int)(this.getSize() / (long)n3);
        int n5 = arrayAccess.getLength();
        int n6 = Math.min(n2, n3);
        if (n2 < n3) {
            long l = n;
            for (int i = 0; i < n3; i += n6) {
                int n7 = i;
                ArrayAccess arrayAccess2 = arrayAccess.subsequence(i, n5 - i);
                DoubleMatrix.transposeSquare(arrayAccess2, n6, n3);
                for (int j = 0; j < n6; ++j) {
                    this.writeFromArray(arrayAccess, n7, l, n6);
                    n7 += n3;
                    l += (long)n4;
                }
            }
        } else {
            int n8;
            for (n8 = 0; n8 < n5; n8 += n6 * n6) {
                ArrayAccess arrayAccess3 = arrayAccess.subsequence(n8, n5 - n8);
                DoubleMatrix.transposeSquare(arrayAccess3, n6, n6);
            }
            for (n8 = 0; n8 < n6; ++n8) {
                long l = n + n8 * n4;
                int n9 = n8 * n6;
                for (int i = 0; i < n2; i += n6) {
                    this.writeFromArray(arrayAccess, n9, l, n6);
                    n9 += n6 * n6;
                    l += (long)n6;
                }
            }
        }
    }

    private void readToArray(long l, ArrayAccess arrayAccess, int n, int n2) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess2 = this.getArray(1, l, n2);
        System.arraycopy(arrayAccess2.getData(), arrayAccess2.getOffset(), arrayAccess.getData(), arrayAccess.getOffset() + n, n2);
        arrayAccess2.close();
    }

    private void writeFromArray(ArrayAccess arrayAccess, int n, long l, int n2) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess2 = this.getArray(2, l, n2);
        System.arraycopy(arrayAccess.getData(), arrayAccess.getOffset() + n, arrayAccess2.getData(), arrayAccess2.getOffset(), n2);
        arrayAccess2.close();
    }

    public DataStorage.Iterator iterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
        if ((n & 3) == 0) {
            throw new IllegalArgumentException("Illegal mode: " + n);
        }
        return new BlockIterator(n, l, l2);
    }

    protected int getUnitSize() {
        return 8;
    }

    private class BlockIterator
    extends DataStorage.AbstractIterator {
        private ArrayAccess arrayAccess;
        private double[] data;
        private int offset;
        private int remaining;

        public BlockIterator(int n, long l, long l2) throws IllegalArgumentException, IllegalStateException, ApfloatRuntimeException {
            super(DoubleDiskDataStorage.this, n, l, l2);
            this.arrayAccess = null;
            this.remaining = 0;
        }

        public void next() throws IllegalStateException, ApfloatRuntimeException {
            this.checkLength();
            assert (this.remaining > 0);
            this.checkAvailable();
            this.offset += this.getIncrement();
            --this.remaining;
            if (this.remaining == 0) {
                this.close();
            }
            super.next();
        }

        public double getDouble() throws IllegalStateException, ApfloatRuntimeException {
            this.checkGet();
            this.checkAvailable();
            return this.data[this.offset];
        }

        public void setDouble(double d) throws IllegalStateException, ApfloatRuntimeException {
            this.checkSet();
            this.checkAvailable();
            this.data[this.offset] = d;
        }

        public void close() throws ApfloatRuntimeException {
            if (this.arrayAccess != null) {
                this.data = null;
                this.arrayAccess.close();
                this.arrayAccess = null;
            }
        }

        private void checkAvailable() throws ApfloatRuntimeException {
            if (this.arrayAccess == null) {
                boolean bl = this.getIncrement() > 0;
                int n = (int)Math.min(this.getLength(), (long)(DiskDataStorage.getBlockSize() / 8));
                long l = bl ? this.getPosition() : this.getPosition() - (long)n + 1L;
                this.arrayAccess = DoubleDiskDataStorage.this.getArray(this.getMode(), l, n);
                this.data = this.arrayAccess.getDoubleData();
                this.offset = this.arrayAccess.getOffset() + (bl ? 0 : n - 1);
                this.remaining = n;
            }
        }
    }

    private class TransposedMemoryArrayAccess
    extends DoubleMemoryArrayAccess {
        private static final long serialVersionUID = -3746109883682965310L;
        private int mode;
        private int startColumn;
        private int columns;
        private int rows;

        public TransposedMemoryArrayAccess(int n, double[] dArray, int n2, int n3, int n4) {
            super(dArray, 0, dArray.length);
            this.mode = n;
            this.startColumn = n2;
            this.columns = n3;
            this.rows = n4;
        }

        public void close() throws ApfloatRuntimeException {
            if ((this.mode & 2) != 0 && this.getData() != null) {
                DoubleDiskDataStorage.this.setTransposedArray(this, this.startColumn, this.columns, this.rows);
            }
            super.close();
        }
    }

    private class DoubleDiskArrayAccess
    extends DoubleMemoryArrayAccess {
        private static final long serialVersionUID = -7097317279839657081L;
        private int mode;
        private long fileOffset;

        public DoubleDiskArrayAccess(int n, long l, int n2) throws ApfloatRuntimeException {
            super(new double[n2], 0, n2);
            this.mode = n;
            this.fileOffset = l;
            if ((n & 1) != 0) {
                final double[] dArray = this.getDoubleData();
                WritableByteChannel writableByteChannel = new WritableByteChannel(){
                    private int readPosition = 0;

                    public int write(ByteBuffer byteBuffer) {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        int n = doubleBuffer.remaining();
                        doubleBuffer.get(dArray, this.readPosition, n);
                        this.readPosition += n;
                        byteBuffer.position(byteBuffer.position() + n * 8);
                        return n * 8;
                    }

                    public void close() {
                    }

                    public boolean isOpen() {
                        return true;
                    }
                };
                DoubleDiskDataStorage.this.transferTo(writableByteChannel, l * 8L, (long)n2 * 8L);
            }
        }

        public void close() throws ApfloatRuntimeException {
            if ((this.mode & 2) != 0 && this.getData() != null) {
                final double[] dArray = this.getDoubleData();
                ReadableByteChannel readableByteChannel = new ReadableByteChannel(){
                    private int writePosition = 0;

                    public int read(ByteBuffer byteBuffer) {
                        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
                        int n = doubleBuffer.remaining();
                        doubleBuffer.put(dArray, this.writePosition, n);
                        this.writePosition += n;
                        byteBuffer.position(byteBuffer.position() + n * 8);
                        return n * 8;
                    }

                    public void close() {
                    }

                    public boolean isOpen() {
                        return true;
                    }
                };
                DoubleDiskDataStorage.this.transferFrom(readableByteChannel, this.fileOffset * 8L, (long)dArray.length * 8L);
            }
            super.close();
        }
    }
}

