/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleDiskDataStorage;
import org.apfloat.internal.DoubleMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= (long)apfloatContext.getMemoryTreshold()) {
            return new DoubleMemoryDataStorage();
        }
        return new DoubleDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        if (l <= apfloatContext.getMaxMemoryBlockSize()) {
            return new DoubleMemoryDataStorage();
        }
        return new DoubleDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext;
        long l;
        if (dataStorage instanceof DoubleMemoryDataStorage && (l = dataStorage.getSize()) > (long)(apfloatContext = ApfloatContext.getContext()).getMemoryTreshold()) {
            DoubleDiskDataStorage doubleDiskDataStorage = new DoubleDiskDataStorage();
            doubleDiskDataStorage.copyFrom(dataStorage);
            dataStorage = doubleDiskDataStorage;
        }
        return dataStorage;
    }
}

