/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.internal.Double3NTTConvolutionStrategy;
import org.apfloat.internal.DoubleKaratsubaConvolutionStrategy;
import org.apfloat.internal.DoubleMediumConvolutionStrategy;
import org.apfloat.internal.DoubleShortConvolutionStrategy;
import org.apfloat.spi.ConvolutionBuilder;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.NTTBuilder;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleConvolutionBuilder
implements ConvolutionBuilder {
    private static final double LOG2_3 = Math.log(3.0) / Math.log(2.0);

    public ConvolutionStrategy createConvolution(int n, long l, long l2, long l3) {
        float f;
        long l4 = Math.min(l, l2);
        long l5 = Math.max(l, l2);
        long l6 = l + l2;
        if (l4 == 1L) {
            return new DoubleShortConvolutionStrategy(n);
        }
        if (l4 <= 15L) {
            return new DoubleMediumConvolutionStrategy(n);
        }
        float f2 = (float)l4 * (float)l5;
        float f3 = 4.3f * (float)Math.pow(l4, LOG2_3) * (float)l5 / (float)l4;
        if (f2 <= Math.min(f3, f = 6.2f * (float)l6 * (float)Util.log2down(l6))) {
            return new DoubleMediumConvolutionStrategy(n);
        }
        if (f3 <= f) {
            return new DoubleKaratsubaConvolutionStrategy(n);
        }
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        NTTBuilder nTTBuilder = apfloatContext.getBuilderFactory().getNTTBuilder();
        NTTStrategy nTTStrategy = nTTBuilder.createNTT(l6);
        return new Double3NTTConvolutionStrategy(n, nTTStrategy);
    }
}

