/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.math.BigInteger;
import java.util.RandomAccess;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleCRTMath;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.MessagePasser;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class DoubleCarryCRT
extends DoubleCRTMath {
    private static final long serialVersionUID = -3954870352092656433L;
    private static final DoubleModMath MATH_MOD_0 = new DoubleModMath();
    private static final DoubleModMath MATH_MOD_1 = new DoubleModMath();
    private static final DoubleModMath MATH_MOD_2 = new DoubleModMath();
    private static final double T0;
    private static final double T1;
    private static final double T2;
    private static final double[] M01;
    private static final double[] M02;
    private static final double[] M12;
    private static final double[] M012;
    private ParallelRunner parallelRunner;

    public DoubleCarryCRT(int n) {
        super(n);
    }

    public DataStorage carryCRT(final DataStorage dataStorage, final DataStorage dataStorage2, final DataStorage dataStorage3, final long l) throws ApfloatRuntimeException {
        Object object;
        final long l2 = Math.min(l + 2L, dataStorage.getSize());
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        final DataStorage dataStorage4 = dataStorageBuilder.createDataStorage(l * 8L);
        dataStorage4.setSize(l);
        final MessagePasser<Long, double[]> messagePasser = new MessagePasser<Long, double[]>();
        if (l2 <= Integer.MAX_VALUE && this.parallelRunner != null && dataStorage instanceof RandomAccess && dataStorage2 instanceof RandomAccess && dataStorage3 instanceof RandomAccess && dataStorage4 instanceof RandomAccess) {
            object = new ParallelRunnable(){

                public int getLength() {
                    return (int)l2;
                }

                public Runnable getRunnable(int n, int n2) {
                    return new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, n, n2, messagePasser);
                }
            };
            this.parallelRunner.runParallel((ParallelRunnable)object);
        } else {
            new CarryCRTRunnable(dataStorage, dataStorage2, dataStorage3, dataStorage4, l2, l, 0L, l2, messagePasser).run();
        }
        object = null;
        assert ((object = messagePasser.getMessage(l2)) != null);
        assert ((object).length == 2);
        assert (object[0] == 0.0);
        assert (object[1] == 0.0);
        return dataStorage4;
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    private static DataStorage.Iterator arrayIterator(final double[] dArray) {
        return new DataStorage.Iterator(){
            private int position;
            {
                this.position = dArray.length - 1;
            }

            public boolean hasNext() {
                return true;
            }

            public void next() {
                --this.position;
            }

            public double getDouble() {
                assert (this.position >= 0);
                return dArray[this.position];
            }

            public void setDouble(double d) {
                assert (this.position >= 0);
                dArray[this.position] = d;
            }
        };
    }

    private static DataStorage.Iterator compositeIterator(final DataStorage.Iterator iterator, final long l, final DataStorage.Iterator iterator2) {
        return new DataStorage.Iterator(){
            private long position;

            public boolean hasNext() {
                return this.position < l ? iterator.hasNext() : iterator2.hasNext();
            }

            public void next() {
                (this.position < l ? iterator : iterator2).next();
                ++this.position;
            }

            public double getDouble() {
                return (this.position < l ? iterator : iterator2).getDouble();
            }

            public void setDouble(double d) {
                (this.position < l ? iterator : iterator2).setDouble(d);
            }

            public void close() throws ApfloatRuntimeException {
                (this.position < l ? iterator : iterator2).close();
            }
        };
    }

    static {
        MATH_MOD_0.setModulus(DoubleModConstants.MODULUS[0]);
        MATH_MOD_1.setModulus(DoubleModConstants.MODULUS[1]);
        MATH_MOD_2.setModulus(DoubleModConstants.MODULUS[2]);
        BigInteger bigInteger = BigInteger.valueOf(Math.abs(0x8000000000000L));
        BigInteger bigInteger2 = BigInteger.valueOf((long)DoubleModConstants.MODULUS[0]);
        BigInteger bigInteger3 = BigInteger.valueOf((long)DoubleModConstants.MODULUS[1]);
        BigInteger bigInteger4 = BigInteger.valueOf((long)DoubleModConstants.MODULUS[2]);
        BigInteger bigInteger5 = bigInteger2.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger4);
        T0 = bigInteger7.modInverse(bigInteger2).doubleValue();
        T1 = bigInteger6.modInverse(bigInteger3).doubleValue();
        T2 = bigInteger5.modInverse(bigInteger4).doubleValue();
        M01 = new double[2];
        M02 = new double[2];
        M12 = new double[2];
        M012 = new double[3];
        BigInteger[] bigIntegerArray = bigInteger5.divideAndRemainder(bigInteger);
        DoubleCarryCRT.M01[0] = bigIntegerArray[0].doubleValue();
        DoubleCarryCRT.M01[1] = bigIntegerArray[1].doubleValue();
        bigIntegerArray = bigInteger6.divideAndRemainder(bigInteger);
        DoubleCarryCRT.M02[0] = bigIntegerArray[0].doubleValue();
        DoubleCarryCRT.M02[1] = bigIntegerArray[1].doubleValue();
        bigIntegerArray = bigInteger7.divideAndRemainder(bigInteger);
        DoubleCarryCRT.M12[0] = bigIntegerArray[0].doubleValue();
        DoubleCarryCRT.M12[1] = bigIntegerArray[1].doubleValue();
        bigIntegerArray = bigInteger2.multiply(bigInteger7).divideAndRemainder(bigInteger);
        DoubleCarryCRT.M012[2] = bigIntegerArray[1].doubleValue();
        bigIntegerArray = bigIntegerArray[0].divideAndRemainder(bigInteger);
        DoubleCarryCRT.M012[0] = bigIntegerArray[0].doubleValue();
        DoubleCarryCRT.M012[1] = bigIntegerArray[1].doubleValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CarryCRTRunnable
    implements Runnable {
        private DataStorage resultMod0;
        private DataStorage resultMod1;
        private DataStorage resultMod2;
        private DataStorage dataStorage;
        private long size;
        private long resultSize;
        private long offset;
        private long length;
        private MessagePasser<Long, double[]> messagePasser;

        public CarryCRTRunnable(DataStorage dataStorage, DataStorage dataStorage2, DataStorage dataStorage3, DataStorage dataStorage4, long l, long l2, long l3, long l4, MessagePasser<Long, double[]> messagePasser) {
            this.resultMod0 = dataStorage;
            this.resultMod1 = dataStorage2;
            this.resultMod2 = dataStorage3;
            this.dataStorage = dataStorage4;
            this.size = l;
            this.resultSize = l2;
            this.offset = l3;
            this.length = l4;
            this.messagePasser = messagePasser;
        }

        @Override
        public void run() {
            double d;
            long l = this.offset == 0L ? this.size - this.resultSize + 1L : 0L;
            long l2 = this.offset + this.length == this.size ? 1 : 0;
            long l3 = 1L - l2;
            long l4 = this.length - l + l2;
            long l5 = this.size - this.offset;
            long l6 = l5 - this.length;
            long l7 = this.size - this.offset - this.length + l3 + l4;
            long l8 = l7 - l4;
            DataStorage.Iterator iterator = this.resultMod0.iterator(1, l5, l6);
            DataStorage.Iterator iterator2 = this.resultMod1.iterator(1, l5, l6);
            DataStorage.Iterator iterator3 = this.resultMod2.iterator(1, l5, l6);
            DataStorage.Iterator iterator4 = this.dataStorage.iterator(2, l7, l8);
            double[] dArray = new double[3];
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            for (long i = 0L; i < this.length; ++i) {
                d = MATH_MOD_0.modMultiply(T0, iterator.getDouble());
                double d2 = MATH_MOD_1.modMultiply(T1, iterator2.getDouble());
                double d3 = MATH_MOD_2.modMultiply(T2, iterator3.getDouble());
                DoubleCarryCRT.this.multiply(M12, d, dArray2);
                DoubleCarryCRT.this.multiply(M02, d2, dArray3);
                if (DoubleCarryCRT.this.add(dArray3, dArray2) != 0.0 || DoubleCarryCRT.this.compare(dArray2, M012) >= 0.0) {
                    DoubleCarryCRT.this.subtract(M012, dArray2);
                }
                DoubleCarryCRT.this.multiply(M01, d3, dArray3);
                if (DoubleCarryCRT.this.add(dArray3, dArray2) != 0.0 || DoubleCarryCRT.this.compare(dArray2, M012) >= 0.0) {
                    DoubleCarryCRT.this.subtract(M012, dArray2);
                }
                DoubleCarryCRT.this.add(dArray2, dArray);
                double d4 = DoubleCarryCRT.this.divide(dArray);
                if (i >= l) {
                    iterator4.setDouble(d4);
                    iterator4.next();
                }
                iterator.next();
                iterator2.next();
                iterator3.next();
            }
            double d5 = DoubleCarryCRT.this.divide(dArray);
            d = dArray[2];
            assert (dArray[0] == 0.0);
            assert (dArray[1] == 0.0);
            if (l4 == this.length - l + 1L) {
                iterator4.setDouble(d5);
                iterator4.close();
                d5 = d;
                assert (d == 0.0);
            }
            double[] dArray4 = new double[]{d, d5};
            if (this.offset > 0L) {
                double[] dArray5 = this.messagePasser.receiveMessage(this.offset);
                DataStorage.Iterator iterator5 = DoubleCarryCRT.arrayIterator(dArray5);
                iterator4 = DoubleCarryCRT.compositeIterator(this.dataStorage.iterator(3, l7, l8), l4, DoubleCarryCRT.arrayIterator(dArray4));
                double d6 = DoubleCarryCRT.this.baseAdd(iterator4, iterator5, 0.0, iterator4, dArray5.length);
                d6 = this.baseCarry(iterator4, d6, l4);
                iterator4.close();
                assert (d6 == 0.0);
            }
            this.messagePasser.sendMessage(this.offset + this.length, dArray4);
        }

        private double baseCarry(DataStorage.Iterator iterator, double d, long l) {
            for (long i = 0L; i < l && d > 0.0; ++i) {
                d = DoubleCarryCRT.this.baseAdd(iterator, null, d, iterator, 1L);
            }
            return d;
        }
    }
}

