/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.DoubleBaseMath;
import org.apfloat.internal.DoubleRadixConstants;

public class DoubleCRTMath
extends DoubleBaseMath {
    private static final long serialVersionUID = -8414531999881223922L;
    private static final long BASE_MASK = 0x7FFFFFFFFFFFFL;
    private static final double INVERSE_2_64 = 5.421010862427522E-20;
    private long base;
    private double inverseBase;

    public DoubleCRTMath(int n) {
        super(n);
        this.base = (long)DoubleRadixConstants.BASE[n];
        this.inverseBase = 1.0 / DoubleRadixConstants.BASE[n];
    }

    public final void multiply(double[] dArray, double d, double[] dArray2) {
        long l = (long)dArray[1] * (long)d;
        long l2 = (long)((dArray[1] * d + (double)(l & Long.MIN_VALUE)) * 5.421010862427522E-20);
        l2 = l2 << 13 | l >>> 51;
        dArray2[2] = l & 0x7FFFFFFFFFFFFL;
        l = (long)dArray[0] * (long)d + l2;
        l2 = (long)((dArray[0] * d + (double)l2 + (double)(l & Long.MIN_VALUE)) * 5.421010862427522E-20);
        l2 = l2 << 13 | l >>> 51;
        dArray2[1] = l & 0x7FFFFFFFFFFFFL;
        dArray2[0] = l2;
    }

    public final double compare(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        if (d != 0.0) {
            return d;
        }
        d = dArray[1] - dArray2[1];
        if (d != 0.0) {
            return d;
        }
        return dArray[2] - dArray2[2];
    }

    public final double add(double[] dArray, double[] dArray2) {
        double d = dArray2[2] + dArray[2];
        double d2 = d >= 2.251799813685248E15 ? 1 : 0;
        dArray2[2] = d = d >= 2.251799813685248E15 ? d - 2.251799813685248E15 : d;
        d = dArray2[1] + dArray[1] + d2;
        d2 = d >= 2.251799813685248E15 ? 1 : 0;
        dArray2[1] = d = d >= 2.251799813685248E15 ? d - 2.251799813685248E15 : d;
        d = dArray2[0] + dArray[0] + d2;
        d2 = d >= 2.251799813685248E15 ? 1 : 0;
        dArray2[0] = d = d >= 2.251799813685248E15 ? d - 2.251799813685248E15 : d;
        return d2;
    }

    public final void subtract(double[] dArray, double[] dArray2) {
        double d = dArray2[2] - dArray[2];
        double d2 = d < 0.0 ? 1 : 0;
        dArray2[2] = d = d < 0.0 ? d + 2.251799813685248E15 : d;
        d = dArray2[1] - dArray[1] - d2;
        d2 = d < 0.0 ? 1 : 0;
        dArray2[1] = d = d < 0.0 ? d + 2.251799813685248E15 : d;
        d = dArray2[0] - dArray[0] - d2;
        dArray2[0] = d = d < 0.0 ? d + 2.251799813685248E15 : d;
    }

    public final double divide(double[] dArray) {
        long l = ((long)dArray[0] << 51) + (long)dArray[1];
        long l2 = (long)((dArray[0] * 2.251799813685248E15 + dArray[1]) * this.inverseBase);
        long l3 = l - l2 * this.base;
        if (l3 >= this.base) {
            l3 -= this.base;
            ++l2;
        }
        if (l3 < 0L) {
            l3 += this.base;
            --l2;
        }
        dArray[0] = 0.0;
        dArray[1] = l2;
        l = (l3 << 51) + (long)dArray[2];
        l2 = (long)(((double)l3 * 2.251799813685248E15 + dArray[2]) * this.inverseBase);
        if ((l3 = l - l2 * this.base) >= this.base) {
            l3 -= this.base;
            ++l2;
        }
        if (l3 < 0L) {
            l3 += this.base;
            --l2;
        }
        dArray[2] = l2;
        return l3;
    }
}

