/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.Serializable;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleRadixConstants;
import org.apfloat.spi.DataStorage;

public class DoubleBaseMath
implements Serializable {
    private static final long serialVersionUID = 4560898425815362356L;
    private int radix;
    private double inverseBase;

    public DoubleBaseMath(int n) {
        this.radix = n;
        this.inverseBase = 1.0 / DoubleRadixConstants.BASE[n];
    }

    public double baseAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, double d, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        boolean bl = iterator == iterator3 || iterator2 == iterator3;
        double d2 = DoubleRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            double d3 = (iterator == null ? 0.0 : iterator.getDouble()) + d + (iterator2 == null ? 0.0 : iterator2.getDouble());
            if (d3 >= d2) {
                d3 -= d2;
                d = 1.0;
            } else {
                d = 0.0;
            }
            iterator3.setDouble(d3);
            if (iterator != null) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            if (bl) continue;
            iterator3.next();
        }
        return d;
    }

    public double baseSubtract(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, double d, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator == null || iterator != iterator2);
        assert (iterator2 != iterator3);
        double d2 = DoubleRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            double d3 = (iterator == null ? 0.0 : iterator.getDouble()) - d - (iterator2 == null ? 0.0 : iterator2.getDouble());
            if (d3 < 0.0) {
                d3 += d2;
                d = 1.0;
            } else {
                d = 0.0;
            }
            iterator3.setDouble(d3);
            if (iterator != null && iterator != iterator3) {
                iterator.next();
            }
            if (iterator2 != null) {
                iterator2.next();
            }
            iterator3.next();
        }
        return d;
    }

    public double baseMultiplyAdd(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, double d, double d2, DataStorage.Iterator iterator3, long l) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        assert (iterator != iterator3);
        double d3 = DoubleRadixConstants.BASE[this.radix];
        for (long i = 0L; i < l; ++i) {
            double d4;
            double d5 = iterator.getDouble();
            long l2 = (long)d5 * (long)(d4 = d) + (long)(d2 += iterator2 == null ? 0.0 : iterator2.getDouble());
            double d6 = l2 - (long)(d2 = (double)((long)((d5 * d4 + d2) * this.inverseBase))) * (long)d3;
            if (d6 >= d3) {
                d6 -= d3;
                d2 += 1.0;
            }
            if (d6 < 0.0) {
                d6 += d3;
                d2 -= 1.0;
            }
            iterator3.setDouble(d6);
            iterator.next();
            if (iterator2 != null && iterator2 != iterator3) {
                iterator2.next();
            }
            iterator3.next();
        }
        return d2;
    }

    public double baseDivide(DataStorage.Iterator iterator, double d, double d2, DataStorage.Iterator iterator2, long l) throws ApfloatRuntimeException {
        assert (iterator != iterator2);
        double d3 = DoubleRadixConstants.BASE[this.radix];
        double d4 = 1.0 / d;
        for (long i = 0L; i < l; ++i) {
            double d5;
            double d6 = iterator == null ? 0.0 : iterator.getDouble();
            long l2 = (long)d2 * (long)d3 + (long)d6;
            if ((d2 = (double)(l2 - (long)(d5 = (double)((long)((d2 * d3 + d6) * d4))) * (long)d)) >= d) {
                d2 -= d;
                d5 += 1.0;
            }
            if (d2 < 0.0) {
                d2 += d;
                d5 -= 1.0;
            }
            iterator2.setDouble(d5);
            if (iterator != null) {
                iterator.next();
            }
            iterator2.next();
        }
        return d2;
    }
}

