/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PushbackReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.OverflowException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleBaseMath;
import org.apfloat.internal.DoubleRadixConstants;
import org.apfloat.internal.ImplementationMismatchException;
import org.apfloat.internal.RadixMismatchException;
import org.apfloat.spi.ApfloatImpl;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.ConvolutionBuilder;
import org.apfloat.spi.ConvolutionStrategy;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;
import org.apfloat.spi.RadixConstants;
import org.apfloat.spi.Util;

public class DoubleApfloatImpl
extends DoubleBaseMath
implements ApfloatImpl {
    private static final DataStorage.Iterator ZERO_ITERATOR = new DataStorage.Iterator(){

        public double getDouble() {
            return 0.0;
        }

        public void next() {
        }
    };
    private static final long serialVersionUID = -4177541592360478544L;
    private static final int UNDEFINED = Integer.MIN_VALUE;
    private static final int MAX_LONG_SIZE = 4;
    private static final int MAX_DOUBLE_SIZE = 4;
    private int sign;
    private long precision;
    private long exponent;
    private DataStorage dataStorage;
    private int radix;
    private int hashCode = 0;
    private int initialDigits = Integer.MIN_VALUE;
    private long leastZeros = Integer.MIN_VALUE;

    private DoubleApfloatImpl(int n, long l, long l2, DataStorage dataStorage, int n2) {
        super(n2);
        assert (n == 0 || n == -1 || n == 1);
        assert (l > 0L);
        assert (n != 0 || l == Long.MAX_VALUE);
        assert (n != 0 || l2 == 0L);
        assert (n != 0 || dataStorage == null);
        assert (n == 0 || dataStorage != null);
        assert (l2 <= DoubleRadixConstants.MAX_EXPONENT[n2] && l2 >= -DoubleRadixConstants.MAX_EXPONENT[n2]);
        assert (dataStorage == null || dataStorage.isReadOnly());
        this.sign = n;
        this.precision = l;
        this.exponent = l2;
        this.dataStorage = dataStorage;
        this.radix = n2;
    }

    public DoubleApfloatImpl(String string, long l, int n, boolean bl) throws NumberFormatException, ApfloatRuntimeException {
        super(DoubleApfloatImpl.checkRadix(n));
        int n2;
        int n3;
        assert (l == Long.MIN_VALUE || l > 0L);
        this.radix = n;
        this.sign = 1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            int n10 = Character.digit((char)n2, n);
            if (n10 == -1) {
                if (n3 == 0 && (n2 == 45 || n2 == 43)) {
                    this.sign = n2 == 45 ? -1 : 1;
                    continue;
                }
                if (!bl && n2 == 46 && n5 == -1) {
                    n5 = n9;
                    continue;
                }
                if (!(bl || n2 != 101 && n2 != 69 || n6 != -1)) {
                    n6 = n3;
                    break;
                }
                throw new NumberFormatException("Invalid character: " + (char)n2 + " at position " + n3);
            }
            if (n7 == n9 && n10 == 0) {
                ++n7;
            } else if (n4 == -1) {
                n4 = n3;
            }
            ++n9;
            if (n10 == 0) {
                ++n8;
                continue;
            }
            n8 = 0;
        }
        if (n9 == 0) {
            throw new NumberFormatException("No digits");
        }
        if (n4 == -1) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        if (l == Long.MIN_VALUE) {
            assert (!bl);
            l = n9 - n7;
        }
        this.precision = l;
        n3 = (n5 >= 0 ? n5 : n9) - n7;
        if (n6 >= 0) {
            String string2 = string.substring(n6 + 1);
            if (string2.startsWith("+")) {
                string2 = string2.substring(1);
            }
            try {
                this.exponent = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("Invalid exponent: " + string2);
            }
        } else {
            this.exponent = 0L;
        }
        if (n3 >= -(n2 = DoubleRadixConstants.BASE_DIGITS[n]) && this.exponent >= Long.MAX_VALUE - (long)n3 - (long)n2) {
            throw new NumberFormatException("Exponent overflow");
        }
        if (n3 <= n2 && this.exponent <= Long.MIN_VALUE - (long)n3 + (long)n2) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.exponent += (long)n3;
        long l2 = (this.exponent + (long)(this.exponent > 0L ? DoubleRadixConstants.BASE_DIGITS[n] - 1 : 0)) / (long)DoubleRadixConstants.BASE_DIGITS[n];
        int n11 = (int)(l2 * (long)DoubleRadixConstants.BASE_DIGITS[n] - this.exponent);
        this.exponent = l2;
        n9 -= n7 + n8;
        n9 = (int)Math.min((long)n9, l);
        int n12 = (int)this.getBasePrecision(n9, DoubleRadixConstants.BASE_DIGITS[n] - n11);
        this.dataStorage = DoubleApfloatImpl.createDataStorage(n12);
        this.dataStorage.setSize(n12);
        double d = 0.0;
        DataStorage.Iterator iterator = this.dataStorage.iterator(2, 0L, n12);
        int n13 = n4;
        while (n9 > 0) {
            char c = string.charAt(n13);
            if (c != '.') {
                int n14 = Character.digit(c, n);
                d *= (double)n;
                d += (double)n14;
                if (n9 == 1) {
                    while (n11 < DoubleRadixConstants.BASE_DIGITS[n] - 1) {
                        d *= (double)n;
                        ++n11;
                    }
                }
                if (++n11 == DoubleRadixConstants.BASE_DIGITS[n]) {
                    n11 = 0;
                    iterator.setDouble(d);
                    iterator.next();
                    d = 0.0;
                }
                --n9;
            }
            ++n13;
        }
        assert (!iterator.hasNext());
        this.dataStorage.setReadOnly();
    }

    public DoubleApfloatImpl(long l, long l2, int n) throws NumberFormatException, ApfloatRuntimeException {
        super(DoubleApfloatImpl.checkRadix(n));
        long l3;
        int n2;
        assert (l2 > 0L);
        this.radix = n;
        if (l > 0L) {
            this.sign = 1;
            l = -l;
        } else if (l < 0L) {
            this.sign = -1;
        } else {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.precision = l2;
        double[] dArray = new double[4];
        long l4 = (long)DoubleRadixConstants.BASE[n];
        if (-l4 < l) {
            n2 = 1;
            dArray[3] = -l;
        } else {
            n2 = 0;
            while (l != 0L) {
                l3 = l / l4;
                dArray[3 - n2] = l3 * l4 - l;
                l = l3;
                ++n2;
            }
        }
        this.exponent = n2;
        l3 = this.getBasePrecision(l2, this.getDigits(dArray[4 - n2]));
        if (l3 < (long)n2) {
            n2 = (int)l3;
        }
        while (dArray[3 - (int)this.exponent + n2] == 0.0) {
            --n2;
        }
        this.dataStorage = DoubleApfloatImpl.createDataStorage(n2);
        this.dataStorage.setSize(n2);
        ArrayAccess arrayAccess = this.dataStorage.getArray(2, 0L, n2);
        System.arraycopy(dArray, 4 - (int)this.exponent, arrayAccess.getData(), arrayAccess.getOffset(), n2);
        arrayAccess.close();
        this.dataStorage.setReadOnly();
    }

    public DoubleApfloatImpl(double d, long l, int n) throws NumberFormatException, ApfloatRuntimeException {
        super(DoubleApfloatImpl.checkRadix(n));
        int n2;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException(d + " is not a valid number");
        }
        this.radix = n;
        if (d > 0.0) {
            this.sign = 1;
        } else if (d < 0.0) {
            this.sign = -1;
            d = -d;
        } else {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.precision = l;
        double[] dArray = new double[4];
        double d2 = DoubleRadixConstants.BASE[n];
        this.exponent = (long)Math.floor(Math.log(d) / Math.log(d2));
        if (this.exponent > 0L) {
            d *= Math.pow(d2, -this.exponent);
        } else if (this.exponent < 0L) {
            d *= Math.pow(d2, -this.exponent - 4L);
            d *= Math.pow(d2, 4.0);
        }
        ++this.exponent;
        if (d < 1.0) {
            d = 1.0;
        }
        for (n2 = 0; n2 < 4 && d > 0.0; d *= d2, ++n2) {
            double d3 = Math.floor(d);
            assert (d3 <= d2);
            if (d3 == d2) {
                d3 -= 1.0;
            }
            dArray[n2] = d3;
            d -= d3;
        }
        long l2 = this.getBasePrecision(l, this.getDigits(dArray[0]));
        if (l2 < (long)n2) {
            n2 = (int)l2;
        }
        while (dArray[n2 - 1] == 0.0) {
            --n2;
        }
        this.dataStorage = DoubleApfloatImpl.createDataStorage(n2);
        this.dataStorage.setSize(n2);
        ArrayAccess arrayAccess = this.dataStorage.getArray(2, 0L, n2);
        System.arraycopy(dArray, 0, arrayAccess.getData(), arrayAccess.getOffset(), n2);
        arrayAccess.close();
        this.dataStorage.setReadOnly();
    }

    private static long readExponent(PushbackReader pushbackReader) throws IOException, NumberFormatException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(20);
        long l = 0L;
        while ((n = pushbackReader.read()) != -1) {
            char c = (char)n;
            int n2 = Character.digit(c, 10);
            if ((l != 0L || c != '-') && n2 == -1) {
                pushbackReader.unread(n);
                break;
            }
            stringBuilder.append(c);
            ++l;
        }
        return Long.parseLong(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public DoubleApfloatImpl(PushbackReader pushbackReader, long l, int n, boolean bl) throws IOException, NumberFormatException, ApfloatRuntimeException {
        super(DoubleApfloatImpl.checkRadix(n));
        int n2;
        int n3;
        assert (l == Long.MIN_VALUE || l > 0L);
        this.radix = n;
        this.sign = 1;
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        long l2 = apfloatContext.getMemoryTreshold() / 8;
        long l3 = 0L;
        long l4 = l2;
        this.dataStorage = DoubleApfloatImpl.createDataStorage(l2);
        this.dataStorage.setSize(l2);
        double d = 0.0;
        int n4 = 0;
        DataStorage.Iterator iterator = this.dataStorage.iterator(2, l3, l4);
        long l5 = 0L;
        long l6 = -1L;
        long l7 = -1L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        while ((n3 = pushbackReader.read()) != -1) {
            block23: {
                int n5;
                block24: {
                    n2 = n3;
                    n5 = Character.digit((char)n2, n);
                    if (n5 != -1) break block24;
                    if (l11 == 0L && (n2 == 45 || n2 == 43)) {
                        this.sign = n2 == 45 ? -1 : 1;
                        break block23;
                    } else if (!bl && n2 == 46 && l7 == -1L) {
                        l7 = l10;
                        break block23;
                    } else {
                        if (!(bl || l10 <= 0L || n2 != 101 && n2 != 69)) {
                            this.exponent = DoubleApfloatImpl.readExponent(pushbackReader);
                            break;
                        }
                        pushbackReader.unread(n3);
                        break;
                    }
                }
                if (l8 == l10 && n5 == 0) {
                    ++l8;
                } else {
                    if (l6 == -1L) {
                        l6 = l11;
                    }
                    d *= (double)n;
                    d += (double)n5;
                    if (l5 == l4) {
                        if (l5 == l2) {
                            DataStorage dataStorage = DoubleApfloatImpl.createDataStorage(0xFFFFFFFFFFFFFFFL);
                            dataStorage.copyFrom(this.dataStorage, l5);
                            this.dataStorage = dataStorage;
                        }
                        l3 = l4;
                        this.dataStorage.setSize(l4 += (long)DoubleApfloatImpl.getBlockSize());
                        iterator.close();
                        iterator = this.dataStorage.iterator(2, l3, l4);
                    }
                    if (++n4 == DoubleRadixConstants.BASE_DIGITS[n]) {
                        n4 = 0;
                        iterator.setDouble(d);
                        iterator.next();
                        d = 0.0;
                        ++l5;
                    }
                }
                ++l10;
                l9 = n5 == 0 ? ++l9 : 0L;
            }
            ++l11;
        }
        if (l10 == 0L) {
            throw new NumberFormatException("No digits");
        }
        if (l6 == -1L) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        if (n4 > 0 && d != 0.0) {
            while (n4 < DoubleRadixConstants.BASE_DIGITS[n]) {
                d *= (double)n;
                ++n4;
            }
            iterator.setDouble(d);
            ++l5;
        }
        iterator.close();
        if (l == Long.MIN_VALUE) {
            assert (!bl);
            l = l10 - l8;
        }
        this.precision = l;
        l11 = (l7 >= 0L ? l7 : l10) - l8;
        if (l11 >= (long)(-(n2 = DoubleRadixConstants.BASE_DIGITS[n])) && this.exponent >= Long.MAX_VALUE - l11 - (long)n2) {
            throw new NumberFormatException("Exponent overflow");
        }
        if (l11 <= (long)n2 && this.exponent <= Long.MIN_VALUE - l11 + (long)n2) {
            this.sign = 0;
            this.precision = Long.MAX_VALUE;
            this.exponent = 0L;
            this.dataStorage = null;
            return;
        }
        this.exponent += l11;
        long l12 = (this.exponent - (long)(this.exponent < 0L ? DoubleRadixConstants.BASE_DIGITS[n] - 1 : 0)) / (long)DoubleRadixConstants.BASE_DIGITS[n];
        int n6 = (int)(this.exponent - l12 * (long)DoubleRadixConstants.BASE_DIGITS[n]);
        this.exponent = l12;
        l10 -= l8 + l9;
        l10 = Math.min(l10, l);
        l5 = (l10 + (long)DoubleRadixConstants.BASE_DIGITS[n] - 1L) / (long)DoubleRadixConstants.BASE_DIGITS[n];
        this.dataStorage.setSize(l5);
        this.dataStorage.setReadOnly();
        if (n6 != 0) {
            long l13 = 1L;
            for (int i = 0; i < n6; l13 *= (long)n, ++i) {
            }
            DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)this.multiply(new DoubleApfloatImpl(l13, Long.MAX_VALUE, n));
            this.exponent = doubleApfloatImpl.exponent;
            this.dataStorage = doubleApfloatImpl.dataStorage;
            this.initialDigits = Integer.MIN_VALUE;
        }
    }

    private static long getTrailingZeros(DataStorage dataStorage, long l) throws ApfloatRuntimeException {
        long l2 = 0L;
        DataStorage.Iterator iterator = dataStorage.iterator(1, l, 0L);
        while (iterator.hasNext()) {
            if (iterator.getDouble() != 0.0) {
                iterator.close();
                break;
            }
            iterator.next();
            ++l2;
        }
        return l2;
    }

    private static long getLeadingZeros(DataStorage dataStorage) throws ApfloatRuntimeException {
        long l = 0L;
        DataStorage.Iterator iterator = dataStorage.iterator(1, 0L, dataStorage.getSize());
        while (iterator.hasNext()) {
            if (iterator.getDouble() != 0.0) {
                iterator.close();
                break;
            }
            iterator.next();
            ++l;
        }
        return l;
    }

    public ApfloatImpl addOrSubtract(ApfloatImpl apfloatImpl, boolean bl) throws ApfloatRuntimeException {
        DataStorage dataStorage;
        long l;
        long l2;
        int n;
        boolean bl2;
        if (!(apfloatImpl instanceof DoubleApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + apfloatImpl.getClass().getName());
        }
        DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)apfloatImpl;
        if (this.radix != doubleApfloatImpl.radix) {
            throw new RadixMismatchException("Cannot use numbers with different radixes: " + this.radix + " and " + doubleApfloatImpl.radix);
        }
        assert (this.sign != 0);
        assert (doubleApfloatImpl.sign != 0);
        int n2 = bl ? -doubleApfloatImpl.sign : doubleApfloatImpl.sign;
        boolean bl3 = bl2 = this.sign != n2;
        if (this == doubleApfloatImpl) {
            if (bl2) {
                return this.zero();
            }
            n = this.sign;
            l2 = this.exponent;
            l = this.precision;
            long l3 = this.getSize() + 1L;
            dataStorage = DoubleApfloatImpl.createDataStorage(l3);
            dataStorage.setSize(l3);
            DataStorage.Iterator iterator = this.dataStorage.iterator(1, l3 - 1L, 0L);
            DataStorage.Iterator iterator2 = this.dataStorage.iterator(1, l3 - 1L, 0L);
            DataStorage.Iterator iterator3 = dataStorage.iterator(2, l3, 0L);
            double d = this.baseAdd(iterator, iterator2, 0.0, iterator3, l3 - 1L);
            iterator3.setDouble(d);
            iterator3.close();
            l3 -= DoubleApfloatImpl.getTrailingZeros(dataStorage, l3);
            int n3 = (int)d;
            int n4 = 1 - n3;
            dataStorage = dataStorage.subsequence(n4, l3 - (long)n4);
            l2 += (long)n3;
            if (this.exponent == DoubleRadixConstants.MAX_EXPONENT[this.radix] && n3 > 0) {
                throw new OverflowException("Overflow");
            }
            if (l != Long.MAX_VALUE && (n3 > 0 || this.getInitialDigits(dataStorage) > this.getInitialDigits())) {
                ++l;
            }
        } else {
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            long l9;
            DoubleApfloatImpl doubleApfloatImpl2;
            DoubleApfloatImpl doubleApfloatImpl3;
            int n5 = this.scale() > doubleApfloatImpl.scale() ? 1 : (this.scale() < doubleApfloatImpl.scale() ? -1 : (bl2 ? this.compareMantissaTo(doubleApfloatImpl) : 1));
            if (n5 > 0) {
                doubleApfloatImpl3 = this;
                doubleApfloatImpl2 = doubleApfloatImpl;
                n = this.sign;
            } else if (n5 < 0) {
                doubleApfloatImpl3 = doubleApfloatImpl;
                doubleApfloatImpl2 = this;
                n = n2;
            } else {
                return this.zero();
            }
            long l10 = doubleApfloatImpl3.scale() - doubleApfloatImpl2.scale();
            if (l10 < 0L) {
                l = doubleApfloatImpl3.precision;
                l2 = doubleApfloatImpl3.exponent;
                l9 = doubleApfloatImpl3.getSize();
                l8 = 0L;
                l7 = l9;
                l6 = l9;
            } else {
                l = Math.min(doubleApfloatImpl3.precision, Util.ifFinite(doubleApfloatImpl2.precision, l10 + doubleApfloatImpl2.precision));
                l5 = Math.min(DoubleRadixConstants.MAX_EXPONENT[this.radix], this.getBasePrecision(l, doubleApfloatImpl3.getInitialDigits()));
                l2 = doubleApfloatImpl3.exponent;
                l6 = doubleApfloatImpl3.exponent - doubleApfloatImpl2.exponent;
                l7 = Math.min(l5, Math.max(doubleApfloatImpl3.getSize(), l6 + doubleApfloatImpl2.getSize()));
                l9 = Math.min(l7, doubleApfloatImpl3.getSize());
                l8 = Math.max(0L, Math.min(l7 - l6, doubleApfloatImpl2.getSize()));
            }
            l5 = l7 + 1L;
            dataStorage = DoubleApfloatImpl.createDataStorage(l5);
            dataStorage.setSize(l5);
            DataStorage.Iterator iterator = doubleApfloatImpl3.dataStorage.iterator(1, l9, 0L);
            DataStorage.Iterator iterator4 = doubleApfloatImpl2.dataStorage.iterator(1, l8, 0L);
            DataStorage.Iterator iterator5 = dataStorage.iterator(2, l5, 0L);
            double d = 0.0;
            if (l7 > l9) {
                l4 = Math.min(l7 - l9, l8);
                d = bl2 ? this.baseSubtract(null, iterator4, d, iterator5, l4) : this.baseAdd(null, iterator4, d, iterator5, l4);
            } else if (l7 > l6 + l8) {
                l4 = l7 - l6 - l8;
                d = bl2 ? this.baseSubtract(iterator, null, d, iterator5, l4) : this.baseAdd(iterator, null, d, iterator5, l4);
            }
            if (l6 > l9) {
                l4 = l6 - l9;
                d = bl2 ? this.baseSubtract(null, null, d, iterator5, l4) : this.baseAdd(null, null, d, iterator5, l4);
            } else if (l9 > l6) {
                l4 = Math.min(l9 - l6, l8);
                d = bl2 ? this.baseSubtract(iterator, iterator4, d, iterator5, l4) : this.baseAdd(iterator, iterator4, d, iterator5, l4);
            }
            if (l6 > 0L) {
                l4 = Math.min(l9, l6);
                d = bl2 ? this.baseSubtract(iterator, null, d, iterator5, l4) : this.baseAdd(iterator, null, d, iterator5, l4);
            }
            iterator5.setDouble(d);
            iterator5.close();
            if (bl2) {
                l4 = DoubleApfloatImpl.getLeadingZeros(dataStorage);
                assert (l4 <= l7);
            } else {
                l4 = d == 0.0 ? 1 : 0;
                if (this.exponent == DoubleRadixConstants.MAX_EXPONENT[this.radix] && l4 == 0L) {
                    throw new OverflowException("Overflow");
                }
            }
            l5 -= DoubleApfloatImpl.getTrailingZeros(dataStorage, l5);
            dataStorage = dataStorage.subsequence(l4, l5 - l4);
            if ((l2 += 1L - l4) < -DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
                return this.zero();
            }
            if (l != Long.MAX_VALUE) {
                long l11 = (1L - l4) * (long)DoubleRadixConstants.BASE_DIGITS[this.radix] + (long)this.getInitialDigits(dataStorage) - (long)doubleApfloatImpl3.getInitialDigits();
                if (-l11 >= l) {
                    return this.zero();
                }
                l = (l += l11) <= 0L ? Long.MAX_VALUE : l;
            }
        }
        dataStorage.setReadOnly();
        return new DoubleApfloatImpl(n, l, l2, dataStorage, this.radix);
    }

    public ApfloatImpl multiply(ApfloatImpl apfloatImpl) throws ApfloatRuntimeException {
        int n;
        if (!(apfloatImpl instanceof DoubleApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + apfloatImpl.getClass().getName());
        }
        DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)apfloatImpl;
        if (this.radix != doubleApfloatImpl.radix) {
            throw new RadixMismatchException("Cannot multiply numbers with different radixes: " + this.radix + " and " + doubleApfloatImpl.radix);
        }
        int n2 = this.sign * doubleApfloatImpl.sign;
        if (n2 == 0) {
            return this.zero();
        }
        long l = this.exponent + doubleApfloatImpl.exponent;
        if (l > DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
            throw new OverflowException("Overflow");
        }
        if (l < -DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
            return this.zero();
        }
        long l2 = Math.min(this.precision, doubleApfloatImpl.precision);
        long l3 = this.getBasePrecision(l2, 0);
        long l4 = this.getSize();
        long l5 = doubleApfloatImpl.getSize();
        long l6 = Math.min(Util.ifFinite(l3, l3 + 1L), l4 + l5);
        long l7 = Math.min(l4, l3);
        long l8 = Math.min(l5, l3);
        DataStorage dataStorage = this.dataStorage.subsequence(0L, l7);
        DataStorage dataStorage2 = this.dataStorage == doubleApfloatImpl.dataStorage ? dataStorage : doubleApfloatImpl.dataStorage.subsequence(0L, l8);
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        ConvolutionBuilder convolutionBuilder = apfloatContext.getBuilderFactory().getConvolutionBuilder();
        ConvolutionStrategy convolutionStrategy = convolutionBuilder.createConvolution(this.radix, l7, l8, l6);
        DataStorage dataStorage3 = convolutionStrategy.convolute(dataStorage, dataStorage2, l6);
        int n3 = n = DoubleApfloatImpl.getMostSignificantWord(dataStorage3) == 0.0 ? 1 : 0;
        if ((l -= (long)n) < -DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
            return this.zero();
        }
        dataStorage3 = dataStorage3.subsequence(n, l6 -= (long)n);
        l6 = Math.min(l6, this.getBasePrecision(l2, this.getInitialDigits(dataStorage3)));
        l6 -= DoubleApfloatImpl.getTrailingZeros(dataStorage3, l6);
        dataStorage3 = dataStorage3.subsequence(0L, l6);
        dataStorage3.setReadOnly();
        return new DoubleApfloatImpl(n2, l2, l, dataStorage3, this.radix);
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.sign == 0 || this.getSize() == 1L;
    }

    public ApfloatImpl divideShort(ApfloatImpl apfloatImpl) throws ApfloatRuntimeException {
        DataStorage dataStorage;
        if (!(apfloatImpl instanceof DoubleApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + apfloatImpl.getClass().getName());
        }
        DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)apfloatImpl;
        if (this.radix != doubleApfloatImpl.radix) {
            throw new RadixMismatchException("Cannot divide numbers with different radixes: " + this.radix + " and " + doubleApfloatImpl.radix);
        }
        assert (this.sign != 0);
        assert (doubleApfloatImpl.sign != 0);
        int n = this.sign * doubleApfloatImpl.sign;
        long l = this.exponent - doubleApfloatImpl.exponent + 1L;
        if (l > DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
            throw new OverflowException("Overflow");
        }
        if (l < -DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
            return this.zero();
        }
        long l2 = Math.min(this.precision, doubleApfloatImpl.precision);
        long l3 = this.getBasePrecision();
        long l4 = Math.min(this.getSize(), l3);
        double d = DoubleApfloatImpl.getMostSignificantWord(doubleApfloatImpl.dataStorage);
        if (d == 1.0) {
            long l5 = l4 - DoubleApfloatImpl.getTrailingZeros(this.dataStorage, l4);
            dataStorage = this.dataStorage.subsequence(0L, l5);
        } else {
            double d2;
            long l6;
            double d3 = d;
            for (int i = 0; i < RadixConstants.RADIX_FACTORS[this.radix].length; ++i) {
                double d4;
                double d5 = RadixConstants.RADIX_FACTORS[this.radix][i];
                while (d3 - d5 * (d4 = (double)((long)(d3 / d5))) == 0.0) {
                    d3 = d4;
                }
            }
            if (d3 != 1.0) {
                if (l3 == Long.MAX_VALUE) {
                    throw new InfiniteExpansionException("Cannot perform inexact division to infinite precision");
                }
                l6 = l3;
            } else {
                d2 = 1.0;
                DataStorage.Iterator iterator = new DataStorage.Iterator(){

                    public void setDouble(double d) {
                    }

                    public void next() {
                    }
                };
                long l7 = 0L;
                while (d2 != 0.0) {
                    d2 = this.baseDivide(null, d, d2, iterator, 1L);
                    ++l7;
                }
                l6 = Math.min(l3, l4 + l7);
            }
            dataStorage = DoubleApfloatImpl.createDataStorage(++l6);
            dataStorage.setSize(l6);
            DataStorage.Iterator iterator = this.dataStorage.iterator(1, 0L, l4);
            DataStorage.Iterator iterator2 = dataStorage.iterator(2, 0L, l6);
            d2 = this.baseDivide(iterator, d, 0.0, iterator2, l4);
            d2 = this.baseDivide(null, d, d2, iterator2, l6 - l4);
            l6 -= DoubleApfloatImpl.getTrailingZeros(dataStorage, l6);
            int n2 = this.getMostSignificantWord() < d ? 1 : 0;
            dataStorage = dataStorage.subsequence(n2, l6 - (long)n2);
            if ((l -= (long)n2) < -DoubleRadixConstants.MAX_EXPONENT[this.radix]) {
                return this.zero();
            }
            dataStorage.setReadOnly();
        }
        return new DoubleApfloatImpl(n, l2, l, dataStorage, this.radix);
    }

    public ApfloatImpl absFloor() throws ApfloatRuntimeException {
        if (this.sign == 0 || this.exponent >= this.dataStorage.getSize()) {
            return this.precision(Long.MAX_VALUE);
        }
        if (this.exponent <= 0L) {
            return this.zero();
        }
        long l = this.exponent;
        l -= DoubleApfloatImpl.getTrailingZeros(this.dataStorage, l);
        DataStorage dataStorage = this.dataStorage.subsequence(0L, l);
        DoubleApfloatImpl doubleApfloatImpl = new DoubleApfloatImpl(this.sign, Long.MAX_VALUE, this.exponent, dataStorage, this.radix);
        return doubleApfloatImpl;
    }

    public ApfloatImpl absCeil() throws ApfloatRuntimeException {
        long l;
        DataStorage dataStorage;
        if (this.sign == 0) {
            return this;
        }
        DataStorage.Iterator iterator = null;
        if (this.exponent <= 0L) {
            int n = 1;
            dataStorage = DoubleApfloatImpl.createDataStorage(n);
            dataStorage.setSize(n);
            ArrayAccess arrayAccess = dataStorage.getArray(2, 0L, n);
            arrayAccess.getDoubleData()[arrayAccess.getOffset()] = 1.0;
            arrayAccess.close();
            l = 1L;
        } else if (this.getSize() <= this.exponent || this.findMismatch(iterator = this.getZeroPaddedIterator(this.exponent, this.getSize()), ZERO_ITERATOR, this.getSize() - this.exponent) < 0L) {
            long l2 = Math.min(this.getSize(), this.exponent);
            l2 -= DoubleApfloatImpl.getTrailingZeros(this.dataStorage, l2);
            dataStorage = this.dataStorage.subsequence(0L, l2);
            l = this.exponent;
        } else {
            long l3 = this.exponent;
            dataStorage = DoubleApfloatImpl.createDataStorage(l3 + 1L);
            dataStorage.setSize(l3 + 1L);
            DataStorage.Iterator iterator2 = this.dataStorage.iterator(1, l3, 0L);
            DataStorage.Iterator iterator3 = dataStorage.iterator(2, l3 + 1L, 0L);
            double d = this.baseAdd(iterator2, null, 1.0, iterator3, l3);
            iterator3.setDouble(d);
            iterator2.close();
            iterator3.close();
            int n = (int)d;
            l3 -= DoubleApfloatImpl.getTrailingZeros(dataStorage, l3 + 1L);
            dataStorage = dataStorage.subsequence(1 - n, l3 + (long)n);
            l = this.exponent + (long)n;
        }
        if (iterator != null) {
            iterator.close();
        }
        dataStorage.setReadOnly();
        DoubleApfloatImpl doubleApfloatImpl = new DoubleApfloatImpl(this.sign, Long.MAX_VALUE, l, dataStorage, this.radix);
        return doubleApfloatImpl;
    }

    private ApfloatImpl zero() {
        return new DoubleApfloatImpl(0, Long.MAX_VALUE, 0L, null, this.radix);
    }

    public int radix() {
        return this.radix;
    }

    public long precision() {
        return this.precision;
    }

    public long size() throws ApfloatRuntimeException {
        assert (this.dataStorage != null);
        return (long)this.getInitialDigits() + (this.getSize() - 1L) * (long)DoubleRadixConstants.BASE_DIGITS[this.radix] - this.getLeastZeros();
    }

    private long getLeastZeros() throws ApfloatRuntimeException {
        if (this.leastZeros == Integer.MIN_VALUE) {
            long l = this.getSize() - 1L;
            double d = this.getWord(l);
            d = this.getLeastSignificantWord(l, d);
            long l2 = 0L;
            if (d == 0.0) {
                long l3 = DoubleApfloatImpl.getTrailingZeros(this.dataStorage, l) + 1L;
                d = this.getWord(l -= l3);
                d = this.getLeastSignificantWord(l, d);
                l2 += l3 * (long)DoubleRadixConstants.BASE_DIGITS[this.radix];
            }
            assert (d != 0.0);
            while (d % (double)this.radix == 0.0) {
                ++l2;
                d /= (double)this.radix;
            }
            this.leastZeros = l2;
        }
        return this.leastZeros;
    }

    public ApfloatImpl precision(long l) {
        if (this.sign == 0 || l == this.precision) {
            return this;
        }
        return new DoubleApfloatImpl(this.sign, l, this.exponent, this.dataStorage, this.radix);
    }

    public long scale() throws ApfloatRuntimeException {
        assert (this.dataStorage != null);
        return (this.exponent - 1L) * (long)DoubleRadixConstants.BASE_DIGITS[this.radix] + (long)this.getInitialDigits();
    }

    public int signum() {
        return this.sign;
    }

    public ApfloatImpl negate() throws ApfloatRuntimeException {
        return new DoubleApfloatImpl(-this.sign, this.precision, this.exponent, this.dataStorage, this.radix);
    }

    public double doubleValue() {
        if (this.sign == 0) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = DoubleRadixConstants.BASE[this.radix];
        int n = (int)Math.min(4L, this.getSize());
        DataStorage.Iterator iterator = this.dataStorage.iterator(1, n, 0L);
        while (iterator.hasNext()) {
            d += iterator.getDouble();
            d /= d2;
            iterator.next();
        }
        if (this.exponent > 0L) {
            return (double)this.sign * d * Math.pow(DoubleRadixConstants.BASE[this.radix], this.exponent - 1L) * DoubleRadixConstants.BASE[this.radix];
        }
        return (double)this.sign * d * Math.pow(DoubleRadixConstants.BASE[this.radix], this.exponent);
    }

    public long longValue() {
        if (this.sign == 0 || this.exponent <= 0L) {
            return 0L;
        }
        if (this.exponent > 4L) {
            return this.sign > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        long l = 0L;
        long l2 = (long)DoubleRadixConstants.BASE[this.radix];
        long l3 = Long.MIN_VALUE / l2;
        int n = (int)Math.min(this.exponent, this.getSize());
        DataStorage.Iterator iterator = this.dataStorage.iterator(1, 0L, n);
        for (int i = 0; i < (int)this.exponent; ++i) {
            if (l < l3) {
                l = 0L;
                iterator.close();
                break;
            }
            l *= l2;
            if (i >= n) continue;
            l -= (long)iterator.getDouble();
            iterator.next();
        }
        if (l == Long.MIN_VALUE || l >= 0L) {
            return this.sign > 0 ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return (long)(-this.sign) * l;
    }

    public boolean isOne() throws ApfloatRuntimeException {
        return this.sign == 1 && this.exponent == 1L && this.getSize() == 1L && this.getMostSignificantWord() == 1.0;
    }

    public long equalDigits(ApfloatImpl apfloatImpl) throws ApfloatRuntimeException {
        long l;
        double d;
        double d2;
        if (!(apfloatImpl instanceof DoubleApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + apfloatImpl.getClass().getName());
        }
        DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)apfloatImpl;
        if (this.radix != doubleApfloatImpl.radix) {
            throw new RadixMismatchException("Cannot compare values with different radixes: " + this.radix + " and " + doubleApfloatImpl.radix);
        }
        if (this.sign == 0 && doubleApfloatImpl.sign == 0) {
            return Long.MAX_VALUE;
        }
        if (this.sign != doubleApfloatImpl.sign) {
            return 0L;
        }
        long l2 = this.scale();
        long l3 = doubleApfloatImpl.scale();
        long l4 = Math.min(l2, l3);
        long l5 = Math.max(l2, l3);
        if (l5 - 1L > l4) {
            return 0L;
        }
        long l6 = this.getSize();
        long l7 = doubleApfloatImpl.getSize();
        long l8 = Math.max(l6, l7);
        DataStorage.Iterator iterator = this.getZeroPaddedIterator(0L, l6);
        DataStorage.Iterator iterator2 = doubleApfloatImpl.getZeroPaddedIterator(0L, l7);
        long l9 = Math.min(this.precision, doubleApfloatImpl.precision);
        int n = -1;
        double d3 = DoubleRadixConstants.BASE[this.radix];
        if (this.exponent > doubleApfloatImpl.exponent) {
            d2 = iterator.getDouble();
            if (d2 != 1.0) {
                iterator.close();
                iterator2.close();
                return 0L;
            }
            d = d3;
            iterator.next();
        } else if (this.exponent < doubleApfloatImpl.exponent) {
            d2 = iterator2.getDouble();
            if (d2 != 1.0) {
                iterator.close();
                iterator2.close();
                return 0L;
            }
            d = -d3;
            iterator2.next();
        } else {
            d = 0.0;
        }
        for (l = 0L; l < l8; ++l) {
            d2 = iterator.getDouble() - iterator2.getDouble() + d;
            if (d2 == 0.0) {
                d = 0.0;
            } else {
                if (Math.abs(d2) > 1.0) {
                    if (Math.abs(d2) >= d3) {
                        n = -1;
                        break;
                    }
                    n = DoubleRadixConstants.BASE_DIGITS[this.radix] - this.getDigits(Math.abs(d2));
                    break;
                }
                if (d2 == 1.0) {
                    d = d3;
                } else if (d2 == -1.0) {
                    d = -d3;
                }
            }
            iterator.next();
            iterator2.next();
        }
        if (l < l8 || d != 0.0) {
            long l10 = this.exponent == doubleApfloatImpl.exponent ? Math.min(this.getInitialDigits(), doubleApfloatImpl.getInitialDigits()) : DoubleRadixConstants.BASE_DIGITS[this.radix];
            long l11 = (l - 1L) * (long)DoubleRadixConstants.BASE_DIGITS[this.radix];
            l9 = Math.min(l9, l10 + l11 + (long)n);
            l9 = Math.max(l9, 0L);
        }
        iterator.close();
        iterator2.close();
        return l9;
    }

    public int compareTo(ApfloatImpl apfloatImpl) throws ApfloatRuntimeException {
        if (!(apfloatImpl instanceof DoubleApfloatImpl)) {
            throw new ImplementationMismatchException("Wrong operand type: " + apfloatImpl.getClass().getName());
        }
        DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)apfloatImpl;
        if (this.sign == 0 && doubleApfloatImpl.sign == 0) {
            return 0;
        }
        if (this.sign < doubleApfloatImpl.sign) {
            return -1;
        }
        if (this.sign > doubleApfloatImpl.sign) {
            return 1;
        }
        if (this.radix != doubleApfloatImpl.radix) {
            throw new RadixMismatchException("Cannot compare values with different radixes: " + this.radix + " and " + doubleApfloatImpl.radix);
        }
        if (this.scale() < doubleApfloatImpl.scale()) {
            return -this.sign;
        }
        if (this.scale() > doubleApfloatImpl.scale()) {
            return this.sign;
        }
        return this.sign * this.compareMantissaTo(doubleApfloatImpl);
    }

    private DataStorage.Iterator getZeroPaddedIterator(final long l, final long l2) throws ApfloatRuntimeException {
        final DataStorage.Iterator iterator = this.dataStorage.iterator(1, l, l2);
        return new DataStorage.Iterator(){
            private long index;
            {
                this.index = l;
            }

            public double getDouble() throws ApfloatRuntimeException {
                double d;
                if (this.index < l2) {
                    d = iterator.getDouble();
                    if (this.index == l2 - 1L) {
                        d = DoubleApfloatImpl.this.getLeastSignificantWord(this.index, d);
                    }
                } else {
                    d = 0.0;
                }
                return d;
            }

            public void next() throws ApfloatRuntimeException {
                if (this.index < l2) {
                    iterator.next();
                    ++this.index;
                }
            }

            public void close() throws ApfloatRuntimeException {
                iterator.close();
            }
        };
    }

    private int compareMantissaTo(DoubleApfloatImpl doubleApfloatImpl) throws ApfloatRuntimeException {
        long l = this.getSize();
        long l2 = doubleApfloatImpl.getSize();
        long l3 = Math.max(l, l2);
        DataStorage.Iterator iterator = this.getZeroPaddedIterator(0L, l);
        DataStorage.Iterator iterator2 = doubleApfloatImpl.getZeroPaddedIterator(0L, l2);
        int n = 0;
        long l4 = this.findMismatch(iterator, iterator2, l3);
        if (l4 >= 0L) {
            double d;
            double d2 = iterator.getDouble();
            if (d2 < (d = iterator2.getDouble())) {
                n = -1;
            } else if (d2 > d) {
                n = 1;
            }
        }
        iterator.close();
        iterator2.close();
        return n;
    }

    private long findMismatch(DataStorage.Iterator iterator, DataStorage.Iterator iterator2, long l) throws ApfloatRuntimeException {
        for (long i = 0L; i < l; ++i) {
            double d;
            double d2 = iterator.getDouble();
            if (d2 != (d = iterator2.getDouble())) {
                return i;
            }
            iterator.next();
            iterator2.next();
        }
        return -1L;
    }

    private double getLeastSignificantWord(long l, double d) throws ApfloatRuntimeException {
        if (this.precision == Long.MAX_VALUE) {
            return d;
        }
        long l2 = (long)this.getInitialDigits() + l * (long)DoubleRadixConstants.BASE_DIGITS[this.radix];
        if (this.precision >= l2) {
            return d;
        }
        double d2 = DoubleRadixConstants.MINIMUM_FOR_DIGITS[this.radix][(int)(l2 - this.precision)];
        return (double)((long)(d / d2)) * d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ApfloatImpl)) {
            return false;
        }
        ApfloatImpl apfloatImpl = (ApfloatImpl)object;
        if (this.signum() == 0 && apfloatImpl.signum() == 0) {
            return true;
        }
        if (this.isOne() && apfloatImpl.isOne()) {
            return true;
        }
        if (!(object instanceof DoubleApfloatImpl)) {
            return false;
        }
        DoubleApfloatImpl doubleApfloatImpl = (DoubleApfloatImpl)object;
        if (this.radix != doubleApfloatImpl.radix) {
            return false;
        }
        if (this.sign != doubleApfloatImpl.sign || this.scale() != doubleApfloatImpl.scale()) {
            return false;
        }
        return this.compareMantissaTo(doubleApfloatImpl) == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 1 + this.sign + (int)this.exponent + (int)(this.exponent >>> 32);
            if (this.dataStorage != null) {
                long l = this.getSize();
                long l2 = 0L;
                while (l2 < l) {
                    double d = this.getWord(l2);
                    if (l2 == l - 1L) {
                        d = this.getLeastSignificantWord(l2, d);
                    }
                    long l3 = (long)d;
                    n += (int)l3 + (int)(l3 >>> 32);
                    l2 = l2 + l2 + 1L;
                }
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public String toString(boolean bl) throws ApfloatRuntimeException {
        long l;
        if (this.sign == 0) {
            return "0";
        }
        long l2 = this.getSize() * (long)DoubleRadixConstants.BASE_DIGITS[this.radix];
        if (bl) {
            long l3 = this.scale();
            l = l3 <= 0L ? 2L - l3 + l2 : (l2 > l3 ? 1L + l2 : l3);
            l += (long)(this.sign < 0 ? 1 : 0);
        } else {
            l = l2 + 24L;
        }
        if (l > Integer.MAX_VALUE || l < 0L) {
            throw new ApfloatInternalException("Number is too large to fit in a String");
        }
        StringWriter stringWriter = new StringWriter((int)l);
        try {
            this.writeTo(stringWriter, bl);
        }
        catch (IOException iOException) {
            throw new ApfloatInternalException("Unexpected I/O error writing to StringWriter", iOException);
        }
        String string = stringWriter.toString();
        assert ((long)string.length() <= l);
        return string;
    }

    private static void writeZeros(Writer writer, long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            writer.write(48);
        }
    }

    public void writeTo(Writer writer, boolean bl) throws IOException, ApfloatRuntimeException {
        long l;
        long l2;
        long l3;
        if (this.sign == 0) {
            writer.write(48);
            return;
        }
        if (this.sign < 0) {
            writer.write(45);
        }
        if (bl) {
            if (this.exponent <= 0L) {
                writer.write("0.");
                DoubleApfloatImpl.writeZeros(writer, -this.scale());
                l3 = -1L;
            } else {
                l3 = this.scale();
            }
            l2 = 0L;
        } else {
            l3 = 1L;
            l2 = this.scale() - 1L;
        }
        boolean bl2 = false;
        long l4 = Math.min(this.precision, (long)this.getInitialDigits() + (l - 1L) * (long)DoubleRadixConstants.BASE_DIGITS[this.radix]);
        long l5 = 0L;
        long l6 = 0L;
        DataStorage.Iterator iterator = this.dataStorage.iterator(1, 0L, l);
        char[] cArray = new char[DoubleRadixConstants.BASE_DIGITS[this.radix]];
        for (l = this.getSize(); l > 0L; --l) {
            int n = bl2 ? 0 : DoubleRadixConstants.BASE_DIGITS[this.radix] - this.getInitialDigits();
            int n2 = (int)Math.min(l4, (long)(DoubleRadixConstants.BASE_DIGITS[this.radix] - n));
            this.formatWord(cArray, iterator.getDouble());
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                if (c == '0') {
                    ++l6;
                    --l4;
                    continue;
                }
                while (l6 > 0L) {
                    if (l5 == l3) {
                        writer.write(46);
                    }
                    writer.write(48);
                    ++l5;
                    --l6;
                }
                if (l5 == l3) {
                    writer.write(46);
                }
                writer.write(c);
                ++l5;
                --l4;
            }
            bl2 = true;
            iterator.next();
        }
        if (!bl && l2 != 0L) {
            writer.write("e" + l2);
        }
        DoubleApfloatImpl.writeZeros(writer, l3 - l5);
    }

    private void formatWord(char[] cArray, double d) {
        int n = DoubleRadixConstants.BASE_DIGITS[this.radix];
        while (n > 0 && d > 0.0) {
            double d2 = (long)(d / (double)this.radix);
            int n2 = (int)(d - d2 * (double)this.radix);
            d = d2;
            cArray[--n] = Character.forDigit(n2, this.radix);
        }
        while (n > 0) {
            cArray[--n] = 48;
        }
    }

    private long getSize() throws ApfloatRuntimeException {
        assert (this.dataStorage != null);
        return Math.min(this.getBasePrecision(), this.dataStorage.getSize());
    }

    private static int checkRadix(int n) throws NumberFormatException {
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Invalid radix " + n + "; radix must be between " + 2 + " and " + 36);
        }
        return n;
    }

    private double getMostSignificantWord() throws ApfloatRuntimeException {
        return DoubleApfloatImpl.getMostSignificantWord(this.dataStorage);
    }

    private static double getMostSignificantWord(DataStorage dataStorage) throws ApfloatRuntimeException {
        ArrayAccess arrayAccess = dataStorage.getArray(1, 0L, 1);
        double d = arrayAccess.getDoubleData()[arrayAccess.getOffset()];
        arrayAccess.close();
        return d;
    }

    private int getInitialDigits() throws ApfloatRuntimeException {
        if (this.initialDigits == Integer.MIN_VALUE) {
            this.initialDigits = this.getDigits(this.getMostSignificantWord());
        }
        return this.initialDigits;
    }

    private int getInitialDigits(DataStorage dataStorage) throws ApfloatRuntimeException {
        return this.getDigits(DoubleApfloatImpl.getMostSignificantWord(dataStorage));
    }

    private int getDigits(double d) {
        assert (d > 0.0);
        double[] dArray = DoubleRadixConstants.MINIMUM_FOR_DIGITS[this.radix];
        int n = dArray.length;
        while (d < dArray[--n]) {
        }
        return n + 1;
    }

    private long getBasePrecision() throws ApfloatRuntimeException {
        return this.getBasePrecision(this.precision, this.getInitialDigits());
    }

    private long getBasePrecision(long l, int n) {
        if (l == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return (l + (long)DoubleRadixConstants.BASE_DIGITS[this.radix] - (long)n - 1L) / (long)DoubleRadixConstants.BASE_DIGITS[this.radix] + 1L;
    }

    private double getWord(long l) {
        ArrayAccess arrayAccess = this.dataStorage.getArray(1, l, 1);
        double d = arrayAccess.getDoubleData()[arrayAccess.getOffset()];
        arrayAccess.close();
        return d;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.leastZeros = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
    }

    private static DataStorage createDataStorage(long l) throws ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        DataStorageBuilder dataStorageBuilder = apfloatContext.getBuilderFactory().getDataStorageBuilder();
        return dataStorageBuilder.createDataStorage(l * 8L);
    }

    private static int getBlockSize() {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        return apfloatContext.getBlockSize() / 8;
    }
}

