/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.BackingStorageException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.FilenameGenerator;

public abstract class DiskDataStorage
extends DataStorage {
    private static final ReadableByteChannel ZERO_CHANNEL = new ReadableByteChannel(){

        public int read(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            for (int i = 0; i < n; ++i) {
                byteBuffer.put((byte)0);
            }
            return n;
        }

        public void close() {
        }

        public boolean isOpen() {
            return true;
        }
    };
    private static final long serialVersionUID = 741984828408146034L;
    private static final long TIMEOUT = 1000L;
    private static ReferenceQueue<FileStorage> referenceQueue = new ReferenceQueue();
    private static Set<FileStorageReference> references = new HashSet<FileStorageReference>();
    private static ThreadLocal<SoftReference<ByteBuffer>> threadLocal = new ThreadLocal();
    private static boolean cleanUp = false;
    private FileStorage fileStorage;

    protected DiskDataStorage() throws ApfloatRuntimeException {
        this.fileStorage = DiskDataStorage.createFileStorage();
    }

    protected DiskDataStorage(DiskDataStorage diskDataStorage, long l, long l2) {
        super(diskDataStorage, l, l2);
        this.fileStorage = diskDataStorage.fileStorage;
    }

    protected void implCopyFrom(DataStorage dataStorage, long l) throws ApfloatRuntimeException {
        if (dataStorage == this) {
            this.setSize(l);
            return;
        }
        assert (l > 0L);
        assert (!this.isReadOnly());
        assert (!this.isSubsequenced());
        int n = this.getUnitSize();
        long l2 = l * (long)n;
        assert (l2 > 0L);
        try {
            this.fileStorage.setSize(l2);
            long l3 = Math.min(l, dataStorage.getSize());
            long l4 = l3 * (long)n;
            long l5 = l2 - l4;
            if (dataStorage instanceof DiskDataStorage) {
                DiskDataStorage diskDataStorage = (DiskDataStorage)dataStorage;
                diskDataStorage.transferTo(this.getFileChannel().position(0L), diskDataStorage.getOffset() * (long)n, l4);
            } else {
                long l6 = 0L;
                int n2 = DiskDataStorage.getBlockSize() / n;
                while (l3 > 0L) {
                    int n3 = (int)Math.min((long)n2, l3);
                    ArrayAccess arrayAccess = dataStorage.getArray(1, l6, n3);
                    ArrayAccess arrayAccess2 = this.getArray(2, l6, n3);
                    System.arraycopy(arrayAccess.getData(), arrayAccess.getOffset(), arrayAccess2.getData(), arrayAccess2.getOffset(), n3);
                    arrayAccess2.close();
                    arrayAccess.close();
                    l3 -= (long)n3;
                    l6 += (long)n3;
                }
            }
            this.pad(l4, l5);
        }
        catch (IOException iOException) {
            throw new BackingStorageException("Unable to copy to file \"" + this.getFilename() + '\"', iOException);
        }
    }

    protected long implGetSize() throws ApfloatRuntimeException {
        try {
            return this.getFileChannel().size() / (long)this.getUnitSize();
        }
        catch (IOException iOException) {
            throw new BackingStorageException("Unable to access file \"" + this.getFilename() + '\"', iOException);
        }
    }

    protected void implSetSize(long l) throws ApfloatRuntimeException {
        assert (l > 0L);
        assert (!this.isReadOnly());
        assert (!this.isSubsequenced());
        assert ((l *= (long)this.getUnitSize()) > 0L);
        try {
            long l2 = this.getFileChannel().size();
            long l3 = l - l2;
            this.fileStorage.setSize(l);
            this.pad(l2, l3);
        }
        catch (IOException iOException) {
            throw new BackingStorageException("Unable to access file \"" + this.getFilename() + '\"', iOException);
        }
    }

    protected void transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws ApfloatRuntimeException {
        this.fileStorage.transferFrom(readableByteChannel, l, l2);
    }

    protected void transferTo(WritableByteChannel writableByteChannel, long l, long l2) throws ApfloatRuntimeException {
        this.fileStorage.transferTo(writableByteChannel, l, l2);
    }

    protected static int getBlockSize() {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        return apfloatContext.getBlockSize();
    }

    protected abstract int getUnitSize();

    protected final String getFilename() {
        return this.fileStorage.getFilename();
    }

    protected final FileChannel getFileChannel() {
        return this.fileStorage.getFileChannel();
    }

    static synchronized void cleanUp() throws ApfloatRuntimeException {
        for (FileStorageReference fileStorageReference : references) {
            fileStorageReference.dispose();
            fileStorageReference.clear();
        }
        references.clear();
        cleanUp = true;
    }

    static synchronized void gc() throws ApfloatRuntimeException {
        DiskDataStorage.forceFreeFileStorage();
    }

    private void pad(long l, long l2) throws IOException, ApfloatRuntimeException {
        this.transferFrom(ZERO_CHANNEL, l, l2);
    }

    private static synchronized FileStorage createFileStorage() throws ApfloatInternalException {
        if (cleanUp) {
            throw new ApfloatInternalException("Shutdown has been initiated, clean-up is in progress");
        }
        DiskDataStorage.freeFileStorage();
        FileStorage fileStorage = new FileStorage();
        return fileStorage;
    }

    private static synchronized void referenceFileStorage(FileStorage fileStorage) throws ApfloatInternalException {
        if (cleanUp) {
            new FileStorageReference(fileStorage, null).dispose();
            throw new ApfloatInternalException("Shutdown has been initiated, clean-up is in progress");
        }
        FileStorageReference fileStorageReference = new FileStorageReference(fileStorage, referenceQueue);
        references.add(fileStorageReference);
    }

    private static synchronized void freeFileStorage() {
        FileStorageReference fileStorageReference;
        while ((fileStorageReference = (FileStorageReference)referenceQueue.poll()) != null) {
            fileStorageReference.dispose();
            fileStorageReference.clear();
            references.remove(fileStorageReference);
        }
    }

    private static synchronized void forceFreeFileStorage() throws ApfloatInternalException {
        try {
            FileStorageReference fileStorageReference;
            while ((fileStorageReference = (FileStorageReference)referenceQueue.remove(1000L)) != null) {
                fileStorageReference.dispose();
                fileStorageReference.clear();
                references.remove(fileStorageReference);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ApfloatInternalException("Reference queue polling was interrupted", interruptedException);
        }
    }

    private static ByteBuffer getDirectByteBuffer() {
        ByteBuffer byteBuffer = null;
        int n = DiskDataStorage.getBlockSize();
        SoftReference<ByteBuffer> softReference = threadLocal.get();
        if (softReference != null && (byteBuffer = softReference.get()) != null && byteBuffer.capacity() != n) {
            softReference.clear();
            byteBuffer = null;
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocateDirect(n);
            softReference = new SoftReference<ByteBuffer>(byteBuffer);
            threadLocal.set(softReference);
        }
        return byteBuffer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileStorageReference
    extends PhantomReference<FileStorage> {
        private File file;
        private RandomAccessFile randomAccessFile;
        private FileChannel fileChannel;

        public FileStorageReference(FileStorage fileStorage, ReferenceQueue<FileStorage> referenceQueue) {
            super(fileStorage, referenceQueue);
            this.file = fileStorage.getFile();
            this.randomAccessFile = fileStorage.getRandomAccessFile();
            this.fileChannel = fileStorage.getFileChannel();
        }

        public void dispose() {
            try {
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.randomAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file.delete();
        }
    }

    private static class FileStorage
    implements Serializable {
        private static final long serialVersionUID = 2062430603153403341L;
        private transient String filename;
        private transient File file;
        private transient RandomAccessFile randomAccessFile;
        private transient FileChannel fileChannel;

        public FileStorage() throws ApfloatRuntimeException {
            this.init();
        }

        private void init() throws ApfloatRuntimeException {
            ApfloatContext apfloatContext = ApfloatContext.getContext();
            FilenameGenerator filenameGenerator = apfloatContext.getFilenameGenerator();
            this.filename = filenameGenerator.generateFilename();
            this.file = new File(this.filename);
            try {
                if (!this.file.createNewFile()) {
                    throw new BackingStorageException("Failed to create new file \"" + this.filename + '\"');
                }
                this.file.deleteOnExit();
                this.randomAccessFile = new RandomAccessFile(this.file, "rw");
            }
            catch (IOException iOException) {
                throw new BackingStorageException("Unable to access file \"" + this.filename + '\"', iOException);
            }
            this.fileChannel = this.randomAccessFile.getChannel();
            DiskDataStorage.referenceFileStorage(this);
        }

        public void setSize(long l) throws IOException, ApfloatRuntimeException {
            try {
                this.getRandomAccessFile().setLength(l);
            }
            catch (IOException iOException) {
                System.gc();
                DiskDataStorage.forceFreeFileStorage();
                this.getRandomAccessFile().setLength(l);
            }
        }

        public void transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws ApfloatRuntimeException {
            try {
                if (readableByteChannel instanceof FileChannel) {
                    while (l2 > 0L) {
                        long l3 = this.getFileChannel().transferFrom(readableByteChannel, l, l2);
                        l += l3;
                        assert ((l2 -= l3) >= 0L);
                    }
                } else {
                    ByteBuffer byteBuffer = DiskDataStorage.getDirectByteBuffer();
                    while (l2 > 0L) {
                        int n;
                        byteBuffer.clear();
                        int n2 = (int)Math.min(l2, (long)byteBuffer.capacity());
                        byteBuffer.limit(n2);
                        byteBuffer.flip();
                        for (n2 = readableByteChannel.read(byteBuffer); n2 > 0; n2 -= n) {
                            n = this.getFileChannel().write(byteBuffer, l);
                            l += (long)n;
                            l2 -= (long)n;
                        }
                        assert (n2 == 0);
                        assert (l2 >= 0L);
                    }
                }
            }
            catch (IOException iOException) {
                throw new BackingStorageException("Unable to write to file \"" + this.getFilename() + '\"', iOException);
            }
        }

        public void transferTo(WritableByteChannel writableByteChannel, long l, long l2) throws ApfloatRuntimeException {
            try {
                if (writableByteChannel instanceof FileChannel) {
                    while (l2 > 0L) {
                        long l3 = this.getFileChannel().transferTo(l, l2, writableByteChannel);
                        l += l3;
                        assert ((l2 -= l3) >= 0L);
                    }
                } else {
                    ByteBuffer byteBuffer = DiskDataStorage.getDirectByteBuffer();
                    while (l2 > 0L) {
                        int n;
                        byteBuffer.clear();
                        int n2 = (int)Math.min(l2, (long)byteBuffer.capacity());
                        byteBuffer.limit(n2);
                        byteBuffer.flip();
                        for (n2 = this.getFileChannel().read(byteBuffer, l); n2 > 0; n2 -= n) {
                            n = writableByteChannel.write(byteBuffer);
                            l += (long)n;
                            l2 -= (long)n;
                        }
                        assert (n2 == 0);
                        assert (l2 >= 0L);
                    }
                }
            }
            catch (IOException iOException) {
                throw new BackingStorageException("Unable to read from file \"" + this.getFilename() + '\"', iOException);
            }
        }

        public String getFilename() {
            return this.filename;
        }

        public File getFile() {
            return this.file;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.randomAccessFile;
        }

        public FileChannel getFileChannel() {
            return this.fileChannel;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            long l = this.getFileChannel().size();
            objectOutputStream.writeLong(l);
            this.transferTo(Channels.newChannel(objectOutputStream), 0L, l);
            objectOutputStream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.init();
            long l = objectInputStream.readLong();
            this.setSize(l);
            this.transferFrom(Channels.newChannel(objectInputStream), 0L, l);
            objectInputStream.defaultReadObject();
        }
    }
}

