/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.ArrayList;
import java.util.List;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.spi.RadixConstants;
import org.apfloat.spi.Util;

class RadixConversionHelper {
    private RadixConversionHelper() {
    }

    public static Apfloat toRadix(Apfloat apfloat, int n) throws ApfloatRuntimeException {
        if (apfloat.radix() == n) {
            return apfloat;
        }
        if (apfloat.signum() == 0) {
            return new Apfloat(0L, (long)n);
        }
        int n2 = apfloat.radix();
        long l = apfloat.size();
        long l2 = apfloat.scale();
        long l3 = RadixConversionHelper.getPrecision(apfloat.precision(), n2, n);
        RadixPowerList radixPowerList = new RadixPowerList(n2, n, l3);
        return RadixConversionHelper.toRadixIntegerPart(apfloat, n, l, l2, radixPowerList).add(RadixConversionHelper.toRadixFractionalPart(apfloat, n, l, l2, radixPowerList)).precision(l3);
    }

    private static Apfloat toRadixIntegerPart(Apfloat apfloat, int n, long l, long l2, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        if (l2 <= 0L) {
            return Apfloat.ZERO;
        }
        if (l2 > l) {
            long l3 = l2 - l;
            apfloat = ApfloatMath.scale(apfloat, -l3);
            apfloat = RadixConversionHelper.toRadixNormalizedPart(apfloat, n, l, radixPowerList);
            return apfloat.multiply(radixPowerList.pow(l3));
        }
        apfloat = apfloat.truncate();
        return RadixConversionHelper.toRadixNormalizedPart(apfloat, n, apfloat.scale(), radixPowerList);
    }

    private static Apfloat toRadixFractionalPart(Apfloat apfloat, int n, long l, long l2, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        if (l > l2) {
            if (l2 > 0L) {
                apfloat = apfloat.subtract(apfloat.truncate());
                l -= l2;
                l2 = 0L;
            }
            long l3 = RadixConversionHelper.getPrecision(apfloat.precision(), apfloat.radix(), n);
            long l4 = l - l2;
            apfloat = ApfloatMath.scale(apfloat, l4);
            apfloat = RadixConversionHelper.toRadixNormalizedPart(apfloat, n, l, radixPowerList);
            return apfloat.precision(l3).divide(radixPowerList.pow(l4));
        }
        return Apfloat.ZERO;
    }

    private static Apfloat toRadixNormalizedPart(Apfloat apfloat, int n, long l, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        long l2 = Util.round2down(l);
        return RadixConversionHelper.split(apfloat, n, l, l2, radixPowerList);
    }

    private static Apfloat split(Apfloat apfloat, int n, long l, long l2, RadixPowerList radixPowerList) throws ApfloatRuntimeException {
        if (l <= 0L) {
            return Apfloat.ZERO;
        }
        if (l <= (long)RadixConstants.LONG_DIGITS[apfloat.radix()]) {
            return new Apfloat(apfloat.longValue(), Long.MAX_VALUE, n);
        }
        Apint apint = ApfloatMath.scale(apfloat, -l2).truncate();
        Apfloat apfloat2 = apfloat.subtract(ApfloatMath.scale(apint, l2));
        return RadixConversionHelper.split(apint, n, l - l2, l2 >> 1, radixPowerList).multiply(radixPowerList.pow(l2)).add(RadixConversionHelper.split(apfloat2, n, l2, l2 >> 1, radixPowerList));
    }

    private static long getPrecision(long l, int n, int n2) throws ApfloatRuntimeException {
        long l2 = (long)((double)l * Math.log(n) / Math.log(n2));
        if (n < n2) {
            l2 = Math.max(1L, l2);
        }
        return Util.ifFinite(l, l2);
    }

    private static class RadixPowerList {
        private List<Apfloat> list = new ArrayList<Apfloat>();

        public RadixPowerList(int n, int n2, long l) throws ApfloatRuntimeException {
            this.list.add(new Apfloat(n, ApfloatHelper.extendPrecision(l), n2));
        }

        public Apfloat pow(long l) throws ApfloatRuntimeException {
            if (l == 0L) {
                return Apfloat.ONE;
            }
            int n = 0;
            while ((l & 1L) == 0L) {
                ++n;
                l >>>= 1;
            }
            Apfloat apfloat = this.get(n);
            while ((l >>>= 1) > 0L) {
                Apfloat apfloat2 = this.get(++n);
                if ((l & 1L) == 0L) continue;
                apfloat = apfloat.multiply(apfloat2);
            }
            return apfloat;
        }

        private Apfloat get(int n) throws ApfloatRuntimeException {
            Apfloat apfloat;
            if (this.list.size() > n) {
                apfloat = this.list.get(n);
            } else {
                apfloat = this.get(n - 1);
                apfloat = apfloat.multiply(apfloat);
                this.list.add(apfloat);
            }
            return apfloat;
        }
    }
}

