/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.spi.Util;

class GCDHelper {
    private GCDHelper() {
    }

    public static Apint gcd(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        if (apint.scale() > apint2.scale() && apint2.signum() != 0) {
            apint = apint.mod(apint2);
        } else if (apint2.scale() > apint.scale() && apint.signum() != 0) {
            apint2 = apint2.mod(apint);
        }
        Apint apint3 = (double)Math.max(apint.scale(), apint2.scale()) * Math.log(Math.max(apint.radix(), apint2.radix())) < 80000.0 ? GCDHelper.elementaryGcd(apint, apint2) : GCDHelper.recursiveGcd(apint, apint2);
        return apint3;
    }

    private static Apint elementaryGcd(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        while (apint2.signum() != 0) {
            Apint apint3 = apint.mod(apint2);
            apint = apint2;
            apint2 = apint3;
        }
        return ApintMath.abs(apint);
    }

    private static Apint recursiveGcd(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        if (apint.radix() != 2 || apint2.radix() != 2) {
            return GCDHelper.recursiveGcd(apint.toRadix(2), apint2.toRadix(2)).toRadix(apint.radix());
        }
        long l = Math.min(GCDHelper.v(apint), GCDHelper.v(apint2));
        apint = ApintMath.scale(apint, -GCDHelper.v(apint));
        apint2 = ApintMath.scale(apint2, 1L - GCDHelper.v(apint2));
        long l2 = Math.max(apint.scale(), apint2.scale());
        HalfGcdType halfGcdType = GCDHelper.halfBinaryGcd(apint, apint2, l2);
        long l3 = halfGcdType.j;
        Matrix matrix = halfGcdType.r;
        Apint apint3 = ApintMath.scale(matrix.r11.multiply(apint).add(matrix.r12.multiply(apint2)), -2L * l3);
        Apint apint4 = matrix.r21.multiply(apint).add(matrix.r22.multiply(apint2));
        if (apint4.signum() != 0) {
            apint3 = GCDHelper.elementaryGcd(apint3, ApintMath.scale(apint4, -2L * l3));
        }
        return ApintMath.abs(ApintMath.scale(apint3, l));
    }

    private static HalfGcdType halfBinaryGcd(Apint apint, Apint apint2, long l) throws ApfloatRuntimeException {
        assert (GCDHelper.v(apint) < GCDHelper.v(apint2));
        Apint apint3 = new Apint(1L, 2);
        if (GCDHelper.v(apint2) > l) {
            return new HalfGcdType(0L, new Matrix(apint3, Apint.ZERO, Apint.ZERO, apint3));
        }
        long l2 = l >> 1;
        Apint apint4 = apint.mod(GCDHelper.powerOfTwo(2L * l2 + 1L));
        Apint apint5 = apint2.mod(GCDHelper.powerOfTwo(2L * l2 + 1L));
        HalfGcdType halfGcdType = GCDHelper.halfBinaryGcd(apint4, apint5, l2);
        long l3 = halfGcdType.j;
        Apint apint6 = ApintMath.scale(halfGcdType.r.r11.multiply(apint).add(halfGcdType.r.r12.multiply(apint2)), -2L * l3);
        Apint apint7 = ApintMath.scale(halfGcdType.r.r21.multiply(apint).add(halfGcdType.r.r22.multiply(apint2)), -2L * l3);
        long l4 = GCDHelper.v(apint7);
        if (Util.ifFinite(l4, l4 + l3) > l) {
            return halfGcdType;
        }
        Apint[] apintArray = GCDHelper.binaryDivide(apint6, apint7);
        Apint apint8 = apintArray[0];
        Apint apint9 = apintArray[1];
        long l5 = l - (l4 + l3);
        Apint apint10 = ApintMath.scale(apint7, -l4).mod(GCDHelper.powerOfTwo(2L * l5 + 1L));
        Apint apint11 = ApintMath.scale(apint9, -l4).mod(GCDHelper.powerOfTwo(2L * l5 + 1L));
        HalfGcdType halfGcdType2 = GCDHelper.halfBinaryGcd(apint10, apint11, l5);
        long l6 = halfGcdType2.j;
        Matrix matrix = new Matrix(Apint.ZERO, GCDHelper.powerOfTwo(l4), GCDHelper.powerOfTwo(l4), apint8);
        Matrix matrix2 = halfGcdType2.r.multiply(matrix).multiply(halfGcdType.r);
        long l7 = l3 + l4 + l6;
        return new HalfGcdType(l7, matrix2);
    }

    private static Apint[] binaryDivide(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        Apint apint3;
        assert (apint.signum() != 0);
        assert (apint2.signum() != 0);
        assert (GCDHelper.v(apint) < GCDHelper.v(apint2));
        Apint apint4 = ApintMath.scale(apint, -GCDHelper.v(apint)).negate();
        Apint apint5 = ApintMath.scale(apint2, -GCDHelper.v(apint2));
        Apint apint6 = apint3 = new Apint(1L, 2);
        long l = GCDHelper.v(apint2) - GCDHelper.v(apint) + 1L;
        int n = Util.log2up(l);
        for (int i = 1; i <= n; ++i) {
            apint6 = apint6.add(apint6.multiply(apint3.subtract(apint5.multiply(apint6)))).mod(GCDHelper.powerOfTwo(1L << i));
        }
        apint6 = GCDHelper.cmod(apint4.multiply(apint6), GCDHelper.powerOfTwo(l));
        Apint apint7 = apint6.multiply(apint2).divide(GCDHelper.powerOfTwo(l - 1L)).add(apint);
        return new Apint[]{apint6, apint7};
    }

    private static long v(Apint apint) throws ApfloatRuntimeException {
        if (apint.signum() == 0) {
            return Long.MAX_VALUE;
        }
        return apint.scale() - apint.size();
    }

    private static Apint powerOfTwo(long l) throws ApfloatRuntimeException {
        assert (l >= 0L);
        return ApintMath.scale(new Apint(1L, 2), l);
    }

    private static Apint cmod(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        Apint apint3;
        apint = (apint = apint.mod(apint2)).compareTo(apint3 = ApintMath.scale(apint2, -1L)) > 0 ? apint.subtract(apint2) : apint;
        apint = apint.compareTo(apint3.negate()) <= 0 ? apint.add(apint2) : apint;
        return apint;
    }

    private static class HalfGcdType {
        public final long j;
        public final Matrix r;

        public HalfGcdType(long l, Matrix matrix) {
            this.j = l;
            this.r = matrix;
        }
    }

    private static class Matrix {
        public final Apint r11;
        public final Apint r12;
        public final Apint r21;
        public final Apint r22;

        public Matrix(Apint apint, Apint apint2, Apint apint3, Apint apint4) {
            this.r11 = apint;
            this.r12 = apint2;
            this.r21 = apint3;
            this.r22 = apint4;
        }

        public Matrix multiply(Matrix matrix) throws ApfloatRuntimeException {
            return new Matrix(Matrix.multiplyAdd(this.r11, matrix.r11, this.r12, matrix.r21), Matrix.multiplyAdd(this.r11, matrix.r12, this.r12, matrix.r22), Matrix.multiplyAdd(this.r21, matrix.r11, this.r22, matrix.r21), Matrix.multiplyAdd(this.r21, matrix.r12, this.r22, matrix.r22));
        }

        private static Apint multiplyAdd(Apint apint, Apint apint2, Apint apint3, Apint apint4) throws ApfloatRuntimeException {
            return apint.multiply(apint2).add(apint3.multiply(apint4));
        }
    }
}

