/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.Closeable;
import java.io.FilterWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormatSymbols;
import java.util.Formatter;
import java.util.Locale;

class FormattingHelper {
    private FormattingHelper() {
    }

    public static Writer wrapAppendableWriter(Appendable appendable) {
        return appendable instanceof Writer ? (Writer)appendable : new AppendableWriter(appendable);
    }

    public static Writer wrapLocalizeWriter(Writer writer, Formatter formatter, int n, boolean bl) {
        return new LocalizeWriter(writer, formatter.locale(), n <= 10, bl);
    }

    public static Writer wrapPadWriter(Writer writer, boolean bl) {
        writer = bl ? new CountWriter(writer) : new BufferWriter(writer);
        return writer;
    }

    public static void finishPad(Writer writer, long l) throws IOException {
        if (writer instanceof CountWriter) {
            CountWriter countWriter = (CountWriter)writer;
            long l2 = l - countWriter.count();
            FormattingHelper.pad(writer, l2);
        } else {
            BufferWriter bufferWriter = (BufferWriter)writer;
            long l3 = l - (long)bufferWriter.getBuffer().length();
            FormattingHelper.pad(bufferWriter.out(), l3);
            bufferWriter.out().append(bufferWriter.getBuffer());
        }
    }

    private static void pad(Appendable appendable, long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            appendable.append(' ');
        }
    }

    private static class BufferWriter
    extends StringWriter {
        private Writer out;

        public BufferWriter(Writer writer) {
            this.out = writer;
        }

        public Writer out() {
            return this.out;
        }
    }

    private static class CountWriter
    extends FilterWriter {
        private long count;

        public CountWriter(Writer writer) {
            super(writer);
        }

        public void write(int n) throws IOException {
            super.write(n);
            ++this.count;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            super.write(cArray, n, n2);
            this.count += (long)n2;
        }

        public void write(String string, int n, int n2) throws IOException {
            super.write(string, n, n2);
            this.count += (long)n2;
        }

        public long count() {
            return this.count;
        }
    }

    private static class LocalizeWriter
    extends FilterWriter {
        private Locale locale;
        private boolean localizeDigits;
        private boolean isUpperCase;
        private char zero;
        private char decimalSeparator;

        public LocalizeWriter(Writer writer, Locale locale, boolean bl, boolean bl2) {
            super(writer);
            this.locale = locale;
            this.localizeDigits = bl;
            this.isUpperCase = bl2;
            if (locale != null) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                this.zero = decimalFormatSymbols.getZeroDigit();
                this.decimalSeparator = decimalFormatSymbols.getDecimalSeparator();
            } else {
                this.zero = (char)48;
                this.decimalSeparator = (char)46;
            }
        }

        public void write(int n) throws IOException {
            if (n == 46) {
                n = this.decimalSeparator;
            } else if (this.localizeDigits && n >= 48 && n <= 57) {
                n += this.zero - 48;
            }
            if (this.isUpperCase) {
                String string = this.locale == null ? String.valueOf((char)n).toUpperCase() : String.valueOf((char)n).toUpperCase(this.locale);
                for (int i = 0; i < string.length(); ++i) {
                    super.write(string.charAt(i));
                }
            } else {
                super.write(n);
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.write(cArray[i + n]);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.write(string.charAt(i + n));
            }
        }
    }

    private static class AppendableWriter
    extends Writer {
        private Appendable out;

        public AppendableWriter(Appendable appendable) {
            this.out = appendable;
        }

        public void write(int n) throws IOException {
            this.out.append((char)n);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            for (int i = 0; i < n2; ++i) {
                this.out.append(cArray[i + n]);
            }
        }

        public void write(String string, int n, int n2) throws IOException {
            this.out.append(string, n, n2);
        }

        public Writer append(CharSequence charSequence) throws IOException {
            this.out.append(charSequence);
            return this;
        }

        public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
            this.out.append(charSequence, n, n2);
            return this;
        }

        public void flush() throws IOException {
            if (this.out instanceof Flushable) {
                ((Flushable)((Object)this.out)).flush();
            }
        }

        public void close() throws IOException {
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
    }
}

