/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.FixedPrecisionApcomplexHelper;
import org.apfloat.spi.Util;

public class FixedPrecisionApfloatHelper
extends FixedPrecisionApcomplexHelper {
    public FixedPrecisionApfloatHelper(long l) throws IllegalArgumentException {
        super(l);
    }

    public Apfloat valueOf(Apfloat apfloat) {
        return super.valueOf(apfloat);
    }

    public Apfloat negate(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(apfloat).negate();
    }

    public Apfloat add(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apfloat).add(this.valueOf(apfloat2)));
    }

    public Apfloat subtract(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apfloat).subtract(this.setPrecision(apfloat2)));
    }

    public Apfloat multiply(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apfloat).multiply(this.setPrecision(apfloat2)));
    }

    public Apfloat divide(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apfloat).divide(this.setPrecision(apfloat2)));
    }

    public Apfloat pow(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat3 = ApfloatHelper.checkPow(apfloat, apfloat2, this.precision());
        if (apfloat3 != null) {
            return this.valueOf(apfloat3);
        }
        return this.exp(this.multiply(this.log(apfloat), apfloat2));
    }

    public Apfloat pow(Apfloat apfloat, long l) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.pow(this.setPrecision(apfloat), l));
    }

    public Apfloat abs(Apfloat apfloat) throws ApfloatRuntimeException {
        return ApfloatMath.abs(this.valueOf(apfloat));
    }

    public Apfloat acos(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        if (apfloat.signum() == 0) {
            return this.divide(this.pi(apfloat.radix()), new Apfloat(2L, this.precision(), apfloat.radix()));
        }
        return this.valueOf(ApfloatMath.acos(this.setPrecision(apfloat)));
    }

    public Apfloat acosh(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.acosh(this.setPrecision(apfloat)));
    }

    public Apfloat asin(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.asin(this.setPrecision(apfloat)));
    }

    public Apfloat asinh(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.asinh(this.setPrecision(apfloat)));
    }

    public Apfloat atan(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.atan(this.setPrecision(apfloat)));
    }

    public Apfloat atanh(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.atanh(this.setPrecision(apfloat)));
    }

    public Apfloat cbrt(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.cbrt(this.setPrecision(apfloat)));
    }

    public Apfloat cos(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.cos(this.setTrigonometricPrecision(apfloat)));
    }

    public Apfloat cosh(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.cosh(this.setExponentialPrecision(apfloat)));
    }

    public Apfloat exp(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.exp(this.setExponentialPrecision(apfloat)));
    }

    public Apfloat log(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.log(this.setPrecision(apfloat)));
    }

    public Apfloat log(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.log(this.setPrecision(apfloat), this.setPrecision(apfloat2)));
    }

    public Apfloat sin(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sin(this.setTrigonometricPrecision(apfloat)));
    }

    public Apfloat sinh(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sinh(this.setExponentialPrecision(apfloat)));
    }

    public Apfloat sqrt(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sqrt(this.setPrecision(apfloat)));
    }

    public Apfloat tan(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.tan(this.setTrigonometricPrecision(apfloat)));
    }

    public Apfloat tanh(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.tanh(this.setExponentialPrecision(apfloat)));
    }

    public Apfloat agm(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.agm(this.setPrecision(apfloat), this.setPrecision(apfloat2)));
    }

    public Apfloat inverseRoot(Apfloat apfloat, long l) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.inverseRoot(this.setPrecision(apfloat), l));
    }

    public Apfloat root(Apfloat apfloat, long l) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.root(this.setPrecision(apfloat), l));
    }

    public Apfloat scale(Apfloat apfloat, long l) throws ApfloatRuntimeException {
        return ApfloatMath.scale(this.valueOf(apfloat), l);
    }

    public Apfloat mod(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return this.fmod(apfloat, apfloat2);
    }

    public Apfloat ceil(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.ceil(this.setPrecision(apfloat)));
    }

    public Apfloat floor(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.floor(this.setPrecision(apfloat)));
    }

    public Apfloat truncate(Apfloat apfloat) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.truncate(this.setPrecision(apfloat)));
    }

    public Apfloat atan2(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.atan2(this.setPrecision(apfloat), this.setPrecision(apfloat2)));
    }

    public Apfloat copySign(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return ApfloatMath.copySign(this.valueOf(apfloat), apfloat2);
    }

    public Apfloat fmod(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.fmod(apfloat, this.setPrecision(apfloat2)));
    }

    public Apfloat[] modf(Apfloat apfloat) throws ApfloatRuntimeException {
        if (apfloat.scale() > 0L) {
            long l = Util.ifFinite(this.precision(), this.precision() + apfloat.scale());
            apfloat = apfloat.precision(l);
        } else {
            apfloat = this.setPrecision(apfloat);
        }
        Apfloat[] apfloatArray = ApfloatMath.modf(apfloat);
        apfloatArray[0] = this.valueOf(apfloatArray[0]);
        apfloatArray[1] = this.valueOf(apfloatArray[1]);
        return apfloatArray;
    }

    public Apfloat factorial(long l) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.factorial(l, this.precision()));
    }

    public Apfloat factorial(long l, int n) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.factorial(l, this.precision(), n));
    }

    public Apfloat pi() throws ApfloatRuntimeException {
        return super.pi();
    }

    public Apfloat pi(int n) throws NumberFormatException, ApfloatRuntimeException {
        return super.pi(n);
    }

    public Apfloat logRadix(int n) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.logRadix(this.precision(), n);
    }

    public Apfloat multiplyAdd(Apfloat apfloat, Apfloat apfloat2, Apfloat apfloat3, Apfloat apfloat4) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.multiplyAdd(this.setPrecision(apfloat), this.setPrecision(apfloat2), this.setPrecision(apfloat3), this.setPrecision(apfloat4)));
    }

    public Apfloat multiplySubtract(Apfloat apfloat, Apfloat apfloat2, Apfloat apfloat3, Apfloat apfloat4) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.multiplySubtract(this.setPrecision(apfloat), this.setPrecision(apfloat2), this.setPrecision(apfloat3), this.setPrecision(apfloat4)));
    }

    public Apfloat product(Apfloat ... apfloatArray) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.product(this.setPrecision(apfloatArray)));
    }

    public Apfloat sum(Apfloat ... apfloatArray) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sum(this.setPrecision(apfloatArray)));
    }

    private Apfloat setPrecision(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.precision(this.precision());
    }

    private Apfloat[] setPrecision(Apfloat[] apfloatArray) throws ApfloatRuntimeException {
        Apfloat[] apfloatArray2 = new Apfloat[apfloatArray.length];
        for (int i = 0; i < apfloatArray.length; ++i) {
            apfloatArray2[i] = this.setPrecision(apfloatArray[i]);
        }
        return apfloatArray2;
    }
}

