/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.spi.Util;

public class FixedPrecisionApcomplexHelper {
    private long precision;

    public FixedPrecisionApcomplexHelper(long l) throws IllegalArgumentException {
        ApfloatHelper.checkPrecision(l);
        this.precision = l;
    }

    public Apcomplex valueOf(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return apcomplex.precision(this.precision());
    }

    public Apcomplex negate(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(apcomplex).negate();
    }

    public Apcomplex conj(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(apcomplex).conj();
    }

    public Apcomplex add(Apcomplex apcomplex, Apcomplex apcomplex2) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apcomplex).add(this.setPrecision(apcomplex2)));
    }

    public Apcomplex subtract(Apcomplex apcomplex, Apcomplex apcomplex2) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apcomplex).subtract(this.setPrecision(apcomplex2)));
    }

    public Apcomplex multiply(Apcomplex apcomplex, Apcomplex apcomplex2) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apcomplex).multiply(this.setPrecision(apcomplex2)));
    }

    public Apcomplex divide(Apcomplex apcomplex, Apcomplex apcomplex2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(apcomplex).divide(this.setPrecision(apcomplex2)));
    }

    public Apcomplex pow(Apcomplex apcomplex, Apcomplex apcomplex2) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex apcomplex3 = ApfloatHelper.checkPow(apcomplex, apcomplex2, this.precision());
        if (apcomplex3 != null) {
            return this.valueOf(apcomplex3);
        }
        return this.exp(this.multiply(this.log(apcomplex), apcomplex2));
    }

    public Apcomplex pow(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.pow(this.setPrecision(apcomplex), l));
    }

    public Apfloat arg(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.arg(this.setPrecision(apcomplex)));
    }

    public Apfloat imag(Apcomplex apcomplex) {
        return this.valueOf(apcomplex.imag());
    }

    public Apfloat real(Apcomplex apcomplex) {
        return this.valueOf(apcomplex.real());
    }

    public Apfloat abs(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.abs(this.setPrecision(apcomplex)));
    }

    public Apfloat norm(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.norm(this.setPrecision(apcomplex)));
    }

    public Apcomplex acos(Apcomplex apcomplex) throws ApfloatRuntimeException {
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            return this.divide(this.pi(apcomplex.radix()), new Apfloat(2L, this.precision(), apcomplex.radix()));
        }
        return this.valueOf(ApcomplexMath.acos(this.setPrecision(apcomplex)));
    }

    public Apcomplex acosh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            return this.valueOf(new Apcomplex(Apfloat.ZERO, this.pi(apcomplex.radix()).divide(new Apfloat(2L, this.precision(), apcomplex.radix()))));
        }
        return this.valueOf(ApcomplexMath.acosh(this.setPrecision(apcomplex)));
    }

    public Apcomplex asin(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.asin(this.setPrecision(apcomplex)));
    }

    public Apcomplex asinh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.asinh(this.setPrecision(apcomplex)));
    }

    public Apcomplex atan(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.atan(this.setPrecision(apcomplex)));
    }

    public Apcomplex atanh(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.atanh(this.setPrecision(apcomplex)));
    }

    public Apcomplex cbrt(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cbrt(this.setPrecision(apcomplex)));
    }

    public Apcomplex cos(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cos(this.setTrigExpPrecision(apcomplex)));
    }

    public Apcomplex cosh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cosh(this.setExpTrigPrecision(apcomplex)));
    }

    public Apcomplex exp(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.exp(this.setExpTrigPrecision(apcomplex)));
    }

    public Apcomplex log(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.log(this.setPrecision(apcomplex)));
    }

    public Apcomplex log(Apcomplex apcomplex, Apcomplex apcomplex2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.log(this.setPrecision(apcomplex), this.setPrecision(apcomplex2)));
    }

    public Apcomplex sin(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sin(this.setTrigExpPrecision(apcomplex)));
    }

    public Apcomplex sinh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sinh(this.setExpTrigPrecision(apcomplex)));
    }

    public Apcomplex sqrt(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sqrt(this.setPrecision(apcomplex)));
    }

    public Apcomplex tan(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.tan(this.setTrigExpPrecision(apcomplex)));
    }

    public Apcomplex tanh(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.tanh(this.setExpTrigPrecision(apcomplex)));
    }

    public Apcomplex agm(Apcomplex apcomplex, Apcomplex apcomplex2) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.agm(this.setPrecision(apcomplex), this.setPrecision(apcomplex2)));
    }

    public Apcomplex inverseRoot(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.inverseRoot(this.setPrecision(apcomplex), l));
    }

    public Apcomplex inverseRoot(Apcomplex apcomplex, long l, long l2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.inverseRoot(this.setPrecision(apcomplex), l, l2));
    }

    public Apcomplex root(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.root(this.setPrecision(apcomplex), l));
    }

    public Apcomplex root(Apcomplex apcomplex, long l, long l2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.root(this.setPrecision(apcomplex), l, l2));
    }

    public Apcomplex[] allRoots(Apcomplex apcomplex, int n) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex[] apcomplexArray = ApcomplexMath.allRoots(this.setPrecision(apcomplex), n);
        for (int i = 0; i < apcomplexArray.length; ++i) {
            apcomplexArray[i] = this.valueOf(apcomplexArray[i]);
        }
        return apcomplexArray;
    }

    public Apcomplex scale(Apcomplex apcomplex, long l) throws ApfloatRuntimeException {
        return ApcomplexMath.scale(this.valueOf(apcomplex), l);
    }

    public Apcomplex product(Apcomplex ... apcomplexArray) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.product(this.setPrecision(apcomplexArray)));
    }

    public Apcomplex sum(Apcomplex ... apcomplexArray) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sum(this.setPrecision(apcomplexArray)));
    }

    public long precision() {
        return this.precision;
    }

    Apfloat valueOf(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.precision(this.precision());
    }

    Apfloat pi() throws ApfloatRuntimeException {
        return ApfloatMath.pi(this.precision());
    }

    Apfloat pi(int n) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.pi(this.precision(), n);
    }

    Apfloat setTrigonometricPrecision(Apfloat apfloat) throws ApfloatRuntimeException {
        long l = ApfloatHelper.extendPrecision(this.precision(), Math.max(0L, apfloat.scale()));
        return apfloat.precision(l);
    }

    Apfloat setExponentialPrecision(Apfloat apfloat) throws ApfloatRuntimeException {
        if (apfloat.scale() <= -this.precision()) {
            apfloat = new Apfloat(0L, Long.MIN_VALUE, apfloat.radix());
        } else if (apfloat.scale() < 0L) {
            long l = Util.ifFinite(this.precision(), this.precision() + apfloat.scale());
            apfloat = apfloat.precision(l);
        } else {
            apfloat = apfloat.precision(this.precision);
        }
        return apfloat;
    }

    private Apcomplex setPrecision(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return apcomplex.precision(this.precision());
    }

    private Apcomplex[] setPrecision(Apcomplex[] apcomplexArray) throws ApfloatRuntimeException {
        Apcomplex[] apcomplexArray2 = new Apcomplex[apcomplexArray.length];
        for (int i = 0; i < apcomplexArray.length; ++i) {
            apcomplexArray2[i] = this.setPrecision(apcomplexArray[i]);
        }
        return apcomplexArray2;
    }

    private Apcomplex setExpTrigPrecision(Apcomplex apcomplex) {
        return new Apcomplex(this.setExponentialPrecision(apcomplex.real()), this.setTrigonometricPrecision(apcomplex.imag()));
    }

    private Apcomplex setTrigExpPrecision(Apcomplex apcomplex) {
        return new Apcomplex(this.setTrigonometricPrecision(apcomplex.real()), this.setExponentialPrecision(apcomplex.imag()));
    }
}

