/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Arrays;
import java.util.Comparator;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;

public class AprationalMath {
    private AprationalMath() {
    }

    public static Aprational pow(Aprational aprational, long l) throws ArithmeticException, ApfloatRuntimeException {
        if (l == 0L) {
            if (aprational.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, aprational.radix());
        }
        if (l < 0L) {
            aprational = Aprational.ONE.divide(aprational);
            l = -l;
        }
        int n = 0;
        while ((l & 1L) == 0L) {
            ++n;
            l >>>= 1;
        }
        Aprational aprational2 = aprational;
        while ((l >>>= 1) > 0L) {
            aprational = aprational.multiply(aprational);
            if ((l & 1L) == 0L) continue;
            aprational2 = aprational2.multiply(aprational);
        }
        while (n-- > 0) {
            aprational2 = aprational2.multiply(aprational2);
        }
        return aprational2;
    }

    @Deprecated
    public static Aprational negate(Aprational aprational) throws ApfloatRuntimeException {
        return aprational.negate();
    }

    public static Aprational abs(Aprational aprational) throws ApfloatRuntimeException {
        if (aprational.signum() >= 0) {
            return aprational;
        }
        return aprational.negate();
    }

    public static Aprational copySign(Aprational aprational, Aprational aprational2) throws ApfloatRuntimeException {
        if (aprational2.signum() == 0) {
            return aprational2;
        }
        if (aprational.signum() != aprational2.signum()) {
            return aprational.negate();
        }
        return aprational;
    }

    public static Aprational scale(Aprational aprational, long l) throws ApfloatRuntimeException {
        if (l >= 0L) {
            return new Aprational(ApintMath.scale(aprational.numerator(), l), aprational.denominator());
        }
        if (l == Long.MIN_VALUE) {
            Apint apint = ApintMath.pow(new Apint((long)aprational.radix(), aprational.radix()), 0x4000000000000000L);
            return new Aprational(aprational.numerator(), aprational.denominator().multiply(apint).multiply(apint));
        }
        return new Aprational(aprational.numerator(), ApintMath.scale(aprational.denominator(), -l));
    }

    public static Aprational product(Aprational ... aprationalArray) throws ApfloatRuntimeException {
        if (aprationalArray.length == 0) {
            return Aprational.ONE;
        }
        Apint[] apintArray = new Apint[aprationalArray.length];
        Apint[] apintArray2 = new Apint[aprationalArray.length];
        for (int i = 0; i < aprationalArray.length; ++i) {
            if (aprationalArray[i].signum() == 0) {
                return Aprational.ZERO;
            }
            apintArray[i] = aprationalArray[i].numerator();
            apintArray2[i] = aprationalArray[i].denominator();
        }
        return new Aprational(ApintMath.product(apintArray), ApintMath.product(apintArray2));
    }

    public static Aprational sum(Aprational ... aprationalArray) throws ApfloatRuntimeException {
        if (aprationalArray.length == 0) {
            return Aprational.ZERO;
        }
        aprationalArray = (Aprational[])aprationalArray.clone();
        Arrays.sort(aprationalArray, new Comparator<Aprational>(){

            @Override
            public int compare(Aprational aprational, Aprational aprational2) {
                long l;
                long l2 = ApfloatHelper.size(aprational);
                return l2 < (l = ApfloatHelper.size(aprational2)) ? -1 : (l2 > l ? 1 : 0);
            }
        });
        return AprationalMath.recursiveSum(aprationalArray, 0, aprationalArray.length - 1);
    }

    private static Aprational recursiveSum(Aprational[] aprationalArray, int n, int n2) throws ApfloatRuntimeException {
        if (n == n2) {
            return aprationalArray[n];
        }
        int n3 = n + n2 >>> 1;
        return AprationalMath.recursiveSum(aprationalArray, n, n3).add(AprationalMath.recursiveSum(aprationalArray, n3 + 1, n2));
    }
}

