/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Formatter;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.AprationalMath;
import org.apfloat.FormattingHelper;
import org.apfloat.spi.ApfloatImpl;
import org.apfloat.spi.RadixConstants;

public class Aprational
extends Apfloat {
    private static final long serialVersionUID = -224128535732558313L;
    private static final long UNDEFINED = Long.MIN_VALUE;
    private Apint numerator;
    private Apint denominator;
    private long scale = Long.MIN_VALUE;
    private transient Apfloat inverseDen = null;
    private transient Apfloat approx = null;

    protected Aprational() {
    }

    public Aprational(Apint apint) throws ApfloatRuntimeException {
        this(apint, ONE);
    }

    public Aprational(Apint apint, Apint apint2) throws IllegalArgumentException, ApfloatRuntimeException {
        this.numerator = apint;
        this.denominator = apint2;
        this.checkDenominator();
        this.reduce();
    }

    public Aprational(String string) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(string, ApfloatContext.getContext().getDefaultRadix());
    }

    public Aprational(String string, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n2 = string.indexOf(47);
        if (n2 < 0) {
            this.numerator = new Apint(string, n);
            this.denominator = ONE;
            return;
        }
        this.numerator = new Apint(string.substring(0, n2).trim(), n);
        this.denominator = new Apint(string.substring(n2 + 1).trim(), n);
        this.checkDenominator();
        this.reduce();
    }

    public Aprational(PushbackReader pushbackReader) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(pushbackReader, ApfloatContext.getContext().getDefaultRadix());
    }

    public Aprational(PushbackReader pushbackReader, int n) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this.numerator = new Apint(pushbackReader, n);
        ApfloatHelper.extractWhitespace(pushbackReader);
        if (!ApfloatHelper.readMatch(pushbackReader, 47)) {
            this.denominator = ONE;
            return;
        }
        ApfloatHelper.extractWhitespace(pushbackReader);
        this.denominator = new Apint(pushbackReader, n);
        this.checkDenominator();
        this.reduce();
    }

    public Aprational(BigInteger bigInteger) throws ApfloatRuntimeException {
        this.numerator = new Apint(bigInteger);
        this.denominator = ONE;
    }

    public Aprational(BigInteger bigInteger, int n) throws ApfloatRuntimeException {
        this.numerator = new Apint(bigInteger, n);
        this.denominator = ONE;
    }

    public Apint numerator() {
        return this.numerator;
    }

    public Apint denominator() {
        return this.denominator;
    }

    public int radix() {
        return this.numerator() == ONE ? this.denominator().radix() : this.numerator().radix();
    }

    public long precision() throws ApfloatRuntimeException {
        return Long.MAX_VALUE;
    }

    public synchronized long scale() throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return -9223372036854775807L;
        }
        if (this.scale == Long.MIN_VALUE) {
            long l = this.numerator().scale() - this.denominator().scale();
            l = l > 0L ? this.truncate().scale() : AprationalMath.scale(this, 1L - l).truncate().scale() + l - 1L;
            this.scale = l;
        }
        return this.scale;
    }

    public long size() throws ApfloatRuntimeException {
        Apint apint = this.denominator();
        for (int i = 0; i < RadixConstants.RADIX_FACTORS[this.radix()].length; ++i) {
            Apint[] apintArray;
            Apint apint2 = new Apint((long)RadixConstants.RADIX_FACTORS[this.radix()][i], this.radix());
            while ((apintArray = ApintMath.div(apint, apint2))[1].signum() == 0) {
                apint = apintArray[0];
            }
        }
        long l = !apint.equals(ONE) ? Long.MAX_VALUE : ApintMath.scale(this.numerator(), this.denominator().scale() * 5L).divide(this.denominator()).size();
        return l;
    }

    public int signum() {
        return this.numerator().signum();
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.numerator().isShort() && this.denominator().equals(ONE);
    }

    public Aprational negate() throws ApfloatRuntimeException {
        return new Aprational(this.numerator().negate(), this.denominator());
    }

    public Aprational add(Aprational aprational) throws ApfloatRuntimeException {
        return new Aprational(this.numerator().multiply(aprational.denominator()).add(this.denominator().multiply(aprational.numerator())), this.denominator().multiply(aprational.denominator())).reduce();
    }

    public Aprational subtract(Aprational aprational) throws ApfloatRuntimeException {
        return new Aprational(this.numerator().multiply(aprational.denominator()).subtract(this.denominator().multiply(aprational.numerator())), this.denominator().multiply(aprational.denominator())).reduce();
    }

    public Aprational multiply(Aprational aprational) throws ApfloatRuntimeException {
        Aprational aprational2 = new Aprational(this.numerator().multiply(aprational.numerator()), this.denominator().multiply(aprational.denominator()));
        if (this == aprational) {
            return aprational2;
        }
        return aprational2.reduce();
    }

    public Aprational divide(Aprational aprational) throws ArithmeticException, ApfloatRuntimeException {
        if (aprational.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.signum() == 0) {
            return this;
        }
        return new Aprational(this.numerator().multiply(aprational.denominator()), this.denominator().multiply(aprational.numerator())).reduce();
    }

    public Aprational mod(Aprational aprational) throws ApfloatRuntimeException {
        if (aprational.signum() == 0) {
            return aprational;
        }
        if (this.signum() == 0) {
            return this;
        }
        return this.subtract(this.divide(aprational).truncate().multiply(aprational));
    }

    public Apint floor() throws ApfloatRuntimeException {
        if (this.signum() >= 0) {
            return this.truncate();
        }
        return this.roundAway();
    }

    public Apint ceil() throws ApfloatRuntimeException {
        if (this.signum() <= 0) {
            return this.truncate();
        }
        return this.roundAway();
    }

    public Apint truncate() throws ApfloatRuntimeException {
        return this.numerator().divide(this.denominator());
    }

    private Apint roundAway() throws ApfloatRuntimeException {
        Apint[] apintArray = ApintMath.div(this.numerator(), this.denominator());
        if (apintArray[1].signum() == 0) {
            return apintArray[0];
        }
        return apintArray[0].add(new Apint((long)this.signum(), apintArray[0].radix()));
    }

    public Aprational toRadix(int n) throws NumberFormatException, ApfloatRuntimeException {
        return new Aprational(this.numerator().toRadix(n), this.denominator().toRadix(n));
    }

    public int compareTo(Aprational aprational) {
        Apint apint = this.numerator().multiply(aprational.denominator());
        Apint apint2 = aprational.numerator().multiply(this.denominator());
        return apint.compareTo(apint2);
    }

    public int compareTo(Apfloat apfloat) {
        if (apfloat instanceof Aprational) {
            return this.compareTo((Aprational)apfloat);
        }
        Apfloat apfloat2 = this.numerator().precision(Long.MAX_VALUE);
        Apfloat apfloat3 = apfloat.multiply(this.denominator()).precision(Long.MAX_VALUE);
        return apfloat2.compareTo(apfloat3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Aprational) {
            Aprational aprational = (Aprational)object;
            return this.numerator().equals(aprational.numerator()) && this.denominator().equals(aprational.denominator());
        }
        if (object instanceof Apfloat) {
            Apfloat apfloat = (Apfloat)object;
            Apfloat apfloat2 = this.numerator().precision(Long.MAX_VALUE);
            Apfloat apfloat3 = apfloat.multiply(this.denominator()).precision(Long.MAX_VALUE);
            return apfloat2.equals(apfloat3);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.numerator().hashCode() * 3 + this.denominator().hashCode();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) throws ApfloatRuntimeException {
        return this.numerator().toString(bl) + (this.denominator().equals(ONE) ? "" : '/' + this.denominator().toString(bl));
    }

    public void writeTo(Writer writer) throws IOException, ApfloatRuntimeException {
        this.writeTo(writer, true);
    }

    public void writeTo(Writer writer, boolean bl) throws IOException, ApfloatRuntimeException {
        this.numerator().writeTo(writer, bl);
        if (!this.denominator().equals(ONE)) {
            writer.write(47);
            this.denominator().writeTo(writer, bl);
        }
    }

    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        if (this.denominator().equals(ONE)) {
            this.numerator().formatTo(formatter, n, n2, n3);
        } else if (n2 == -1) {
            this.numerator().formatTo(formatter, n, n2, n3);
            formatter.format("/", new Object[0]);
            this.denominator().formatTo(formatter, n, n2, n3);
        } else {
            try {
                Writer writer = FormattingHelper.wrapAppendableWriter(formatter.out());
                writer = FormattingHelper.wrapPadWriter(writer, (n & 1) == 1);
                formatter = new Formatter(writer, formatter.locale());
                this.numerator().formatTo(formatter, n, -1, n3);
                formatter.format("/", new Object[0]);
                this.denominator().formatTo(formatter, n, -1, n3);
                FormattingHelper.finishPad(writer, n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected ApfloatImpl getImpl(long l) throws ApfloatRuntimeException {
        return this.ensureApprox(l).getImpl(l);
    }

    private void checkDenominator() throws IllegalArgumentException {
        if (this.denominator.signum() == 0) {
            throw new IllegalArgumentException("Denominator is zero");
        }
    }

    private Aprational reduce() throws IllegalArgumentException, ApfloatRuntimeException {
        if (this.numerator.signum() == 0) {
            this.denominator = ONE;
        } else {
            if (!this.numerator.equals(ONE) && !this.denominator.equals(ONE)) {
                if (this.numerator.radix() != this.denominator.radix()) {
                    throw new IllegalArgumentException("Numerator and denominator must have the same radix");
                }
                Apint apint = ApintMath.gcd(this.numerator, this.denominator);
                this.numerator = this.numerator.divide(apint);
                this.denominator = this.denominator.divide(apint);
            }
            int n = this.numerator.signum() * this.denominator.signum();
            this.denominator = ApintMath.abs(this.denominator);
            if (n != this.numerator.signum()) {
                this.numerator = this.numerator.negate();
            }
        }
        return this;
    }

    private synchronized Apfloat ensureApprox(long l) throws ApfloatRuntimeException {
        if (!this.hasApprox(l)) {
            if (this.denominator().equals(ONE)) {
                this.approx = this.numerator();
            } else {
                l = Math.max(l, 1L);
                if (this.denominator().isShort()) {
                    this.approx = this.numerator().precision(l).divide(this.denominator());
                } else {
                    this.inverseDen = ApfloatMath.inverseRoot(this.denominator(), 1L, l, this.inverseDen);
                    this.approx = this.numerator().multiply(this.inverseDen);
                }
            }
        }
        return this.approx;
    }

    private boolean hasApprox(long l) throws ApfloatRuntimeException {
        return this.approx != null && this.approx.precision() >= l;
    }
}

