/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.GCDHelper;

public class ApintMath {
    private ApintMath() {
    }

    public static Apint pow(Apint apint, long l) throws ArithmeticException, ApfloatRuntimeException {
        if (l == 0L) {
            if (apint.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, apint.radix());
        }
        if (l < 0L) {
            return Apint.ZERO;
        }
        int n = 0;
        while ((l & 1L) == 0L) {
            ++n;
            l >>= 1;
        }
        Apint apint2 = apint;
        while ((l >>= 1) > 0L) {
            apint = apint.multiply(apint);
            if ((l & 1L) == 0L) continue;
            apint2 = apint2.multiply(apint);
        }
        while (n-- > 0) {
            apint2 = apint2.multiply(apint2);
        }
        return apint2;
    }

    public static Apint[] sqrt(Apint apint) throws ArithmeticException, ApfloatRuntimeException {
        return ApintMath.root(apint, 2L);
    }

    public static Apint[] cbrt(Apint apint) throws ApfloatRuntimeException {
        return ApintMath.root(apint, 3L);
    }

    public static Apint[] root(Apint apint, long l) throws ArithmeticException, ApfloatRuntimeException {
        Apint apint2;
        if (l == 0L) {
            if (apint.signum() == 0) {
                throw new ArithmeticException("Zeroth root of zero");
            }
            Apint apint3 = new Apint(1L, apint.radix());
            return new Apint[]{apint3, apint.subtract(apint3)};
        }
        if (apint.signum() == 0) {
            return new Apint[]{apint, apint};
        }
        if (apint.equals(Apint.ONE) || l == 1L) {
            return new Apint[]{apint, Apint.ZERO};
        }
        if (l < 0L) {
            return new Apint[]{Apint.ZERO, apint};
        }
        long l2 = apint.scale() / l + 20L;
        Apfloat apfloat = apint.precision(l2);
        Apfloat apfloat2 = ApfloatMath.root(apfloat, l);
        Apint apint4 = apfloat2.truncate();
        Apint apint5 = ApintMath.pow(apint4, l);
        if (ApintMath.abs(apint5).compareTo(ApintMath.abs(apint)) > 0) {
            apint5 = apint.signum() >= 0 ? ApintMath.powXMinus1(apint5, apint4, l) : ApintMath.powXPlus1(apint5, apint4, l);
            apint4 = apint4.subtract(new Apint((long)apint.signum(), apint.radix()));
        } else {
            Apint apint6 = apint2 = apint.signum() >= 0 ? ApintMath.powXPlus1(apint5, apint4, l) : ApintMath.powXMinus1(apint5, apint4, l);
            if (ApintMath.abs(apint2).compareTo(ApintMath.abs(apint)) <= 0) {
                apint5 = apint2;
                apint4 = apint4.add(new Apint((long)apint.signum(), apint.radix()));
            }
        }
        apint2 = apint.subtract(apint5);
        assert (apint2.signum() * apint.signum() >= 0);
        return new Apint[]{apint4, apint2};
    }

    private static Apint powXMinus1(Apint apint, Apint apint2, long l) throws ApfloatRuntimeException {
        Apint apint3 = new Apint(1L, apint2.radix());
        apint = l == 2L ? apint.subtract(apint2).subtract(apint2).add(apint3) : (l == 3L ? apint.subtract(new Apint(3L, apint2.radix()).multiply(apint2).multiply(apint2.subtract(apint3))).subtract(apint3) : ApintMath.pow(apint2.subtract(apint3), l));
        return apint;
    }

    private static Apint powXPlus1(Apint apint, Apint apint2, long l) throws ApfloatRuntimeException {
        Apint apint3 = new Apint(1L, apint2.radix());
        apint = l == 2L ? apint.add(apint2).add(apint2).add(apint3) : (l == 3L ? apint.add(new Apint(3L, apint2.radix()).multiply(apint2).multiply(apint2.add(apint3))).add(apint3) : ApintMath.pow(apint2.add(apint3), l));
        return apint;
    }

    @Deprecated
    public static Apint negate(Apint apint) throws ApfloatRuntimeException {
        return apint.negate();
    }

    public static Apint abs(Apint apint) throws ApfloatRuntimeException {
        if (apint.signum() >= 0) {
            return apint;
        }
        return apint.negate();
    }

    public static Apint copySign(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        if (apint2.signum() == 0) {
            return apint2;
        }
        if (apint.signum() != apint2.signum()) {
            return apint.negate();
        }
        return apint;
    }

    public static Apint scale(Apint apint, long l) throws ApfloatRuntimeException {
        return ApfloatMath.scale(apint, l).truncate();
    }

    public static Apint[] div(Apint apint, Apint apint2) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat;
        Apint apint3;
        if (apint2.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (apint.signum() == 0) {
            return new Apint[]{apint, apint};
        }
        if (apint2.equals(Apint.ONE)) {
            return new Apint[]{apint, Apint.ZERO};
        }
        Apint apint4 = ApintMath.abs(apint);
        if (apint4.compareTo(apint3 = ApintMath.abs(apint2)) < 0) {
            return new Apint[]{Apint.ZERO, apint};
        }
        long l = apint.scale() - apint2.scale() + 20L;
        Apfloat apfloat2 = apint.precision(l);
        Apint apint5 = apfloat2.divide(apfloat = apint2.precision(l)).truncate();
        if ((apint4 = apint4.subtract(ApintMath.abs(apint5.multiply(apint2)))).compareTo(apint3) >= 0) {
            apint5 = apint5.add(new Apint((long)(apint.signum() * apint2.signum()), apint.radix()));
            apint4 = apint4.subtract(apint3);
        } else if (apint4.signum() < 0) {
            apint5 = apint5.subtract(new Apint((long)(apint.signum() * apint2.signum()), apint.radix()));
            apint4 = apint4.add(apint3);
        }
        Apint apint6 = ApintMath.copySign(apint4, apint);
        return new Apint[]{apint5, apint6};
    }

    public static Apint gcd(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        return GCDHelper.gcd(apint, apint2);
    }

    public static Apint lcm(Apint apint, Apint apint2) throws ApfloatRuntimeException {
        if (apint.signum() == 0 && apint2.signum() == 0) {
            return Apint.ZERO;
        }
        return ApintMath.abs(apint.multiply(apint2)).divide(ApintMath.gcd(apint, apint2));
    }

    public static Apint modMultiply(Apint apint, Apint apint2, Apint apint3) throws ApfloatRuntimeException {
        return apint.multiply(apint2).mod(apint3);
    }

    private static Apint modMultiply(Apint apint, Apint apint2, Apint apint3, Apfloat apfloat) throws ApfloatRuntimeException {
        Apint apint4;
        Apint apint5 = apint.multiply(apint2);
        if (apint5.signum() == 0) {
            return apint5;
        }
        long l = apint5.scale() - apint3.scale() + 20L;
        Apint apint6 = ApintMath.abs(apint5);
        if (apint6.compareTo(apint4 = ApintMath.abs(apint3)) < 0) {
            return apint5;
        }
        Apint apint7 = apint5.multiply(apfloat.precision(l)).truncate();
        if ((apint6 = apint6.subtract(ApintMath.abs(apint7.multiply(apint3)))).compareTo(apint4) >= 0) {
            apint6 = apint6.subtract(apint4);
        } else if (apint6.signum() < 0) {
            apint6 = apint6.add(apint4);
        }
        apint7 = ApintMath.copySign(apint6, apint5);
        return apint7;
    }

    public static Apint modPow(Apint apint, Apint apint2, Apint apint3) throws ArithmeticException, ApfloatRuntimeException {
        Apint[] apintArray;
        if (apint2.signum() == 0) {
            if (apint.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apint(1L, apint.radix());
        }
        if (apint3.signum() == 0) {
            return apint3;
        }
        apint3 = ApintMath.abs(apint3);
        Apfloat apfloat = ApfloatMath.inverseRoot(apint3, 1L, apint3.scale() + 20L);
        apint = apint.mod(apint3);
        if (apint2.signum() < 0) {
            apint = ApintMath.modInverse(apint, apint3);
            apint2 = apint2.negate();
        }
        Apint apint4 = new Apint(2L, apint2.radix());
        while ((apintArray = ApintMath.div(apint2, apint4))[1].signum() == 0) {
            apint = ApintMath.modMultiply(apint, apint, apint3, apfloat);
            apint2 = apintArray[0];
        }
        Apint apint5 = apint;
        apintArray = ApintMath.div(apint2, apint4);
        while ((apint2 = apintArray[0]).signum() > 0) {
            apint = ApintMath.modMultiply(apint, apint, apint3, apfloat);
            apintArray = ApintMath.div(apint2, apint4);
            if (apintArray[1].signum() == 0) continue;
            apint5 = ApintMath.modMultiply(apint5, apint, apint3, apfloat);
        }
        return apint5;
    }

    private static Apint modInverse(Apint apint, Apint apint2) throws ArithmeticException, ApfloatRuntimeException {
        Apint apint3 = new Apint(1L, apint2.radix());
        Apint apint4 = Apint.ZERO;
        Apint apint5 = apint3;
        Apint apint6 = apint3;
        Apint apint7 = Apint.ZERO;
        Apint apint8 = apint;
        Apint apint9 = apint2;
        while (apint9.signum() != 0) {
            Apint apint10 = apint.divide(apint9);
            Apint apint11 = apint9;
            apint9 = apint.mod(apint9);
            apint = apint11;
            apint11 = apint4;
            apint4 = apint6.subtract(apint10.multiply(apint4));
            apint6 = apint11;
            apint11 = apint5;
            apint5 = apint7.subtract(apint10.multiply(apint5));
            apint7 = apint11;
        }
        if (!ApintMath.abs(apint).equals(apint3)) {
            throw new ArithmeticException("Modular inverse does not exist");
        }
        if (apint6.signum() != apint8.signum()) {
            apint6 = apint6.add(ApintMath.copySign(apint2, apint8));
        }
        return apint6;
    }

    public static Apint factorial(long l) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        return new Apint(ApfloatMath.factorial(l, Long.MAX_VALUE));
    }

    public static Apint factorial(long l, int n) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        return new Apint(ApfloatMath.factorial(l, Long.MAX_VALUE, n));
    }

    public static Apint product(Apint ... apintArray) throws ApfloatRuntimeException {
        return new Apint(ApfloatMath.product(apintArray));
    }

    public static Apint sum(Apint ... apintArray) throws ApfloatRuntimeException {
        return new Apint(ApfloatMath.sum(apintArray));
    }
}

