/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigInteger;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formatter;
import java.util.IllegalFormatPrecisionException;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Aprational;
import org.apfloat.spi.ApfloatImpl;

public class Apint
extends Aprational {
    private static final long serialVersionUID = 5409721945040465491L;
    private Apfloat value;

    protected Apint() {
    }

    Apint(Apfloat apfloat) {
        this.value = apfloat;
    }

    public Apint(String string) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(string, true));
    }

    public Apint(String string, int n) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(string, Long.MAX_VALUE, n, true));
    }

    public Apint(long l) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(l));
    }

    public Apint(long l, int n) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(l, Long.MAX_VALUE, n));
    }

    public Apint(PushbackReader pushbackReader) throws IOException, NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(pushbackReader, Long.MAX_VALUE, true));
    }

    public Apint(PushbackReader pushbackReader, int n) throws IOException, NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(ApfloatHelper.createApfloat(pushbackReader, Long.MAX_VALUE, n, true));
    }

    public Apint(BigInteger bigInteger) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(bigInteger);
    }

    public Apint(BigInteger bigInteger, int n) throws NumberFormatException, ApfloatRuntimeException {
        this.value = new Apfloat(bigInteger, Long.MAX_VALUE, n);
    }

    public Apint numerator() {
        return this;
    }

    public Apint denominator() {
        return ONE;
    }

    public int radix() {
        return this.value.radix();
    }

    public long scale() throws ApfloatRuntimeException {
        return this.value.scale();
    }

    public long size() throws ApfloatRuntimeException {
        return this.value.size();
    }

    public int signum() {
        return this.value.signum();
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.value.isShort();
    }

    public Apint negate() throws ApfloatRuntimeException {
        return new Apint(this.value.negate());
    }

    public Apint add(Apint apint) throws ApfloatRuntimeException {
        return new Apint(this.value.add(apint.value));
    }

    public Apint subtract(Apint apint) throws ApfloatRuntimeException {
        return new Apint(this.value.subtract(apint.value));
    }

    public Apint multiply(Apint apint) throws ApfloatRuntimeException {
        return new Apint(this.value.multiply(apint.value));
    }

    public Apint divide(Apint apint) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat;
        Apfloat apfloat2;
        if (apint.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.signum() == 0) {
            return this;
        }
        if (apint.equals(ONE)) {
            return this;
        }
        Apfloat apfloat3 = ApfloatMath.abs(this.value);
        if (apfloat3.compareTo(apfloat2 = ApfloatMath.abs(apint.value)) < 0) {
            return ZERO;
        }
        long l = this.scale() - apint.scale() + 20L;
        Apfloat apfloat4 = this.value.precision(l);
        Apint apint2 = apfloat4.divide(apfloat = apint.value.precision(l)).truncate();
        if ((apfloat3 = apfloat3.subtract(ApfloatMath.abs(apint2.multiply(apint.value)))).compareTo(apfloat2) >= 0) {
            apint2 = apint2.add(new Apint((long)(this.signum() * apint.signum()), apint.radix()));
        } else if (apfloat3.signum() < 0) {
            apint2 = apint2.subtract(new Apint((long)(this.signum() * apint.signum()), apint.radix()));
        }
        return apint2;
    }

    public Apint mod(Apint apint) throws ApfloatRuntimeException {
        return new Apint(this.value.mod(apint.value));
    }

    public Apint floor() {
        return this;
    }

    public Apint ceil() {
        return this;
    }

    public Apint truncate() {
        return this;
    }

    public BigInteger toBigInteger() throws IllegalArgumentException {
        if (this.signum() == 0) {
            return BigInteger.ZERO;
        }
        return ApfloatHelper.toBigInteger(this);
    }

    public Apint toRadix(int n) throws NumberFormatException, ApfloatRuntimeException {
        return new Apint(this.value.toRadix(n));
    }

    public int compareTo(Apint apint) {
        return this.value.compareTo(apint.value);
    }

    public int compareTo(Aprational aprational) {
        if (aprational instanceof Apint) {
            return this.compareTo((Apint)aprational);
        }
        return super.compareTo(aprational);
    }

    public int compareTo(Apfloat apfloat) {
        if (apfloat instanceof Aprational) {
            return this.compareTo((Aprational)apfloat);
        }
        return this.value.compareTo(apfloat);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Apint) {
            Apint apint = (Apint)object;
            return this.value.equals(apint.value);
        }
        if (object instanceof Apfloat && !(object instanceof Aprational)) {
            Apfloat apfloat = (Apfloat)object;
            return this.value.equals(apfloat);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString(boolean bl) throws ApfloatRuntimeException {
        return this.value.toString(bl);
    }

    public void writeTo(Writer writer, boolean bl) throws IOException, ApfloatRuntimeException {
        this.value.writeTo(writer, bl);
    }

    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        if ((n & 4) == 4) {
            throw new FormatFlagsConversionMismatchException("#", 's');
        }
        if (n3 != -1) {
            throw new IllegalFormatPrecisionException(n3);
        }
        this.value.formatTo(formatter, n | 4, n2, n3);
    }

    protected ApfloatImpl getImpl(long l) throws ApfloatRuntimeException {
        return this.value.getImpl(l);
    }
}

