/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ConcurrentSoftHashMap;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.OverflowException;
import org.apfloat.ShutdownMap;
import org.apfloat.spi.Util;

public class ApfloatMath {
    private static final Map<Integer, Apfloat> SHUTDOWN_MAP = new ShutdownMap<Integer, Apfloat>();
    private static ConcurrentMap<Integer, Integer> radixPiKeys = new ConcurrentHashMap<Integer, Integer>();
    private static Map<Integer, Apfloat> radixPi = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, PiCalculator> radixPiCalculator = new Hashtable<Integer, PiCalculator>();
    private static Map<Integer, Apfloat> radixPiT = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixPiQ = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixPiP = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixPiInverseRoot = new ConcurrentSoftHashMap<Integer, Apfloat>();
    private static Map<Integer, Long> radixPiTerms = new Hashtable<Integer, Long>();
    private static ConcurrentMap<Integer, Integer> radixLogKeys = new ConcurrentHashMap<Integer, Integer>();
    private static Map<Integer, Apfloat> radixLog = new ConcurrentHashMap<Integer, Apfloat>();
    private static Map<Integer, Apfloat> radixLogPi = new ConcurrentHashMap<Integer, Apfloat>();

    private ApfloatMath() {
    }

    public static Apfloat pow(Apfloat apfloat, long l) throws ArithmeticException, ApfloatRuntimeException {
        if (l == 0L) {
            if (apfloat.signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        }
        if (l < 0L) {
            apfloat = ApfloatMath.inverseRoot(apfloat, 1L);
            l = -l;
        }
        long l2 = apfloat.precision();
        apfloat = ApfloatHelper.extendPrecision(apfloat);
        int n = 0;
        while ((l & 1L) == 0L) {
            ++n;
            l >>>= 1;
        }
        Apfloat apfloat2 = apfloat;
        while ((l >>>= 1) > 0L) {
            apfloat = apfloat.multiply(apfloat);
            if ((l & 1L) == 0L) continue;
            apfloat2 = apfloat2.multiply(apfloat);
        }
        while (n-- > 0) {
            apfloat2 = apfloat2.multiply(apfloat2);
        }
        return apfloat2.precision(l2);
    }

    public static Apfloat sqrt(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.root(apfloat, 2L);
    }

    public static Apfloat cbrt(Apfloat apfloat) throws ApfloatRuntimeException {
        return ApfloatMath.root(apfloat, 3L);
    }

    public static Apfloat root(Apfloat apfloat, long l) throws ArithmeticException, ApfloatRuntimeException {
        if (l == 0L) {
            throw new ArithmeticException("Zeroth root");
        }
        if (apfloat.signum() == 0) {
            return Apfloat.ZERO;
        }
        if (l == 1L) {
            return apfloat;
        }
        if (l == Long.MIN_VALUE) {
            return ApfloatMath.sqrt(ApfloatMath.inverseRoot(apfloat, l / -2L));
        }
        if (l < 0L) {
            return ApfloatMath.inverseRoot(apfloat, -l);
        }
        if (l == 2L) {
            return apfloat.multiply(ApfloatMath.inverseRoot(apfloat, 2L));
        }
        if (l == 3L) {
            Apfloat apfloat2 = apfloat.multiply(apfloat);
            return apfloat.multiply(ApfloatMath.inverseRoot(apfloat2, 3L));
        }
        Apfloat apfloat3 = ApfloatMath.inverseRoot(apfloat, l);
        return ApfloatMath.inverseRoot(apfloat3, 1L);
    }

    public static Apfloat inverseRoot(Apfloat apfloat, long l) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.inverseRoot(apfloat, l, apfloat.precision());
    }

    public static Apfloat inverseRoot(Apfloat apfloat, long l, long l2) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.inverseRoot(apfloat, l, l2, null);
    }

    public static Apfloat inverseRoot(Apfloat apfloat, long l, long l2, Apfloat apfloat2) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.inverseRoot(apfloat, l, l2, apfloat2, apfloat2 == null ? 0L : apfloat2.precision());
    }

    public static Apfloat inverseRoot(Apfloat apfloat, long l, long l2, Apfloat apfloat2, long l3) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        long l4;
        Apfloat apfloat3;
        long l5;
        if (apfloat.signum() == 0) {
            throw new ArithmeticException("Inverse root of zero");
        }
        if (l == 0L) {
            throw new ArithmeticException("Inverse zeroth root");
        }
        if ((l & 1L) == 0L && apfloat.signum() < 0) {
            throw new ArithmeticException("Even root of negative number; result would be complex");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Target precision " + l2 + " is not positive");
        }
        if (apfloat.equals(Apfloat.ONE)) {
            return apfloat.precision(l2);
        }
        if (l2 == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate inverse root to infinite precision");
        }
        if (l == Long.MIN_VALUE) {
            Apfloat apfloat4 = ApfloatMath.inverseRoot(apfloat, l / -2L);
            return ApfloatMath.inverseRoot(apfloat4, 2L);
        }
        if (l < 0L) {
            Apfloat apfloat5 = ApfloatMath.inverseRoot(apfloat, -l);
            return ApfloatMath.inverseRoot(apfloat5, 1L);
        }
        long l6 = ApfloatHelper.getDoublePrecision(apfloat.radix());
        Apfloat apfloat6 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat7 = new Apfloat(l, Long.MAX_VALUE, apfloat.radix());
        if (apfloat2 == null || l3 < l6) {
            long l7 = apfloat.scale() / l;
            l5 = apfloat.scale() - l7 * l;
            apfloat3 = apfloat.precision(l6);
            apfloat3 = ApfloatMath.scale(apfloat3, -apfloat3.scale());
            l4 = l6;
            apfloat3 = new Apfloat((double)apfloat3.signum() * Math.pow(Math.abs(apfloat3.doubleValue()), -1.0 / (double)l) * Math.pow(apfloat.radix(), (double)(-l5) / (double)l), l4, apfloat.radix());
            apfloat3 = ApfloatMath.scale(apfloat3, -l7);
        } else {
            apfloat3 = apfloat2;
            l4 = l3;
        }
        int n = 0;
        for (long i = l4; i < l2; i <<= 1) {
            ++n;
        }
        int n2 = n;
        l5 = l4;
        while (n2 > 0 && l5 - 20L << n2 < l2) {
            --n2;
            l5 <<= 1;
        }
        apfloat = ApfloatHelper.extendPrecision(apfloat);
        while (n-- > 0) {
            apfloat3 = apfloat3.precision(Math.min(l4 *= 2L, l2));
            Apfloat apfloat8 = ApfloatMath.pow(apfloat3, l);
            apfloat8 = ApfloatMath.lastIterationExtendPrecision(n, n2, apfloat8);
            apfloat8 = apfloat6.subtract(apfloat.multiply(apfloat8));
            if (n < n2) {
                apfloat8 = apfloat8.precision(l4 / 2L);
            }
            apfloat3 = ApfloatMath.lastIterationExtendPrecision(n, n2, apfloat3);
            apfloat3 = apfloat3.add(apfloat3.multiply(apfloat8).divide(apfloat7));
            if (n != n2) continue;
            apfloat8 = ApfloatMath.pow(apfloat3, l);
            apfloat8 = ApfloatMath.lastIterationExtendPrecision(n, -1, apfloat8);
            apfloat3 = ApfloatMath.lastIterationExtendPrecision(n, -1, apfloat3);
            apfloat3 = apfloat3.add(apfloat3.multiply(apfloat6.subtract(apfloat.multiply(apfloat8))).divide(apfloat7));
        }
        return apfloat3.precision(l2);
    }

    public static Apint floor(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.floor();
    }

    public static Apint ceil(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.ceil();
    }

    public static Apint truncate(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.truncate();
    }

    @Deprecated
    public static Apfloat negate(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.negate();
    }

    public static Apfloat abs(Apfloat apfloat) throws ApfloatRuntimeException {
        if (apfloat.signum() >= 0) {
            return apfloat;
        }
        return apfloat.negate();
    }

    public static Apfloat copySign(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        if (apfloat2.signum() == 0) {
            return apfloat2;
        }
        if (apfloat.signum() != apfloat2.signum()) {
            return apfloat.negate();
        }
        return apfloat;
    }

    public static Apfloat scale(Apfloat apfloat, long l) throws ApfloatRuntimeException {
        Apfloat apfloat2;
        if (l == 0L || apfloat.signum() == 0) {
            return apfloat;
        }
        Apfloat apfloat3 = new Apfloat(apfloat.radix(), Long.MAX_VALUE, apfloat.radix());
        if ((Math.abs(l) & 0xC000000000000000L) != 0L) {
            Apfloat apfloat4 = ApfloatMath.pow(apfloat3, Math.abs(l) >>> 1);
            Apfloat apfloat5 = (l & 1L) == 0L ? apfloat4 : apfloat4.multiply(apfloat3);
            apfloat2 = l >= 0L ? apfloat.multiply(apfloat4).multiply(apfloat5) : apfloat.divide(apfloat4).divide(apfloat5);
        } else if (apfloat.radix() <= 14) {
            Apfloat apfloat6 = new Apfloat("1e" + l, Long.MAX_VALUE, apfloat.radix());
            apfloat2 = apfloat.multiply(apfloat6);
        } else {
            Apfloat apfloat7 = ApfloatMath.pow(apfloat3, Math.abs(l));
            apfloat2 = l >= 0L ? apfloat.multiply(apfloat7) : apfloat.divide(apfloat7);
        }
        return apfloat2;
    }

    public static Apfloat[] modf(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat[] apfloatArray;
        apfloatArray = new Apfloat[]{ApfloatMath.floor(apfloat), apfloat.subtract(apfloatArray[0])};
        return apfloatArray;
    }

    public static Apfloat fmod(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        Apfloat apfloat3;
        if (apfloat2.signum() == 0) {
            return apfloat2;
        }
        if (apfloat.signum() == 0) {
            return apfloat;
        }
        Apfloat apfloat4 = ApfloatMath.abs(apfloat);
        if (apfloat4.compareTo(apfloat3 = ApfloatMath.abs(apfloat2)) < 0) {
            return apfloat;
        }
        if (apfloat.precision() <= apfloat.scale() - apfloat2.scale()) {
            return Apfloat.ZERO;
        }
        long l = apfloat.scale() - apfloat2.scale() + 20L;
        Apfloat apfloat5 = apfloat.precision(l);
        Apfloat apfloat6 = apfloat2.precision(l);
        Apfloat apfloat7 = apfloat5.divide(apfloat6).truncate();
        l = Math.min(Util.ifFinite(apfloat2.precision(), apfloat2.precision() + apfloat.scale() - apfloat2.scale()), apfloat.precision());
        apfloat5 = apfloat.precision(l);
        apfloat6 = apfloat2.precision(l);
        apfloat4 = ApfloatMath.abs(apfloat5).subtract(ApfloatMath.abs(apfloat7.multiply(apfloat6)));
        if (apfloat4.compareTo(apfloat3 = ApfloatMath.abs(apfloat6)) >= 0) {
            apfloat4 = apfloat4.subtract(apfloat3);
        } else if (apfloat4.signum() < 0) {
            apfloat4 = apfloat4.add(apfloat3);
        }
        apfloat7 = ApfloatMath.copySign(apfloat4, apfloat);
        return apfloat7;
    }

    public static Apfloat multiplyAdd(Apfloat apfloat, Apfloat apfloat2, Apfloat apfloat3, Apfloat apfloat4) throws ApfloatRuntimeException {
        return ApfloatMath.multiplyAddOrSubtract(apfloat, apfloat2, apfloat3, apfloat4, false);
    }

    public static Apfloat multiplySubtract(Apfloat apfloat, Apfloat apfloat2, Apfloat apfloat3, Apfloat apfloat4) throws ApfloatRuntimeException {
        return ApfloatMath.multiplyAddOrSubtract(apfloat, apfloat2, apfloat3, apfloat4, true);
    }

    private static Apfloat multiplyAddOrSubtract(Apfloat apfloat, Apfloat apfloat2, Apfloat apfloat3, Apfloat apfloat4, boolean bl) throws ApfloatRuntimeException {
        Apfloat apfloat5;
        Apfloat apfloat6;
        long[] lArray = ApfloatHelper.getMatchingPrecisions(apfloat, apfloat2, apfloat3, apfloat4);
        if (lArray[0] == 0L) {
            apfloat6 = Apfloat.ZERO;
        } else {
            apfloat = apfloat.precision(lArray[0]);
            apfloat2 = apfloat2.precision(lArray[0]);
            apfloat6 = apfloat.multiply(apfloat2);
        }
        if (lArray[1] == 0L) {
            apfloat5 = Apfloat.ZERO;
        } else {
            apfloat3 = apfloat3.precision(lArray[1]);
            apfloat4 = apfloat4.precision(lArray[1]);
            apfloat5 = apfloat3.multiply(apfloat4);
        }
        Apfloat apfloat7 = bl ? apfloat6.subtract(apfloat5) : apfloat6.add(apfloat5);
        return apfloat7.signum() == 0 ? apfloat7 : apfloat7.precision(lArray[2]);
    }

    public static Apfloat agm(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        Apfloat apfloat3;
        if (apfloat.signum() == 0 || apfloat2.signum() == 0) {
            return Apfloat.ZERO;
        }
        long l = Math.min(apfloat.precision(), apfloat2.precision());
        long l2 = Math.max(apfloat.precision(), apfloat2.precision());
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate agm to infinite precision");
        }
        l = ApfloatHelper.extendPrecision(l);
        apfloat = ApfloatHelper.ensurePrecision(apfloat, l);
        apfloat2 = ApfloatHelper.ensurePrecision(apfloat2, l);
        long l3 = 0L;
        long l4 = (l + 1L) / 2L;
        Apfloat apfloat4 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
        while (l3 < 1000L && l3 < l4) {
            apfloat3 = apfloat.add(apfloat2).divide(apfloat4);
            apfloat2 = ApfloatMath.sqrt(apfloat.multiply(apfloat2));
            apfloat = apfloat3;
            apfloat = ApfloatHelper.ensurePrecision(apfloat, l);
            apfloat2 = ApfloatHelper.ensurePrecision(apfloat2, l);
            l3 = apfloat.equalDigits(apfloat2);
        }
        while (l3 <= l4) {
            apfloat3 = apfloat.add(apfloat2).divide(apfloat4);
            apfloat2 = ApfloatMath.sqrt(apfloat.multiply(apfloat2));
            apfloat = apfloat3;
            apfloat = ApfloatHelper.ensurePrecision(apfloat, l);
            apfloat2 = ApfloatHelper.ensurePrecision(apfloat2, l);
            l3 *= 2L;
        }
        return apfloat.add(apfloat2).divide(apfloat4).precision(l2);
    }

    public static Apfloat pi(long l) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        int n = apfloatContext.getDefaultRadix();
        return ApfloatMath.pi(l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Apfloat pi(long l, int n) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        Apfloat apfloat;
        Integer n2;
        if (l <= 0L) {
            throw new IllegalArgumentException("Precision " + l + " is not positive");
        }
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate pi to infinite precision");
        }
        Integer n3 = n2 = ApfloatMath.getRadixPiKey(new Integer(n));
        synchronized (n3) {
            apfloat = radixPi.get(n2);
            apfloat = apfloat == null || apfloat.precision() < l ? ApfloatMath.calculatePi(l, n2) : apfloat.precision(l);
        }
        return apfloat;
    }

    private static Integer getRadixPiKey(Integer n) {
        Integer n2 = radixPiKeys.putIfAbsent(n, n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    private static Apfloat calculatePi(long l, Integer n) throws ApfloatRuntimeException {
        int n2 = n;
        PiCalculator piCalculator = radixPiCalculator.get(n);
        if (piCalculator == null) {
            piCalculator = new PiCalculator(n2);
            radixPiCalculator.put(n, piCalculator);
        }
        ApfloatHolder apfloatHolder = new ApfloatHolder();
        ApfloatHolder apfloatHolder2 = new ApfloatHolder();
        ApfloatHolder apfloatHolder3 = new ApfloatHolder();
        long l2 = (long)((double)l * Math.log(n2) / 32.65445004177);
        long l3 = ApfloatHelper.extendPrecision(l);
        Long l4 = radixPiTerms.get(n);
        Apfloat apfloat = radixPiT.get(n);
        Apfloat apfloat2 = radixPiQ.get(n);
        Apfloat apfloat3 = radixPiP.get(n);
        Apfloat apfloat4 = radixPiInverseRoot.get(n);
        if (l4 != null && apfloat != null && apfloat2 != null && apfloat3 != null && apfloat4 != null) {
            long l5 = l4;
            if (l5 != l2 + 1L) {
                piCalculator.r(l5, l2 + 1L, apfloatHolder, apfloatHolder2, apfloatHolder3);
                apfloat = apfloatHolder2.getApfloat().multiply(apfloat).add(apfloat3.multiply(apfloatHolder.getApfloat()));
                apfloat2 = apfloat2.multiply(apfloatHolder2.getApfloat());
                apfloat3 = apfloat3.multiply(apfloatHolder3.getApfloat());
            }
            apfloat4 = ApfloatMath.inverseRoot(new Apfloat(640320L, l3, n2), 2L, l3, apfloat4);
        } else {
            piCalculator.r(0L, l2 + 1L, apfloatHolder, apfloatHolder2, apfloatHolder3);
            apfloat = apfloatHolder.getApfloat();
            apfloat2 = apfloatHolder2.getApfloat();
            apfloat3 = apfloatHolder3.getApfloat();
            apfloat4 = ApfloatMath.inverseRoot(new Apfloat(640320L, l3, n2), 2L);
        }
        Apfloat apfloat5 = ApfloatMath.inverseRoot(apfloat4.multiply(apfloat), 1L).multiply(new Apfloat(53360L, Long.MAX_VALUE, n2)).multiply(apfloat2);
        apfloat4 = apfloat4.precision(l);
        apfloat5 = apfloat5.precision(l);
        radixPiT.put(n, apfloat);
        radixPiQ.put(n, apfloat2);
        radixPiP.put(n, apfloat3);
        radixPiInverseRoot.put(n, apfloat4);
        radixPiTerms.put(n, l2 + 1L);
        radixPi.put(n, apfloat5);
        return apfloat5;
    }

    public static Apfloat log(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.log(apfloat, true);
    }

    public static Apfloat log(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        long l = Math.min(apfloat.precision(), apfloat2.precision());
        apfloat = apfloat.precision(l);
        apfloat2 = apfloat2.precision(l);
        return ApfloatMath.log(apfloat, false).divide(ApfloatMath.log(apfloat2, false));
    }

    private static Apfloat log(Apfloat apfloat, boolean bl) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat2;
        if (apfloat.signum() <= 0) {
            throw new ArithmeticException("Logarithm of " + (apfloat.signum() == 0 ? "zero" : "negative number; result would be complex"));
        }
        if (apfloat.equals(Apfloat.ONE)) {
            return Apfloat.ZERO;
        }
        long l = apfloat.precision();
        Apfloat apfloat3 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        long l2 = Util.ifFinite(l, l - apfloat3.equalDigits(apfloat));
        long l3 = apfloat.scale();
        apfloat = ApfloatMath.scale(apfloat, -l3);
        if (l3 == 0L) {
            apfloat2 = Apfloat.ZERO;
        } else {
            Apfloat apfloat4 = ApfloatHelper.extendPrecision(ApfloatMath.logRadix(l, apfloat.radix(), bl));
            apfloat2 = new Apfloat(l3, Long.MAX_VALUE, apfloat.radix()).multiply(apfloat4);
        }
        return ApfloatHelper.extendPrecision(ApfloatMath.rawLog(apfloat, bl)).add(apfloat2).precision(l2);
    }

    private static Apfloat rawLog(Apfloat apfloat, boolean bl) throws ApfloatRuntimeException {
        assert (apfloat.signum() > 0);
        long l = apfloat.precision();
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate logarithm to infinite precision");
        }
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        long l2 = ApfloatHelper.extendPrecision(l);
        long l3 = l / 2L + 25L;
        apfloat = ApfloatHelper.extendPrecision(apfloat, 25L);
        Apfloat apfloat3 = apfloat2.precision(l2);
        apfloat3 = ApfloatMath.scale(apfloat3, -l3);
        apfloat = ApfloatMath.scale(apfloat, -l3);
        Apfloat apfloat4 = ApfloatHelper.extendPrecision(ApfloatMath.agm(apfloat2, apfloat3));
        Apfloat apfloat5 = ApfloatHelper.extendPrecision(ApfloatMath.agm(apfloat2, apfloat));
        Apfloat apfloat6 = apfloat5.subtract(apfloat4).precision(l2);
        if (bl) {
            Apfloat apfloat7 = ApfloatHelper.extendPrecision(ApfloatMath.pi(l, apfloat.radix()));
            apfloat6 = apfloat7.multiply(apfloat6);
        }
        apfloat6 = apfloat6.divide(new Apfloat(2L, Long.MAX_VALUE, apfloat.radix()).multiply(apfloat4).multiply(apfloat5));
        return apfloat6.precision(l);
    }

    private static Integer getRadixLogKey(Integer n) {
        Integer n2 = radixLogKeys.putIfAbsent(n, n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    public static Apfloat logRadix(long l, int n) throws ApfloatRuntimeException {
        return ApfloatMath.logRadix(l, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Apfloat logRadix(long l, int n, boolean bl) throws ApfloatRuntimeException {
        Apfloat apfloat;
        Integer n2;
        Integer n3 = n2 = ApfloatMath.getRadixLogKey(new Integer(n));
        synchronized (n3) {
            Map<Integer, Apfloat> map = bl ? radixLogPi : radixLog;
            apfloat = map.get(n2);
            if (apfloat == null || apfloat.precision() < l) {
                if (bl) {
                    apfloat = ApfloatHelper.extendPrecision(ApfloatMath.logRadix(l, n, false));
                    Apfloat apfloat2 = ApfloatHelper.extendPrecision(ApfloatMath.pi(l, n));
                    apfloat = apfloat.multiply(apfloat2).precision(l);
                } else {
                    Apfloat apfloat3 = new Apfloat("0.1", l, n);
                    apfloat = ApfloatMath.rawLog(apfloat3, bl).negate();
                }
                map.put(n2, apfloat);
            } else {
                apfloat = apfloat.precision(l);
            }
        }
        return apfloat;
    }

    public static Apfloat exp(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat apfloat2;
        long l;
        int n = apfloat.radix();
        if (apfloat.signum() == 0) {
            return new Apfloat(1L, Long.MAX_VALUE, n);
        }
        long l2 = apfloat.precision();
        long l3 = ApfloatHelper.getDoublePrecision(n);
        if ((l2 = Util.ifFinite(l2, l2 + Math.max(1L - apfloat.scale(), 0L))) == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate exponent to infinite precision");
        }
        if (apfloat.compareTo(new Apfloat(9.223372036854776E18 * Math.log(n), l3, n)) >= 0) {
            throw new OverflowException("Overflow");
        }
        if (apfloat.scale() <= -4611686018427387884L) {
            return new Apfloat(1L, Long.MAX_VALUE, n).add(apfloat).precision(Long.MAX_VALUE);
        }
        if (apfloat.scale() < -l3 / 2L) {
            l = -2L * apfloat.scale();
            apfloat2 = new Apfloat(1L, l, n).add(apfloat);
        } else {
            double d = apfloat.doubleValue() / Math.log(n);
            double d2 = Math.floor(d);
            double d3 = d - d2;
            apfloat2 = new Apfloat(Math.pow(n, d3), l3, n);
            apfloat2 = ApfloatMath.scale(apfloat2, (long)d2);
            int n2 = d2 > 0.0 ? (int)Math.floor(Math.log(d2 + 0.5) / Math.log(n)) : 0;
            l = Math.max(1L, l3 - (long)n2);
        }
        int n3 = 0;
        for (long i = l; i < l2; i <<= 1) {
            ++n3;
        }
        int n4 = n3;
        long l4 = l;
        while (n4 > 0 && l4 - 20L << n4 < l2) {
            --n4;
            l4 <<= 1;
        }
        if (n3 > 0) {
            ApfloatMath.logRadix(l2, n);
        }
        apfloat = ApfloatHelper.extendPrecision(apfloat);
        while (n3-- > 0) {
            apfloat2 = apfloat2.precision(Math.min(l *= 2L, l2));
            Apfloat apfloat3 = ApfloatMath.log(apfloat2);
            apfloat3 = ApfloatMath.lastIterationExtendPrecision(n3, n4, apfloat3);
            apfloat3 = apfloat.subtract(apfloat3);
            if (n3 < n4) {
                apfloat3 = apfloat3.precision(l / 2L);
            }
            apfloat2 = ApfloatMath.lastIterationExtendPrecision(n3, n4, apfloat2);
            apfloat2 = apfloat2.add(apfloat2.multiply(apfloat3));
            if (n3 != n4) continue;
            apfloat3 = ApfloatMath.log(apfloat2);
            apfloat3 = ApfloatMath.lastIterationExtendPrecision(n3, -1, apfloat3);
            apfloat2 = ApfloatMath.lastIterationExtendPrecision(n3, -1, apfloat2);
            apfloat2 = apfloat2.add(apfloat2.multiply(apfloat.subtract(apfloat3)));
        }
        return apfloat2.precision(l2);
    }

    public static Apfloat pow(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        long l = Math.min(apfloat.precision(), apfloat2.precision());
        Apfloat apfloat3 = ApfloatHelper.checkPow(apfloat, apfloat2, l);
        if (apfloat3 != null) {
            return apfloat3;
        }
        ApfloatMath.logRadix(l, apfloat.radix());
        Apfloat apfloat4 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        l = Util.ifFinite(l, l + apfloat4.equalDigits(apfloat));
        apfloat = apfloat.precision(Math.min(apfloat.precision(), l));
        apfloat3 = ApfloatMath.log(apfloat);
        long l2 = Math.min(apfloat2.precision(), apfloat3.precision());
        apfloat3 = ApfloatHelper.extendPrecision(apfloat3);
        apfloat3 = ApfloatHelper.extendPrecision(apfloat2).multiply(apfloat3);
        apfloat3 = ApfloatMath.exp(apfloat3.precision(l2));
        return apfloat3;
    }

    public static Apfloat acosh(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        return ApfloatMath.log(apfloat.add(ApfloatMath.sqrt(apfloat.multiply(apfloat).subtract(apfloat2))));
    }

    public static Apfloat asinh(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        if (apfloat.signum() >= 0) {
            return ApfloatMath.log(ApfloatMath.sqrt(apfloat.multiply(apfloat).add(apfloat2)).add(apfloat));
        }
        return ApfloatMath.log(ApfloatMath.sqrt(apfloat.multiply(apfloat).add(apfloat2)).subtract(apfloat)).negate();
    }

    public static Apfloat atanh(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat3 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
        return ApfloatMath.log(apfloat2.add(apfloat).divide(apfloat2.subtract(apfloat))).divide(apfloat3);
    }

    public static Apfloat cosh(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat apfloat2 = ApfloatMath.exp(apfloat);
        Apfloat apfloat3 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat4 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
        return apfloat2.add(apfloat3.divide(apfloat2)).divide(apfloat4);
    }

    public static Apfloat sinh(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat apfloat2 = ApfloatMath.exp(apfloat);
        Apfloat apfloat3 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat4 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
        return apfloat2.subtract(apfloat3.divide(apfloat2)).divide(apfloat4);
    }

    public static Apfloat tanh(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat3 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat4 = ApfloatMath.exp(apfloat3.multiply(ApfloatMath.abs(apfloat)));
        apfloat4 = apfloat4.subtract(apfloat2).divide(apfloat4.add(apfloat2));
        return apfloat.signum() < 0 ? apfloat4.negate() : apfloat4;
    }

    public static Apfloat acos(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apcomplex apcomplex = new Apcomplex(Apfloat.ZERO, apfloat2);
        return ApcomplexMath.log(apfloat.add(apcomplex.multiply(ApfloatMath.sqrt(apfloat2.subtract(apfloat.multiply(apfloat)))))).imag();
    }

    public static Apfloat asin(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apcomplex apcomplex = new Apcomplex(Apfloat.ZERO, apfloat2);
        return ApcomplexMath.log(ApfloatMath.sqrt(apfloat2.subtract(apfloat.multiply(apfloat))).subtract(apcomplex.multiply(apfloat))).imag().negate();
    }

    public static Apfloat atan(Apfloat apfloat) throws ApfloatRuntimeException {
        Apfloat apfloat2 = new Apfloat(1L, Long.MAX_VALUE, apfloat.radix());
        Apfloat apfloat3 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
        Apcomplex apcomplex = new Apcomplex(Apfloat.ZERO, apfloat2);
        return ApcomplexMath.log(apcomplex.subtract(apfloat).divide(apcomplex.add(apfloat))).imag().divide(apfloat3);
    }

    public static Apfloat atan2(Apfloat apfloat, Apfloat apfloat2) throws ArithmeticException, ApfloatRuntimeException {
        if (apfloat2.signum() == 0) {
            if (apfloat.signum() == 0) {
                throw new ArithmeticException("Angle of (0, 0)");
            }
            Apfloat apfloat3 = ApfloatMath.pi(apfloat.precision(), apfloat.radix());
            Apfloat apfloat4 = new Apfloat(2L, Long.MAX_VALUE, apfloat.radix());
            return new Apfloat(apfloat.signum(), Long.MAX_VALUE, apfloat.radix()).multiply(apfloat3).divide(apfloat4);
        }
        if (apfloat.signum() == 0) {
            if (apfloat2.signum() > 0) {
                return Apfloat.ZERO;
            }
            return ApfloatMath.pi(apfloat2.precision(), apfloat2.radix());
        }
        if (Math.min(apfloat.precision(), apfloat2.precision()) == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate atan2 to infinite precision");
        }
        long l = Math.max(apfloat.scale(), apfloat2.scale());
        apfloat = ApfloatMath.scale(apfloat, -l);
        apfloat2 = ApfloatMath.scale(apfloat2, -l);
        return ApcomplexMath.log(new Apcomplex(apfloat2, apfloat)).imag();
    }

    public static Apfloat cos(Apfloat apfloat) throws ApfloatRuntimeException {
        return ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, apfloat)).real();
    }

    public static Apfloat sin(Apfloat apfloat) throws ApfloatRuntimeException {
        return ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, apfloat)).imag();
    }

    public static Apfloat tan(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex apcomplex = ApcomplexMath.exp(new Apcomplex(Apfloat.ZERO, apfloat));
        return apcomplex.imag().divide(apcomplex.real());
    }

    public static Apfloat product(Apfloat ... apfloatArray) throws ApfloatRuntimeException {
        if (apfloatArray.length == 0) {
            return Apfloat.ONE;
        }
        long l = Long.MAX_VALUE;
        for (int i = 0; i < apfloatArray.length; ++i) {
            if (apfloatArray[i].signum() == 0) {
                return Apfloat.ZERO;
            }
            l = Math.min(l, apfloatArray[i].precision());
        }
        Apfloat[] apfloatArray2 = new Apfloat[apfloatArray.length];
        long l2 = (long)Math.sqrt(apfloatArray.length);
        long l3 = ApfloatHelper.extendPrecision(l, l2);
        for (int i = 0; i < apfloatArray.length; ++i) {
            apfloatArray2[i] = apfloatArray[i].precision(l3);
        }
        apfloatArray = apfloatArray2;
        PriorityQueue<Apfloat> priorityQueue = new PriorityQueue<Apfloat>(apfloatArray.length, new Comparator<Apfloat>(){

            @Override
            public int compare(Apfloat apfloat, Apfloat apfloat2) {
                long l;
                long l2 = apfloat.size();
                return l2 < (l = apfloat2.size()) ? -1 : (l2 > l ? 1 : 0);
            }
        });
        priorityQueue.addAll(Arrays.asList(apfloatArray));
        while (priorityQueue.size() > 1) {
            Apfloat apfloat = (Apfloat)priorityQueue.remove();
            Apfloat apfloat2 = (Apfloat)priorityQueue.remove();
            Apfloat apfloat3 = apfloat.multiply(apfloat2);
            priorityQueue.add(apfloat3);
        }
        return ((Apfloat)priorityQueue.remove()).precision(l);
    }

    public static Apfloat sum(Apfloat ... apfloatArray) throws ApfloatRuntimeException {
        if (apfloatArray.length == 0) {
            return Apfloat.ZERO;
        }
        long l = -9223372036854775807L;
        long l2 = Long.MAX_VALUE;
        for (int i = 0; i < apfloatArray.length; ++i) {
            long l3 = l;
            long l4 = l2;
            long l5 = apfloatArray[i].scale();
            long l6 = apfloatArray[i].precision();
            l = Math.max(l3, l5);
            long l7 = l - l3 < 0L ? Long.MAX_VALUE : l - l3;
            long l8 = l - l5 < 0L ? Long.MAX_VALUE : l - l5;
            l2 = Math.min(Util.ifFinite(l4, l4 + l7), Util.ifFinite(l6, l6 + l8));
        }
        Apfloat[] apfloatArray2 = new Apfloat[apfloatArray.length];
        for (int i = 0; i < apfloatArray.length; ++i) {
            long l9 = apfloatArray[i].scale();
            long l10 = l - l9 < 0L ? Long.MAX_VALUE : l - l9;
            long l11 = l2 - l10 <= 0L ? 0L : Util.ifFinite(l2, l2 - l10);
            apfloatArray2[i] = l11 > 0L ? apfloatArray[i].precision(l11) : Apfloat.ZERO;
        }
        apfloatArray = apfloatArray2;
        Arrays.sort(apfloatArray, new Comparator<Apfloat>(){

            @Override
            public int compare(Apfloat apfloat, Apfloat apfloat2) {
                long l;
                long l2 = apfloat.scale();
                return l2 < (l = apfloat2.scale()) ? -1 : (l2 > l ? 1 : 0);
            }
        });
        Apfloat apfloat = Apfloat.ZERO;
        for (int i = 0; i < apfloatArray.length; ++i) {
            apfloat = apfloat.add(apfloatArray[i]);
        }
        return apfloat;
    }

    private static Apfloat lastIterationExtendPrecision(int n, int n2, Apfloat apfloat) throws ApfloatRuntimeException {
        return n == 0 && n2 != 0 ? ApfloatHelper.extendPrecision(apfloat) : apfloat;
    }

    static Apfloat factorial(long l, long l2) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        int n = apfloatContext.getDefaultRadix();
        return ApfloatMath.factorial(l, l2, n);
    }

    static Apfloat factorial(long l, long l2, int n) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        Apfloat apfloat;
        if (l < 0L) {
            throw new ArithmeticException("Factorial of negative number");
        }
        if (l < 2L) {
            return new Apfloat(1L, l2, n);
        }
        long l3 = l2;
        l2 = ApfloatHelper.extendPrecision(l2);
        Apfloat apfloat2 = apfloat = new Apfloat(1L, l2, n);
        long l4 = 0L;
        for (int i = 62 - Long.numberOfLeadingZeros(l); i >= 0; --i) {
            long l5 = l >>> i;
            long l6 = l5 >>> 1;
            l4 += l6;
            apfloat = apfloat.multiply(ApfloatMath.oddProduct(l6 + 1L, l5, l2, n));
            apfloat2 = apfloat2.multiply(apfloat);
        }
        return apfloat2.multiply(ApfloatMath.pow(new Apfloat(2L, l2, n), l4)).precision(l3);
    }

    private static Apfloat oddProduct(long l, long l2, long l3, int n) throws ApfloatRuntimeException {
        if ((l |= 1L) > (l2 = l2 - 1L | 1L)) {
            return new Apfloat(1L, l3, n);
        }
        if (l == l2) {
            return new Apfloat(l, l3, n);
        }
        long l4 = l + l2 >>> 1;
        return ApfloatMath.oddProduct(l, l4, l3, n).multiply(ApfloatMath.oddProduct(l4 + 1L, l2, l3, n));
    }

    static void cleanUp() {
        radixPi = SHUTDOWN_MAP;
        radixPiT = SHUTDOWN_MAP;
        radixPiQ = SHUTDOWN_MAP;
        radixPiP = SHUTDOWN_MAP;
        radixPiInverseRoot = SHUTDOWN_MAP;
        radixLog = SHUTDOWN_MAP;
        radixLogPi = SHUTDOWN_MAP;
    }

    private static class PiCalculator {
        private final Apfloat A;
        private final Apfloat B;
        private final Apfloat J;
        private final Apfloat ONE;
        private final Apfloat TWO;
        private final Apfloat FIVE;
        private final Apfloat SIX;
        private int radix;

        public PiCalculator(int n) throws ApfloatRuntimeException {
            this.A = new Apfloat(13591409L, Long.MAX_VALUE, n);
            this.B = new Apfloat(545140134L, Long.MAX_VALUE, n);
            this.J = new Apfloat(10939058860032000L, Long.MAX_VALUE, n);
            this.ONE = new Apfloat(1L, Long.MAX_VALUE, n);
            this.TWO = new Apfloat(2L, Long.MAX_VALUE, n);
            this.FIVE = new Apfloat(5L, Long.MAX_VALUE, n);
            this.SIX = new Apfloat(6L, Long.MAX_VALUE, n);
            this.radix = n;
        }

        private Apfloat a(long l) throws ApfloatRuntimeException {
            Apfloat apfloat = new Apfloat(l, Long.MAX_VALUE, this.radix);
            Apfloat apfloat2 = this.A.add(this.B.multiply(apfloat));
            apfloat2 = (l & 1L) == 0L ? apfloat2 : apfloat2.negate();
            return apfloat2;
        }

        private Apfloat p(long l) throws ApfloatRuntimeException {
            Apfloat apfloat;
            if (l == 0L) {
                apfloat = this.ONE;
            } else {
                Apfloat apfloat2 = new Apfloat(l, Long.MAX_VALUE, this.radix);
                Apfloat apfloat3 = this.SIX.multiply(apfloat2);
                apfloat = apfloat3.subtract(this.ONE).multiply(this.TWO.multiply(apfloat2).subtract(this.ONE)).multiply(apfloat3.subtract(this.FIVE));
            }
            return apfloat;
        }

        private Apfloat q(long l) throws ApfloatRuntimeException {
            Apfloat apfloat;
            if (l == 0L) {
                apfloat = this.ONE;
            } else {
                Apfloat apfloat2 = new Apfloat(l, Long.MAX_VALUE, this.radix);
                apfloat = this.J.multiply(apfloat2).multiply(apfloat2).multiply(apfloat2);
            }
            return apfloat;
        }

        public void r(long l, long l2, ApfloatHolder apfloatHolder, ApfloatHolder apfloatHolder2, ApfloatHolder apfloatHolder3) throws ApfloatRuntimeException {
            int n = (int)Math.min(l2 - l, Integer.MAX_VALUE);
            switch (n) {
                case 0: {
                    assert (l != l2);
                    break;
                }
                case 1: {
                    Apfloat apfloat = this.p(l);
                    apfloatHolder.setApfloat(this.a(l).multiply(apfloat));
                    apfloatHolder2.setApfloat(this.q(l));
                    apfloatHolder3.setApfloat(apfloat);
                    break;
                }
                case 2: {
                    Apfloat apfloat = this.p(l);
                    Apfloat apfloat2 = apfloat.multiply(this.p(l + 1L));
                    Apfloat apfloat3 = this.q(l + 1L);
                    apfloatHolder.setApfloat(apfloat3.multiply(this.a(l)).multiply(apfloat).add(this.a(l + 1L).multiply(apfloat2)));
                    apfloatHolder2.setApfloat(this.q(l).multiply(apfloat3));
                    apfloatHolder3.setApfloat(apfloat2);
                    break;
                }
                case 3: {
                    Apfloat apfloat = this.p(l);
                    Apfloat apfloat4 = apfloat.multiply(this.p(l + 1L));
                    Apfloat apfloat5 = apfloat4.multiply(this.p(l + 2L));
                    Apfloat apfloat6 = this.q(l + 2L);
                    Apfloat apfloat7 = this.q(l + 1L).multiply(apfloat6);
                    apfloatHolder.setApfloat(apfloat7.multiply(this.a(l)).multiply(apfloat).add(apfloat6.multiply(this.a(l + 1L)).multiply(apfloat4)).add(this.a(l + 2L).multiply(apfloat5)));
                    apfloatHolder2.setApfloat(this.q(l).multiply(apfloat7));
                    apfloatHolder3.setApfloat(apfloat5);
                    break;
                }
                case 4: {
                    Apfloat apfloat = this.p(l);
                    Apfloat apfloat8 = apfloat.multiply(this.p(l + 1L));
                    Apfloat apfloat9 = apfloat8.multiply(this.p(l + 2L));
                    Apfloat apfloat10 = apfloat9.multiply(this.p(l + 3L));
                    Apfloat apfloat11 = this.q(l + 3L);
                    Apfloat apfloat12 = this.q(l + 2L).multiply(apfloat11);
                    Apfloat apfloat13 = this.q(l + 1L).multiply(apfloat12);
                    apfloatHolder.setApfloat(apfloat13.multiply(this.a(l)).multiply(apfloat).add(apfloat12.multiply(this.a(l + 1L)).multiply(apfloat8)).add(apfloat11.multiply(this.a(l + 2L)).multiply(apfloat9)).add(this.a(l + 3L).multiply(apfloat10)));
                    apfloatHolder2.setApfloat(this.q(l).multiply(apfloat13));
                    apfloatHolder3.setApfloat(apfloat10);
                    break;
                }
                default: {
                    long l3 = (l + l2) / 2L;
                    ApfloatHolder apfloatHolder4 = new ApfloatHolder();
                    ApfloatHolder apfloatHolder5 = new ApfloatHolder();
                    ApfloatHolder apfloatHolder6 = new ApfloatHolder();
                    this.r(l, l3, apfloatHolder4, apfloatHolder5, apfloatHolder6);
                    this.r(l3, l2, apfloatHolder, apfloatHolder2, apfloatHolder3);
                    apfloatHolder.setApfloat(apfloatHolder2.getApfloat().multiply(apfloatHolder4.getApfloat()).add(apfloatHolder6.getApfloat().multiply(apfloatHolder.getApfloat())));
                    apfloatHolder2.setApfloat(apfloatHolder5.getApfloat().multiply(apfloatHolder2.getApfloat()));
                    apfloatHolder3.setApfloat(apfloatHolder6.getApfloat().multiply(apfloatHolder3.getApfloat()));
                }
            }
        }
    }

    private static class ApfloatHolder {
        private Apfloat apfloat;

        public ApfloatHolder() {
            this(null);
        }

        public ApfloatHolder(Apfloat apfloat) {
            this.apfloat = apfloat;
        }

        public Apfloat getApfloat() {
            return this.apfloat;
        }

        public void setApfloat(Apfloat apfloat) {
            this.apfloat = apfloat;
        }
    }
}

