/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.spi.ApfloatBuilder;
import org.apfloat.spi.ApfloatImpl;
import org.apfloat.spi.RadixConstants;
import org.apfloat.spi.Util;

class ApfloatHelper {
    private ApfloatHelper() {
    }

    public static ApfloatImpl createApfloat(String string, boolean bl) throws NumberFormatException, ApfloatRuntimeException {
        long l = bl ? Long.MAX_VALUE : Long.MIN_VALUE;
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.implCreateApfloat(string, l, n, bl);
    }

    public static ApfloatImpl createApfloat(String string, long l, boolean bl) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(string, l, n, bl);
    }

    public static ApfloatImpl createApfloat(String string, long l, int n, boolean bl) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        if (l != Long.MIN_VALUE) {
            ApfloatHelper.checkPrecision(l);
        }
        return ApfloatHelper.implCreateApfloat(string, l, n, bl);
    }

    private static ApfloatImpl implCreateApfloat(String string, long l, int n, boolean bl) throws NumberFormatException, ApfloatRuntimeException {
        ApfloatBuilder apfloatBuilder = ApfloatHelper.getApfloatBuilder();
        return apfloatBuilder.createApfloat(string, l, n, bl);
    }

    public static ApfloatImpl createApfloat(long l) throws NumberFormatException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.implCreateApfloat(l, Long.MAX_VALUE, n);
    }

    public static ApfloatImpl createApfloat(long l, long l2) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(l, l2, n);
    }

    public static ApfloatImpl createApfloat(long l, long l2, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        l2 = l2 == Long.MIN_VALUE ? Long.MAX_VALUE : l2;
        ApfloatHelper.checkPrecision(l2);
        return ApfloatHelper.implCreateApfloat(l, l2, n);
    }

    private static ApfloatImpl implCreateApfloat(long l, long l2, int n) throws NumberFormatException, ApfloatRuntimeException {
        ApfloatBuilder apfloatBuilder = ApfloatHelper.getApfloatBuilder();
        return apfloatBuilder.createApfloat(l, l2, n);
    }

    public static ApfloatImpl createApfloat(float f) throws NumberFormatException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        int n2 = ApfloatHelper.getFloatPrecision(n);
        return ApfloatHelper.implCreateApfloat(f, (long)n2, n);
    }

    public static ApfloatImpl createApfloat(float f, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(f, l, n);
    }

    public static ApfloatImpl createApfloat(float f, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        l = l == Long.MIN_VALUE ? (long)ApfloatHelper.getFloatPrecision(n) : l;
        ApfloatHelper.checkPrecision(l);
        return ApfloatHelper.implCreateApfloat(f, l, n);
    }

    public static ApfloatImpl createApfloat(double d) throws NumberFormatException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        int n2 = ApfloatHelper.getDoublePrecision(n);
        return ApfloatHelper.implCreateApfloat(d, (long)n2, n);
    }

    public static ApfloatImpl createApfloat(double d, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(d, l, n);
    }

    public static ApfloatImpl createApfloat(double d, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        l = l == Long.MIN_VALUE ? (long)ApfloatHelper.getDoublePrecision(n) : l;
        ApfloatHelper.checkPrecision(l);
        return ApfloatHelper.implCreateApfloat(d, l, n);
    }

    private static ApfloatImpl implCreateApfloat(double d, long l, int n) throws NumberFormatException, ApfloatRuntimeException {
        ApfloatBuilder apfloatBuilder = ApfloatHelper.getApfloatBuilder();
        return apfloatBuilder.createApfloat(d, l, n);
    }

    public static ApfloatImpl createApfloat(PushbackReader pushbackReader, boolean bl) throws IOException, NumberFormatException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.implCreateApfloat(pushbackReader, Long.MIN_VALUE, n, bl);
    }

    public static ApfloatImpl createApfloat(PushbackReader pushbackReader, long l, boolean bl) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(pushbackReader, l, n, bl);
    }

    public static ApfloatImpl createApfloat(PushbackReader pushbackReader, long l, int n, boolean bl) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        if (l != Long.MIN_VALUE) {
            ApfloatHelper.checkPrecision(l);
        }
        return ApfloatHelper.implCreateApfloat(pushbackReader, l, n, bl);
    }

    private static ApfloatImpl implCreateApfloat(PushbackReader pushbackReader, long l, int n, boolean bl) throws IOException, NumberFormatException, ApfloatRuntimeException {
        ApfloatBuilder apfloatBuilder = ApfloatHelper.getApfloatBuilder();
        return apfloatBuilder.createApfloat(pushbackReader, l, n, bl);
    }

    public static ApfloatImpl createApfloat(BigInteger bigInteger) throws NumberFormatException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(bigInteger, Long.MAX_VALUE, n);
    }

    public static ApfloatImpl createApfloat(BigInteger bigInteger, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        int n = ApfloatHelper.getDefaultRadix();
        return ApfloatHelper.createApfloat(bigInteger, l, n);
    }

    public static ApfloatImpl createApfloat(BigInteger bigInteger, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        Apfloat apfloat;
        if (l != Long.MIN_VALUE) {
            ApfloatHelper.checkPrecision(l);
        }
        ApfloatHelper.checkRadix(n);
        try {
            apfloat = new Apfloat(ApfloatHelper.createApfloat(ApfloatHelper.toPushbackReader(bigInteger), Long.MAX_VALUE, 16, true));
        }
        catch (IOException iOException) {
            throw new ApfloatRuntimeException("Should not occur", iOException);
        }
        l = l == Long.MIN_VALUE ? Long.MAX_VALUE : l;
        return apfloat.toRadix(n).getImpl(l);
    }

    public static ApfloatImpl createApfloat(BigDecimal bigDecimal) throws ApfloatRuntimeException {
        return ApfloatHelper.implCreateApfloat(bigDecimal.toString(), Long.MIN_VALUE, 10, false);
    }

    public static ApfloatImpl createApfloat(BigDecimal bigDecimal, long l) throws IllegalArgumentException, ApfloatRuntimeException {
        return ApfloatHelper.createApfloat(bigDecimal.toString(), l, 10, false);
    }

    public static boolean readMatch(PushbackReader pushbackReader, int n) throws IOException {
        int n2 = pushbackReader.read();
        if (n2 != n) {
            if (n2 != -1) {
                pushbackReader.unread(n2);
            }
            return false;
        }
        return true;
    }

    public static void extractWhitespace(PushbackReader pushbackReader) throws IOException {
        int n;
        while (Character.isWhitespace((char)(n = pushbackReader.read()))) {
        }
        if (n != -1) {
            pushbackReader.unread(n);
        }
    }

    public static long[] getMatchingPrecisions(Apfloat apfloat, Apfloat apfloat2) throws ApfloatRuntimeException {
        long l;
        if (apfloat.signum() == 0 || apfloat2.signum() == 0) {
            return new long[]{0L, 0L};
        }
        long l2 = apfloat.precision();
        long l3 = apfloat2.precision();
        long l4 = apfloat.scale();
        long l5 = Math.max(l4, l = apfloat2.scale());
        long l6 = l5 - l4 < 0L ? Long.MAX_VALUE : l5 - l4;
        long l7 = l5 - l < 0L ? Long.MAX_VALUE : l5 - l;
        long l8 = Math.min(Util.ifFinite(l2, l2 + l6), Util.ifFinite(l3, l3 + l7));
        long l9 = l8 - l6 <= 0L ? 0L : Util.ifFinite(l8, l8 - l6);
        long l10 = l8 - l7 <= 0L ? 0L : Util.ifFinite(l8, l8 - l7);
        return new long[]{l9, l10};
    }

    public static long[] getMatchingPrecisions(Apfloat apfloat, Apfloat apfloat2, Apfloat apfloat3, Apfloat apfloat4) throws ApfloatRuntimeException {
        long l;
        long l2;
        long l3 = apfloat.signum() == 0 || apfloat2.signum() == 0 ? 0L : Math.min(apfloat.precision(), apfloat2.precision());
        long l4 = l2 = apfloat3.signum() == 0 || apfloat4.signum() == 0 ? 0L : Math.min(apfloat3.precision(), apfloat4.precision());
        if (l3 == 0L || l2 == 0L) {
            return new long[]{l3, l2, Math.max(l3, l2)};
        }
        long l5 = apfloat.scale() + apfloat2.scale();
        long l6 = Math.max(l5, l = apfloat3.scale() + apfloat4.scale());
        long l7 = l6 - l5 < 0L ? Long.MAX_VALUE : l6 - l5;
        long l8 = l6 - l < 0L ? Long.MAX_VALUE : l6 - l;
        long l9 = Math.min(Util.ifFinite(l3, l3 + l7), Util.ifFinite(l2, l2 + l8));
        long l10 = l9 - l7 <= 0L ? 0L : Util.ifFinite(l9, l9 - l7 + 1L);
        long l11 = l9 - l8 <= 0L ? 0L : Util.ifFinite(l9, l9 - l8 + 1L);
        return new long[]{l10, l11, l9};
    }

    public static void checkPrecision(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("Precision " + l + " is not positive");
        }
    }

    public static void checkRadix(int n) throws NumberFormatException {
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Invalid radix " + n + "; radix must be between " + 2 + " and " + 36);
        }
    }

    private static void checkPowPrecision(long l) throws InfiniteExpansionException {
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate power to infinite precision");
        }
    }

    private static Apcomplex checkPowBasic(Apcomplex apcomplex, Apcomplex apcomplex2, long l) throws ArithmeticException, ApfloatRuntimeException {
        if (apcomplex2.real().signum() == 0 && apcomplex2.imag().signum() == 0) {
            if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apcomplex(new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix()));
        }
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0 || apcomplex.equals(Apcomplex.ONE) || apcomplex2.equals(Apcomplex.ONE)) {
            return apcomplex.precision(l);
        }
        return null;
    }

    public static Apcomplex checkPow(Apcomplex apcomplex, Apcomplex apcomplex2, long l) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex apcomplex3 = ApfloatHelper.checkPowBasic(apcomplex, apcomplex2, l);
        if (apcomplex3 != null) {
            return apcomplex3;
        }
        ApfloatHelper.checkPowPrecision(l);
        return null;
    }

    public static Apfloat checkPow(Apfloat apfloat, Apfloat apfloat2, long l) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex apcomplex = ApfloatHelper.checkPowBasic(apfloat, apfloat2, l);
        if (apcomplex != null) {
            return apcomplex.real();
        }
        if (apfloat.signum() < 0) {
            throw new ArithmeticException("Power of negative number; result would be complex");
        }
        ApfloatHelper.checkPowPrecision(l);
        return null;
    }

    public static int getFloatPrecision(int n) {
        assert (n > 0);
        return RadixConstants.FLOAT_PRECISION[n];
    }

    public static int getDoublePrecision(int n) {
        assert (n > 0);
        return RadixConstants.DOUBLE_PRECISION[n];
    }

    public static int getLongPrecision(int n) {
        assert (n > 0);
        return RadixConstants.LONG_PRECISION[n];
    }

    public static Apfloat limitPrecision(Apfloat apfloat, long l) throws ApfloatRuntimeException {
        return apfloat.precision(Math.min(apfloat.precision(), l));
    }

    public static Apfloat ensurePrecision(Apfloat apfloat, long l) throws ApfloatRuntimeException {
        return apfloat.precision(Math.max(apfloat.precision(), l));
    }

    public static long extendPrecision(long l, long l2) {
        return Util.ifFinite(l, l + l2);
    }

    public static long extendPrecision(long l) {
        return ApfloatHelper.extendPrecision(l, 20L);
    }

    public static Apfloat extendPrecision(Apfloat apfloat) throws ApfloatRuntimeException {
        return apfloat.precision(ApfloatHelper.extendPrecision(apfloat.precision()));
    }

    public static Apfloat extendPrecision(Apfloat apfloat, long l) throws ApfloatRuntimeException {
        return apfloat.precision(ApfloatHelper.extendPrecision(apfloat.precision(), l));
    }

    public static Apcomplex setPrecision(Apcomplex apcomplex, long l) throws ApfloatRuntimeException {
        if (apcomplex.real().signum() == 0) {
            return new Apcomplex(apcomplex.real(), apcomplex.imag().precision(l));
        }
        if (apcomplex.imag().signum() == 0) {
            return new Apcomplex(apcomplex.real().precision(l), apcomplex.imag());
        }
        long l2 = l - apcomplex.precision();
        long l3 = apcomplex.real().precision();
        long l4 = apcomplex.imag().precision();
        long l5 = Util.ifFinite(l3, l3 + l2);
        long l6 = Util.ifFinite(l4, l4 + l2);
        if (l2 < 0L) {
            if (l3 + l2 <= 0L) {
                return new Apcomplex(Apfloat.ZERO, apcomplex.imag().precision(l));
            }
            if (l4 + l2 <= 0L) {
                return new Apcomplex(apcomplex.real().precision(l), Apfloat.ZERO);
            }
        }
        return new Apcomplex(apcomplex.real().precision(l5), apcomplex.imag().precision(l6));
    }

    public static Apcomplex limitPrecision(Apcomplex apcomplex, long l) throws ApfloatRuntimeException {
        return new Apcomplex(apcomplex.real().precision(Math.min(apcomplex.real().precision(), l)), apcomplex.imag().precision(Math.min(apcomplex.imag().precision(), l)));
    }

    public static Apcomplex ensurePrecision(Apcomplex apcomplex, long l) throws ApfloatRuntimeException {
        return new Apcomplex(apcomplex.real().precision(Math.max(apcomplex.real().precision(), l)), apcomplex.imag().precision(Math.max(apcomplex.imag().precision(), l)));
    }

    public static Apcomplex extendPrecision(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return new Apcomplex(apcomplex.real().precision(ApfloatHelper.extendPrecision(apcomplex.real().precision())), apcomplex.imag().precision(ApfloatHelper.extendPrecision(apcomplex.imag().precision())));
    }

    public static Apcomplex extendPrecision(Apcomplex apcomplex, long l) throws ApfloatRuntimeException {
        return new Apcomplex(apcomplex.real().precision(ApfloatHelper.extendPrecision(apcomplex.real().precision(), l)), apcomplex.imag().precision(ApfloatHelper.extendPrecision(apcomplex.imag().precision(), l)));
    }

    public static long size(Aprational aprational) throws ApfloatRuntimeException {
        return Math.max(aprational.numerator().size(), aprational.denominator().size());
    }

    public static BigInteger toBigInteger(Apint apint) {
        assert (apint.signum() != 0);
        Apint apint2 = ApintMath.abs(apint.toRadix(16));
        long l = apint2.scale();
        long l2 = l + 1L >> 1;
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum array size exceeded");
        }
        final byte[] byArray = new byte[(int)l2];
        final boolean bl = (l & 1L) == 0L;
        try {
            apint2.writeTo(new Writer(){
                private int b;
                private int bytePosition;
                private boolean hi;
                {
                    this.hi = bl;
                }

                public void write(int n) {
                    n = Character.digit(n, 16);
                    if (this.hi) {
                        this.b = n << 4;
                    } else {
                        this.b += n & 0xF;
                        byArray[this.bytePosition] = (byte)this.b;
                        ++this.bytePosition;
                    }
                    this.hi = !this.hi;
                }

                public void write(char[] cArray, int n, int n2) {
                    for (int i = 0; i < n2; ++i) {
                        this.write(cArray[n + i]);
                    }
                }

                public void close() {
                }

                public void flush() {
                }
            });
        }
        catch (IOException iOException) {
            throw new ApfloatRuntimeException("Should not occur", iOException);
        }
        BigInteger bigInteger = new BigInteger(apint.signum(), byArray);
        return bigInteger;
    }

    public static PushbackReader toPushbackReader(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.abs().toByteArray();
        final int n = bigInteger.signum() < 0 ? 45 : -1;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray){
            private int b;
            {
                super(byArray);
                this.b = n;
            }

            public int read() {
                int n2;
                if (this.b == -1) {
                    this.b = super.read();
                    if (this.b == -1) {
                        n2 = -1;
                    } else {
                        n2 = Character.forDigit(this.b >> 4, 16);
                        this.b = Character.forDigit(this.b & 0xF, 16);
                    }
                } else {
                    n2 = this.b;
                    this.b = -1;
                }
                return n2;
            }

            public int read(byte[] byArray, int n5, int n2) {
                int n3;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n4 = this.read();
                    if (n4 == -1) {
                        n3 = n3 == 0 ? -1 : n3;
                        break;
                    }
                    byArray[n3 + n5] = (byte)n4;
                }
                return n3;
            }
        };
        return new PushbackReader(new InputStreamReader((InputStream)byteArrayInputStream, "ISO-8859-1"));
    }

    private static int getDefaultRadix() throws NumberFormatException {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        return apfloatContext.getDefaultRadix();
    }

    private static ApfloatBuilder getApfloatBuilder() {
        ApfloatContext apfloatContext = ApfloatContext.getContext();
        return apfloatContext.getBuilderFactory().getApfloatBuilder();
    }
}

