/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Enumeration;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apfloat.ApfloatConfigurationException;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.ConcurrentWeakHashMap;
import org.apfloat.spi.BuilderFactory;
import org.apfloat.spi.FilenameGenerator;
import org.apfloat.spi.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApfloatContext
implements Cloneable {
    public static final String BUILDER_FACTORY = "builderFactory";
    public static final String DEFAULT_RADIX = "defaultRadix";
    public static final String MAX_MEMORY_BLOCK_SIZE = "maxMemoryBlockSize";
    public static final String CACHE_L1_SIZE = "cacheL1Size";
    public static final String CACHE_L2_SIZE = "cacheL2Size";
    public static final String CACHE_BURST = "cacheBurst";
    public static final String MEMORY_TRESHOLD = "memoryTreshold";
    public static final String SHARED_MEMORY_TRESHOLD = "sharedMemoryTreshold";
    public static final String BLOCK_SIZE = "blockSize";
    public static final String NUMBER_OF_PROCESSORS = "numberOfProcessors";
    public static final String FILE_PATH = "filePath";
    public static final String FILE_INITIAL_VALUE = "fileInitialValue";
    public static final String FILE_SUFFIX = "fileSuffix";
    public static final String CLEANUP_AT_EXIT = "cleanupAtExit";
    private static ApfloatContext globalContext;
    private static Map<Thread, ApfloatContext> threadContexts;
    private static Properties defaultProperties;
    private static ExecutorService defaultExecutorService;
    private volatile BuilderFactory builderFactory;
    private volatile FilenameGenerator filenameGenerator;
    private volatile int defaultRadix;
    private volatile long maxMemoryBlockSize;
    private volatile int cacheL1Size;
    private volatile int cacheL2Size;
    private volatile int cacheBurst;
    private volatile int memoryTreshold;
    private volatile long sharedMemoryTreshold;
    private volatile int blockSize;
    private volatile int numberOfProcessors;
    private volatile CleanupThread cleanupThread;
    private volatile Properties properties;
    private volatile Object sharedMemoryLock = new Object();
    private volatile ExecutorService executorService = defaultExecutorService;
    private volatile ConcurrentHashMap<String, Object> attributes = new ConcurrentHashMap();

    public ApfloatContext(Properties properties) throws ApfloatConfigurationException {
        this.properties = (Properties)defaultProperties.clone();
        this.properties.putAll((Map<?, ?>)properties);
        this.setProperties(this.properties);
    }

    public static ApfloatContext getContext() {
        ApfloatContext apfloatContext = ApfloatContext.getThreadContext();
        if (apfloatContext == null) {
            apfloatContext = ApfloatContext.getGlobalContext();
        }
        return apfloatContext;
    }

    public static ApfloatContext getGlobalContext() {
        return globalContext;
    }

    public static ApfloatContext getThreadContext() {
        return ApfloatContext.getThreadContext(Thread.currentThread());
    }

    public static ApfloatContext getThreadContext(Thread thread) {
        return threadContexts.get(thread);
    }

    public static void setThreadContext(ApfloatContext apfloatContext) {
        ApfloatContext.setThreadContext(apfloatContext, Thread.currentThread());
    }

    public static void setThreadContext(ApfloatContext apfloatContext, Thread thread) {
        threadContexts.put(thread, apfloatContext);
    }

    public static void removeThreadContext() {
        ApfloatContext.removeThreadContext(Thread.currentThread());
    }

    public static void removeThreadContext(Thread thread) {
        threadContexts.remove(thread);
    }

    public static void clearThreadContexts() {
        threadContexts.clear();
    }

    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public void setBuilderFactory(BuilderFactory builderFactory) {
        this.properties.setProperty(BUILDER_FACTORY, builderFactory.getClass().getName());
        this.builderFactory = builderFactory;
        if (this.cleanupThread != null) {
            this.cleanupThread.setBuilderFactory(builderFactory);
        }
    }

    public FilenameGenerator getFilenameGenerator() {
        return this.filenameGenerator;
    }

    public void setFilenameGenerator(FilenameGenerator filenameGenerator) {
        this.properties.setProperty(FILE_PATH, filenameGenerator.getPath());
        this.properties.setProperty(FILE_INITIAL_VALUE, String.valueOf(filenameGenerator.getInitialValue()));
        this.properties.setProperty(FILE_SUFFIX, filenameGenerator.getSuffix());
        this.filenameGenerator = filenameGenerator;
    }

    public int getDefaultRadix() {
        return this.defaultRadix;
    }

    public void setDefaultRadix(int n) {
        n = Math.min(Math.max(n, 2), 36);
        this.properties.setProperty(DEFAULT_RADIX, String.valueOf(n));
        this.defaultRadix = n;
    }

    public long getMaxMemoryBlockSize() {
        return this.maxMemoryBlockSize;
    }

    public void setMaxMemoryBlockSize(long l) {
        l = Util.round23down(Math.max(l, 65536L));
        this.properties.setProperty(MAX_MEMORY_BLOCK_SIZE, String.valueOf(l));
        this.maxMemoryBlockSize = l;
    }

    public int getCacheL1Size() {
        return this.cacheL1Size;
    }

    public void setCacheL1Size(int n) {
        n = Util.round2down(Math.max(n, 512));
        this.properties.setProperty(CACHE_L1_SIZE, String.valueOf(n));
        this.cacheL1Size = n;
    }

    public int getCacheL2Size() {
        return this.cacheL2Size;
    }

    public void setCacheL2Size(int n) {
        n = Util.round2down(Math.max(n, 2048));
        this.properties.setProperty(CACHE_L2_SIZE, String.valueOf(n));
        this.cacheL2Size = n;
    }

    public int getCacheBurst() {
        return this.cacheBurst;
    }

    public void setCacheBurst(int n) {
        n = Util.round2down(Math.max(n, 8));
        this.properties.setProperty(CACHE_BURST, String.valueOf(n));
        this.cacheBurst = n;
    }

    public int getMemoryTreshold() {
        return this.memoryTreshold;
    }

    public void setMemoryTreshold(int n) {
        n = Math.max(n, 128);
        this.properties.setProperty(MEMORY_TRESHOLD, String.valueOf(n));
        this.memoryTreshold = n;
    }

    public long getSharedMemoryTreshold() {
        return this.sharedMemoryTreshold;
    }

    public void setSharedMemoryTreshold(long l) {
        l = Math.max(l, 128L);
        this.properties.setProperty(SHARED_MEMORY_TRESHOLD, String.valueOf(l));
        this.sharedMemoryTreshold = l;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int n) {
        n = Util.round2down(Math.max(n, 128));
        this.properties.setProperty(BLOCK_SIZE, String.valueOf(n));
        this.blockSize = n;
    }

    public int getNumberOfProcessors() {
        return this.numberOfProcessors;
    }

    public void setNumberOfProcessors(int n) {
        n = Math.max(n, 1);
        this.properties.setProperty(NUMBER_OF_PROCESSORS, String.valueOf(n));
        this.numberOfProcessors = n;
    }

    public boolean getCleanupAtExit() {
        return this.cleanupThread != null;
    }

    public void setCleanupAtExit(boolean bl) {
        this.properties.setProperty(CLEANUP_AT_EXIT, String.valueOf(bl));
        if (bl && this.cleanupThread == null) {
            this.cleanupThread = new CleanupThread();
            this.cleanupThread.setBuilderFactory(this.builderFactory);
            Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        } else if (!bl && this.cleanupThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.cleanupThread);
            this.cleanupThread = null;
        }
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, String string2) throws ApfloatConfigurationException {
        try {
            if (string.equals(BUILDER_FACTORY)) {
                this.setBuilderFactory((BuilderFactory)Class.forName(string2).newInstance());
            } else if (string.equals(DEFAULT_RADIX)) {
                this.setDefaultRadix(Integer.parseInt(string2));
            } else if (string.equals(MAX_MEMORY_BLOCK_SIZE)) {
                this.setMaxMemoryBlockSize(Long.parseLong(string2));
            } else if (string.equals(CACHE_L1_SIZE)) {
                this.setCacheL1Size(Integer.parseInt(string2));
            } else if (string.equals(CACHE_L2_SIZE)) {
                this.setCacheL2Size(Integer.parseInt(string2));
            } else if (string.equals(CACHE_BURST)) {
                this.setCacheBurst(Integer.parseInt(string2));
            } else if (string.equals(MEMORY_TRESHOLD)) {
                this.setMemoryTreshold(Integer.parseInt(string2));
            } else if (string.equals(SHARED_MEMORY_TRESHOLD)) {
                this.setSharedMemoryTreshold(Long.parseLong(string2));
            } else if (string.equals(BLOCK_SIZE)) {
                this.setBlockSize(Integer.parseInt(string2));
            } else if (string.equals(NUMBER_OF_PROCESSORS)) {
                this.setNumberOfProcessors(Integer.parseInt(string2));
            } else if (string.equals(FILE_PATH)) {
                this.setFilenameGenerator(new FilenameGenerator(string2, this.getProperty(FILE_INITIAL_VALUE), this.getProperty(FILE_SUFFIX)));
            } else if (string.equals(FILE_INITIAL_VALUE)) {
                this.setFilenameGenerator(new FilenameGenerator(this.getProperty(FILE_PATH), string2, this.getProperty(FILE_SUFFIX)));
            } else if (string.equals(FILE_SUFFIX)) {
                this.setFilenameGenerator(new FilenameGenerator(this.getProperty(FILE_PATH), this.getProperty(FILE_INITIAL_VALUE), string2));
            } else if (string.equals(CLEANUP_AT_EXIT)) {
                this.setCleanupAtExit(Boolean.parseBoolean(string2));
            } else {
                this.properties.setProperty(string, string2);
            }
        }
        catch (Exception exception) {
            throw new ApfloatConfigurationException("Error setting property \"" + string + "\" to value \"" + string2 + '\"', exception);
        }
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public Object getSharedMemoryLock() {
        return this.sharedMemoryLock;
    }

    public void setSharedMemoryLock(Object object) {
        this.sharedMemoryLock = object;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Object setAttribute(String string, Object object) {
        return this.attributes.put(string, object);
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.keys();
    }

    public static Properties loadProperties() throws ApfloatRuntimeException {
        Properties properties = new Properties();
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("apfloat");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                properties.setProperty(string, resourceBundle.getString(string));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return properties;
    }

    public static ExecutorService getDefaultExecutorService() {
        ThreadFactory threadFactory = new ThreadFactory(){
            private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

            public Thread newThread(Runnable runnable) {
                Thread thread = this.defaultThreadFactory.newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
        return Executors.newCachedThreadPool(threadFactory);
    }

    public void setProperties(Properties properties) throws ApfloatConfigurationException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public Object clone() {
        try {
            ApfloatContext apfloatContext = (ApfloatContext)super.clone();
            apfloatContext.properties = (Properties)apfloatContext.properties.clone();
            apfloatContext.attributes = new ConcurrentHashMap<String, Object>(apfloatContext.attributes);
            return apfloatContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        long l;
        threadContexts = new ConcurrentWeakHashMap<Thread, ApfloatContext>();
        defaultProperties = new Properties();
        try {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
            l = Math.max(memoryUsage.getCommitted(), memoryUsage.getMax());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            l = Runtime.getRuntime().maxMemory();
        }
        long l2 = Util.round23down(l / 5L * 4L);
        int n = Runtime.getRuntime().availableProcessors();
        String string = l >= 0x100000000L ? "Long" : "Int";
        defaultProperties.setProperty(BUILDER_FACTORY, "org.apfloat.internal." + string + "BuilderFactory");
        defaultProperties.setProperty(DEFAULT_RADIX, "10");
        defaultProperties.setProperty(MAX_MEMORY_BLOCK_SIZE, String.valueOf(l2));
        defaultProperties.setProperty(CACHE_L1_SIZE, "8192");
        defaultProperties.setProperty(CACHE_L2_SIZE, "262144");
        defaultProperties.setProperty(CACHE_BURST, "32");
        defaultProperties.setProperty(MEMORY_TRESHOLD, "65536");
        defaultProperties.setProperty(SHARED_MEMORY_TRESHOLD, String.valueOf(l2 / (long)n / 32L));
        defaultProperties.setProperty(BLOCK_SIZE, "65536");
        defaultProperties.setProperty(NUMBER_OF_PROCESSORS, String.valueOf(n));
        defaultProperties.setProperty(FILE_PATH, "");
        defaultProperties.setProperty(FILE_INITIAL_VALUE, "0");
        defaultProperties.setProperty(FILE_SUFFIX, ".ap");
        defaultProperties.setProperty(CLEANUP_AT_EXIT, "true");
        defaultExecutorService = ApfloatContext.getDefaultExecutorService();
        globalContext = new ApfloatContext(ApfloatContext.loadProperties());
    }

    private static class CleanupThread
    extends Thread {
        private BuilderFactory builderFactory;

        public CleanupThread() {
            super("apfloat shutdown clean-up thread");
        }

        public void run() {
            ApfloatMath.cleanUp();
            System.gc();
            System.gc();
            System.runFinalization();
            this.builderFactory.shutdown();
        }

        public void setBuilderFactory(BuilderFactory builderFactory) {
            this.builderFactory = builderFactory;
        }
    }
}

