/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Formatter;
import org.apfloat.Apcomplex;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.Aprational;
import org.apfloat.FormattingHelper;
import org.apfloat.RadixConversionHelper;
import org.apfloat.spi.ApfloatImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Apfloat
extends Apcomplex
implements Comparable<Apfloat> {
    private static final long serialVersionUID = -36707433458144439L;
    private ApfloatImpl impl;

    protected Apfloat() {
    }

    protected Apfloat(ApfloatImpl apfloatImpl) {
        assert (apfloatImpl.precision() > 0L);
        this.impl = apfloatImpl;
    }

    public Apfloat(String string) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(string, false));
    }

    public Apfloat(String string, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(string, l, false));
    }

    public Apfloat(String string, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(string, l, n, false));
    }

    public Apfloat(long l) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(l));
    }

    public Apfloat(long l, long l2) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(l, l2));
    }

    public Apfloat(long l, long l2, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(l, l2, n));
    }

    public Apfloat(float f) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(f));
    }

    public Apfloat(float f, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(f, l));
    }

    public Apfloat(float f, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(f, l, n));
    }

    public Apfloat(double d) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(d));
    }

    public Apfloat(double d, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(d, l));
    }

    public Apfloat(double d, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(d, l, n));
    }

    public Apfloat(PushbackReader pushbackReader) throws IOException, NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(pushbackReader, false));
    }

    public Apfloat(PushbackReader pushbackReader, long l) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(pushbackReader, l, false));
    }

    public Apfloat(PushbackReader pushbackReader, long l, int n) throws IOException, NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(pushbackReader, l, n, false));
    }

    public Apfloat(BigInteger bigInteger) throws NumberFormatException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(bigInteger));
    }

    public Apfloat(BigInteger bigInteger, long l) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(bigInteger, l));
    }

    public Apfloat(BigInteger bigInteger, long l, int n) throws NumberFormatException, IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(bigInteger, l, n));
    }

    public Apfloat(BigDecimal bigDecimal) throws ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(bigDecimal));
    }

    public Apfloat(BigDecimal bigDecimal, long l) throws IllegalArgumentException, ApfloatRuntimeException {
        this(ApfloatHelper.createApfloat(bigDecimal, l));
    }

    @Override
    public int radix() {
        return this.impl.radix();
    }

    @Override
    public Apfloat real() {
        return this;
    }

    @Override
    public Apfloat imag() {
        return ZERO;
    }

    @Override
    public long precision() throws ApfloatRuntimeException {
        return this.impl.precision();
    }

    @Override
    public Apfloat precision(long l) throws IllegalArgumentException, ApfloatRuntimeException {
        ApfloatHelper.checkPrecision(l);
        return new Apfloat(this.getImpl(l));
    }

    @Override
    public long scale() throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return -9223372036854775807L;
        }
        return this.impl.scale();
    }

    @Override
    public long size() throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return 0L;
        }
        return this.impl.size();
    }

    public int signum() {
        return this.impl.signum();
    }

    public boolean isShort() throws ApfloatRuntimeException {
        return this.impl.isShort();
    }

    @Override
    public Apfloat negate() throws ApfloatRuntimeException {
        return new Apfloat(this.impl.negate());
    }

    public Apfloat add(Apfloat apfloat) throws ApfloatRuntimeException {
        if (apfloat.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            return apfloat;
        }
        return this.addOrSubtract(apfloat, false);
    }

    public Apfloat subtract(Apfloat apfloat) throws ApfloatRuntimeException {
        if (apfloat.signum() == 0) {
            return this;
        }
        if (this.signum() == 0) {
            ApfloatImpl apfloatImpl = apfloat.getImpl();
            apfloatImpl = apfloatImpl.negate();
            return new Apfloat(apfloatImpl);
        }
        return this.addOrSubtract(apfloat, true);
    }

    private Apfloat addOrSubtract(Apfloat apfloat, boolean bl) throws ApfloatRuntimeException {
        ApfloatImpl apfloatImpl;
        long[] lArray = ApfloatHelper.getMatchingPrecisions(this, apfloat);
        if (lArray[0] == 0L) {
            apfloatImpl = apfloat.getImpl(lArray[1]);
            if (bl) {
                apfloatImpl = apfloatImpl.negate();
            }
        } else if (lArray[1] == 0L) {
            apfloatImpl = this.getImpl(lArray[0]);
        } else {
            apfloatImpl = this.getImpl(lArray[0]);
            ApfloatImpl apfloatImpl2 = apfloat.getImpl(lArray[1]);
            apfloatImpl = apfloatImpl.addOrSubtract(apfloatImpl2, bl);
        }
        return new Apfloat(apfloatImpl);
    }

    public Apfloat multiply(Apfloat apfloat) throws ApfloatRuntimeException {
        if (this.signum() == 0) {
            return this;
        }
        if (apfloat.signum() == 0) {
            return apfloat;
        }
        if (this.equals(ONE)) {
            return apfloat.precision(Math.min(this.precision(), apfloat.precision()));
        }
        if (apfloat.equals(ONE)) {
            return this.precision(Math.min(this.precision(), apfloat.precision()));
        }
        long l = Math.min(this.precision(), apfloat.precision());
        ApfloatImpl apfloatImpl = this.getImpl(l);
        ApfloatImpl apfloatImpl2 = apfloat.getImpl(l);
        ApfloatImpl apfloatImpl3 = apfloatImpl.multiply(apfloatImpl2);
        return new Apfloat(apfloatImpl3);
    }

    public Apfloat divide(Apfloat apfloat) throws ArithmeticException, ApfloatRuntimeException {
        if (apfloat.signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.signum() == 0) {
            return this;
        }
        if (apfloat.equals(ONE)) {
            return this.precision(Math.min(this.precision(), apfloat.precision()));
        }
        long l = Math.min(this.precision(), apfloat.precision());
        if (apfloat.isShort()) {
            ApfloatImpl apfloatImpl = this.getImpl(l);
            ApfloatImpl apfloatImpl2 = apfloat.getImpl(l);
            ApfloatImpl apfloatImpl3 = apfloatImpl.divideShort(apfloatImpl2);
            return new Apfloat(apfloatImpl3);
        }
        Apfloat apfloat2 = ApfloatMath.inverseRoot(apfloat, 1L, l);
        return this.multiply(apfloat2);
    }

    public Apfloat mod(Apfloat apfloat) throws ApfloatRuntimeException {
        return ApfloatMath.fmod(this, apfloat);
    }

    public Apint floor() throws ApfloatRuntimeException {
        if (this.signum() >= 0) {
            return new Apint(new Apfloat(this.impl.absFloor()));
        }
        return new Apint(new Apfloat(this.impl.absCeil()));
    }

    public Apint ceil() throws ApfloatRuntimeException {
        if (this.signum() >= 0) {
            return new Apint(new Apfloat(this.impl.absCeil()));
        }
        return new Apint(new Apfloat(this.impl.absFloor()));
    }

    public Apint truncate() throws ApfloatRuntimeException {
        return new Apint(new Apfloat(this.impl.absFloor()));
    }

    @Override
    public double doubleValue() {
        int n = ApfloatHelper.getDoublePrecision(this.radix());
        ApfloatImpl apfloatImpl = this.getImpl(n);
        return apfloatImpl.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public byte byteValue() {
        long l = this.longValue();
        return (byte)Math.min(Math.max(l, -128L), 127L);
    }

    @Override
    public short shortValue() {
        long l = this.longValue();
        return (short)Math.min(Math.max(l, -32768L), 32767L);
    }

    @Override
    public int intValue() {
        long l = this.longValue();
        return (int)Math.min(Math.max(l, Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    @Override
    public long longValue() {
        int n = ApfloatHelper.getLongPrecision(this.radix());
        ApfloatImpl apfloatImpl = this.getImpl(n);
        return apfloatImpl.longValue();
    }

    public long equalDigits(Apfloat apfloat) throws ApfloatRuntimeException {
        long l = Math.min(this.precision(), apfloat.precision());
        ApfloatImpl apfloatImpl = this.getImpl(l);
        ApfloatImpl apfloatImpl2 = apfloat.getImpl(l);
        return apfloatImpl.equalDigits(apfloatImpl2);
    }

    @Override
    public Apfloat toRadix(int n) throws NumberFormatException, ApfloatRuntimeException {
        return RadixConversionHelper.toRadix(this, n);
    }

    @Override
    public int compareTo(Apfloat apfloat) {
        if (apfloat instanceof Aprational) {
            return -apfloat.compareTo(this);
        }
        return this.getImpl().compareTo(apfloat.getImpl());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Aprational) {
            return object.equals(this);
        }
        if (object instanceof Apfloat) {
            Apfloat apfloat = (Apfloat)object;
            return this.getImpl().equals(apfloat.getImpl());
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return this.impl.hashCode();
    }

    @Override
    public String toString(boolean bl) throws ApfloatRuntimeException {
        return this.impl.toString(bl);
    }

    @Override
    public void writeTo(Writer writer, boolean bl) throws IOException, ApfloatRuntimeException {
        this.impl.writeTo(writer, bl);
    }

    @Override
    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        Apfloat apfloat = n3 == -1 ? this : ApfloatHelper.limitPrecision(this, (long)n3);
        try {
            Writer writer = FormattingHelper.wrapAppendableWriter(formatter.out());
            writer = FormattingHelper.wrapLocalizeWriter(writer, formatter, this.radix(), (n & 2) == 2);
            if (n2 == -1) {
                apfloat.writeTo(writer, (n & 4) == 4);
            } else {
                writer = FormattingHelper.wrapPadWriter(writer, (n & 1) == 1);
                apfloat.writeTo(writer, (n & 4) == 4);
                FormattingHelper.finishPad(writer, n2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected ApfloatImpl getImpl(long l) throws ApfloatRuntimeException {
        if (l == this.precision()) {
            return this.impl;
        }
        return this.impl.precision(l);
    }

    private ApfloatImpl getImpl() throws ApfloatRuntimeException {
        long l = this.precision();
        return this.getImpl(l);
    }
}

