/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.LossOfPrecisionException;
import org.apfloat.OverflowException;
import org.apfloat.spi.Util;

public class ApcomplexMath {
    private ApcomplexMath() {
    }

    @Deprecated
    public static Apcomplex negate(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return apcomplex.negate();
    }

    public static Apfloat abs(Apcomplex apcomplex) throws ApfloatRuntimeException {
        if (apcomplex.real().signum() == 0) {
            return ApfloatMath.abs(apcomplex.imag());
        }
        if (apcomplex.imag().signum() == 0) {
            return ApfloatMath.abs(apcomplex.real());
        }
        return ApfloatMath.sqrt(ApcomplexMath.norm(apcomplex));
    }

    public static Apfloat norm(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return ApfloatMath.multiplyAdd(apcomplex.real(), apcomplex.real(), apcomplex.imag(), apcomplex.imag());
    }

    public static Apfloat arg(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        return ApfloatMath.atan2(apcomplex.imag(), apcomplex.real());
    }

    public static Apcomplex scale(Apcomplex apcomplex, long l) throws ApfloatRuntimeException {
        return new Apcomplex(ApfloatMath.scale(apcomplex.real(), l), ApfloatMath.scale(apcomplex.imag(), l));
    }

    public static Apcomplex pow(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        if (l == 0L) {
            if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
                throw new ArithmeticException("Zero to power zero");
            }
            return new Apcomplex(new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix()));
        }
        if (l < 0L) {
            apcomplex = Apcomplex.ONE.divide(apcomplex);
            l = -l;
        }
        return ApcomplexMath.powAbs(apcomplex, l);
    }

    private static Apcomplex powAbs(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        long l2 = apcomplex.precision();
        apcomplex = ApfloatHelper.extendPrecision(apcomplex);
        int n = 0;
        while ((l & 1L) == 0L) {
            ++n;
            l >>>= 1;
        }
        Apcomplex apcomplex2 = apcomplex;
        while ((l >>>= 1) > 0L) {
            apcomplex = apcomplex.multiply(apcomplex);
            if ((l & 1L) == 0L) continue;
            apcomplex2 = apcomplex2.multiply(apcomplex);
        }
        while (n-- > 0) {
            apcomplex2 = apcomplex2.multiply(apcomplex2);
        }
        return ApfloatHelper.setPrecision(apcomplex2, l2);
    }

    public static Apcomplex sqrt(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return ApcomplexMath.root(apcomplex, 2L);
    }

    public static Apcomplex cbrt(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return ApcomplexMath.root(apcomplex, 3L);
    }

    public static Apcomplex root(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.root(apcomplex, l, 0L);
    }

    public static Apcomplex root(Apcomplex apcomplex, long l, long l2) throws ArithmeticException, ApfloatRuntimeException {
        if (l == 0L) {
            throw new ArithmeticException("Zeroth root");
        }
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            if (l < 0L) {
                throw new ArithmeticException("Inverse root of zero");
            }
            return Apcomplex.ZERO;
        }
        if (l == 1L) {
            return apcomplex;
        }
        if (apcomplex.imag().signum() == 0 && apcomplex.real().signum() > 0 && (l2 %= l) == 0L) {
            return new Apcomplex(ApfloatMath.root(apcomplex.real(), l));
        }
        if (l < 0L) {
            return ApcomplexMath.inverseRootAbs(apcomplex, -l, l2);
        }
        if (l == 2L) {
            return apcomplex.multiply(ApcomplexMath.inverseRootAbs(apcomplex, 2L, l2));
        }
        if (l == 3L) {
            if (apcomplex.real().signum() < 0) {
                l2 = apcomplex.imag().signum() == 0 ? 1L - l2 : l2 - 1L;
                l2 %= l;
            } else {
                l2 = -l2;
            }
            Apcomplex apcomplex2 = apcomplex.multiply(apcomplex);
            return apcomplex.multiply(ApcomplexMath.inverseRootAbs(apcomplex2, 3L, l2));
        }
        return ApcomplexMath.inverseRootAbs(ApcomplexMath.inverseRootAbs(apcomplex, l, l2), 1L, 0L);
    }

    public static Apcomplex inverseRoot(Apcomplex apcomplex, long l) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.inverseRoot(apcomplex, l, 0L);
    }

    public static Apcomplex inverseRoot(Apcomplex apcomplex, long l, long l2) throws ArithmeticException, ApfloatRuntimeException {
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            throw new ArithmeticException("Inverse root of zero");
        }
        if (l == 0L) {
            throw new ArithmeticException("Inverse zeroth root");
        }
        if (apcomplex.imag().signum() == 0 && apcomplex.real().signum() > 0 && (l2 %= l) == 0L) {
            return new Apcomplex(ApfloatMath.inverseRoot(apcomplex.real(), l));
        }
        if (l < 0L) {
            return ApcomplexMath.inverseRootAbs(ApcomplexMath.inverseRootAbs(apcomplex, -l, l2), 1L, 0L);
        }
        return ApcomplexMath.inverseRootAbs(apcomplex, l, l2);
    }

    private static Apcomplex inverseRootAbs(Apcomplex apcomplex, long l, long l2) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex apcomplex2;
        double d;
        double d2;
        double d3;
        double d4;
        Apcomplex apcomplex3;
        Apfloat apfloat;
        Apcomplex apcomplex4;
        long l3;
        if (apcomplex.equals(Apcomplex.ONE) && l2 == 0L) {
            return apcomplex;
        }
        if (l == 2L && apcomplex.imag().signum() == 0 && apcomplex.real().signum() < 0) {
            Apfloat apfloat2 = ApfloatMath.inverseRoot(apcomplex.real().negate(), l);
            return new Apcomplex(Apfloat.ZERO, l2 == 0L ? apfloat2.negate() : apfloat2);
        }
        long l4 = apcomplex.precision();
        if (l4 == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate inverse root to infinite precision");
        }
        Apfloat apfloat3 = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat4 = ApfloatMath.abs(new Apfloat(l, Long.MAX_VALUE, apcomplex.radix()));
        double d5 = Math.abs((double)l);
        long l5 = apcomplex.real().scale();
        long l6 = apcomplex.imag().scale();
        long l7 = Math.max(l5, l6);
        long l8 = l7 - Math.min(l5, l6);
        long l9 = l3 = (long)ApfloatHelper.getDoublePrecision(apcomplex.radix());
        long l10 = l7 / l;
        long l11 = l7 - l10 * l;
        double d6 = Math.pow(apcomplex.radix(), (double)(-l11) / d5);
        if (apcomplex.imag().signum() == 0 || (l8 > l3 / 2L || l8 < 0L) && l5 > l6) {
            double d7;
            apcomplex4 = apcomplex.real().precision(l3);
            apfloat = apcomplex.imag().precision(l3);
            apcomplex3 = new Apcomplex(Apcomplex.ZERO, apfloat.divide(apfloat4.multiply((Apfloat)apcomplex4)));
            apcomplex4 = ApfloatMath.scale((Apfloat)apcomplex4, -((Apfloat)apcomplex4).scale());
            d4 = ((Apfloat)apcomplex4).doubleValue();
            if (d7 >= 0.0) {
                d3 = Math.pow(d4, -1.0 / d5) * d6;
                d2 = 0.0;
            } else {
                d4 = Math.pow(-d4, -1.0 / d5) * d6;
                d = (apfloat.signum() >= 0 ? -Math.PI : Math.PI) / d5;
                d3 = d4 * Math.cos(d);
                d2 = d4 * Math.sin(d);
            }
            apcomplex4 = ApfloatMath.scale(new Apfloat(d3, l3, apcomplex.radix()), -l10);
            apfloat = ApfloatMath.scale(new Apfloat(d2, l3, apcomplex.radix()), -l10);
            apcomplex2 = new Apcomplex((Apfloat)apcomplex4, apfloat);
            apcomplex2 = apcomplex2.subtract(apcomplex2.multiply(apcomplex3));
        } else if (apcomplex.real().signum() == 0 || (l8 > l3 / 2L || l8 < 0L) && l6 > l5) {
            double d8;
            apcomplex4 = apcomplex.real().precision(l3);
            apfloat = apcomplex.imag().precision(l3);
            apcomplex3 = new Apcomplex(Apfloat.ZERO, ((Apfloat)apcomplex4).divide(apfloat4.multiply(apfloat)));
            apfloat = ApfloatMath.scale(apfloat, -apfloat.scale());
            d4 = apfloat.doubleValue();
            if (d8 >= 0.0) {
                d4 = Math.pow(d4, -1.0 / d5) * d6;
                d = -Math.PI / (2.0 * d5);
            } else {
                d4 = Math.pow(-d4, -1.0 / d5) * d6;
                d = Math.PI / (2.0 * d5);
            }
            d3 = d4 * Math.cos(d);
            d2 = d4 * Math.sin(d);
            apcomplex4 = ApfloatMath.scale(new Apfloat(d3, l3, apcomplex.radix()), -l10);
            apfloat = ApfloatMath.scale(new Apfloat(d2, l3, apcomplex.radix()), -l10);
            apcomplex2 = new Apcomplex((Apfloat)apcomplex4, apfloat);
            apcomplex2 = apcomplex2.add(apcomplex2.multiply(apcomplex3));
        } else {
            apcomplex4 = apcomplex.real().precision(l3);
            apfloat = apcomplex.imag().precision(l3);
            apcomplex4 = ApfloatMath.scale((Apfloat)apcomplex4, -l7);
            apfloat = ApfloatMath.scale(apfloat, -l7);
            d3 = ((Apfloat)apcomplex4).doubleValue();
            d2 = apfloat.doubleValue();
            d4 = Math.pow(d3 * d3 + d2 * d2, -1.0 / (2.0 * d5)) * d6;
            d = -Math.atan2(d2, d3) / d5;
            d3 = d4 * Math.cos(d);
            d2 = d4 * Math.sin(d);
            apcomplex4 = ApfloatMath.scale(new Apfloat(d3, l3, apcomplex.radix()), -l10);
            apfloat = ApfloatMath.scale(new Apfloat(d2, l3, apcomplex.radix()), -l10);
            apcomplex2 = new Apcomplex((Apfloat)apcomplex4, apfloat);
        }
        if (l2 != 0L) {
            long l12 = l2 = l2 < 0L ? l2 + l : l2;
            if (l % 4L == 0L && l >>> 2 == l2) {
                apcomplex4 = new Apcomplex(Apfloat.ZERO, apfloat3);
            } else if (l % 4L == 0L && (l >>> 2) * 3L == l2) {
                apcomplex4 = new Apcomplex(Apfloat.ZERO, apfloat3.negate());
            } else if (l % 2L == 0L && l >>> 1 == l2) {
                apcomplex4 = apfloat3.negate();
            } else {
                d = Math.PI * 2 * (double)l2 / d5;
                d3 = Math.cos(d);
                d2 = Math.sin(d);
                apfloat = new Apfloat(d3, l3, apcomplex.radix());
                apcomplex3 = new Apfloat(d2, l3, apcomplex.radix());
                apcomplex4 = new Apcomplex(apfloat, (Apfloat)apcomplex3);
            }
            apcomplex2 = apcomplex2.multiply(apcomplex.imag().signum() >= 0 ? apcomplex4.conj() : apcomplex4);
        }
        int n = 0;
        for (long i = l9; i < l4; i <<= 1) {
            ++n;
        }
        int n2 = n;
        long l13 = l9;
        while (n2 > 0 && l13 - 20L << n2 < l4) {
            --n2;
            l13 <<= 1;
        }
        apcomplex = ApfloatHelper.extendPrecision(apcomplex);
        while (n-- > 0) {
            apcomplex2 = ApfloatHelper.setPrecision(apcomplex2, Math.min(l9 *= 2L, l4));
            Apcomplex apcomplex5 = ApcomplexMath.powAbs(apcomplex2, l);
            apcomplex5 = ApcomplexMath.lastIterationExtendPrecision(n, n2, apcomplex5);
            apcomplex5 = apfloat3.subtract(apcomplex.multiply(apcomplex5));
            if (n < n2) {
                apcomplex5 = new Apcomplex(apcomplex5.real().precision(l9 / 2L), apcomplex5.imag().precision(l9 / 2L));
            }
            apcomplex2 = ApcomplexMath.lastIterationExtendPrecision(n, n2, apcomplex2);
            apcomplex2 = apcomplex2.add(apcomplex2.multiply(apcomplex5).divide(apfloat4));
            if (n != n2) continue;
            apcomplex5 = ApcomplexMath.powAbs(apcomplex2, l);
            apcomplex5 = ApcomplexMath.lastIterationExtendPrecision(n, -1, apcomplex5);
            apcomplex2 = ApcomplexMath.lastIterationExtendPrecision(n, -1, apcomplex2);
            apcomplex2 = apcomplex2.add(apcomplex2.multiply(apfloat3.subtract(apcomplex.multiply(apcomplex5))).divide(apfloat4));
        }
        return ApfloatHelper.setPrecision(apcomplex2, l4);
    }

    public static Apcomplex[] allRoots(Apcomplex apcomplex, int n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0) {
            throw new ArithmeticException("Zeroth root");
        }
        if (n == 1) {
            return new Apcomplex[]{apcomplex};
        }
        if (n == Integer.MIN_VALUE) {
            throw new ApfloatRuntimeException("Maximum array size exceeded");
        }
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            if (n < 0) {
                throw new ArithmeticException("Inverse root of zero");
            }
            Object[] objectArray = new Apcomplex[n];
            Arrays.fill(objectArray, Apcomplex.ZERO);
            return objectArray;
        }
        boolean bl = n < 0;
        n = Math.abs(n);
        long l = apcomplex.precision();
        apcomplex = ApfloatHelper.extendPrecision(apcomplex);
        Apcomplex apcomplex2 = ApcomplexMath.inverseRootAbs(new Apfloat(1L, l, apcomplex.radix()), n, 1L);
        apcomplex2 = apcomplex.imag().signum() >= 0 ^ bl ? apcomplex2.conj() : apcomplex2;
        Apcomplex[] apcomplexArray = new Apcomplex[n];
        Apcomplex apcomplex3 = bl ? ApcomplexMath.inverseRootAbs(apcomplex, n, 0L) : ApcomplexMath.root(apcomplex, n);
        apcomplexArray[0] = ApfloatHelper.setPrecision(apcomplex3, l);
        for (int i = 1; i < n; ++i) {
            apcomplex3 = apcomplex3.multiply(apcomplex2);
            apcomplexArray[i] = ApfloatHelper.setPrecision(apcomplex3, l);
        }
        return apcomplexArray;
    }

    public static Apcomplex agm(Apcomplex apcomplex, Apcomplex apcomplex2) throws ApfloatRuntimeException {
        Apcomplex apcomplex3;
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0 || apcomplex2.real().signum() == 0 && apcomplex2.imag().signum() == 0) {
            return Apcomplex.ZERO;
        }
        long l = Math.min(apcomplex.precision(), apcomplex2.precision());
        long l2 = Math.max(apcomplex.precision(), apcomplex2.precision());
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate agm to infinite precision");
        }
        l = ApfloatHelper.extendPrecision(l);
        apcomplex = ApfloatHelper.ensurePrecision(apcomplex, l);
        apcomplex2 = ApfloatHelper.ensurePrecision(apcomplex2, l);
        long l3 = 0L;
        long l4 = (l + 1L) / 2L;
        Apfloat apfloat = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        while (l3 < 1000L && l3 < l4) {
            apcomplex3 = apcomplex.add(apcomplex2).divide(apfloat);
            apcomplex2 = ApcomplexMath.sqrt(apcomplex.multiply(apcomplex2));
            apcomplex = apcomplex3;
            apcomplex = ApfloatHelper.ensurePrecision(apcomplex, l);
            apcomplex2 = ApfloatHelper.ensurePrecision(apcomplex2, l);
            l3 = apcomplex.equalDigits(apcomplex2);
        }
        while (l3 <= l4) {
            apcomplex3 = apcomplex.add(apcomplex2).divide(apfloat);
            apcomplex2 = ApcomplexMath.sqrt(apcomplex.multiply(apcomplex2));
            apcomplex = apcomplex3;
            apcomplex = ApfloatHelper.ensurePrecision(apcomplex, l);
            apcomplex2 = ApfloatHelper.ensurePrecision(apcomplex2, l);
            l3 *= 2L;
        }
        return ApfloatHelper.setPrecision(apcomplex.add(apcomplex2).divide(apfloat), l2);
    }

    public static Apcomplex log(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex apcomplex2;
        Apfloat apfloat;
        Apfloat apfloat2;
        Apfloat apfloat3;
        if (apcomplex.real().signum() >= 0 && apcomplex.imag().signum() == 0) {
            return ApfloatMath.log(apcomplex.real());
        }
        long l = apcomplex.precision();
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate logarithm to infinite precision");
        }
        if (apcomplex.real().signum() < 0) {
            apfloat3 = ApfloatHelper.extendPrecision(ApfloatMath.pi(l, apcomplex.radix()), apcomplex.radix() <= 3 ? 1L : 0L);
            apfloat2 = apcomplex.imag().signum() >= 0 ? apfloat3 : apfloat3.negate();
            apcomplex = apcomplex.negate();
        } else {
            apfloat2 = Apfloat.ZERO;
        }
        apfloat3 = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat4 = ApcomplexMath.abs(apcomplex);
        long l2 = apcomplex.scale();
        apcomplex = ApcomplexMath.scale(apcomplex, -l2);
        if (l2 == 0L) {
            apfloat = Apfloat.ZERO;
        } else {
            apcomplex2 = ApfloatHelper.extendPrecision(ApfloatMath.logRadix(l, apcomplex.radix()));
            apfloat = new Apfloat(l2, Long.MAX_VALUE, apcomplex.radix()).multiply((Apfloat)apcomplex2);
        }
        apcomplex2 = ApfloatHelper.extendPrecision(ApcomplexMath.rawLog(apcomplex)).add(apfloat);
        long l3 = Math.max(l - apfloat3.equalDigits(apfloat4), 1L);
        long l4 = Math.max(l - 1L + apcomplex2.imag().scale(), 1L);
        return new Apcomplex(apcomplex2.real().precision(l3), apcomplex2.imag().precision(l4).add(apfloat2));
    }

    public static Apcomplex log(Apcomplex apcomplex, Apcomplex apcomplex2) throws ArithmeticException, ApfloatRuntimeException {
        return ApcomplexMath.log(apcomplex).divide(ApcomplexMath.log(apcomplex2));
    }

    private static Apcomplex rawLog(Apcomplex apcomplex) throws ApfloatRuntimeException {
        assert (apcomplex.real().signum() != 0 || apcomplex.imag().signum() != 0);
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        long l = apcomplex.precision();
        long l2 = ApfloatHelper.extendPrecision(l);
        long l3 = l / 2L + 25L;
        apcomplex = ApfloatHelper.extendPrecision(apcomplex, 25L);
        Apfloat apfloat2 = apfloat.precision(l2);
        apfloat2 = ApfloatMath.scale(apfloat2, -l3);
        apcomplex = ApcomplexMath.scale(apcomplex, -l3);
        Apfloat apfloat3 = ApfloatHelper.extendPrecision(ApfloatMath.agm(apfloat, apfloat2));
        Apcomplex apcomplex2 = ApfloatHelper.extendPrecision(ApcomplexMath.agm(apfloat, apcomplex));
        Apfloat apfloat4 = ApfloatHelper.extendPrecision(ApfloatMath.pi(l, apcomplex.radix()));
        Apcomplex apcomplex3 = apfloat4.multiply(apcomplex2.subtract(apfloat3)).divide(new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix()).multiply(apfloat3).multiply(apcomplex2));
        return ApfloatHelper.setPrecision(apcomplex3, l);
    }

    public static Apcomplex exp(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apcomplex apcomplex2;
        Apfloat apfloat;
        Apfloat apfloat2;
        Apcomplex apcomplex3;
        long l;
        if (apcomplex.imag().signum() == 0) {
            return ApfloatMath.exp(apcomplex.real());
        }
        int n = apcomplex.radix();
        Apfloat apfloat3 = new Apfloat(1L, Long.MAX_VALUE, n);
        long l2 = ApfloatHelper.getDoublePrecision(n);
        long l3 = l = apcomplex.imag().precision() >= apcomplex.imag().scale() ? Math.min(Util.ifFinite(apcomplex.real().precision(), apcomplex.real().precision() + Math.max(1L - apcomplex.real().scale(), 0L)), Util.ifFinite(apcomplex.imag().precision(), 1L + apcomplex.imag().precision() - apcomplex.imag().scale())) : 0L;
        if (l == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate exponent to infinite precision");
        }
        if (apcomplex.real().compareTo(new Apfloat(9.223372036854776E18 * Math.log(n), l2, n)) >= 0) {
            throw new OverflowException("Overflow");
        }
        if (l == 0L) {
            throw new LossOfPrecisionException("Complete loss of accurate digits in imaginary part");
        }
        boolean bl = false;
        if (apcomplex.imag().scale() > 0L) {
            long l4 = Util.ifFinite(l, l + apcomplex.imag().scale());
            apcomplex3 = ApfloatMath.pi(l4, n);
            Apfloat apfloat4 = ((Apfloat)apcomplex3).add((Apfloat)apcomplex3);
            Apfloat apfloat5 = ((Apfloat)apcomplex3).divide(new Apfloat(2L, l, n));
            apfloat2 = ApfloatMath.fmod(apcomplex.imag(), apfloat4);
            if (apfloat2.compareTo((Apfloat)apcomplex3) > 0) {
                apfloat2 = apfloat2.subtract(apfloat4);
            } else if (apfloat2.compareTo(((Apfloat)apcomplex3).negate()) <= 0) {
                apfloat2 = apfloat2.add(apfloat4);
            }
            if (apfloat2.compareTo(apfloat5) > 0) {
                apfloat2 = apfloat2.subtract((Apfloat)apcomplex3);
                bl = true;
            } else if (apfloat2.compareTo(apfloat5.negate()) <= 0) {
                apfloat2 = apfloat2.add((Apfloat)apcomplex3);
                bl = true;
            }
        } else {
            apfloat2 = apcomplex.imag();
        }
        apcomplex = new Apcomplex(apcomplex.real(), apfloat2);
        if (apcomplex.real().signum() == 0) {
            apfloat = apfloat3;
        } else if (apcomplex.real().scale() < -l2 / 2L) {
            long l5 = Util.ifFinite(-apcomplex.real().scale(), -2L * apcomplex.real().scale());
            apfloat = apfloat3.precision(l5).add(apcomplex.real());
        } else {
            double d = apcomplex.real().doubleValue() / Math.log(n);
            double d2 = Math.floor(d);
            double d3 = d - d2;
            apfloat = new Apfloat(Math.pow(n, d3), l2, n);
            apfloat = ApfloatMath.scale(apfloat, (long)d2);
            int n2 = d2 > 0.0 ? (int)Math.floor(Math.log(d2 + 0.5) / Math.log(n)) : 0;
            apfloat = apfloat.precision(Math.max(1L, l2 - (long)n2));
        }
        if (apfloat2.signum() == 0) {
            apcomplex2 = apfloat3;
        } else if (apfloat2.scale() < -l2 / 2L) {
            long l6 = Util.ifFinite(-apfloat2.scale(), -2L * apfloat2.scale());
            apcomplex2 = new Apcomplex(apfloat3.precision(l6), apfloat2.precision(-apfloat2.scale()));
        } else {
            double d = apfloat2.doubleValue();
            apcomplex2 = new Apcomplex(new Apfloat(Math.cos(d), l2, n), new Apfloat(Math.sin(d), l2, n));
        }
        apcomplex3 = apfloat.multiply(apcomplex2);
        long l7 = apcomplex3.precision();
        int n3 = 0;
        for (long i = l7; i < l; i <<= 1) {
            ++n3;
        }
        int n4 = n3;
        long l8 = l7;
        while (n4 > 0 && l8 - 20L << n4 < l) {
            --n4;
            l8 <<= 1;
        }
        if (n3 > 0) {
            ApfloatMath.logRadix(l, n);
        }
        apcomplex = ApfloatHelper.extendPrecision(apcomplex);
        while (n3-- > 0) {
            apcomplex3 = ApfloatHelper.setPrecision(apcomplex3, Math.min(l7 *= 2L, l));
            Apcomplex apcomplex4 = ApcomplexMath.log(apcomplex3);
            apcomplex4 = ApcomplexMath.lastIterationExtendPrecision(n3, n4, apcomplex4);
            apcomplex4 = apcomplex.subtract(apcomplex4);
            if (n3 < n4) {
                apcomplex4 = new Apcomplex(apcomplex4.real().precision(l7 / 2L), apcomplex4.imag().precision(l7 / 2L));
            }
            apcomplex3 = ApcomplexMath.lastIterationExtendPrecision(n3, n4, apcomplex3);
            apcomplex3 = apcomplex3.add(apcomplex3.multiply(apcomplex4));
            if (n3 != n4) continue;
            apcomplex4 = ApcomplexMath.log(apcomplex3);
            apcomplex4 = ApcomplexMath.lastIterationExtendPrecision(n3, -1, apcomplex4);
            apcomplex3 = ApcomplexMath.lastIterationExtendPrecision(n3, -1, apcomplex3);
            apcomplex3 = apcomplex3.add(apcomplex3.multiply(apcomplex.subtract(apcomplex4)));
        }
        return ApfloatHelper.setPrecision(bl ? apcomplex3.negate() : apcomplex3, l);
    }

    public static Apcomplex pow(Apcomplex apcomplex, Apcomplex apcomplex2) throws ApfloatRuntimeException {
        long l = Math.min(apcomplex.precision(), apcomplex2.precision());
        Apcomplex apcomplex3 = ApfloatHelper.checkPow(apcomplex, apcomplex2, l);
        if (apcomplex3 != null) {
            return apcomplex3;
        }
        if (apcomplex.real().signum() >= 0 && apcomplex.imag().signum() == 0 && apcomplex2.imag().signum() == 0) {
            return ApfloatMath.pow(apcomplex.real(), apcomplex2.real());
        }
        return ApcomplexMath.exp(apcomplex2.multiply(ApcomplexMath.log(apcomplex)));
    }

    public static Apcomplex acos(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        if (apcomplex.imag().signum() == 0 && ApfloatMath.abs(apcomplex.real()).compareTo(apfloat) <= 0) {
            return ApfloatMath.acos(apcomplex.real());
        }
        Apcomplex apcomplex2 = new Apcomplex(Apfloat.ZERO, apfloat);
        Apcomplex apcomplex3 = apcomplex2.multiply(ApcomplexMath.log(apcomplex.add(ApcomplexMath.sqrt(apcomplex.multiply(apcomplex).subtract(apfloat)))));
        if (apcomplex.real().signum() * apcomplex.imag().signum() >= 0) {
            return apcomplex3.negate();
        }
        return apcomplex3;
    }

    public static Apcomplex acosh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        if (apcomplex.real().signum() >= 0) {
            return ApcomplexMath.log(apcomplex.add(ApcomplexMath.sqrt(apcomplex.multiply(apcomplex).subtract(apfloat))));
        }
        return ApcomplexMath.log(apcomplex.subtract(ApcomplexMath.sqrt(apcomplex.multiply(apcomplex).subtract(apfloat))));
    }

    public static Apcomplex asin(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        if (apcomplex.imag().signum() == 0 && ApfloatMath.abs(apcomplex.real()).compareTo(apfloat) <= 0) {
            return ApfloatMath.asin(apcomplex.real());
        }
        Apcomplex apcomplex2 = new Apcomplex(Apfloat.ZERO, apfloat);
        if (apcomplex.imag().signum() >= 0) {
            return apcomplex2.multiply(ApcomplexMath.log(ApcomplexMath.sqrt(apfloat.subtract(apcomplex.multiply(apcomplex))).subtract(apcomplex2.multiply(apcomplex))));
        }
        return apcomplex2.multiply(ApcomplexMath.log(apcomplex2.multiply(apcomplex).add(ApcomplexMath.sqrt(apfloat.subtract(apcomplex.multiply(apcomplex)))))).negate();
    }

    public static Apcomplex asinh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        if (apcomplex.real().signum() >= 0) {
            return ApcomplexMath.log(ApcomplexMath.sqrt(apcomplex.multiply(apcomplex).add(apfloat)).add(apcomplex));
        }
        return ApcomplexMath.log(ApcomplexMath.sqrt(apcomplex.multiply(apcomplex).add(apfloat)).subtract(apcomplex)).negate();
    }

    public static Apcomplex atan(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        if (apcomplex.imag().signum() == 0) {
            return ApfloatMath.atan(apcomplex.real());
        }
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = new Apcomplex(Apfloat.ZERO, apfloat);
        return ApcomplexMath.log(apcomplex2.add(apcomplex).divide(apcomplex2.subtract(apcomplex))).multiply(apcomplex2).divide(apfloat2);
    }

    public static Apcomplex atanh(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        return ApcomplexMath.log(apfloat.add(apcomplex).divide(apfloat.subtract(apcomplex))).divide(apfloat2);
    }

    public static Apcomplex cos(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = new Apcomplex(Apfloat.ZERO, apfloat);
        Apcomplex apcomplex3 = ApcomplexMath.exp(apcomplex2.multiply(apcomplex));
        return apcomplex3.add(apfloat.divide(apcomplex3)).divide(apfloat2);
    }

    public static Apcomplex cosh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = ApcomplexMath.exp(apcomplex);
        return apcomplex2.add(apfloat.divide(apcomplex2)).divide(apfloat2);
    }

    public static Apcomplex sin(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = new Apcomplex(Apfloat.ZERO, apfloat);
        Apcomplex apcomplex3 = ApcomplexMath.exp(apcomplex2.multiply(apcomplex));
        return apfloat.divide(apcomplex3).subtract(apcomplex3).multiply(apcomplex2).divide(apfloat2);
    }

    public static Apcomplex sinh(Apcomplex apcomplex) throws ApfloatRuntimeException {
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = ApcomplexMath.exp(apcomplex);
        return apcomplex2.subtract(apfloat.divide(apcomplex2)).divide(apfloat2);
    }

    public static Apcomplex tan(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        boolean bl = apcomplex.imag().signum() > 0;
        apcomplex = bl ? apcomplex.negate() : apcomplex;
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = new Apcomplex(Apfloat.ZERO, apfloat);
        Apcomplex apcomplex3 = ApcomplexMath.exp(apfloat2.multiply(apcomplex2).multiply(apcomplex));
        apcomplex3 = apcomplex2.multiply(apfloat.subtract(apcomplex3)).divide(apfloat.add(apcomplex3));
        return bl ? apcomplex3.negate() : apcomplex3;
    }

    public static Apcomplex tanh(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        boolean bl = apcomplex.real().signum() < 0;
        apcomplex = bl ? apcomplex.negate() : apcomplex;
        Apfloat apfloat = new Apfloat(1L, Long.MAX_VALUE, apcomplex.radix());
        Apfloat apfloat2 = new Apfloat(2L, Long.MAX_VALUE, apcomplex.radix());
        Apcomplex apcomplex2 = ApcomplexMath.exp(apfloat2.multiply(apcomplex));
        apcomplex2 = apcomplex2.subtract(apfloat).divide(apcomplex2.add(apfloat));
        return bl ? apcomplex2.negate() : apcomplex2;
    }

    public static Apcomplex product(Apcomplex ... apcomplexArray) throws ApfloatRuntimeException {
        if (apcomplexArray.length == 0) {
            return Apcomplex.ONE;
        }
        long l = Long.MAX_VALUE;
        for (int i = 0; i < apcomplexArray.length; ++i) {
            if (apcomplexArray[i].real().signum() == 0 && apcomplexArray[i].imag().signum() == 0) {
                return Apcomplex.ZERO;
            }
            l = Math.min(l, apcomplexArray[i].precision());
        }
        Apcomplex[] apcomplexArray2 = new Apcomplex[apcomplexArray.length];
        long l2 = (long)Math.sqrt(apcomplexArray.length);
        long l3 = ApfloatHelper.extendPrecision(l, l2);
        for (int i = 0; i < apcomplexArray.length; ++i) {
            apcomplexArray2[i] = apcomplexArray[i].precision(l3);
        }
        apcomplexArray = apcomplexArray2;
        PriorityQueue<Apcomplex> priorityQueue = new PriorityQueue<Apcomplex>(apcomplexArray.length, new Comparator<Apcomplex>(){

            @Override
            public int compare(Apcomplex apcomplex, Apcomplex apcomplex2) {
                long l;
                long l2 = apcomplex.size();
                return l2 < (l = apcomplex2.size()) ? -1 : (l2 > l ? 1 : 0);
            }
        });
        priorityQueue.addAll(Arrays.asList(apcomplexArray));
        while (priorityQueue.size() > 1) {
            Apcomplex apcomplex = (Apcomplex)priorityQueue.remove();
            Apcomplex apcomplex2 = (Apcomplex)priorityQueue.remove();
            Apcomplex apcomplex3 = apcomplex.multiply(apcomplex2);
            priorityQueue.add(apcomplex3);
        }
        return ApfloatHelper.setPrecision((Apcomplex)priorityQueue.remove(), l);
    }

    public static Apcomplex sum(Apcomplex ... apcomplexArray) throws ApfloatRuntimeException {
        if (apcomplexArray.length == 0) {
            return Apcomplex.ZERO;
        }
        Apfloat[] apfloatArray = new Apfloat[apcomplexArray.length];
        Apfloat[] apfloatArray2 = new Apfloat[apcomplexArray.length];
        for (int i = 0; i < apcomplexArray.length; ++i) {
            apfloatArray[i] = apcomplexArray[i].real();
            apfloatArray2[i] = apcomplexArray[i].imag();
        }
        return new Apcomplex(ApfloatMath.sum(apfloatArray), ApfloatMath.sum(apfloatArray2));
    }

    private static Apcomplex lastIterationExtendPrecision(int n, int n2, Apcomplex apcomplex) {
        return n == 0 && n2 != 0 ? ApfloatHelper.extendPrecision(apcomplex) : apcomplex;
    }
}

