/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Formattable;
import java.util.Formatter;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.FormattingHelper;

public class Apcomplex
extends Number
implements Formattable,
Serializable {
    public static final Apint ZERO = new Apint(0L);
    public static final Apint ONE = new Apint(1L);
    public static final Apcomplex I = new Apcomplex(ZERO, ONE);
    public static final long INFINITE = Long.MAX_VALUE;
    public static final long DEFAULT = Long.MIN_VALUE;
    static final int EXTRA_PRECISION = 20;
    private static final long serialVersionUID = 3642932980384250551L;
    private Apfloat real;
    private Apfloat imag;

    protected Apcomplex() {
    }

    public Apcomplex(Apfloat apfloat) {
        this(apfloat, ZERO);
    }

    public Apcomplex(Apfloat apfloat, Apfloat apfloat2) throws IllegalArgumentException {
        if (apfloat.signum() != 0 && apfloat2.signum() != 0 && apfloat.radix() != apfloat2.radix()) {
            throw new IllegalArgumentException("Real part and imaginary part must have the same radix");
        }
        this.real = apfloat;
        this.imag = apfloat2;
    }

    public Apcomplex(String string) throws NumberFormatException, ApfloatRuntimeException {
        if (!string.startsWith("(")) {
            this.real = new Apfloat(string);
            this.imag = ZERO;
            return;
        }
        if (!string.endsWith(")")) {
            throw new NumberFormatException("Missing end parenthesis");
        }
        int n = string.indexOf(44);
        if (n < 0) {
            this.real = new Apfloat(string.substring(1, string.length() - 1).trim());
            this.imag = ZERO;
            return;
        }
        this.real = new Apfloat(string.substring(1, n).trim());
        this.imag = new Apfloat(string.substring(n + 1, string.length() - 1).trim());
    }

    public Apcomplex(PushbackReader pushbackReader) throws IOException, NumberFormatException, ApfloatRuntimeException {
        if (!ApfloatHelper.readMatch(pushbackReader, 40)) {
            this.real = new Apfloat(pushbackReader);
            this.imag = ZERO;
            return;
        }
        ApfloatHelper.extractWhitespace(pushbackReader);
        this.real = new Apfloat(pushbackReader);
        ApfloatHelper.extractWhitespace(pushbackReader);
        if (ApfloatHelper.readMatch(pushbackReader, 44)) {
            ApfloatHelper.extractWhitespace(pushbackReader);
            this.imag = new Apfloat(pushbackReader);
        } else {
            this.imag = ZERO;
        }
        ApfloatHelper.extractWhitespace(pushbackReader);
        if (!ApfloatHelper.readMatch(pushbackReader, 41)) {
            throw new NumberFormatException("Missing end parenthesis");
        }
    }

    public int radix() {
        return this.real().signum() == 0 ? (this.imag().signum() == 0 ? this.real().radix() : this.imag().radix()) : this.real().radix();
    }

    public Apfloat real() {
        return this.real;
    }

    public Apfloat imag() {
        return this.imag;
    }

    public Apcomplex conj() throws ApfloatRuntimeException {
        return new Apcomplex(this.real(), this.imag().negate());
    }

    public long precision() throws ApfloatRuntimeException {
        if (this.real().signum() == 0 || this.imag().signum() == 0) {
            return Math.min(this.real().precision(), this.imag().precision());
        }
        long[] lArray = ApfloatHelper.getMatchingPrecisions(this.real(), this.imag());
        return Math.max(lArray[0], lArray[1]);
    }

    public Apcomplex precision(long l) throws IllegalArgumentException, ApfloatRuntimeException {
        ApfloatHelper.checkPrecision(l);
        Apcomplex apcomplex = new Apcomplex(this.real().precision(l), this.imag().precision(l));
        if (this.real().signum() == 0 || this.imag().signum() == 0) {
            return apcomplex;
        }
        long[] lArray = ApfloatHelper.getMatchingPrecisions(apcomplex.real(), apcomplex.imag());
        long l2 = lArray[0];
        long l3 = lArray[1];
        return new Apcomplex(l2 > 0L ? apcomplex.real().precision(l2) : Apfloat.ZERO, l3 > 0L ? apcomplex.imag().precision(l3) : Apfloat.ZERO);
    }

    public long scale() throws ApfloatRuntimeException {
        return Math.max(this.real().scale(), this.imag().scale());
    }

    public long size() throws ApfloatRuntimeException {
        return Math.max(this.real().size(), this.imag().size());
    }

    public Apcomplex negate() throws ApfloatRuntimeException {
        return new Apcomplex(this.real().negate(), this.imag().negate());
    }

    public Apcomplex add(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return new Apcomplex(this.real().add(apcomplex.real()), this.imag().add(apcomplex.imag()));
    }

    public Apcomplex subtract(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return new Apcomplex(this.real().subtract(apcomplex.real()), this.imag().subtract(apcomplex.imag()));
    }

    public Apcomplex multiply(Apcomplex apcomplex) throws ApfloatRuntimeException {
        return new Apcomplex(ApfloatMath.multiplySubtract(this.real(), apcomplex.real(), this.imag(), apcomplex.imag()), ApfloatMath.multiplyAdd(this.real(), apcomplex.imag(), this.imag(), apcomplex.real()));
    }

    public Apcomplex divide(Apcomplex apcomplex) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat apfloat;
        Apfloat apfloat2;
        if (apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (apcomplex.real().signum() == 0) {
            apcomplex = new Apcomplex(apcomplex.imag(), apcomplex.real().negate());
            apfloat2 = this.imag();
            apfloat = this.real().negate();
        } else {
            apfloat2 = this.real();
            apfloat = this.imag();
        }
        if (apfloat.signum() == 0) {
            if (apfloat2.signum() == 0) {
                return this;
            }
            if (apcomplex.imag().signum() == 0) {
                return apfloat2.divide(apcomplex.real());
            }
        } else if (apcomplex.imag().signum() == 0) {
            if (apcomplex.real().equals(ONE)) {
                return new Apcomplex(apfloat2.precision(Math.min(apfloat2.precision(), apcomplex.real().precision())), apfloat.precision(Math.min(apfloat.precision(), apcomplex.real().precision())));
            }
            if (apcomplex.real().isShort()) {
                return new Apcomplex(apfloat2.divide(apcomplex.real()), apfloat.divide(apcomplex.real()));
            }
            long l = Math.min(this.precision(), apcomplex.real().precision());
            Apfloat apfloat3 = ApfloatMath.inverseRoot(apcomplex.real(), 1L, l);
            return new Apcomplex(apfloat2.multiply(apfloat3), apfloat.multiply(apfloat3));
        }
        long l = Math.min(this.precision(), apcomplex.precision());
        Apcomplex apcomplex2 = new Apcomplex(apcomplex.real().precision(Math.min(l, apcomplex.real().precision())), apcomplex.imag().precision(Math.min(l, apcomplex.imag().precision())));
        return this.multiply(apcomplex.conj()).divide(ApcomplexMath.norm(apcomplex2));
    }

    public double doubleValue() {
        return this.real().doubleValue();
    }

    public float floatValue() {
        return this.real().floatValue();
    }

    public byte byteValue() {
        return this.real().byteValue();
    }

    public short shortValue() {
        return this.real().shortValue();
    }

    public int intValue() {
        return this.real().intValue();
    }

    public long longValue() {
        return this.real().longValue();
    }

    public long equalDigits(Apcomplex apcomplex) throws ApfloatRuntimeException {
        if (this.real().signum() == 0 && this.imag().signum() == 0 && apcomplex.real().signum() == 0 && apcomplex.imag().signum() == 0) {
            return Long.MAX_VALUE;
        }
        long l = Math.min(this.scale(), apcomplex.scale());
        long l2 = Math.max(this.scale(), apcomplex.scale());
        if (l2 - 1L > l) {
            return 0L;
        }
        long l3 = Math.max(this.real().scale(), apcomplex.real().scale());
        long l4 = Math.max(this.imag().scale(), apcomplex.imag().scale());
        long l5 = l2 - l3 < 0L ? Long.MAX_VALUE : l2 - l3;
        long l6 = l2 - l4 < 0L ? Long.MAX_VALUE : l2 - l4;
        long l7 = this.real().equalDigits(apcomplex.real());
        long l8 = this.imag().equalDigits(apcomplex.imag());
        return Math.min(l7 + l5 < 0L ? Long.MAX_VALUE : l7 + l5, l8 + l6 < 0L ? Long.MAX_VALUE : l8 + l6);
    }

    public Apcomplex toRadix(int n) throws NumberFormatException, ApfloatRuntimeException {
        return new Apcomplex(this.real().toRadix(n), this.imag().toRadix(n));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Apcomplex) {
            Apcomplex apcomplex = (Apcomplex)object;
            return this.real().equals(apcomplex.real()) && this.imag().equals(apcomplex.imag());
        }
        return false;
    }

    public int hashCode() {
        return this.real().hashCode() * 3 + this.imag().hashCode();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) throws ApfloatRuntimeException {
        if (this.imag().signum() == 0) {
            return this.real().toString(bl);
        }
        return '(' + this.real().toString(bl) + ", " + this.imag().toString(bl) + ')';
    }

    public void writeTo(Writer writer) throws IOException, ApfloatRuntimeException {
        this.writeTo(writer, false);
    }

    public void writeTo(Writer writer, boolean bl) throws IOException, ApfloatRuntimeException {
        if (this.imag().signum() == 0) {
            this.real().writeTo(writer, bl);
        } else {
            writer.write(40);
            this.real().writeTo(writer, bl);
            writer.write(", ");
            this.imag().writeTo(writer, bl);
            writer.write(41);
        }
    }

    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        if (this.imag().signum() == 0) {
            this.real().formatTo(formatter, n, n2, n3);
        } else if (n2 == -1) {
            formatter.format("(", new Object[0]);
            this.real().formatTo(formatter, n, n2, n3);
            formatter.format(", ", new Object[0]);
            this.imag().formatTo(formatter, n, n2, n3);
            formatter.format(")", new Object[0]);
        } else {
            try {
                Writer writer = FormattingHelper.wrapAppendableWriter(formatter.out());
                writer = FormattingHelper.wrapPadWriter(writer, (n & 1) == 1);
                formatter = new Formatter(writer, formatter.locale());
                formatter.format("(", new Object[0]);
                this.real().formatTo(formatter, n, -1, n3);
                formatter.format(", ", new Object[0]);
                this.imag().formatTo(formatter, n, -1, n3);
                formatter.format(")", new Object[0]);
                FormattingHelper.finishPad(writer, n2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

