/*
 * Decompiled with CFR 0.152.
 */
package mvc.var;

import common.Globals;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import lattice.IBox;
import lattice.IShape;
import lattice.Ray;
import math.Util;
import math.VecMath;
import mvc.Controller;
import mvc.IModelListener;
import mvc.Model;
import mvc.ScanSession;
import mvc.scan.Observables;
import mvc.scan.ScanListener;
import mvc.scan.ScanVisualizer;
import mvc.var.GroupedScanKeyListener;
import mvc.var.RayKeyListener;

public class VariableVisualizer<T extends Number>
extends JPanel {
    public static final int DIST_DIGITS = 4;
    public static final String[] OBSERVABLES = new String[]{"Reflections", "Length", "Reflections/Length"};
    private final short YSIDE_PIXEL = (short)270;
    private final short XSIDE_PIXEL = (short)200;
    private final Controller<T> ctrl;
    private JTextField obsHeightField;
    private JTextField obsDistField;
    private JTextField obsRotField;
    private JTextField obsSizeField;
    private JTextField obsDisplayField;
    private JTextField scRotMinField;
    private JTextField scRotMaxField;
    private JTextField scHeightMinField;
    private JTextField scHeightMaxField;
    private JTextField scDisplayField;
    private final JTextField[] allFields;
    private JTabbedPane tabPane;
    private JTextField msgField;
    private IModelListener modelListener;
    private ScanListener scanListener;
    private byte selObs = (byte)-1;
    private TitledBorder obsMaxTitle;
    private boolean truncate;
    private boolean showErrorMsg;

    public VariableVisualizer(Controller<T> c) {
        this.ctrl = c;
        this.allFields = new JTextField[8];
        this.initGui();
        this.updateObservableFields(true);
        this.initListeners();
        this.msgField.setText("");
    }

    private void updateObservableFields(boolean force) {
        int rcnt;
        VecMath<Number> math = this.ctrl.getModel().getMath();
        int[] carPos = new int[4];
        boolean hasFocus = false;
        JTextField[] tfs = new JTextField[]{this.obsHeightField, this.obsDistField, this.obsRotField, this.obsSizeField};
        for (int i = 0; i < tfs.length; ++i) {
            if (tfs[i].hasFocus()) {
                JTextField tmp = tfs[i];
                tfs[i] = tfs[tfs.length - 1];
                tfs[tfs.length - 1] = tmp;
                hasFocus = true;
            }
            carPos[i] = tfs[i].getCaretPosition();
        }
        Number y1 = this.ctrl.getModel().getRay().getStart()[1];
        if (this.truncate) {
            y1 = math.util.round(y1, this.ctrl.getModel().getDecimalPlaces());
        }
        boolean update = true;
        if (!force) {
            String txt = this.obsHeightField.getText();
            if ((txt = txt.replace('&', ' ')).trim().compareTo("") == 0) {
                update = true;
            } else {
                boolean bl = update = math.cmp(y1, (Number)math.util.parse(txt.trim())) != 0;
            }
        }
        if (update) {
            String valTxt = math.util.toPlainString(y1);
            this.obsHeightField.setText(valTxt);
        }
        Number x = this.ctrl.getModel().getRay().getStart()[0];
        if (this.truncate) {
            x = math.util.round(x, 4);
        }
        if (!force) {
            String txt = this.obsDistField.getText();
            if ((txt = txt.replace('&', ' ')).trim().compareTo("") == 0) {
                update = true;
            } else {
                boolean bl = update = math.cmp(x, (Number)math.util.parse(txt.trim())) != 0;
            }
        }
        if (update) {
            String valTxt = math.util.toPlainString(x);
            this.obsDistField.setText(valTxt);
        }
        T phi = this.ctrl.getModel().getGridRotation();
        phi = math.div((Number)phi, (Number)math.PI);
        if (this.truncate) {
            phi = math.util.round(phi, this.ctrl.getModel().getDecimalPlaces());
        }
        if (!force) {
            String txt = this.obsRotField.getText();
            if ((txt = txt.replace('&', ' ')).trim().compareTo("") == 0) {
                update = true;
            } else {
                boolean bl = update = math.cmp((Number)phi, (Number)math.util.parse(txt.trim())) != 0;
            }
        }
        if (update) {
            String valTxt = math.util.toPlainString(phi);
            this.obsRotField.setText(valTxt);
        }
        T s = this.ctrl.getModel().getShape().getSize();
        if (this.truncate) {
            s = math.util.round(s, this.ctrl.getModel().getDecimalPlaces());
        }
        if (!force) {
            String txt = this.obsSizeField.getText();
            if ((txt = txt.replace('&', ' ')).trim().compareTo("") == 0) {
                update = true;
            } else {
                boolean bl = update = math.cmp((Number)s, (Number)math.util.parse(txt.trim())) != 0;
            }
        }
        if (update) {
            String valTxt = math.util.toPlainString(s);
            this.obsSizeField.setText(valTxt);
        }
        for (int i = 0; i < tfs.length; ++i) {
            int pos = Math.max(0, Math.min(carPos[i], tfs[i].getText().length() - 1));
            tfs[i].setCaretPosition(pos);
        }
        if (!hasFocus) {
            this.setMessage("");
        }
        String txt = (rcnt = this.ctrl.getModel().getReflectionCount()) >= 0 ? "" + rcnt : ">=" + -rcnt;
        float length = this.ctrl.getModel().getLength();
        length = (float)Math.round(length * 100.0f) / 100.0f;
        txt = length >= 0.0f ? txt + "  /  " + length : txt + "  /  >" + -length;
        try {
            int loops = this.ctrl.getModel().getLoops();
            txt = loops >= 0 ? txt + "  /  " + loops : txt + "  /  >=" + -loops;
        }
        catch (Exception e) {
            txt = txt + "  /  error";
        }
        this.obsDisplayField.setText(txt);
    }

    private void initGui() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = 1;
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Main", this.createObservablesTab());
        this.tabPane.addTab("Scanner", this.createScannerTab());
        this.tabPane.setEnabledAt(1, false);
        gridbag.setConstraints(this.tabPane, c);
        this.add(this.tabPane);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.gridwidth = 1;
        this.msgField = new JTextField(" ");
        this.msgField.setEditable(false);
        this.msgField.setFocusable(false);
        this.msgField.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.msgField.setMinimumSize(new Dimension(100, 35));
        Font f = this.msgField.getFont();
        this.msgField.setFont(new Font(f.getName(), f.getStyle(), f.getSize() - 2));
        gridbag.setConstraints(this.msgField, c);
        this.add(this.msgField);
        c.insets = new Insets(10, 5, 5, 0);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.1;
        JTextField leftBtn = new JTextField("<");
        leftBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                for (JTextField tf : VariableVisualizer.this.allFields) {
                    if (!tf.hasFocus()) continue;
                    tf.setCaretPosition(0);
                }
            }
        });
        leftBtn.setEditable(false);
        leftBtn.setFocusable(false);
        leftBtn.setFont(new Font("Monospaced", 1, 10));
        leftBtn.setBorder(new TitledBorder(""));
        leftBtn.setMinimumSize(new Dimension(20, 0));
        gridbag.setConstraints(leftBtn, c);
        this.add(leftBtn);
        c.gridx = 2;
        JTextField rightBtn = new JTextField(">");
        rightBtn.setFocusable(false);
        rightBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                for (JTextField tf : VariableVisualizer.this.allFields) {
                    if (!tf.hasFocus()) continue;
                    tf.setCaretPosition(tf.getText().length());
                }
            }
        });
        rightBtn.setEditable(false);
        rightBtn.setFont(new Font("Monospaced", 1, 10));
        rightBtn.setBorder(new TitledBorder(""));
        rightBtn.setMinimumSize(new Dimension(20, 0));
        gridbag.setConstraints(rightBtn, c);
        this.add(rightBtn);
    }

    private JPanel createObservablesTab() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.obsHeightField = new JTextField();
        this.obsHeightField.setHorizontalAlignment(4);
        this.obsHeightField.setCaretPosition(0);
        this.obsHeightField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                return VariableVisualizer.this.ctrl.getModel().getRay().getStart()[1];
            }
        });
        JPanel p = this.wrapConf(this.obsHeightField, "Height");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.obsDistField = new JTextField();
        this.obsDistField.setHorizontalAlignment(4);
        this.obsDistField.setCaretPosition(0);
        this.obsDistField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                return VariableVisualizer.this.ctrl.getModel().getRay().getStart()[0];
            }
        });
        p = this.wrapConf(this.obsDistField, "Distance");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.obsRotField = new JTextField();
        this.obsRotField.setHorizontalAlignment(4);
        this.obsRotField.setCaretPosition(0);
        this.obsRotField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                return VariableVisualizer.this.ctrl.getModel().getGridRotation();
            }
        });
        p = VariableVisualizer.createAnglePanel(this.obsRotField, "Angle");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.obsSizeField = new JTextField();
        this.obsSizeField.setHorizontalAlignment(4);
        this.obsSizeField.setCaretPosition(0);
        this.obsSizeField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                return VariableVisualizer.this.ctrl.getModel().getShape().getSize();
            }
        });
        p = this.wrapConf(this.obsSizeField, "Radius");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        String obsName = OBSERVABLES[0];
        obsName = obsName + " / " + OBSERVABLES[1];
        obsName = obsName + " / Loops";
        this.obsDisplayField = new JTextField();
        this.obsDisplayField.setHorizontalAlignment(4);
        this.obsDisplayField.setEditable(false);
        this.obsDisplayField.setFocusable(false);
        this.obsDisplayField.setBorder(new TitledBorder(obsName));
        this.obsDisplayField.setForeground(Color.gray.darker());
        gridbag.setConstraints(this.obsDisplayField, c);
        panel.add(this.obsDisplayField);
        this.allFields[0] = this.obsHeightField;
        this.allFields[1] = this.obsDistField;
        this.allFields[2] = this.obsRotField;
        this.allFields[3] = this.obsSizeField;
        panel.setVisible(true);
        return panel;
    }

    private JPanel createScannerTab() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.scRotMinField = new JTextField();
        this.scRotMinField.setHorizontalAlignment(4);
        this.scRotMinField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                IBox frame = VariableVisualizer.this.ctrl.getModel().getScanSession().getInitBox();
                return frame.getCorner()[0];
            }
        });
        JPanel p = VariableVisualizer.createAnglePanel(this.scRotMinField, "Min Angle");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.scRotMaxField = new JTextField();
        this.scRotMaxField.setHorizontalAlignment(4);
        this.scRotMaxField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                IBox frame = VariableVisualizer.this.ctrl.getModel().getScanSession().getInitBox();
                VecMath<Number> math = VariableVisualizer.this.ctrl.getModel().getMath();
                return math.add(frame.getCorner()[0], frame.getLengths()[0]);
            }
        });
        p = VariableVisualizer.createAnglePanel(this.scRotMaxField, "Max Angle");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.scHeightMinField = new JTextField();
        this.scHeightMinField.setHorizontalAlignment(4);
        this.scHeightMinField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                IBox frame = VariableVisualizer.this.ctrl.getModel().getScanSession().getInitBox();
                return frame.getCorner()[1];
            }
        });
        p = this.wrapConf(this.scHeightMinField, "Min Height");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.scHeightMaxField = new JTextField();
        this.scHeightMaxField.setHorizontalAlignment(4);
        this.scHeightMaxField.addCaretListener(new PrintCaretPosListener(){

            @Override
            T getModelValue() {
                IBox frame = VariableVisualizer.this.ctrl.getModel().getScanSession().getInitBox();
                VecMath<Number> math = VariableVisualizer.this.ctrl.getModel().getMath();
                return math.add(frame.getCorner()[1], frame.getLengths()[1]);
            }
        });
        p = this.wrapConf(this.scHeightMaxField, "Max Height");
        gridbag.setConstraints(p, c);
        panel.add(p);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.scDisplayField = new JTextField();
        this.scDisplayField.setHorizontalAlignment(4);
        this.scDisplayField.setEditable(false);
        this.obsMaxTitle = new TitledBorder("Observable Max");
        this.scDisplayField.setBorder(this.obsMaxTitle);
        gridbag.setConstraints(this.scDisplayField, c);
        panel.add(this.scDisplayField);
        this.allFields[4] = this.scHeightMinField;
        this.allFields[5] = this.scHeightMaxField;
        this.allFields[6] = this.scRotMinField;
        this.allFields[7] = this.scRotMaxField;
        panel.setVisible(true);
        return panel;
    }

    private static JPanel createAnglePanel(JTextField tf, String title) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(gbl);
        p.setBorder(new TitledBorder(title));
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        p.setBackground(tf.getBackground());
        tf.setBackground(Globals.INPUT_BG);
        gbl.setConstraints(tf, gbc);
        p.add(tf);
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        JTextField piLabel = new JTextField(" * \u03c0");
        piLabel.setEditable(false);
        piLabel.setBackground(Globals.INPUT_BG);
        piLabel.setMinimumSize(piLabel.getPreferredSize());
        gbl.setConstraints(piLabel, gbc);
        p.add(piLabel);
        return p;
    }

    private JPanel wrapConf(JTextField tf, String borderText) {
        tf.setBackground(Globals.INPUT_BG);
        JPanel l = new JPanel(new GridLayout());
        l.add(tf);
        TitledBorder tb = BorderFactory.createTitledBorder(borderText);
        l.setBorder(tb);
        return l;
    }

    public void updateScannerFrameFields(IBox<T> frame) {
        ScanVisualizer<T> scanVis;
        VecMath<Number> math = this.ctrl.getModel().getMath();
        int rndPos = Integer.MIN_VALUE;
        if (this.truncate) {
            Number[] lengths = (Number[])frame.getLengths().clone();
            lengths[0] = math.div(lengths[0], (Number)math.util.cast(1000));
            lengths[1] = math.div(lengths[1], (Number)math.util.cast(1000));
            int s1 = math.util.getScale(lengths[0]);
            int s2 = math.util.getScale(lengths[1]);
            rndPos = Math.max(-s1, -s2);
        }
        Number phi1 = frame.getCorner()[0];
        phi1 = math.div(phi1, (Number)math.PI);
        if (this.truncate) {
            phi1 = math.util.round(phi1, rndPos);
        }
        String s = math.util.toPlainString(phi1);
        this.scRotMinField.setText(s);
        this.scRotMinField.setCaretPosition(0);
        Number phi2 = math.add(frame.getCorner()[0], frame.getLengths()[0]);
        phi2 = math.div(phi2, (Number)math.PI);
        if (this.truncate) {
            phi2 = math.util.round(phi2, rndPos);
        }
        s = math.util.toPlainString(phi2);
        this.scRotMaxField.setText(s);
        this.scRotMaxField.setCaretPosition(0);
        Number h1 = frame.getCorner()[1];
        if (this.truncate) {
            h1 = math.util.round(h1, rndPos);
        }
        s = math.util.toPlainString(h1);
        this.scHeightMinField.setText(s);
        this.scHeightMinField.setCaretPosition(0);
        Number h2 = math.add(frame.getCorner()[1], frame.getLengths()[1]);
        if (this.truncate) {
            h2 = math.util.round(h2, rndPos);
        }
        s = math.util.toPlainString(h2);
        this.scHeightMaxField.setText(s);
        this.scHeightMaxField.setCaretPosition(0);
        if (this.selObs == -1 && (scanVis = this.ctrl.getView().getScanVisualizer()) != null) {
            this.setObservable(scanVis.getObservable(), 0);
        }
        this.setScannerTabEnabled(true);
    }

    public void updateScannerObsFields(Observables obs) {
        String txt = obs.getMax(this.selObs) + "  /  " + obs.aproxPixels;
        this.scDisplayField.setText(txt);
    }

    private void initListeners() {
        this.modelListener = new IModelListener(){

            @Override
            public void modelChanged(byte event) {
                switch (event) {
                    case 10: {
                        if (VariableVisualizer.this.obsDisplayField.getText().compareTo("") != 0) {
                            VariableVisualizer.this.obsDisplayField.setText("");
                        }
                        Cursor wcur = Cursor.getPredefinedCursor(3);
                        if (VariableVisualizer.this.getCursor() == wcur) break;
                        VariableVisualizer.this.setCursor(wcur);
                        for (int i = 0; i < 4; ++i) {
                            VariableVisualizer.this.allFields[i].setCursor(wcur);
                        }
                        break;
                    }
                    case 30: {
                        VariableVisualizer.this.setCursor(Cursor.getPredefinedCursor(0));
                        Cursor tcur = Cursor.getPredefinedCursor(2);
                        for (int i = 0; i < 4; ++i) {
                            VariableVisualizer.this.allFields[i].setCursor(tcur);
                        }
                        VariableVisualizer.this.updateObservableFields(false);
                    }
                }
            }
        };
        this.ctrl.getModel().addModelListener(this.modelListener);
        this.scanListener = new ScanListener(){
            boolean init = false;

            @Override
            public void start() {
                this.init();
            }

            @Override
            public void stop(String msg) {
            }

            @Override
            public void update(int x, int y) {
                if (!this.init) {
                    this.init();
                }
                ScanSession scs = VariableVisualizer.this.ctrl.getModel().getScanSession();
                VariableVisualizer.this.updateScannerObsFields(scs.obs);
            }

            private void init() {
                ScanSession scs = VariableVisualizer.this.ctrl.getModel().getScanSession();
                VariableVisualizer.this.updateScannerFrameFields(scs.getInitBox());
                this.init = true;
            }
        };
        this.ctrl.getModel().addScanListener(this.scanListener);
        this.obsHeightField.addKeyListener(new RayKeyListener<T>(this.ctrl, this.obsHeightField, false){

            @Override
            void handleValue(T val) {
                Ray ray = this.ctrl.getModel().getRay();
                ray.getStart()[1] = val;
                this.ctrl.getModel().setRay(ray, (byte)1);
            }
        });
        this.obsDistField.addKeyListener(new RayKeyListener<T>(this.ctrl, this.obsDistField, true){

            @Override
            void handleValue(T val) {
                Ray ray = this.ctrl.getModel().getRay();
                ray.getStart()[0] = val;
                this.ctrl.getModel().setRay(ray, (byte)1);
            }
        });
        this.obsRotField.addKeyListener(new RayKeyListener<T>(this.ctrl, this.obsRotField, true){

            @Override
            void handleValue(T val) {
                Model model = this.ctrl.getModel();
                Object phi = model.getMath().mul(val, model.getMath().PI);
                model.setGridRotation(phi);
            }
        });
        this.obsSizeField.addKeyListener(new RayKeyListener<T>(this.ctrl, this.obsSizeField, true){

            @Override
            void handleValue(T r) {
                Model model = this.ctrl.getModel();
                int MAX_R = model.transformShapeSize(100);
                VecMath<int> mt = model.getMath();
                IShape s = model.getShape();
                if (mt.cmp((int)r, MAX_R) < 0) {
                    s.setSize(r);
                } else {
                    s.setSize(MAX_R);
                }
                model.setShape(s);
            }
        });
        GroupedScanKeyListener<T> gskl = new GroupedScanKeyListener<T>(this.ctrl, this.scRotMinField, this.scRotMaxField, this.scHeightMinField, this.scHeightMaxField);
        this.scRotMinField.addKeyListener(gskl);
        this.scRotMaxField.addKeyListener(gskl);
        this.scHeightMinField.addKeyListener(gskl);
        this.scHeightMaxField.addKeyListener(gskl);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 270);
    }

    public void setScannerTabEnabled(boolean b) {
        this.tabPane.setEnabledAt(1, b);
        if (!b) {
            this.tabPane.setSelectedIndex(0);
        }
    }

    public void onDelete() {
        this.ctrl.getModel().removeScanListener(this.scanListener);
        this.ctrl.getModel().removeModelListener(this.modelListener);
    }

    public void setObservable(byte idx, Number max) {
        this.scDisplayField.setText(max.toString());
        this.selObs = idx;
        String obsName = OBSERVABLES[this.selObs];
        this.obsMaxTitle.setTitle("Max. " + obsName + " / Prec. Errors");
    }

    public synchronized void enableTruncation(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScanSession scs;
                VariableVisualizer.this.truncate = b;
                VariableVisualizer.this.updateObservableFields(true);
                if (VariableVisualizer.this.tabPane.isEnabledAt(1) && (scs = VariableVisualizer.this.ctrl.getModel().getScanSession()) != null) {
                    VariableVisualizer.this.updateScannerFrameFields(scs.getInitBox());
                }
            }
        });
    }

    void setMessage(String msg) {
        this.msgField.setText(msg);
    }

    public void enableErrorMsg(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScanSession scs;
                VariableVisualizer.this.showErrorMsg = b;
                VariableVisualizer.this.updateObservableFields(true);
                if (VariableVisualizer.this.tabPane.isEnabledAt(1) && (scs = VariableVisualizer.this.ctrl.getModel().getScanSession()) != null) {
                    VariableVisualizer.this.updateScannerFrameFields(scs.getInitBox());
                }
            }
        });
    }

    abstract class PrintCaretPosListener
    implements CaretListener {
        PrintCaretPosListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            JTextField src = (JTextField)e.getSource();
            String txt = src.getText().trim();
            int pos = txt.indexOf(".");
            int digits = txt.length() - (pos != -1 ? 1 : 0);
            if (e.getDot() > -1) {
                int dpos1 = e.getDot();
                int dpos2 = pos != -1 && pos <= dpos1 ? dpos1 : dpos1 + 1;
                String msg = "Digit: " + Math.min(dpos2, digits) + "/" + digits;
                if (VariableVisualizer.this.showErrorMsg) {
                    Util util = ((VariableVisualizer)VariableVisualizer.this).ctrl.getModel().getMath().util;
                    int errScale = util.getErrorScale(this.getModelValue());
                    msg = errScale == -2147483647 ? msg + ", Error=0" : msg + ", Error<10e" + (errScale + 1);
                }
                VariableVisualizer.this.msgField.setText(msg);
            }
        }

        abstract T getModelValue();
    }
}

