/*
 * Decompiled with CFR 0.152.
 */
package mvc.var;

import common.FileIO;
import common.SelectTextItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import mvc.var.VariableVisualizer;

public class VariableMenuBar<T extends Number>
extends JMenuBar {
    private final VariableVisualizer<T> vis;
    private JCheckBoxMenuItem helpItem;

    public VariableMenuBar(VariableVisualizer<T> vis) {
        this.vis = vis;
        this.init();
    }

    private void init() {
        JMenu optMenu = new JMenu("Options");
        JRadioButtonMenuItem oItem = new JRadioButtonMenuItem("Truncate");
        oItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VariableMenuBar.this.vis.enableTruncation(true);
                } else {
                    VariableMenuBar.this.vis.enableTruncation(false);
                }
            }
        });
        oItem.setSelected(true);
        oItem.setSelected(true);
        optMenu.add(oItem);
        JRadioButtonMenuItem errorItem = new JRadioButtonMenuItem("Show Error");
        errorItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VariableMenuBar.this.vis.enableErrorMsg(true);
                } else {
                    VariableMenuBar.this.vis.enableErrorMsg(false);
                }
            }
        });
        optMenu.add(errorItem);
        JMenu infoMenu = new JMenu("?");
        this.helpItem = new JCheckBoxMenuItem("help...");
        String txt = new FileIO(null).loadInfoText("Variables");
        String title = "Variables Info";
        this.helpItem.addItemListener(new SelectTextItemListener(this.helpItem, title, txt, 550, 500));
        infoMenu.add(this.helpItem);
        this.add(optMenu);
        this.add(infoMenu);
    }

    public void onDelete() {
        this.helpItem.setSelected(false);
    }
}

