/*
 * Decompiled with CFR 0.152.
 */
package mvc.var;

import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import mvc.Controller;
import mvc.var.BaseKeyListener;

public abstract class RayKeyListener<T extends Number>
extends BaseKeyListener<T> {
    private final JTextField textField;

    public RayKeyListener(Controller<T> c, JTextField tf, boolean exp) {
        super(c, exp);
        this.textField = tf;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.ctrl.stopCalculation();
            try {
                this.ctrl.waitForCalculatorRelease();
                boolean expand = RayKeyListener.removeNonNumberChars(this.textField);
                Object val = this.getValue(this.textField.getText().trim(), expand);
                this.handleValue(val);
                this.ctrl.startCalculation();
            }
            catch (NumberFormatException ex) {
                String msg = "Can't read number. " + ex.getMessage();
                JOptionPane.showMessageDialog(this.textField, msg);
            }
        }
    }

    abstract void handleValue(T var1);
}

