/*
 * Decompiled with CFR 0.152.
 */
package mvc.var;

import common.Log;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import math.VecMath;
import mvc.Controller;
import mvc.scan.ScanVisualizer;
import mvc.var.BaseKeyListener;

class GroupedScanKeyListener<T extends Number>
extends BaseKeyListener<T> {
    private final JTextField[] textFields;

    GroupedScanKeyListener(Controller<T> c, JTextField phiMin, JTextField phiMax, JTextField hMin, JTextField hMax) {
        super(c, true);
        this.textFields = new JTextField[]{phiMin, phiMax, hMin, hMax};
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            ScanVisualizer scanVis = this.ctrl.getView().getScanVisualizer();
            scanVis.stopScan("Stopped on zoom frame change");
            VecMath<Number> mt = this.ctrl.getModel().getMath();
            Number[] values = mt.util.array(this.textFields.length);
            try {
                for (int i = 0; i < this.textFields.length; ++i) {
                    GroupedScanKeyListener.removeNonNumberChars(this.textFields[i]);
                    values[i] = this.getValue(this.textFields[i].getText());
                }
                Number[] p1 = mt.util.array(2);
                p1[0] = mt.mul(values[0], (Number)mt.PI);
                p1[1] = values[2];
                Number[] p2 = mt.util.array(2);
                p2[0] = mt.mul(values[1], (Number)mt.PI);
                p2[1] = values[3];
                String msg = "Frame area is zero";
                if (mt.cmp(p1[0], p2[0]) != 0 && mt.cmp(p1[1], p2[1]) != 0) {
                    scanVis.prepareScan(p1, p2);
                    scanVis.startScan();
                    msg = "Scan started";
                }
                this.ctrl.getView().getVariableVisualizer().setMessage(msg);
            }
            catch (NumberFormatException ex) {
                Log.getIstc().log(ex);
            }
        }
    }
}

