/*
 * Decompiled with CFR 0.152.
 */
package mvc.var;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import math.VecMath;
import mvc.Controller;

public abstract class BaseKeyListener<T extends Number>
extends KeyAdapter {
    static final char LIMIT_CHAR = '&';
    protected final Controller<T> ctrl;
    private final boolean autoExpand;

    public BaseKeyListener(Controller<T> c, boolean exp) {
        this.ctrl = c;
        this.autoExpand = exp;
    }

    @Override
    public abstract void keyReleased(KeyEvent var1);

    protected static boolean removeNonNumberChars(JTextField tf) {
        String valTxt1 = tf.getText();
        StringBuffer valTxt2 = new StringBuffer(valTxt1.trim());
        boolean expand = true;
        for (int i = 0; i < valTxt2.length(); ++i) {
            char c = valTxt2.charAt(i);
            if (c == '&') {
                expand = false;
            }
            if (c == '.' || c == '-' || Character.isDigit(c)) continue;
            valTxt2.deleteCharAt(i--);
        }
        if (valTxt1.length() != valTxt2.length()) {
            tf.setText(valTxt2.toString());
        }
        return expand;
    }

    protected T getValue(String text) {
        return this.getValue(text, this.autoExpand);
    }

    protected T getValue(String text, boolean exp) {
        StringBuffer valTxt = new StringBuffer(text);
        if (valTxt.indexOf(".") == -1) {
            valTxt.append(".0");
        }
        VecMath<T> mt = this.ctrl.getModel().getMath();
        if (this.autoExpand || exp) {
            Object retVal = mt.util.parse(valTxt.toString());
            for (int pr = mt.util.precision(retVal); pr <= mt.PRECISION; ++pr) {
                valTxt.append("0");
            }
        }
        Object val = mt.util.parse(valTxt.toString());
        if (this.autoExpand || exp) {
            val = mt.util.copy(val, mt.PRECISION);
        }
        return val;
    }
}

