/*
 * Decompiled with CFR 0.152.
 */
package mvc.scan;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;
import lattice.Box2D;
import math.VecMath;
import mvc.Controller;
import mvc.IModelListener;
import mvc.Model;
import mvc.PixelMap;
import mvc.scan.Observables;
import mvc.scan.ScanListener;
import mvc.var.VariableVisualizer;

public class ScanVisualizer<T extends Number>
extends JComponent {
    private final short YSIDE_PIXEL = (short)300;
    private final short XSIDE_PIXEL = (short)300;
    private final byte BORDER = (byte)10;
    private final Controller<T> ctrl;
    private final Box2D<T> iniPhiYBox;
    private final Box2D<T> curPhiYBox;
    private final HashMap<Short, Color> colors;
    private PixelMap<T> trafo;
    private Box2D<T> dragBox;
    private Observables obs;
    private Observables unscaledObs;
    private byte observable;
    private ScanListener scanListener;
    private IModelListener modelListener;
    private BufferedImage bimg;
    private String message;

    public ScanVisualizer(Controller<T> c) {
        this.ctrl = c;
        this.observable = 0;
        Model<T> model = this.ctrl.getModel();
        VecMath math = model.getMath();
        Number[] corner = math.util.array(2);
        corner[0] = math.neg(math.PI_OVER_FOUR);
        corner[1] = model.getWorldBox().getCorner()[1];
        Number[] lengths = math.util.array(2);
        lengths[0] = math.PI_OVER_TWO;
        lengths[1] = model.getWorldBox().getLengths()[1];
        this.iniPhiYBox = new Box2D(corner, lengths, math);
        this.curPhiYBox = this.iniPhiYBox;
        this.colors = new HashMap();
        this.setBorder(new MatteBorder(10, 10, 10, 10, Color.black));
        this.setOpaque(true);
        this.initListeners();
    }

    private void initListeners() {
        ZoomMouseListener zl = new ZoomMouseListener();
        this.addMouseMotionListener(zl);
        this.addMouseListener(zl);
        this.modelListener = new IModelListener(){

            @Override
            public void modelChanged(byte event) {
                switch (event) {
                    case 60: {
                        break;
                    }
                    case 40: 
                    case 50: {
                        ScanVisualizer.this.trafo = null;
                        break;
                    }
                    case 5: {
                        ScanVisualizer.this.stopScan("Stopped on grid change");
                        break;
                    }
                    case 8: {
                        ScanVisualizer.this.stopScan("Stopped on circle change");
                    }
                }
            }
        };
        this.ctrl.getModel().addModelListener(this.modelListener);
        this.scanListener = new ScanListener(){
            short width;
            short height;

            @Override
            public void start() {
                ScanVisualizer.this.message = null;
                this.height = ScanVisualizer.this.getPixelMap().canvasHeight();
                this.width = ScanVisualizer.this.getPixelMap().canvasWidth();
                ScanVisualizer.this.repaint();
            }

            @Override
            public void stop(String msg) {
                if (msg != null) {
                    ScanVisualizer.this.message = msg;
                    ScanVisualizer.this.repaint();
                }
            }

            @Override
            public void update(int x, int y) {
                if (x <= this.width - 1) {
                    if (ScanVisualizer.this.obs.isMaxChanged(ScanVisualizer.this.observable)) {
                        ScanVisualizer.this.obs.setMaxChanged(ScanVisualizer.this.observable, false);
                        ScanVisualizer.this.paintObservableImage(0, 0, x + 1, ScanVisualizer.this.bimg.getHeight());
                        ScanVisualizer.this.repaint(10, 10, x + 1, this.height);
                    } else {
                        ScanVisualizer.this.paintObservableImage(x, y, x + 1, y + 1);
                        ScanVisualizer.this.repaint(10 + x, 10 + y, 1, 1);
                    }
                }
            }
        };
        this.ctrl.getModel().addScanListener(this.scanListener);
        this.addMouseListener(new SelectMouseListener());
    }

    @Override
    public void paintComponent(Graphics g) {
        String msg;
        Graphics2D g2d = (Graphics2D)g;
        PixelMap<T> pixMap = this.getPixelMap();
        pixMap.setSreenSize((short)this.getWidth(), (short)this.getHeight());
        short h = pixMap.canvasHeight();
        short w = pixMap.canvasWidth();
        if (this.obs == null) {
            this.unscaledObs = this.obs = new Observables(w, h, this.obs);
            this.newObservableImage();
        }
        if (this.obs.reflCnt.length != w || this.obs.reflCnt[0].length != h) {
            this.stopScan("Stopped on resize");
            this.obs = new Observables(w, h, this.obs);
            this.obs.scaledCopy(this.unscaledObs);
            this.newObservableImage();
        }
        g2d.drawImage((Image)this.bimg, 10, 10, this);
        if (this.dragBox != null) {
            g2d.setColor(Color.black);
            Rectangle r = pixMap.box2Pix(this.dragBox);
            g2d.drawRect(r.x, r.y, r.width, r.height);
        }
        if ((msg = this.message) != null) {
            g2d.setColor(Color.BLACK);
            FontRenderContext rctx = g2d.getFontRenderContext();
            Rectangle2D bnd = g2d.getFont().getStringBounds(msg, rctx);
            int textWidth = this.getWidth() - (int)bnd.getWidth() - 10 - 2;
            int textHeight = this.getHeight() - 10 - 2;
            g2d.drawString(msg, textWidth, textHeight);
        }
    }

    private void paintObservableImage(int xMin, int yMin, int xMax, int yMax) {
        int w = this.bimg.getWidth();
        int h = this.bimg.getHeight();
        if (xMin < w && xMax <= w && yMin < h && yMax <= h) {
            for (int x = xMin; x < xMax; ++x) {
                for (int y = yMin; y < yMax; ++y) {
                    Color color = null;
                    switch (this.observable) {
                        case 0: {
                            color = this.getColor(this.obs.reflCnt[x][y], this.obs.maxReflCnt);
                            break;
                        }
                        case 1: {
                            color = this.getColor(this.obs.length[x][y], this.obs.maxLength);
                            break;
                        }
                        case 2: {
                            color = this.getColor(this.obs.obs1[x][y], this.obs.maxObs1);
                        }
                    }
                    this.bimg.setRGB(x, y, color.getRGB());
                }
            }
        }
    }

    private void newObservableImage() {
        PixelMap<T> pixMap = this.getPixelMap();
        short h = pixMap.canvasHeight();
        short w = pixMap.canvasWidth();
        this.bimg = new BufferedImage(w, h, 1);
        this.paintObservableImage(0, 0, this.bimg.getWidth(), this.bimg.getHeight());
    }

    public void prepareScan(T[] p1, T[] p2) {
        this.setBoxCorners((Number[])p1, (Number[])p2, this.curPhiYBox);
        this.getPixelMap().worldChanged(this.curPhiYBox);
    }

    private void setBoxCorners(T[] start, T[] end, Box2D<T> box) {
        Model<T> model = this.ctrl.getModel();
        Number[] corner = model.getMath().util.array(2);
        VecMath<T> math = model.getMath();
        corner[0] = math.cmp(start[0], end[0]) < 0 ? start[0] : end[0];
        corner[1] = math.cmp(start[1], end[1]) < 0 ? start[1] : end[1];
        Number[] lengths = model.getMath().util.array(2);
        lengths[0] = math.abs(math.sub(start[0], end[0]));
        lengths[1] = math.abs(math.sub(start[1], end[1]));
        box.setCorner(corner);
        box.setLengths(lengths);
    }

    public void startScan() {
        short h = this.getPixelMap().canvasHeight();
        short w = this.getPixelMap().canvasWidth();
        this.startScan(w, h);
    }

    private void startScan(int width, int height) {
        this.unscaledObs = this.obs = new Observables(width, height, this.obs);
        this.newObservableImage();
        this.ctrl.startScan(this.obs, this.getPixelMap());
    }

    public void stopScan(String msg) {
        this.ctrl.stopScan(msg);
    }

    private Color getColor(float val, float maxVal) {
        if (val > maxVal) {
            return Color.red;
        }
        short relVal = (short)(val / maxVal * 1000.0f);
        Color c = this.colors.get(relVal);
        if (c == null) {
            float x = (float)(1.0 - Math.sqrt((float)relVal / 1000.0f));
            Color sc = Color.white;
            c = new Color((int)((float)sc.getRed() * x), (int)((float)sc.getGreen() * x), (int)((float)sc.getBlue() * x));
            this.colors.put(relVal, c);
        }
        return c;
    }

    public PixelMap<T> getPixelMap() {
        if (this.trafo == null) {
            Model<T> model = this.ctrl.getModel();
            VecMath<T> mt = model.getMath();
            this.trafo = new PixelMap<T>(this.getWidth(), this.getHeight(), 10, 10, this.curPhiYBox, mt);
        }
        return this.trafo;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(310, 310);
    }

    public void setObservable(byte o) {
        this.observable = o;
        VariableVisualizer<T> varVis = this.ctrl.getView().getVariableVisualizer();
        if (varVis != null) {
            varVis.setObservable(o, this.obs != null ? (Number)this.obs.getMax(o) : (Number)0);
        }
        if (this.obs != null) {
            this.obs.setMaxChanged(this.observable, false);
            if (this.bimg != null) {
                this.paintObservableImage(0, 0, this.bimg.getWidth(), this.bimg.getHeight());
                this.repaint();
            }
        }
    }

    public byte getObservable() {
        return this.observable;
    }

    public Observables getObservables() {
        return this.obs;
    }

    public void onDelete() {
        this.ctrl.getModel().removeScanListener(this.scanListener);
        this.ctrl.getModel().removeModelListener(this.modelListener);
    }

    public void addScanListener(ScanListener l) {
        this.ctrl.getModel().addScanListener(l);
    }

    public void removeScanListener(ScanListener l) {
        this.ctrl.getModel().removeScanListener(l);
    }

    public class ZoomMouseListener
    extends MouseAdapter {
        Point start;

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.start == null) {
                this.start = e.getPoint();
            } else {
                VecMath math = ScanVisualizer.this.ctrl.getModel().getMath();
                Point end = e.getPoint();
                Rectangle r = ScanVisualizer.this.dragBox != null ? ScanVisualizer.this.getPixelMap().box2Pix(ScanVisualizer.this.dragBox) : null;
                ScanVisualizer.this.dragBox = null;
                if (Math.abs(this.start.x - end.x) > 10 && Math.abs(this.start.y - end.y) > 10) {
                    ScanVisualizer.this.dragBox = new Box2D(math.util.array(2), math.ONE, math);
                    ScanVisualizer.this.setBoxCorners(this.toWorld(this.start), this.toWorld(end), ScanVisualizer.this.dragBox);
                    Rectangle r2 = ScanVisualizer.this.getPixelMap().box2Pix(ScanVisualizer.this.dragBox);
                    Rectangle rectangle = r = r != null ? r.union(r2) : r2;
                }
                if (r != null) {
                    ScanVisualizer.this.repaint(r.x, r.y, r.width + 1, r.height + 1);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.start != null && ScanVisualizer.this.dragBox != null) {
                ScanVisualizer.this.stopScan("Stopped on zoom");
                ScanVisualizer.this.prepareScan(this.toWorld(this.start), this.toWorld(e.getPoint()));
                PixelMap pixMap = ScanVisualizer.this.getPixelMap();
                ScanVisualizer.this.startScan(pixMap.canvasWidth(), pixMap.canvasHeight());
            }
            ScanVisualizer.this.dragBox = null;
            this.start = null;
        }

        private T[] toWorld(Point p) {
            Model model = ScanVisualizer.this.ctrl.getModel();
            Number[] q = model.getMath().util.array(2);
            PixelMap pm = ScanVisualizer.this.getPixelMap();
            q[0] = pm.xPix2World(pm.toCanvasX((short)p.x));
            q[1] = pm.yPix2World(pm.toCanvasY((short)p.y));
            return q;
        }
    }

    public class SelectMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            Model model = ScanVisualizer.this.ctrl.getModel();
            ScanVisualizer.this.ctrl.stopCalculation();
            ScanVisualizer.this.setCursor(Cursor.getPredefinedCursor(3));
            PixelMap pixMap = ScanVisualizer.this.getPixelMap();
            Object phi = pixMap.xPix2World(pixMap.toCanvasX((short)e.getX()));
            VecMath mt = model.getMath();
            Number[] sincosphi = mt.sincos((Number)phi);
            Number[] startVec = model.getRay().getStart();
            Box2D world = model.getWorldBox();
            startVec[0] = mt.add(world.getCorner()[0], world.getLengths()[0]);
            startVec[1] = pixMap.yPix2World(pixMap.toCanvasY((short)e.getY()));
            ScanVisualizer.this.ctrl.waitForCalculatorRelease();
            model.setGridRotation((Number)phi, sincosphi);
            ScanVisualizer.this.ctrl.startCalculation();
            ScanVisualizer.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

