/*
 * Decompiled with CFR 0.152.
 */
package mvc.scan;

import common.FileIO;
import common.SelectTextItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import mvc.scan.ScanListener;
import mvc.scan.ScanVisualizer;

public class ScanMenuBar<T extends Number>
extends JMenuBar {
    private JMenu obsMenu;
    private JMenu runMenu;
    private final ScanVisualizer<T> vis;
    private JRadioButtonMenuItem runItem;
    private ScanListener scanListener;
    private boolean allowEvent = true;
    private JCheckBoxMenuItem infoItem;

    public ScanMenuBar(ScanVisualizer<T> vis) {
        this.vis = vis;
        this.init();
    }

    private void init() {
        JMenu infoMenu = new JMenu("?");
        this.infoItem = new JCheckBoxMenuItem("help...");
        String text = new FileIO(null).loadInfoText("Scanner");
        String title = "Scanner Info";
        this.infoItem.addItemListener(new SelectTextItemListener(this.infoItem, title, text, 550, 450));
        this.obsMenu = new JMenu("Observables");
        this.runItem = new JRadioButtonMenuItem("Run");
        this.runMenu = new JMenu("Run");
        this.runItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ScanMenuBar.this.allowEvent) {
                    if (e.getStateChange() == 1) {
                        ScanMenuBar.this.vis.startScan();
                    } else {
                        ScanMenuBar.this.vis.stopScan("Stopped");
                    }
                }
            }
        });
        this.scanListener = new ScanListener(){

            @Override
            public void start() {
            }

            @Override
            public void stop(String msg) {
                if (ScanMenuBar.this.runItem.isSelected()) {
                    ScanMenuBar.this.allowEvent = false;
                    ScanMenuBar.this.runItem.setSelected(false);
                    ScanMenuBar.this.allowEvent = true;
                }
            }

            @Override
            public void update(int i, int j) {
            }
        };
        this.vis.addScanListener(this.scanListener);
        JRadioButtonMenuItem item11 = new JRadioButtonMenuItem("Reflections");
        item11.addItemListener(new ObsListener(0));
        item11.setSelected(true);
        JRadioButtonMenuItem item12 = new JRadioButtonMenuItem("Length");
        item12.addItemListener(new ObsListener(1));
        JRadioButtonMenuItem item13 = new JRadioButtonMenuItem("Reflections/Length");
        item13.addItemListener(new ObsListener(2));
        this.add(this.runMenu);
        this.runMenu.add(this.runItem);
        this.add(this.obsMenu);
        infoMenu.add(this.infoItem);
        this.add(infoMenu);
        this.obsMenu.add(item11);
        this.obsMenu.add(item12);
        this.obsMenu.add(item13);
        ButtonGroup bg = new ButtonGroup();
        bg.add(item11);
        bg.add(item12);
        bg.add(item13);
    }

    public void postInit() {
        this.runItem.setSelected(true);
    }

    public void onDelete() {
        this.vis.removeScanListener(this.scanListener);
        this.infoItem.setSelected(false);
    }

    private final class ObsListener
    implements ItemListener {
        private final byte obs;

        public ObsListener(byte o) {
            this.obs = o;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                ScanMenuBar.this.vis.setObservable(this.obs);
            }
        }
    }
}

