/*
 * Decompiled with CFR 0.152.
 */
package mvc.mgr;

import common.Globals;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import math.VecMath;
import mvc.mgr.BaseLightPatternEditor;
import pattern.LightChar;
import pattern.LightCharPattern;

public class TextLightPatternEditor<T extends Number>
extends BaseLightPatternEditor<T, LightCharPattern<T>> {
    private JEditorPane textEditor;
    private TextPreviewCanvas textPreview;
    private final LightChar[] lightChars;
    private JCheckBox storeCalc;
    private JScrollPane previewScroller;
    private final T maxR;

    public TextLightPatternEditor(LightChar[] lcs, VecMath<T> mt) {
        super(false, 2, mt);
        this.lightChars = lcs;
        this.maxR = mt.util.cast(70);
        this.setMaxRadius(this.maxR);
    }

    @Override
    void setLightPattern(LightCharPattern<T> lcp) {
        this.setLightPatternName(lcp.getName());
        this.textEditor.setText(lcp.getText());
        this.storeCalc.setSelected(lcp.isStoreCalcEnabled());
        this.textChanged();
    }

    @Override
    LightCharPattern<T> getLightPattern() throws Exception {
        String txt = this.textEditor.getText();
        boolean store = this.storeCalc.isSelected();
        String name = this.getLightPatternName();
        return new LightCharPattern(name, txt, store, this.lightChars, this.math);
    }

    private void textChanged() {
        String rText = LightCharPattern.reduce(this.textEditor.getText());
        short gSize = LightCharPattern.calcGridSize(rText);
        this.setGridSize(gSize);
        this.textPreview.setText(rText, gSize);
        this.previewScroller.repaint();
        this.clearEstimation();
    }

    @Override
    int initGui(GridBagLayout gbl, GridBagConstraints gbc, int row) {
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.weightx = 1.0;
        gbc.weighty = 15.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        TitledBorder tb = BorderFactory.createTitledBorder("Text");
        this.textEditor = new JEditorPane();
        this.textEditor.setBackground(Globals.INPUT_BG);
        this.textEditor.setFont(new Font("Monospaced", 0, 9));
        this.textEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                TextLightPatternEditor.this.textChanged();
            }
        });
        this.textEditor.setPreferredSize(new Dimension(100, 100));
        JScrollPane sp = new JScrollPane(this.textEditor);
        int policy = 31;
        sp.setHorizontalScrollBarPolicy(policy);
        policy = 20;
        sp.setVerticalScrollBarPolicy(policy);
        sp.setBorder(tb);
        sp.setPreferredSize(new Dimension(100, 100));
        gbl.setConstraints(sp, gbc);
        this.add(sp);
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = row++;
        gbc.weightx = 1.0;
        gbc.weighty = 15.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        tb = BorderFactory.createTitledBorder("Layout");
        this.textPreview = new TextPreviewCanvas();
        this.textPreview.setFont(new Font("Monospaced", 0, 8));
        this.previewScroller = new JScrollPane(this.textPreview);
        policy = 31;
        this.previewScroller.setHorizontalScrollBarPolicy(policy);
        policy = 20;
        this.previewScroller.setVerticalScrollBarPolicy(policy);
        this.previewScroller.setBorder(tb);
        this.previewScroller.setPreferredSize(new Dimension(100, 100));
        gbl.setConstraints(this.previewScroller, gbc);
        this.add(this.previewScroller);
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = this.columns;
        gbc.gridheight = 1;
        tb = BorderFactory.createTitledBorder("Store Calculations");
        GridBagLayout gbl2 = new GridBagLayout();
        GridBagConstraints gbc2 = new GridBagConstraints();
        JPanel p = new JPanel(gbl2);
        gbc2.fill = 1;
        gbc2.gridx = 0;
        gbc2.weightx = 0.1;
        gbc2.weighty = 1.0;
        String txt = "Avoids recalculation of the pattern but reveals the radius in the storage file.";
        JTextPane tp = new JTextPane();
        tp.setBackground(this.getBackground());
        tp.setText(txt);
        tp.setPreferredSize(new Dimension(100, 35));
        this.storeCalc = new JCheckBox("");
        gbl2.setConstraints(this.storeCalc, gbc2);
        p.add(this.storeCalc);
        gbc2.gridx = 1;
        gbc2.weightx = 1.0;
        gbl2.setConstraints(tp, gbc2);
        p.add(tp);
        p.setBorder(tb);
        gbl.setConstraints(p, gbc);
        this.add(p);
        return row + 1;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.textEditor.setEnabled(b);
        this.textPreview.setEnabled(b);
        this.storeCalc.setEnabled(b);
    }

    @Override
    public void clear() {
        super.clear();
        this.setMaxRadius(this.maxR);
        this.textEditor.setText("");
        this.textPreview.setText("", (short)-1);
        this.storeCalc.setSelected(false);
    }

    private class TextPreviewCanvas
    extends JPanel {
        private String text;
        private short size;

        private TextPreviewCanvas() {
        }

        void setText(String txt, short gridSize) {
            this.text = txt;
            this.size = gridSize;
            int txtHeight = this.getFontMetrics(TextLightPatternEditor.this.textPreview.getFont()).getHeight() - 2;
            int txtWidth = this.getFontMetrics(TextLightPatternEditor.this.textPreview.getFont()).charWidth('M');
            this.setPreferredSize(new Dimension(txtWidth * this.size, txtHeight * this.size));
            this.revalidate();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.text != null) {
                Graphics2D g2d = (Graphics2D)g;
                String[] lines = LightCharPattern.preview(this.text, this.size);
                int txtHeight = this.getFontMetrics(TextLightPatternEditor.this.textPreview.getFont()).getHeight() - 2;
                int txtWidth = this.getFontMetrics(TextLightPatternEditor.this.textPreview.getFont()).charWidth('M');
                float cols = (float)(this.getSize().getWidth() / (double)txtWidth);
                float rows = (float)(this.getSize().getHeight() / (double)txtHeight);
                int x = (int)((cols - (float)(this.size - 1)) / 2.0f * (float)txtWidth);
                int y = (int)((rows - (float)(this.size - 1)) / 2.0f * (float)txtHeight);
                g2d.setFont(this.getFont());
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i] == null) continue;
                    g2d.drawString(lines[i], x, y + (i + 1) * txtHeight);
                }
            }
        }
    }
}

