/*
 * Decompiled with CFR 0.152.
 */
package mvc.mgr;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SeqenceTableModel
implements TableModel {
    private final ArrayList<TableModelListener> listeners = new ArrayList();
    private final String[] columnNames;
    private final ArrayList<Row> rows;
    private ArrayList<Row> rowBuffer;

    public SeqenceTableModel(String[] columnNames) {
        this.columnNames = columnNames;
        this.rows = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            this.rows.add(new Row());
        }
    }

    public void updateTable() {
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                for (TableModelListener l : SeqenceTableModel.this.listeners) {
                    l.tableChanged(new TableModelEvent(SeqenceTableModel.this));
                }
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < this.columnNames.length) {
            return this.columnNames[columnIndex];
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int cIdx) {
        switch (cIdx) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rIdx, int cIdx) {
        switch (cIdx) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rIdx, int cIdx) {
        switch (cIdx) {
            case 0: {
                return rIdx + 1 + "";
            }
            case 1: {
                return this.rows.get(rIdx).cell;
            }
            case 2: {
                return this.rows.get(rIdx).value;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object val, int rIdx, int cIdx) {
        switch (cIdx) {
            case 1: {
                this.rows.get(rIdx).cell = (String)val;
                break;
            }
            case 2: {
                this.rows.get(rIdx).value = (String)val;
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void clear() {
        for (Row r : this.rows) {
            r.clear();
        }
        this.updateTable();
    }

    public void removeRows(int[] rowPos) {
        ArrayList<Row> delRows = new ArrayList<Row>();
        for (int r : rowPos) {
            delRows.add(this.rows.get(r));
        }
        for (Row r : delRows) {
            this.rows.remove(r);
        }
        this.updateTable();
    }

    public void insertRow(int row) {
        if (this.rows.size() >= row) {
            this.rows.add(row, new Row());
            this.updateTable();
        }
    }

    public void copyBuffer(int pos) {
        if (this.rowBuffer != null) {
            for (int i = this.rowBuffer.size() - 1; i >= 0; --i) {
                this.rows.add(pos, this.rowBuffer.get(i));
            }
        }
        this.updateTable();
    }

    public void bufferRows(int[] rowIndexes) {
        if (rowIndexes != null) {
            this.rowBuffer = new ArrayList();
        }
        for (int i : rowIndexes) {
            this.rowBuffer.add(new Row(this.rows.get(i)));
        }
    }

    public int getLastRowPos() {
        for (int i = 0; i < this.rows.size(); ++i) {
            String c = this.rows.get(i).cell;
            if (c != null && c.trim().compareTo("") != 0) continue;
            return i - 1;
        }
        return -1;
    }

    public void incX(int[] rowPos) {
        this.alter(rowPos, true, "(", ",");
    }

    public void decX(int[] rowPos) {
        this.alter(rowPos, false, "(", ",");
    }

    public void incY(int[] rowPos) {
        this.alter(rowPos, true, ",", ")");
    }

    public void decY(int[] rowPos) {
        this.alter(rowPos, false, ",", ")");
    }

    private void alter(int[] rowPos, boolean b, String s1, String s2) {
        for (int pos : rowPos) {
            Row row = this.rows.get(pos);
            int i1 = row.cell.indexOf(s1);
            int i2 = row.cell.indexOf(s2);
            if (i1 == -1 || i2 == -1) continue;
            String valstr = row.cell.substring(i1 + 1, i2);
            short val = Short.parseShort(valstr);
            val = (short)(val + (b ? 1 : -1));
            String c = row.cell;
            row.cell = c.substring(0, i1 + 1) + val + c.substring(i2);
        }
        this.updateTable();
    }

    private class Row {
        private String cell;
        private String value;

        Row() {
        }

        Row(Row r) {
            this.cell = r.cell;
            this.value = r.value;
        }

        void clear() {
            this.cell = null;
            this.value = null;
        }
    }
}

