/*
 * Decompiled with CFR 0.152.
 */
package mvc.mgr;

import common.FileIO;
import common.Log;
import common.SelectTextItemListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import math.VecMath;
import mvc.Controller;
import mvc.IModelListener;
import mvc.LightPatternSelector;
import mvc.Model;
import mvc.mgr.ArtLightPatternEditor;
import mvc.mgr.BaseLightPatternEditor;
import mvc.mgr.TextLightPatternEditor;
import pattern.BaseLightPattern;
import pattern.CalculationRecords;
import pattern.ILightPattern;
import pattern.LightChar;
import pattern.LightCharPattern;

public class LightPatternManager<T extends Number>
extends JFrame {
    private JTree patternTree;
    private BaseLightPatternEditor<T, BaseLightPattern<T>> artEditor;
    private BaseLightPatternEditor<T, LightCharPattern<T>> textEditor;
    private final Controller<T> ctrl;
    private JPanel buttonPanel;
    private JScrollPane patternTreeScroller;
    private IModelListener modelListener;
    private JToggleButton help;

    public LightPatternManager(Controller<T> c) {
        super("Pattern Manager");
        this.ctrl = c;
        this.buildGuiComponents();
        this.layoutGui(this.artEditor);
        TreeNode root = (TreeNode)this.patternTree.getModel().getRoot();
        TreeNode c0 = root.getChildAt(0);
        if (c0.getChildCount() > 0) {
            TreeNode c00 = c0.getChildAt(0);
            TreePath path1 = new TreePath(new TreeNode[]{root, c0, c00});
            this.patternTree.setSelectionPath(path1);
        } else {
            TreePath path1 = new TreePath(new TreeNode[]{root, c0});
            this.patternTree.setSelectionPath(path1);
        }
        TreeNode c1 = root.getChildAt(1);
        TreePath path2 = new TreePath(new TreeNode[]{root, c1});
        this.patternTree.expandPath(path2);
    }

    public LightPatternManager(Controller<T> c, boolean artOrMsg) {
        super("Pattern Manager");
        this.ctrl = c;
        this.buildGuiComponents();
        this.layoutGui(this.artEditor);
        TreeNode root = (TreeNode)this.patternTree.getModel().getRoot();
        TreeNode c0 = root.getChildAt(0);
        TreeNode c1 = root.getChildAt(1);
        if (artOrMsg) {
            if (c0.getChildCount() > 0) {
                TreeNode c00 = c0.getChildAt(0);
                TreePath path1 = new TreePath(new TreeNode[]{root, c0, c00});
                this.patternTree.setSelectionPath(path1);
            } else {
                TreePath path1 = new TreePath(new TreeNode[]{root, c0});
                this.patternTree.setSelectionPath(path1);
            }
        } else if (c1.getChildCount() > 0) {
            TreeNode c10 = c1.getChildAt(0);
            TreePath path1 = new TreePath(new TreeNode[]{root, c1, c10});
            this.patternTree.setSelectionPath(path1);
        } else {
            TreePath path1 = new TreePath(new TreeNode[]{root, c1});
            this.patternTree.setSelectionPath(path1);
        }
    }

    private void buildGuiComponents() {
        this.buildTree();
        Model<T> m = this.ctrl.getModel();
        this.artEditor = new ArtLightPatternEditor<T>(m.getMath());
        BaseLightPatternEditor<T, BaseLightPattern<T>> baseLightPatternEditor = this.artEditor;
        baseLightPatternEditor.getClass();
        this.artEditor.setEstimator(baseLightPatternEditor.new BaseLightPatternEditor.Estimator(this.ctrl));
        this.textEditor = new TextLightPatternEditor<T>(m.getLightChars(), m.getMath());
        BaseLightPatternEditor<T, LightCharPattern<T>> baseLightPatternEditor2 = this.textEditor;
        baseLightPatternEditor2.getClass();
        this.textEditor.setEstimator(baseLightPatternEditor2.new BaseLightPatternEditor.Estimator(this.ctrl));
        this.modelListener = new IModelListener(){

            @Override
            public void modelChanged(byte event) {
                if (event == 8) {
                    LightPatternManager.this.artEditor.setPrecision(-1);
                    LightPatternManager.this.artEditor.setTime(-1);
                    LightPatternManager.this.textEditor.setPrecision(-1);
                    LightPatternManager.this.textEditor.setTime(-1);
                }
            }
        };
        m.addModelListener(this.modelListener);
        this.buttonPanel = new JPanel(new FlowLayout(2));
        this.help = new JToggleButton("Help");
        String text = new FileIO(null).loadInfoText("Manager");
        this.help.addItemListener(new SelectTextItemListener(this.help, "Help", text, 600, 600));
        JButton calc = new JButton("Calculate");
        calc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Component ed = LightPatternManager.this.getContentPane().getComponent(1);
                Object o = LightPatternManager.this.patternTree.getLastSelectedPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                BaseLightPattern lpOrig = (BaseLightPattern)node.getUserObject();
                LightPatternSelector lps = LightPatternManager.this.ctrl.getView().getLightPatternSelector();
                try {
                    Object lp = ((BaseLightPatternEditor)ed).getLightPattern();
                    lps.select(LightPatternManager.this, lp, ((BaseLightPattern)lp).isStoreCalcEnabled() && ((BaseLightPattern)lp).equals(lpOrig));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(LightPatternManager.this.ctrl.getView(), e.getMessage());
                }
            }
        });
        JButton save = new JButton("Save");
        save.addActionListener(new SaveActionListener());
        this.buttonPanel.add(this.help);
        this.buttonPanel.add(calc);
        this.buttonPanel.add(save);
    }

    private void layoutGui(BaseLightPatternEditor<T, ?> editor) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 2;
        gridbag.setConstraints(this.patternTreeScroller, c);
        this.getContentPane().add(this.patternTreeScroller);
        c.insets = new Insets(5, 0, 0, 5);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 10.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        gridbag.setConstraints(editor, c);
        this.getContentPane().add(editor);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        JButton[] eb = editor.getEditorButtons();
        if (eb != null) {
            for (JButton b : eb) {
                this.buttonPanel.add(b);
            }
        }
        gridbag.setConstraints(this.buttonPanel, c);
        this.getContentPane().add(this.buttonPanel);
    }

    @Override
    public void dispose() {
        this.ctrl.getModel().removeModelListener(this.modelListener);
        this.help.setSelected(false);
    }

    private void buildTree() {
        List<BaseLightPattern<T>> patterns = this.ctrl.getModel().getLightPatterns();
        final DefaultMutableTreeNode root = new DefaultMutableTreeNode("Light Patterns");
        final DefaultMutableTreeNode artNode = new DefaultMutableTreeNode("Symmetric");
        final DefaultMutableTreeNode txtNode = new DefaultMutableTreeNode("Symbol Sequence");
        root.add(artNode);
        root.add(txtNode);
        ArrayList<ILightPattern> artLPList = new ArrayList<ILightPattern>();
        ArrayList<ILightPattern> txtLPList = new ArrayList<ILightPattern>();
        for (ILightPattern iLightPattern : patterns) {
            if (iLightPattern instanceof LightCharPattern) {
                txtLPList.add(iLightPattern);
                continue;
            }
            artLPList.add(iLightPattern);
        }
        Comparator comp = new Comparator<ILightPattern<T>>(){

            @Override
            public int compare(ILightPattern<T> lp0, ILightPattern<T> lp1) {
                return lp0.getName().compareTo(lp1.getName());
            }
        };
        Collections.sort(artLPList, comp);
        Collections.sort(txtLPList, comp);
        for (ILightPattern p : txtLPList) {
            txtNode.add(new LightPatternNode(p));
        }
        for (ILightPattern p : artLPList) {
            artNode.add(new LightPatternNode(p));
        }
        final DefaultTreeModel defaultTreeModel = new DefaultTreeModel(root);
        this.patternTree = new JTree(defaultTreeModel);
        this.patternTreeScroller = new JScrollPane(this.patternTree);
        this.patternTreeScroller.setHorizontalScrollBarPolicy(31);
        Dimension d = this.patternTree.getPreferredSize();
        d.width = (int)((double)d.width * 1.5);
        this.patternTreeScroller.setMinimumSize(d);
        this.patternTreeScroller.setPreferredSize(d);
        this.patternTreeScroller.setMaximumSize(d);
        JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem newItem = new JMenuItem("New");
        newItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                TreeNode node = (TreeNode)LightPatternManager.this.patternTree.getLastSelectedPathComponent();
                if (node != null) {
                    VecMath math = LightPatternManager.this.ctrl.getModel().getMath();
                    BaseLightPattern p = null;
                    int nc = LightPatternManager.this.nameCount("New", (DefaultMutableTreeNode)root);
                    String name = "New " + (nc == 0 ? "" : Integer.valueOf(nc));
                    if (node == artNode) {
                        p = new BaseLightPattern(name, math);
                    } else {
                        LightChar[] lightChars = LightPatternManager.this.ctrl.getModel().getLightChars();
                        try {
                            p = new LightCharPattern(name, "", lightChars, math);
                        }
                        catch (Exception e) {
                            Log.getIstc().log(e);
                        }
                    }
                    LightPatternNode child = new LightPatternNode(p);
                    LightPatternManager.sortedInsert(defaultTreeModel, (MutableTreeNode)node, child);
                    TreePath path = new TreePath(new Object[]{root, node, child});
                    LightPatternManager.this.patternTree.setSelectionPath(path);
                    int row = LightPatternManager.this.patternTree.getRowForPath(path);
                    Point loc = LightPatternManager.this.patternTree.getRowBounds(row).getLocation();
                    loc.x = ((LightPatternManager)LightPatternManager.this).patternTree.getBounds().getLocation().x;
                    LightPatternManager.this.patternTreeScroller.getViewport().setViewPosition(loc);
                }
            }
        });
        final JMenuItem copyItem = new JMenuItem("Duplicate");
        copyItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Object lspc = LightPatternManager.this.patternTree.getLastSelectedPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lspc;
                BaseLightPattern origPat = (BaseLightPattern)node.getUserObject();
                int nc = LightPatternManager.this.nameCount(origPat.getName(), (DefaultMutableTreeNode)root);
                String name = origPat.getName() + " " + (nc == 0 ? "" : Integer.valueOf(nc));
                BaseLightPattern newPat = null;
                if (node.getParent() == artNode) {
                    newPat = new BaseLightPattern(origPat);
                    newPat.setName(name);
                } else {
                    try {
                        LightCharPattern origLcp = (LightCharPattern)origPat;
                        newPat = new LightCharPattern(origLcp);
                        newPat.setName(name);
                    }
                    catch (Exception e) {
                        Log.getIstc().log(e);
                    }
                }
                LightPatternNode child = new LightPatternNode(newPat);
                LightPatternManager.sortedInsert(defaultTreeModel, (MutableTreeNode)node.getParent(), child);
            }
        });
        final JMenuItem deleteItem = new JMenuItem("Delete");
        deleteItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Object lspc = LightPatternManager.this.patternTree.getLastSelectedPathComponent();
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)lspc;
                ILightPattern pat = (ILightPattern)n.getUserObject();
                String msg = "Delete Pattern " + pat.getName() + " ?";
                int choice = JOptionPane.showConfirmDialog(LightPatternManager.this, msg);
                if (choice == 0) {
                    DefaultMutableTreeNode p = (DefaultMutableTreeNode)n.getParent();
                    int pos = p.getIndex(n);
                    p.remove(n);
                    defaultTreeModel.nodesWereRemoved(p, new int[]{pos}, new Object[]{n});
                    LightPatternManager.this.ctrl.getModel().removeLightPattern(pat);
                    LightPatternManager.this.setEditingEnabled(false);
                }
            }
        });
        popupMenu.add(newItem);
        popupMenu.add(copyItem);
        popupMenu.add(deleteItem);
        this.patternTree.setComponentPopupMenu(popupMenu);
        this.patternTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                Object o;
                Object node = LightPatternManager.this.patternTree.getLastSelectedPathComponent();
                if (root == node || null == node) {
                    newItem.setEnabled(false);
                    copyItem.setEnabled(false);
                    deleteItem.setEnabled(false);
                    LightPatternManager.this.setEditingEnabled(false);
                } else if (artNode == node || txtNode == node) {
                    newItem.setEnabled(true);
                    copyItem.setEnabled(false);
                    deleteItem.setEnabled(false);
                    LightPatternManager.this.setEditingEnabled(false);
                } else {
                    newItem.setEnabled(false);
                    copyItem.setEnabled(true);
                    deleteItem.setEnabled(true);
                }
                if (node != null && (o = ((DefaultMutableTreeNode)node).getUserObject()) instanceof BaseLightPattern) {
                    LightPatternManager.this.edit((BaseLightPattern)o);
                }
            }
        });
    }

    private static void sortedInsert(DefaultTreeModel model, MutableTreeNode par, DefaultMutableTreeNode child) {
        String childName = ((ILightPattern)child.getUserObject()).getName();
        int pos = par.getChildCount();
        for (int i = 0; i < par.getChildCount(); ++i) {
            Object o = ((DefaultMutableTreeNode)par.getChildAt(i)).getUserObject();
            if (((ILightPattern)o).getName().compareTo(childName) < 0) continue;
            pos = i;
            break;
        }
        par.insert(child, pos);
        model.nodesWereInserted(par, new int[]{par.getIndex(child)});
    }

    private int nameCount(String name, DefaultMutableTreeNode root) {
        int cnt = -1;
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            ILightPattern p;
            Object o = ((DefaultMutableTreeNode)en.nextElement()).getUserObject();
            if (!(o instanceof ILightPattern) || !(p = (ILightPattern)o).getName().startsWith(name)) continue;
            String strCtr = p.getName().trim().substring(name.length());
            try {
                int ctr = Integer.parseInt(strCtr.trim());
                if (cnt >= ctr) continue;
                cnt = ctr;
            }
            catch (Exception e) {
                cnt = cnt == -1 ? 0 : cnt;
            }
        }
        return cnt + 1;
    }

    private void setEditingEnabled(boolean b) {
        for (Component c : this.buttonPanel.getComponents()) {
            c.setEnabled(b);
        }
        Component editor = this.getContentPane().getComponent(1);
        if (!b) {
            ((BaseLightPatternEditor)editor).clear();
        }
        editor.setEnabled(b);
    }

    private void edit(BaseLightPattern<T> lp) {
        Component c;
        BaseLightPatternEditor prevEditor;
        BaseLightPatternEditor<T, BaseLightPattern<T>> editor = this.artEditor;
        if (lp instanceof LightCharPattern) {
            editor = this.textEditor;
        }
        if ((prevEditor = (BaseLightPatternEditor)(c = this.getContentPane().getComponent(1))) != editor) {
            Dimension size = this.getSize();
            JButton[] eb = prevEditor.getEditorButtons();
            if (eb != null) {
                for (JButton b : eb) {
                    this.buttonPanel.remove(b);
                }
                this.buttonPanel.invalidate();
            }
            this.getContentPane().removeAll();
            this.layoutGui(editor);
            this.getContentPane().invalidate();
            this.setSize(new Dimension(size.width + 1, size.height + 1));
        }
        this.setEditingEnabled(true);
        editor.setLightPattern(lp);
    }

    private class LightPatternNode
    extends DefaultMutableTreeNode {
        public LightPatternNode(ILightPattern blp) {
            super(blp);
        }

        @Override
        public String toString() {
            return ((BaseLightPattern)this.getUserObject()).getName();
        }
    }

    private final class SaveActionListener
    implements ActionListener {
        private SaveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Component ed = LightPatternManager.this.getContentPane().getComponent(1);
            try {
                BaseLightPatternEditor blped = (BaseLightPatternEditor)ed;
                Object lp = blped.getLightPattern();
                Object o = LightPatternManager.this.patternTree.getLastSelectedPathComponent();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                ILightPattern lpOrig = (ILightPattern)node.getUserObject();
                CalculationRecords records = null;
                if (lpOrig.equals(lp)) {
                    records = LightPatternManager.this.ctrl.getModel().getRecords(lpOrig.getName());
                }
                if (lpOrig.getName().compareTo(lp.getName()) != 0) {
                    TreeNode root = (TreeNode)LightPatternManager.this.patternTree.getModel().getRoot();
                    for (int j = 0; j < root.getChildCount(); ++j) {
                        MutableTreeNode c = (MutableTreeNode)root.getChildAt(j);
                        for (int i = 0; i < c.getChildCount(); ++i) {
                            DefaultMutableTreeNode cc = (DefaultMutableTreeNode)c.getChildAt(i);
                            ILightPattern lipat = (ILightPattern)cc.getUserObject();
                            if (lipat.getName().compareTo(lp.getName()) != 0) continue;
                            throw new Exception("Name is already in use.");
                        }
                    }
                    LightPatternManager.this.ctrl.getModel().removeLightPattern(lpOrig);
                }
                LightPatternManager.this.ctrl.getModel().addLightPattern(lp);
                if (records != null) {
                    records.setPatternName(lp.getName());
                    LightPatternManager.this.ctrl.getModel().addRecords(records);
                } else {
                    LightPatternManager.this.ctrl.getModel().deleteRecords(lp.getName());
                }
                node.setUserObject(lp);
                ((DefaultTreeModel)LightPatternManager.this.patternTree.getModel()).nodeChanged(node);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(LightPatternManager.this.ctrl.getView(), e.getMessage());
            }
        }
    }
}

