/*
 * Decompiled with CFR 0.152.
 */
package mvc.mgr;

import common.Globals;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import math.VecMath;
import mvc.Controller;
import mvc.Model;
import pattern.BaseLightPattern;
import pattern.ILightPattern;

public abstract class BaseLightPatternEditor<T extends Number, P extends BaseLightPattern<T>>
extends JPanel {
    private JTextField nameField;
    private JTextField sizeField;
    private JTextField maxRField;
    private JTextField precField;
    private JTextField timeField;
    protected final VecMath<T> math;
    protected final int columns;
    private JButton estimateButton;
    private Estimator estimator;

    public BaseLightPatternEditor(boolean editable, int cols, VecMath<T> mt) {
        this.columns = cols;
        this.math = mt;
        this.initGui(editable);
    }

    void initGui(boolean editable) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int row = 0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = this.columns;
        c.gridheight = 1;
        TitledBorder tb = BorderFactory.createTitledBorder("Name");
        this.nameField = new JTextField();
        this.nameField.setBackground(Globals.INPUT_BG);
        JPanel l = new JPanel(new GridLayout());
        l.add(this.nameField);
        l.setBorder(tb);
        gridbag.setConstraints(l, c);
        this.add(l);
        row = this.initGui(gridbag, c, row + 1);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = this.columns;
        c.gridheight = 1;
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel p = new JPanel(gridbag2);
        c2.fill = 1;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.gridx = 0;
        tb = BorderFactory.createTitledBorder("Max. Radius");
        this.maxRField = new JTextField("       ");
        this.maxRField.setEditable(editable);
        if (!editable) {
            this.maxRField.setBackground(this.getBackground());
            this.maxRField.setForeground(Color.gray.darker());
        } else {
            this.maxRField.setBackground(Globals.INPUT_BG);
        }
        l = new JPanel(new GridLayout());
        l.add(this.maxRField);
        l.setBorder(tb);
        gridbag2.setConstraints(l, c2);
        p.add(l);
        c2.gridx = 1;
        tb = BorderFactory.createTitledBorder("Grid Size");
        this.sizeField = new JTextField("       ");
        this.sizeField.setEditable(editable);
        if (!editable) {
            this.sizeField.setBackground(this.getBackground());
            this.sizeField.setForeground(Color.gray.darker());
        } else {
            this.sizeField.setBackground(Globals.INPUT_BG);
        }
        l = new JPanel(new GridLayout());
        l.add(this.sizeField);
        l.setBorder(tb);
        gridbag2.setConstraints(l, c2);
        p.add(l);
        c2.gridx = 2;
        tb = BorderFactory.createTitledBorder("Precision");
        this.precField = new JTextField("--- digits");
        this.precField.setEditable(false);
        this.precField.setForeground(Color.gray.darker());
        l = new JPanel(new GridLayout());
        l.add(this.precField);
        l.setBorder(tb);
        gridbag2.setConstraints(l, c2);
        p.add(l);
        c2.gridx = 3;
        gridbag.setConstraints(p, c);
        tb = BorderFactory.createTitledBorder("Time");
        this.timeField = new JTextField("--- sec");
        this.timeField.setEditable(false);
        this.timeField.setForeground(Color.gray.darker());
        l = new JPanel(new GridLayout());
        l.add(this.timeField);
        l.setBorder(tb);
        gridbag2.setConstraints(l, c2);
        p.add(l);
        gridbag.setConstraints(p, c);
        this.add(p);
        this.estimateButton = new JButton("Estimate");
        this.estimateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                Container topLevel = BaseLightPatternEditor.this.getTopLevelAncestor();
                topLevel.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Object lp = BaseLightPatternEditor.this.getLightPattern();
                    BaseLightPatternEditor.this.estimator.setParameters(lp);
                    BaseLightPatternEditor.this.setPrecision(((BaseLightPattern)lp).getAccuracyUpperBound());
                    BaseLightPatternEditor.this.setTime(((BaseLightPattern)lp).estimateCalcTime());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(BaseLightPatternEditor.this, e.getMessage());
                }
                topLevel.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    abstract void setLightPattern(P var1);

    abstract P getLightPattern() throws Exception;

    abstract int initGui(GridBagLayout var1, GridBagConstraints var2, int var3);

    void clearEstimation() {
        this.setPrecision(-1);
        this.setTime(-1);
    }

    JButton[] getEditorButtons() {
        return new JButton[]{this.estimateButton};
    }

    T getMaxRadius() throws Exception {
        String txt = this.maxRField.getText().trim();
        if (txt == null || txt.compareTo("") == 0) {
            throw new Exception("Maximum radius is missing.");
        }
        int pos = txt.indexOf("%");
        if (pos != -1) {
            return this.math.util.parse(txt.substring(0, pos).trim());
        }
        throw new Exception("Percent unit for the radius is missing.");
    }

    void setMaxRadius(T mr) {
        String maxR = this.math.util.toPlainString(mr);
        this.maxRField.setText(maxR + " %");
    }

    short getGridSize() throws Exception {
        String txt = this.sizeField.getText().trim();
        if (txt == null || txt.compareTo("") == 0) {
            throw new Exception("Grid size is missing.");
        }
        int pos = txt.indexOf("x");
        if (pos != -1) {
            return Short.parseShort(txt.substring(0, pos));
        }
        return Short.parseShort(txt);
    }

    void setGridSize(short gs) {
        this.sizeField.setText(gs + "x" + gs);
    }

    String getLightPatternName() {
        return this.nameField.getText().trim();
    }

    void setLightPatternName(String name) {
        this.nameField.setText(name);
    }

    void setPrecision(int p) {
        if (this.precField != null) {
            if (p == -1) {
                this.precField.setText("--- digits");
            } else {
                this.precField.setText(p + " digits");
            }
        }
    }

    void setTime(int t) {
        if (this.timeField != null) {
            if (t == -1) {
                this.timeField.setText("--- sec");
            } else if (t < 60) {
                this.timeField.setText(t + " sec");
            } else if (t < 3600) {
                this.timeField.setText((float)((int)((float)t * 10.0f / 60.0f)) / 10.0f + " min");
            } else if (t < 86400) {
                this.timeField.setText((float)((int)((float)t * 10.0f / 3600.0f)) / 10.0f + " h");
            } else {
                this.timeField.setText((float)((int)((float)t * 10.0f / 86400.0f)) / 10.0f + " d");
            }
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.nameField.setEnabled(b);
        this.sizeField.setEnabled(b);
        this.maxRField.setEnabled(b);
        this.precField.setEnabled(b);
        this.timeField.setEnabled(b);
    }

    public void clear() {
        this.setMaxRadius(this.math.ZERO);
        this.setGridSize((short)0);
        this.setLightPatternName("");
        this.setPrecision(-1);
        this.setTime(-1);
    }

    public void setEstimator(Estimator e) {
        this.estimator = e;
    }

    final class Estimator {
        private Controller<T> ctrl;

        Estimator(Controller<T> c) {
            this.ctrl = c;
        }

        void setParameters(ILightPattern<T> lp) {
            Model model = this.ctrl.getModel();
            Object gap = model.calcGap(lp.getGridSize());
            Object size = model.calcShapeSize(lp.getGridSize());
            Number[] corner = (Number[])model.getGridInitBound().getCorner().clone();
            lp.setParameters(corner, (Number)gap, (Number)size);
        }
    }
}

