/*
 * Decompiled with CFR 0.152.
 */
package mvc.mgr;

import common.Globals;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import math.VecMath;
import mvc.mgr.BaseLightPatternEditor;
import mvc.mgr.SeqenceTableModel;
import pattern.BaseLightPattern;

public class ArtLightPatternEditor<T extends Number>
extends BaseLightPatternEditor<T, BaseLightPattern<T>> {
    private static final String[] BND_VAL_TYPES = new String[]{"POINT", "GRADIENT LEFT", "GRADIENT RIGHT"};
    private static final String[] BND_VAL_POINT = new String[]{"FIRST", "SECOND"};
    private static final String[] BND_VAL_GRAD = new String[]{"-1", "0", "1"};
    private static final String INFINITY = "inf";
    private JComboBox startBTComboBox;
    private JComboBox startBVComboBox;
    private JComboBox endBTComboBox;
    private JComboBox endBVComboBox;
    private SeqenceTableModel seqTableModel;
    private JTable seqTable;
    private JScrollPane seqTableScroller;

    public ArtLightPatternEditor(VecMath<T> mt) {
        super(true, 2, mt);
    }

    @Override
    void setLightPattern(BaseLightPattern<T> lp) {
        this.setLightPatternName(lp.getName());
        this.setGridSize(lp.getGridSize());
        this.setMaxRadius(lp.getMaxShapeSize());
        switch (lp.getStartBndValType()) {
            case 0: {
                this.startBTComboBox.setSelectedItem(BND_VAL_TYPES[0]);
                break;
            }
            case 2: {
                this.startBTComboBox.setSelectedItem(BND_VAL_TYPES[1]);
                break;
            }
            case 1: {
                this.startBTComboBox.setSelectedItem(BND_VAL_TYPES[2]);
            }
        }
        switch (lp.getEndBndValType()) {
            case 0: {
                this.endBTComboBox.setSelectedItem(BND_VAL_TYPES[0]);
                break;
            }
            case 2: {
                this.endBTComboBox.setSelectedItem(BND_VAL_TYPES[1]);
                break;
            }
            case 1: {
                this.endBTComboBox.setSelectedItem(BND_VAL_TYPES[2]);
            }
        }
        this.seqTableModel.clear();
        List<short[]> cells = lp.getCellSequence();
        if (cells != null) {
            while (this.seqTableModel.getRowCount() < cells.size() + 10) {
                this.seqTableModel.insertRow(0);
            }
            while (this.seqTableModel.getRowCount() > cells.size() + 10) {
                this.seqTableModel.removeRows(new int[]{0});
            }
            for (int i = 0; i < cells.size(); ++i) {
                short[] cell = cells.get(i);
                String cellStr = " (" + cell[0] + "," + cell[1] + ")";
                this.seqTableModel.setValueAt(cellStr, i, 1);
            }
            int i1 = lp.getStartBndValType() == 0 ? 1 : 0;
            int i2 = lp.getEndBndValType() == 0 ? 1 : 0;
            for (int i = i1; i < cells.size() - i2; ++i) {
                float gr = lp.getInitialGradients().get(i - i1).floatValue();
                this.seqTableModel.setValueAt(" " + gr, i, 2);
            }
            T bv = lp.getStartBndVal();
            if (lp.getStartBndValType() == 0) {
                this.seqTableModel.setValueAt(" " + this.getBndValStr(bv), 0, 2);
                this.startBVComboBox.setSelectedItem(this.getBndValSelectStr(bv));
            } else {
                this.startBVComboBox.setSelectedItem(((Number)bv).byteValue() + "");
            }
            bv = lp.getEndBndVal();
            if (lp.getEndBndValType() == 0) {
                int row = this.seqTableModel.getLastRowPos();
                this.seqTableModel.setValueAt(" " + this.getBndValStr(bv), row, 2);
                this.endBVComboBox.setSelectedItem(this.getBndValSelectStr(bv));
            } else {
                this.endBVComboBox.setSelectedItem(((Number)bv).byteValue() + "");
            }
        }
    }

    @Override
    BaseLightPattern<T> getLightPattern() throws Exception {
        String select;
        ArtLightPatternEditor.stopEditing(this.seqTable);
        short maxPrec = Globals.PRECISIONS[Globals.PRECISIONS.length - 1];
        BaseLightPattern lp = new BaseLightPattern(this.math);
        lp.setName(this.getLightPatternName());
        if (this.getGridSize() == 0) {
            throw new Exception("The size of the grid must be at least 2x2.");
        }
        lp.setGridSize(this.getGridSize());
        if (this.math.cmp(this.getMaxRadius(), this.math.ZERO) == 0) {
            throw new Exception("The maximum radius must be > 0 %.");
        }
        lp.setMaxShapeSize(this.math.util.copy(this.getMaxRadius(), maxPrec));
        String sbt = (String)this.startBTComboBox.getSelectedItem();
        if (sbt.compareTo(BND_VAL_TYPES[0]) == 0) {
            lp.setStartBndValType((byte)0);
        } else if (sbt.compareTo(BND_VAL_TYPES[1]) == 0) {
            lp.setStartBndValType((byte)2);
        } else {
            lp.setStartBndValType((byte)1);
        }
        String ebt = (String)this.endBTComboBox.getSelectedItem();
        if (ebt.compareTo(BND_VAL_TYPES[0]) == 0) {
            lp.setEndBndValType((byte)0);
        } else if (ebt.compareTo(BND_VAL_TYPES[1]) == 0) {
            lp.setEndBndValType((byte)2);
        } else {
            lp.setEndBndValType((byte)1);
        }
        if (this.seqTableModel.getLastRowPos() == -1) {
            throw new Exception("The sequence of grid cells is missing.");
        }
        if (lp.getStartBndValType() == 0) {
            select = (String)this.startBVComboBox.getSelectedItem();
            String value = ((String)this.seqTableModel.getValueAt(0, 2)).trim();
            T bv = this.getBoundValue(value, select);
            lp.setStartBndVal(bv);
        } else {
            byte value = Byte.parseByte((String)this.startBVComboBox.getSelectedItem());
            lp.setStartBndVal(this.math.util.copy(this.math.util.cast(value), maxPrec));
        }
        if (lp.getEndBndValType() == 0) {
            select = (String)this.endBVComboBox.getSelectedItem();
            int lastRow = this.seqTableModel.getLastRowPos();
            String value = ((String)this.seqTableModel.getValueAt(lastRow, 2)).trim();
            T bv = this.getBoundValue(value, select);
            lp.setEndBndVal(bv);
        } else {
            byte value = Byte.parseByte((String)this.endBVComboBox.getSelectedItem());
            lp.setEndBndVal(this.math.util.copy(this.math.util.cast(value), maxPrec));
        }
        ArrayList<short[]> cells = new ArrayList<short[]>();
        for (int row = 0; row <= this.seqTableModel.getLastRowPos(); ++row) {
            String cell = (String)this.seqTableModel.getValueAt(row, 1);
            int i1 = cell.indexOf("(");
            int i2 = cell.indexOf(",");
            int i3 = cell.indexOf(")");
            if (i1 == -1 || i2 == -1 || i3 == -1) {
                String txt = "Error in line " + row + ":\n" + "The format of the cells is (x,y).";
                throw new Exception(txt);
            }
            short val1 = Short.parseShort(cell.substring(i1 + 1, i2));
            short val2 = Short.parseShort(cell.substring(i2 + 1, i3));
            cells.add(new short[]{val1, val2});
        }
        lp.setCellSequence(cells);
        lp.calcStartIndex();
        if (lp.getStartIndex() == -1) {
            throw new Exception("All cells lie outside of the grid.");
        }
        if (lp.getStartIndex() != 0) {
            lp.setPropagating(true);
        }
        int i1 = lp.getStartBndValType() == 0 ? 1 : 0;
        int i2 = lp.getEndBndValType() == 0 ? 1 : 0;
        ArrayList<Float> gradients = new ArrayList<Float>();
        for (int row = i1; row <= this.seqTableModel.getLastRowPos() - i2; ++row) {
            String value = ((String)this.seqTableModel.getValueAt(row, 2)).trim();
            try {
                if (value.compareTo(INFINITY) == 0) {
                    gradients.add(Float.valueOf(1000.0f));
                    continue;
                }
                gradients.add(Float.valueOf(Float.parseFloat(value)));
                continue;
            }
            catch (Exception e) {
                String txt = "Error in line " + row + ":\n" + "The gradient is neither a float number nor an " + INFINITY + ".";
                throw new Exception(txt);
            }
        }
        lp.setInitialGradients(gradients);
        return lp;
    }

    private String getBndValSelectStr(T bv) {
        if (((Number)bv).byteValue() < 4) {
            return BND_VAL_POINT[0];
        }
        return BND_VAL_POINT[1];
    }

    private String getBndValStr(T bv) {
        byte pos = ((Number)bv).byteValue();
        if (pos >= 4) {
            pos = (byte)(pos - 4);
        }
        String gradient = null;
        switch (pos) {
            case 0: {
                gradient = "0";
                break;
            }
            case 1: {
                gradient = "1";
                break;
            }
            case 2: {
                gradient = INFINITY;
                break;
            }
            case 3: {
                gradient = "-1";
            }
        }
        return gradient;
    }

    private T getBoundValue(String val, String select) throws Exception {
        int pos;
        if (val.compareTo(INFINITY) == 0) {
            pos = 2;
        } else {
            try {
                byte value = Byte.parseByte(val);
                switch (value) {
                    case 0: {
                        pos = 0;
                        break;
                    }
                    case 1: {
                        pos = 1;
                        break;
                    }
                    case -1: {
                        pos = 3;
                        break;
                    }
                    default: {
                        throw new Exception();
                    }
                }
            }
            catch (Exception e) {
                String msg = "The initial gradient of a boundary\npoint must be one of -1,0,1 or inf";
                throw new Exception(msg);
            }
        }
        if (select.compareTo(BND_VAL_POINT[1]) == 0) {
            pos = (byte)(pos + 4);
        }
        return this.math.util.cast(pos);
    }

    @Override
    int initGui(GridBagLayout gb, GridBagConstraints c, int row) {
        c.fill = 1;
        c.gridx = 1;
        c.gridy = row;
        c.weightx = 3.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 5;
        TitledBorder tb = BorderFactory.createTitledBorder("Sequence");
        this.buildTable();
        this.seqTableScroller = new JScrollPane(this.seqTable);
        int policy = 20;
        this.seqTableScroller.setVerticalScrollBarPolicy(policy);
        policy = 31;
        this.seqTableScroller.setHorizontalScrollBarPolicy(policy);
        this.seqTableScroller.setBorder(tb);
        gb.setConstraints(this.seqTableScroller, c);
        this.add(this.seqTableScroller);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row++;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        tb = BorderFactory.createTitledBorder("1. Boundary Value Type");
        this.startBTComboBox = new JComboBox<String>(BND_VAL_TYPES);
        this.startBTComboBox.setBorder(tb);
        gb.setConstraints(this.startBTComboBox, c);
        this.add(this.startBTComboBox);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row++;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        tb = BorderFactory.createTitledBorder("1. Boundary Value");
        this.startBVComboBox = new JComboBox<String>(BND_VAL_POINT);
        this.startBVComboBox.setBorder(tb);
        gb.setConstraints(this.startBVComboBox, c);
        this.add(this.startBVComboBox);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row++;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        tb = BorderFactory.createTitledBorder("2. Boundary Value Type");
        this.endBTComboBox = new JComboBox<String>(BND_VAL_TYPES);
        this.endBTComboBox.setBorder(tb);
        gb.setConstraints(this.endBTComboBox, c);
        this.add(this.endBTComboBox);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row++;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        tb = BorderFactory.createTitledBorder("2. Boundary Value");
        this.endBVComboBox = new JComboBox<String>(BND_VAL_POINT);
        this.endBVComboBox.setBorder(tb);
        gb.setConstraints(this.endBVComboBox, c);
        this.add(this.endBVComboBox);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = row++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.gridheight = 1;
        JPanel p = new JPanel();
        gb.setConstraints(p, c);
        this.add(p);
        AdjustBoundValuesListener l = new AdjustBoundValuesListener(this.startBTComboBox, this.startBVComboBox);
        this.startBTComboBox.addItemListener(l);
        l = new AdjustBoundValuesListener(this.endBTComboBox, this.endBVComboBox);
        this.endBTComboBox.addItemListener(l);
        return row;
    }

    private void buildTable() {
        this.seqTableModel = new SeqenceTableModel(new String[]{"", "Cell", "Gradient"});
        this.seqTable = new JTable(this.seqTableModel);
        this.seqTable.setRowSelectionAllowed(true);
        this.seqTable.setColumnSelectionAllowed(false);
        CellEditorListener autoInserter = new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent arg0) {
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                TableCellEditor editor = (TableCellEditor)e.getSource();
                String val = (String)editor.getCellEditorValue();
                int rIdx = ArtLightPatternEditor.this.seqTable.getEditingRow();
                int cIdx = ArtLightPatternEditor.this.seqTable.getEditingColumn();
                ArtLightPatternEditor.this.seqTableModel.setValueAt(val, rIdx, cIdx);
            }
        };
        StringEditor se = new StringEditor(true);
        ColorRenderer cr = new ColorRenderer();
        se.addCellEditorListener(autoInserter);
        TableColumn col = this.seqTable.getColumnModel().getColumn(0);
        col.setMaxWidth(30);
        col.setMinWidth(30);
        col = this.seqTable.getColumnModel().getColumn(1);
        col.setCellEditor(se);
        col.setCellRenderer(cr);
        col = this.seqTable.getColumnModel().getColumn(2);
        col.setCellEditor(se);
        col.setCellRenderer(cr);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem insertRowItem = new JMenuItem("Insert");
        insertRowItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ArtLightPatternEditor.stopEditing(ArtLightPatternEditor.this.seqTable);
                int[] selRows = ArtLightPatternEditor.this.seqTable.getSelectedRows();
                ArtLightPatternEditor.this.seqTableModel.insertRow(selRows[0]);
            }
        });
        JMenuItem deleteRowItem = new JMenuItem("Delete");
        deleteRowItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ArtLightPatternEditor.stopEditing(ArtLightPatternEditor.this.seqTable);
                int[] selRows = ArtLightPatternEditor.this.seqTable.getSelectedRows();
                ArtLightPatternEditor.this.seqTableModel.removeRows(selRows);
            }
        });
        JMenuItem copyItem = new JMenuItem("Copy");
        copyItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ArtLightPatternEditor.stopEditing(ArtLightPatternEditor.this.seqTable);
                ArtLightPatternEditor.this.seqTableModel.bufferRows(ArtLightPatternEditor.this.seqTable.getSelectedRows());
            }
        });
        JMenuItem pasteItem = new JMenuItem("Paste");
        pasteItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                ArtLightPatternEditor.stopEditing(ArtLightPatternEditor.this.seqTable);
                int[] selRows = ArtLightPatternEditor.this.seqTable.getSelectedRows();
                ArtLightPatternEditor.this.seqTableModel.copyBuffer(selRows[0]);
            }
        });
        JMenuItem incXItem = new JMenuItem("x -> x+1");
        incXItem.addMouseListener(new ReselectMouseListener(){

            @Override
            void execute() {
                ArtLightPatternEditor.this.seqTableModel.incX(ArtLightPatternEditor.this.seqTable.getSelectedRows());
            }
        });
        JMenuItem decXItem = new JMenuItem("x -> x-1");
        decXItem.addMouseListener(new ReselectMouseListener(){

            @Override
            void execute() {
                ArtLightPatternEditor.this.seqTableModel.decX(ArtLightPatternEditor.this.seqTable.getSelectedRows());
            }
        });
        JMenuItem incYItem = new JMenuItem("y -> y+1");
        incYItem.addMouseListener(new ReselectMouseListener(){

            @Override
            void execute() {
                ArtLightPatternEditor.this.seqTableModel.incY(ArtLightPatternEditor.this.seqTable.getSelectedRows());
            }
        });
        JMenuItem decYItem = new JMenuItem("y -> y-1");
        decYItem.addMouseListener(new ReselectMouseListener(){

            @Override
            void execute() {
                ArtLightPatternEditor.this.seqTableModel.decY(ArtLightPatternEditor.this.seqTable.getSelectedRows());
            }
        });
        popupMenu.add(insertRowItem);
        popupMenu.add(deleteRowItem);
        popupMenu.add(copyItem);
        popupMenu.add(pasteItem);
        popupMenu.add(incXItem);
        popupMenu.add(decXItem);
        popupMenu.add(incYItem);
        popupMenu.add(decYItem);
        this.seqTable.setComponentPopupMenu(popupMenu);
        ListSelectionModel selModel = this.seqTable.getSelectionModel();
        selModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                boolean b = ArtLightPatternEditor.this.seqTable.getSelectedRows().length != 0;
                ArtLightPatternEditor.this.enablePopupMenues(b);
                ArtLightPatternEditor.this.clearEstimation();
            }
        });
        selModel.setSelectionMode(1);
        this.enablePopupMenues(false);
    }

    private void enablePopupMenues(boolean b) {
        JPopupMenu pm = this.seqTable.getComponentPopupMenu();
        for (int i = 0; i < pm.getComponentCount(); ++i) {
            pm.getComponent(i).setEnabled(b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.startBTComboBox.setEnabled(b);
        this.startBVComboBox.setEnabled(b);
        this.endBTComboBox.setEnabled(b);
        this.endBVComboBox.setEnabled(b);
        this.seqTable.setEnabled(b);
        this.seqTableScroller.setEnabled(b);
    }

    @Override
    public void clear() {
        super.clear();
        ArtLightPatternEditor.stopEditing(this.seqTable);
        this.seqTableModel.clear();
        this.startBTComboBox.setSelectedItem(null);
        this.startBVComboBox.setSelectedItem(null);
        this.endBTComboBox.setSelectedItem(null);
        this.endBVComboBox.setSelectedItem(null);
    }

    private static void stopEditing(JTable table) {
        int rIdx = table.getEditingRow();
        int cIdx = table.getEditingColumn();
        if (rIdx != -1 && cIdx != -1) {
            table.getCellEditor(rIdx, cIdx).stopCellEditing();
        }
    }

    private class AdjustBoundValuesListener
    implements ItemListener {
        private JComboBox btComboBox;
        private JComboBox bvComboBox;

        AdjustBoundValuesListener(JComboBox btCBox, JComboBox bvCBox) {
            this.btComboBox = btCBox;
            this.bvComboBox = bvCBox;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            this.bvComboBox.removeAllItems();
            String si = (String)this.btComboBox.getSelectedItem();
            if (si != null) {
                String[] items = BND_VAL_POINT;
                if (si.compareTo(BND_VAL_TYPES[0]) != 0) {
                    items = BND_VAL_GRAD;
                }
                for (String item : items) {
                    this.bvComboBox.addItem(item);
                }
            }
            ArtLightPatternEditor.this.clearEstimation();
        }
    }

    private abstract class ReselectMouseListener
    extends MouseAdapter {
        private ReselectMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            ArtLightPatternEditor.stopEditing(ArtLightPatternEditor.this.seqTable);
            final int i0 = ArtLightPatternEditor.this.seqTable.getSelectionModel().getMinSelectionIndex();
            final int i1 = ArtLightPatternEditor.this.seqTable.getSelectionModel().getMaxSelectionIndex();
            this.execute();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArtLightPatternEditor.this.seqTable.getSelectionModel().addSelectionInterval(i0, i1);
                }
            });
        }

        abstract void execute();
    }

    private class ColorRenderer
    extends DefaultTableCellRenderer {
        private ColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable t, Object v, boolean sel, boolean b, int row, int col) {
            Component c = super.getTableCellRendererComponent(t, v, sel, b, row, col);
            c.setBackground(Globals.INPUT_BG);
            return c;
        }
    }

    private class StringEditor
    extends DefaultCellEditor {
        public StringEditor(boolean editable) {
            super(new JTextField());
            this.setClickCountToStart(1);
            ((JTextField)this.getComponent()).setEditable(editable);
            ((JTextField)this.getComponent()).setBackground(Globals.INPUT_BG);
        }
    }
}

