/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.ColorTheme;
import common.FloatConverter;
import common.Globals;
import common.ICallback;
import common.IConverter;
import common.Log;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import lattice.Box2D;
import lattice.Circle;
import lattice.IBox;
import lattice.IShape;
import lattice.Ray;
import math.Util;
import math.VecMath;
import mvc.Controller;
import mvc.IFZLBorder;
import mvc.IModelListener;
import mvc.Model;
import mvc.PixelMap;
import mvc.PixelMapAbstract;
import mvc.PixelMapFloat;
import mvc.SimpleBorder;
import mvc.TouchButtonsOverlay;
import pattern.BaseLightPattern;

public class Visualizer<T extends Number>
extends JPanel {
    public static final short LS_1 = 0;
    public static final short LS_2 = 1;
    public static final short LS_3 = 2;
    public static final short LS_4 = 3;
    public static final short[] LIGHT_SOURCES = new short[]{0, 1, 2, 3};
    private final Controller<T> ctrl;
    private final LinkedList<Short> paintedPts;
    private final LinkedList<Short> paintedShapeBounds;
    private final LightSourceSprite lightSrc;
    private BufferedImage bimg;
    private PaintRequestQueue queue;
    private PixelMapAbstract<T> trafo;
    private PixelMapAbstract<Float> trafoFloat;
    private ColorTheme theme;
    private boolean applPaint;
    private final ICallback callback;
    private BufferedImage circleImg;
    private Box2D<Float> canvasBox;
    private IFZLBorder border;
    private TouchButtonsOverlay<T> tbo;
    BaseLightPattern<T> pattern;

    public Visualizer(Controller<T> c, ColorTheme ct, ICallback callback, boolean scrs) {
        this.ctrl = c;
        this.paintedPts = new LinkedList();
        this.paintedShapeBounds = new LinkedList();
        this.theme = ct;
        this.lightSrc = new LightSourceSprite();
        this.callback = callback;
        VecMath<Float> fm = this.ctrl.getModel().getFloatMath();
        this.canvasBox = new Box2D((Number[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, (Number)Float.valueOf(1.0f), fm);
        this.setOpaque(true);
        this.setFocusable(true);
        this.setDoubleBuffered(false);
        this.border = new SimpleBorder(10, this.theme.getBorderColor());
        this.initListeners(scrs);
    }

    private Box2D<Float> getCanvas() {
        if (this.tbo != null) {
            return this.tbo.getCanvas();
        }
        return this.canvasBox;
    }

    private void initListeners(boolean screensaver) {
        Model<T> model = this.ctrl.getModel();
        UpdateModelListener ml = new UpdateModelListener();
        model.addModelListener(ml);
        this.addComponentListener(new ResizeListener());
        if (screensaver) {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    System.exit(0);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent me) {
                    System.exit(0);
                }
            });
            return;
        }
        SelectRayMouseListener srml = new SelectRayMouseListener();
        this.addMouseListener(srml);
        this.addMouseMotionListener(srml);
        SelectRayKeyListener srkl = new SelectRayKeyListener();
        this.addKeyListener(srkl);
        RotateGridKeyListener rgkl = new RotateGridKeyListener();
        this.addKeyListener(rgkl);
        RotateGridListener rgl = new RotateGridListener();
        this.addMouseListener(rgl);
        this.addMouseMotionListener(rgl);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 88) {
                    System.exit(0);
                }
                if (e.getKeyCode() == 27) {
                    System.exit(0);
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.border.getBorderInsets(this);
        short borderX = (short)insets.left;
        short borderY = (short)insets.top;
        short w = (short)this.getWidth();
        short h = (short)this.getHeight();
        this.getPixelMap().setBorder(borderX, borderY);
        this.getFloatPixelMap().setBorder(borderX, borderY);
        this.getPixelMap().setSreenSize(w, h);
        this.getFloatPixelMap().setSreenSize(w, h);
        Number[] lgs = new Float[]{Float.valueOf(1.0f * (float)(w - 2 * borderX - 1)), Float.valueOf(1.0f * (float)(h - 2 * borderY - 1))};
        this.getCanvas().setLengths(lgs);
        if (this.bimg == null || this.bimg.getWidth() != w || this.bimg.getHeight() != h) {
            short[] defStartEnd;
            this.lightSrc.valid = false;
            this.bimg = new BufferedImage(w, h, 1);
            Graphics ig = this.bimg.getGraphics();
            this.paintBackground(ig, w, h, borderX, borderY);
            Iterator iter = this.paintedShapeBounds.iterator();
            while (iter.hasNext()) {
                short x = (Short)iter.next();
                short y = (Short)iter.next();
                short width = (Short)iter.next();
                short height = (Short)iter.next();
                ig.fillOval(x, y, width, height);
            }
            Visualizer.paintReflections(ig, this.paintedPts, this.theme.getRayColor());
            if (this.pattern != null && (defStartEnd = this.findDefPath(this.pattern))[0] != -1 && defStartEnd[1] <= this.paintedPts.size()) {
                Visualizer.paintReflections(g, this.paintedPts.subList(defStartEnd[0], defStartEnd[1]), new Color(255, 43, 82));
            }
            ig.translate(-borderX, -borderY);
            this.border.drawBorder(this, ig);
        }
        if (this.applPaint) {
            this.lazyQueue();
            if (this.queue.size() > 0) {
                PaintRequest p = this.queue.poll();
                this.doPaint(this.bimg.getGraphics(), p, borderX, borderY);
            }
        }
        g.drawImage(this.bimg, 0, 0, this);
    }

    private void paintBackground(Graphics g, int w, int h, int bx, int by) {
        if (this.tbo != null) {
            this.tbo.paintBackround(g, w, h, bx, by, this.theme.getBgColor());
            this.tbo.paintButtons(g, w, h, bx, by);
        } else {
            g.translate(bx, by);
            g.setColor(this.theme.getBgColor());
            g.fillRect(0, 0, w - 2 * bx, h - 2 * by);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyQueue() {
        ICallback iCallback = this.callback;
        synchronized (iCallback) {
            if (this.queue == null) {
                this.queue = new PaintRequestQueue();
                this.callback.call();
            }
        }
    }

    private void doPaint(Graphics g, PaintRequest req, short bx, short by) {
        Iterator iter;
        if (req.background) {
            this.border.drawBorder(this, g);
            this.paintBackground(g, this.getWidth(), this.getHeight(), bx, by);
            this.paintedPts.clear();
            this.paintedShapeBounds.clear();
            this.lightSrc.valid = false;
        } else {
            g.translate(bx, by);
            if (req.newray) {
                this.lightSrc.delete();
                Visualizer.paintReflections(g, this.paintedPts, this.theme.getBgColor());
                this.paintedPts.clear();
            }
            if (req.circles || req.newray) {
                this.lightSrc.delete();
                g.setColor(this.theme.getBgColor());
                iter = this.paintedShapeBounds.iterator();
                while (iter.hasNext()) {
                    short x = (Short)iter.next();
                    short y = (Short)iter.next();
                    short w = (Short)iter.next();
                    short h = (Short)iter.next();
                    g.fillRect(x, y, w, h);
                }
                this.paintedShapeBounds.clear();
            }
        }
        if (this.paintedShapeBounds.size() == 0) {
            this.paintShapes(g, req.iter);
        }
        if (req.data != null && req.data.size() > 0) {
            short[] defStartEnd;
            iter = req.data.iterator();
            while (iter.hasNext()) {
                Number[] pt2;
                float x = ((Number)iter.next()).floatValue();
                float y = ((Number)iter.next()).floatValue();
                short x0 = this.getFloatPixelMap().xWorld2Pix(Float.valueOf(x));
                short y0 = this.getFloatPixelMap().yWorld2Pix(Float.valueOf(y));
                if (this.paintedPts.size() == 0) {
                    if (this.tbo != null) {
                        pt2 = new Float[]{Float.valueOf(1.0f * (float)x0), Float.valueOf(1.0f * (float)y0)};
                        if (!this.getCanvas().containsLocal(pt2)) {
                            Number[] dir = new Float[]{Float.valueOf(-1.0f), Float.valueOf(0.0f)};
                            Ray ray = new Ray((Number[])pt2.clone(), dir, null);
                            if (this.getCanvas().intersect(ray, pt2)) {
                                x0 = (short)(((Float)pt2[0]).floatValue() - (float)(this.lightSrc.width() - this.lightSrc.xOffset()));
                            } else {
                                dir[0] = Float.valueOf(1.0f);
                                this.getCanvas().intersect(ray, pt2);
                                x0 = (short)(((Float)pt2[0]).floatValue() + (float)(this.lightSrc.width() - this.lightSrc.xOffset()));
                            }
                        }
                    } else {
                        int x1 = this.lightSrc.width() - this.lightSrc.xOffset();
                        x0 = (short)Math.min(this.getWidth() - 2 * bx - x1, x0);
                    }
                } else {
                    pt2 = new Float[]{Float.valueOf(1.0f * (float)x0), Float.valueOf(1.0f * (float)y0)};
                    if (!this.getCanvas().containsLocal(pt2)) {
                        short xp = this.paintedPts.get(this.paintedPts.size() - 2);
                        short yp = this.paintedPts.get(this.paintedPts.size() - 1);
                        Number[] pt1 = new Float[]{Float.valueOf(1.0f * (float)xp), Float.valueOf(1.0f * (float)yp)};
                        Number[] dir = new Float[]{Float.valueOf(((Float)pt2[0]).floatValue() - pt1[0].floatValue()), Float.valueOf(((Float)pt2[1]).floatValue() - pt1[1].floatValue())};
                        this.ctrl.getModel().getFloatMath().normalize(dir);
                        Ray ray = new Ray(pt1, dir, null);
                        this.getCanvas().intersect(ray, pt2);
                        x0 = ((Float)pt2[0]).shortValue();
                        y0 = ((Float)pt2[1]).shortValue();
                    }
                }
                this.paintedPts.add(x0);
                this.paintedPts.add(y0);
            }
            if (req.newray) {
                this.lightSrc.put(this.paintedPts.get(0), this.paintedPts.get(1));
            }
            Visualizer.paintReflections(g, this.paintedPts, this.theme.getRayColor());
            if (this.pattern != null && (defStartEnd = this.findDefPath(this.pattern))[0] != -1 && defStartEnd[1] <= this.paintedPts.size()) {
                Visualizer.paintReflections(g, this.paintedPts.subList(defStartEnd[0], defStartEnd[1]), new Color(255, 43, 82));
            }
            this.lightSrc.paint(g);
        }
        g.translate(-bx, -by);
    }

    public PixelMapAbstract<Float> getFloatPixelMap() {
        if (this.trafoFloat == null) {
            Model<T> model = this.ctrl.getModel();
            Box2D<T> worldBox = model.getWorldBox();
            VecMath<Float> fmath = model.getFloatMath();
            FloatConverter tfltCvtr = new FloatConverter();
            IBox box = worldBox.convert((IConverter)tfltCvtr, fmath);
            Insets insets = this.border.getBorderInsets(this);
            short bx = (short)insets.left;
            short by = (short)insets.top;
            this.trafoFloat = new PixelMapFloat(this.getWidth(), this.getHeight(), bx, by, (Box2D<Float>)box);
        }
        return this.trafoFloat;
    }

    PixelMapAbstract<T> getPixelMap() {
        if (this.trafo == null) {
            Model<T> model = this.ctrl.getModel();
            IBox box = model.getWorldBox().copy();
            VecMath<T> mt = model.getMath();
            Insets insets = this.border.getBorderInsets(this);
            short bx = (short)insets.left;
            short by = (short)insets.top;
            this.trafo = new PixelMap<T>(this.getWidth(), this.getHeight(), bx, by, box, mt);
        }
        return this.trafo;
    }

    private void paintShapes(Graphics g, Iterator<IShape<Float>> it) {
        short[] pixPt = new short[2];
        Number[] wPt = new Float[2];
        PixelMapAbstract<Float> pixMap = this.getFloatPixelMap();
        while (it.hasNext()) {
            IShape<Float> shape = it.next();
            wPt[0] = ((Float[])shape.getCenter())[0];
            wPt[1] = ((Float[])shape.getCenter())[1];
            if (!(shape instanceof Circle)) continue;
            float r = ((Float)((Circle)shape).getRadius()).floatValue();
            Number[] numberArray = wPt;
            Float.valueOf(numberArray[0].floatValue() - r);
            numberArray = wPt;
            Float.valueOf(numberArray[1].floatValue() + r);
            pixMap.world2Pix(wPt, pixPt);
            short r2Pix = pixMap.xLengthWorld2Pix(Float.valueOf(2.0f * r));
            this.fillCircle(g, pixPt[0], pixPt[1], r2Pix);
            this.paintedShapeBounds.add(pixPt[0]);
            this.paintedShapeBounds.add(pixPt[1]);
            this.paintedShapeBounds.add(r2Pix);
            this.paintedShapeBounds.add(r2Pix);
        }
    }

    void requestDefPath(BaseLightPattern<T> b) {
        this.pattern = b;
    }

    short[] findDefPath(BaseLightPattern<T> blp) {
        int i;
        List<short[]> bcs = blp.getCellSequence();
        if (blp.isPropagating()) {
            return new short[]{2, (short)(2 + 2 * bcs.size())};
        }
        ArrayList<Short> cells = new ArrayList<Short>();
        short s = this.ctrl.getModel().getGridSize();
        for (i = 2; i < this.paintedPts.size() - 2; i += 2) {
            for (int j = 0; j < this.paintedShapeBounds.size(); j += 4) {
                Short x = this.paintedPts.get(i);
                Short y = this.paintedPts.get(i + 1);
                float r = this.paintedShapeBounds.get(j + 2) / 2;
                float a = (float)this.paintedShapeBounds.get(j).shortValue() + r;
                float b = (float)this.paintedShapeBounds.get(j + 1).shortValue() + r;
                if (!(((float)x.shortValue() - a) * ((float)x.shortValue() - a) + ((float)y.shortValue() - b) * ((float)y.shortValue() - b) <= (r + 3.0f) * (r + 3.0f))) continue;
                cells.add((short)(j / (4 * s)));
                cells.add((short)(j / 4 % s));
                break;
            }
            if (cells.size() == i) continue;
            return new short[]{-1, -1};
        }
        boolean[] ok = new boolean[]{false, false, false, false};
        int idx = 1;
        for (i = 0; !(i >= cells.size() - 2 * bcs.size() || ok[0] || ok[1] || ok[2] || ok[3]); i += 2) {
            ok = new boolean[]{true, true, true, true};
            for (int j = bcs.size() - 1; j >= 0 && (ok[0] || ok[1] || ok[2] || ok[3]); --j) {
                Short cx = (Short)cells.get(i + 2 * j);
                Short cy = (Short)cells.get(i + 1 + 2 * j);
                if (ok[0]) {
                    boolean bl = ok[0] = cx == bcs.get(j)[idx] && cy == bcs.get(j)[1 - idx];
                }
                if (ok[1]) {
                    boolean bl = ok[1] = cx == s - 1 - bcs.get(j)[idx] && cy == bcs.get(j)[1 - idx];
                }
                if (ok[2]) {
                    boolean bl = ok[2] = cx == bcs.get(j)[idx] && cy == s - 1 - bcs.get(j)[1 - idx];
                }
                if (!ok[3]) continue;
                ok[3] = cx == s - 1 - bcs.get(j)[idx] && cy == s - 1 - bcs.get(j)[1 - idx];
            }
        }
        if (ok[0] || ok[1] || ok[2] || ok[3]) {
            return new short[]{(short)i, (short)(i + bcs.size() * 2)};
        }
        return new short[]{-1, -1};
    }

    private void fillCircle(Graphics g, short ptx, short pty, short s) {
        if (this.circleImg == null || this.circleImg.getHeight() != s) {
            this.circleImg = new BufferedImage(s, s, 2);
            this.refreshCircleImg();
        }
        g.drawImage(this.circleImg, ptx, pty, null);
    }

    private void refreshCircleImg() {
        Graphics ig = this.circleImg.getGraphics();
        ig.setColor(new Color(0, 0, 0, 0));
        int s = this.circleImg.getHeight();
        ig.fillRect(0, 0, s, s);
        ig.setColor(this.theme.getShapeColor());
        ig.fillOval(0, 0, s, s);
    }

    private static void paintReflections(Graphics g, List<Short> pts, Color color) {
        Iterator<Short> iter = pts.iterator();
        if (iter.hasNext()) {
            g.setColor(color);
            short startx = iter.next();
            short starty = iter.next();
            while (iter.hasNext()) {
                short endx = iter.next();
                short endy = iter.next();
                g.drawLine(startx, starty, endx, endy);
                startx = endx;
                starty = endy;
            }
        }
    }

    public void draw(LinkedList<T> coords, Iterator<IShape<Float>> it, boolean c, boolean r) {
        this.queue.push(new PaintRequest(coords, false, c, r, it));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Visualizer.this.paintImmediately(Visualizer.this.getVisibleRect());
            }
        });
    }

    @Override
    public void paintImmediately(int x, int y, int w, int h) {
        this.applPaint = true;
        super.paintImmediately(x, y, w, h);
        this.applPaint = false;
    }

    @Override
    public void paintImmediately(Rectangle r) {
        this.applPaint = true;
        super.paintImmediately(r);
        this.applPaint = false;
    }

    @Override
    public void repaint() {
        if (this.ctrl != null) {
            if (this.queue != null) {
                this.queue.push(this.createPaintAllRequest());
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Visualizer.this.paintImmediately(Visualizer.this.getVisibleRect());
                }
            });
        }
    }

    public PaintRequest createPaintAllRequest() {
        LinkedList data = new LinkedList();
        Model model = this.ctrl.getModel();
        model.getRayDataComplete(data);
        return new PaintRequest(data, true, true, true, model.getShapeIteratorFloat());
    }

    public void setTheme(ColorTheme theme) {
        this.theme = theme;
        if (this.ctrl.getModel().getShape() instanceof Circle && this.circleImg != null) {
            this.refreshCircleImg();
        }
        this.lightSrc.refresh();
        this.border.setColor(theme.getBorderColor());
        if (this.tbo != null) {
            this.tbo.setColor(this.getTheme().getBorderColor());
        }
    }

    public ColorTheme getTheme() {
        return this.theme;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public void setLightSourceType(short lsType) {
        this.lightSrc.setType(lsType);
        this.repaint();
    }

    public void setBorder(IFZLBorder b) {
        this.border = b;
        new ResizeListener().componentResized(new ComponentEvent(this, 0));
        this.repaint();
    }

    public void setTouchOverlay(TouchButtonsOverlay touchButtonsOverlay) {
        this.tbo = touchButtonsOverlay;
        this.tbo.setColor(this.getTheme().getBorderColor());
        TouchButtonsMouseListener tbml = new TouchButtonsMouseListener();
        this.addMouseListener(tbml);
        this.setBorder(new SimpleBorder(50, this.theme.getBorderColor()));
    }

    private final class PaintRequest {
        private LinkedList<T> data;
        boolean background;
        boolean circles;
        boolean newray;
        Iterator<IShape<Float>> iter;

        public PaintRequest(LinkedList<T> d, boolean b, boolean c, boolean r, Iterator<IShape<Float>> it) {
            if (d != null) {
                this.data = new LinkedList(d);
                if (Globals.LOG_VERBOSE && d.size() == 0) {
                    Log.getIstc().logln("WARNING: Empty data paint request!");
                }
            }
            this.background = b;
            this.circles = c;
            this.newray = r;
            this.iter = it;
        }

        public String toString() {
            return "bg:" + this.background + " cr:" + this.circles + " nr:" + this.newray + " sz:" + this.data.size();
        }
    }

    private final class PaintRequestQueue {
        private final ArrayList<PaintRequest> requests = new ArrayList();

        private PaintRequestQueue() {
        }

        public synchronized PaintRequest poll() {
            if (this.requests.size() > 0) {
                return this.requests.remove(this.requests.size() - 1);
            }
            return null;
        }

        public synchronized void push(PaintRequest request) {
            this.requests.add(0, request);
        }

        public int size() {
            return this.requests.size();
        }
    }

    private final class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent ce) {
            boolean stop = Visualizer.this.ctrl.stopCalculation();
            Model model = Visualizer.this.ctrl.getModel();
            VecMath mt = model.getMath();
            Insets ins = Visualizer.this.border.getBorderInsets(Visualizer.this);
            short borderX = (short)ins.left;
            short borderY = (short)ins.top;
            Visualizer.this.ctrl.waitForCalculatorRelease();
            short w = (short)Visualizer.this.getWidth();
            short h = (short)Visualizer.this.getHeight();
            Visualizer.this.getPixelMap().setBorder(borderX, borderY);
            Visualizer.this.getFloatPixelMap().setBorder(borderX, borderY);
            Visualizer.this.getPixelMap().setSreenSize(w, h);
            Visualizer.this.getFloatPixelMap().setSreenSize(w, h);
            Box2D world = model.getWorldBox();
            Box2D newWorld = Visualizer.this.ctrl.createNewWorld(w - 2 * borderX - 1, h - 2 * borderY - 1, mt);
            world.setCorner(newWorld.getCorner());
            if (model.getRay() != null) {
                if (model.updateWorldBox(newWorld)) {
                    Visualizer.this.ctrl.startCalculation();
                } else if (stop) {
                    String descr = model.getDescription();
                    model.setRay(model.getRay(), descr, (byte)1);
                    Visualizer.this.ctrl.startCalculation();
                }
            }
        }
    }

    private final class SelectRayKeyListener
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            if (Visualizer.this.ctrl.isPatAnimRun()) {
                return;
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                boolean upDown = e.getKeyCode() == 38;
                Model model = Visualizer.this.ctrl.getModel();
                if (!Visualizer.this.ctrl.isRotAnimRun()) {
                    Visualizer.this.ctrl.stopCalculation();
                }
                Number[] start = (Number[])model.getRay().getStart().clone();
                T[] dir = model.LIGHT_SOURCE_DIR;
                Ray ray = new Ray(start, dir, model.getMath().util);
                PixelMapAbstract pixMap = Visualizer.this.getPixelMap();
                Object dy = pixMap.yLengthPix2World((short)1);
                start[1] = upDown ? (Number)model.getMath().add(start[1], (Number)dy) : (Number)model.getMath().sub(start[1], (Number)dy);
                if (!Visualizer.this.ctrl.isRotAnimRun()) {
                    Visualizer.this.ctrl.waitForCalculatorRelease();
                    model.setRay(ray, (byte)1);
                    Visualizer.this.ctrl.startCalculation();
                } else {
                    Visualizer.this.ctrl.setRayLater(ray);
                }
            }
        }
    }

    private final class SelectRayMouseListener
    extends MouseAdapter {
        private short[] pt;

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.pt != null) {
                short[] pt2 = Visualizer.this.getPixelMap().toCanvas((short)e.getX(), (short)e.getY());
                this.setRay(pt2, (byte)0);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!Visualizer.this.ctrl.isPatAnimRun()) {
                this.pt = Visualizer.this.getPixelMap().toCanvas((short)e.getX(), (short)e.getY());
                if (!Visualizer.this.lightSrc.hit(this.pt)) {
                    this.pt = null;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.pt != null) {
                short[] pt2 = Visualizer.this.getPixelMap().toCanvas((short)e.getX(), (short)e.getY());
                if (this.pt[0] - pt2[0] != 0 || this.pt[1] - pt2[1] != 0) {
                    this.setRay(pt2, (byte)1);
                }
                this.pt = null;
            }
        }

        private void setRay(short[] pt, byte mode) {
            if (!Visualizer.this.ctrl.isRotAnimRun()) {
                Visualizer.this.ctrl.stopCalculation();
            }
            Model model = Visualizer.this.ctrl.getModel();
            Visualizer.this.getPixelMap().clip2Canvas(pt, (short)1);
            VecMath mt = model.getMath();
            Number[] wp = mt.util.array(2);
            Visualizer.this.getPixelMap().pix2World(pt[0], pt[1], wp);
            wp[0] = mt.util.round(wp[0], 4);
            wp[0] = mt.util.expand(wp[0], mt.PRECISION);
            T[] dir = model.LIGHT_SOURCE_DIR;
            Ray ray = new Ray(wp, dir, model.getMath().util);
            if (!Visualizer.this.ctrl.isRotAnimRun()) {
                Visualizer.this.ctrl.waitForCalculatorRelease();
                model.setRay(ray, mode);
                Visualizer.this.ctrl.startCalculation();
            } else {
                Visualizer.this.ctrl.setRayLater(ray);
            }
        }
    }

    private final class TouchButtonsMouseListener
    extends MouseAdapter {
        boolean releaseRepaint = false;

        private TouchButtonsMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Insets insets = Visualizer.this.border.getBorderInsets(Visualizer.this);
            short bx = (short)insets.left;
            short by = (short)insets.top;
            if (Visualizer.this.tbo.handleButtonPress(Visualizer.this.getWidth(), Visualizer.this.getHeight(), bx, by, e.getX() - bx, e.getY() - by)) {
                Visualizer.this.repaint();
                this.releaseRepaint = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.releaseRepaint) {
                Visualizer.this.repaint();
                this.releaseRepaint = false;
            }
        }
    }

    private final class RotateGridKeyListener
    extends KeyAdapter {
        private RotateGridKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int kc;
            if (!(Visualizer.this.ctrl.isRotAnimRun() || Visualizer.this.ctrl.isPatAnimRun() || (kc = e.getKeyCode()) != 37 && kc != 39)) {
                Model model = Visualizer.this.ctrl.getModel();
                Visualizer.this.ctrl.stopCalculation();
                VecMath math = model.getMath();
                float dphi = e.getKeyCode() == 39 ? -0.001f : 0.001f;
                Number[] sincosphi = math.discrSinCos(dphi);
                Object phi = math.discrAngle(dphi);
                Visualizer.this.ctrl.waitForCalculatorRelease();
                model.setCalcMode((byte)1);
                model.rotateGrid((Number)phi, sincosphi);
                Visualizer.this.ctrl.startCalculation();
            }
        }
    }

    private final class RotateGridListener
    extends MouseAdapter {
        private Float[] pt1;
        private boolean ignore;

        private RotateGridListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!(this.ignore || Visualizer.this.ctrl.isRotAnimRun() || Visualizer.this.ctrl.isPatAnimRun())) {
                short[] pt = Visualizer.this.getPixelMap().toCanvas((short)e.getX(), (short)e.getY());
                if (this.pt1 == null && Visualizer.this.lightSrc.hit(pt)) {
                    this.ignore = true;
                } else {
                    PixelMapAbstract<Float> pixMap = Visualizer.this.getFloatPixelMap();
                    short[] cvpt = pixMap.toCanvas((short)e.getX(), (short)e.getY());
                    Number[] pt2 = new Float[2];
                    pixMap.pix2World(cvpt, pt2);
                    Model model = Visualizer.this.ctrl.getModel();
                    Util util = model.getMath().util;
                    if (model.isInGrid(util.cast((Float[])pt2))) {
                        if (this.pt1 != null) {
                            this.rotateGrid(this.pt1, (Float[])pt2, (byte)0);
                        }
                        this.pt1 = pt2;
                    } else if (this.pt1 == null) {
                        this.ignore = true;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.pt1 != null) {
                PixelMapAbstract<Float> pixMap = Visualizer.this.getFloatPixelMap();
                short[] cvpt = pixMap.toCanvas((short)e.getX(), (short)e.getY());
                Number[] pt2 = new Float[2];
                pixMap.pix2World(cvpt, pt2);
                this.rotateGrid(this.pt1, (Float[])pt2, (byte)1);
            }
            this.pt1 = null;
            this.ignore = false;
        }

        private void rotateGrid(Float[] p1, Float[] p2, byte mode) {
            Visualizer.this.ctrl.stopCalculation();
            float cosphi = p1[0].floatValue() * p2[0].floatValue() + p1[1].floatValue() * p2[1].floatValue();
            cosphi = (float)((double)cosphi / Math.sqrt(p1[0].floatValue() * p1[0].floatValue() + p1[1].floatValue() * p1[1].floatValue()));
            cosphi = (float)((double)cosphi / Math.sqrt(p2[0].floatValue() * p2[0].floatValue() + p2[1].floatValue() * p2[1].floatValue()));
            cosphi = Math.max(Math.min(cosphi, 1.0f), -1.0f);
            float s = Math.signum(p1[0].floatValue() * p2[1].floatValue() - p1[1].floatValue() * p2[0].floatValue());
            float phi = (float)((double)s * Math.acos(cosphi));
            float pifactor = (float)((double)phi / Math.PI);
            VecMath math = Visualizer.this.ctrl.getModel().getMath();
            Number[] sincosphi = math.discrSinCos(pifactor);
            Object discrPhi = math.discrAngle(pifactor);
            Visualizer.this.ctrl.waitForCalculatorRelease();
            Visualizer.this.ctrl.getModel().setCalcMode(mode);
            Visualizer.this.ctrl.getModel().rotateGrid((Number)discrPhi, sincosphi);
            Visualizer.this.ctrl.startCalculation();
        }
    }

    private final class UpdateModelListener
    extends IModelListener {
        private final LinkedList<T> data = new LinkedList();
        boolean newCircleDraw = true;
        boolean newRayDraw = false;

        UpdateModelListener() {
        }

        @Override
        public void modelChanged(byte event) {
            if (event != 50) {
                Visualizer.this.pattern = null;
            }
            switch (event) {
                case 50: {
                    Visualizer.this.trafo = null;
                    Visualizer.this.trafoFloat = null;
                    break;
                }
                case 40: {
                    Visualizer.this.trafo = null;
                    Visualizer.this.trafoFloat = null;
                    Visualizer.this.repaint();
                    break;
                }
                case 10: {
                    this.newRayDraw = true;
                    break;
                }
                case 5: {
                    this.newCircleDraw = true;
                    this.newRayDraw = true;
                    break;
                }
                case 0: {
                    this.newCircleDraw = true;
                    this.newRayDraw = true;
                    break;
                }
                case 8: {
                    this.newCircleDraw = true;
                    this.newRayDraw = true;
                    if (Visualizer.this.tbo == null) break;
                    Visualizer.this.repaint();
                    break;
                }
                case 20: {
                    if (Visualizer.this.queue == null) {
                        this.newCircleDraw = true;
                        this.newRayDraw = true;
                        break;
                    }
                    this.data.clear();
                    Model model = Visualizer.this.ctrl.getModel();
                    model.getRayDataUpdate(this.data);
                    Iterator<IShape<Float>> shapeIter = null;
                    if (this.newCircleDraw || this.newRayDraw) {
                        shapeIter = model.getShapeIteratorFloat();
                    }
                    Visualizer.this.draw(this.data, shapeIter, this.newCircleDraw, this.newRayDraw);
                    this.newCircleDraw = false;
                    this.newRayDraw = false;
                }
            }
        }
    }

    private final class LightSourceSprite {
        private final short[] pos = new short[2];
        private final int[][] pixBuf = new int[10][9];
        private List<Byte> xoffsets;
        private List<byte[][]> defs;
        private BufferedImage img;
        private boolean valid = false;
        private short shape = LIGHT_SOURCES[0];

        LightSourceSprite() {
            this.xoffsets = new ArrayList<Byte>();
            this.defs = new ArrayList<byte[][]>();
            this.defs.add(new byte[][]{{0, 0, 2, 2, 2, 2, 2, 2, 2, 0}, {0, 0, 2, 1, 1, 1, 1, 1, 2, 2}, {0, 0, 2, 2, 2, 2, 2, 2, 1, 2}, {0, 0, 0, 2, 1, 1, 1, 2, 1, 2}, {0, 0, 0, 0, 1, 1, 1, 2, 1, 0}, {0, 0, 0, 2, 1, 1, 1, 2, 1, 2}, {0, 0, 2, 2, 2, 2, 2, 2, 1, 2}, {0, 0, 2, 1, 1, 1, 1, 1, 2, 2}, {0, 0, 2, 2, 2, 2, 2, 2, 2, 0}});
            this.xoffsets.add((byte)4);
            this.defs.add(new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 2, 2, 2, 2, 0}, {2, 2, 2, 1, 2, 1, 2, 1, 2, 2}, {2, 1, 1, 2, 1, 2, 1, 2, 1, 2}, {0, 1, 1, 2, 1, 2, 1, 2, 1, 0}, {2, 1, 1, 2, 1, 2, 1, 2, 1, 2}, {2, 2, 2, 1, 2, 1, 2, 1, 2, 2}, {0, 0, 2, 2, 2, 2, 2, 2, 2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}});
            this.xoffsets.add((byte)1);
            this.defs.add(new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {2, 1, 1, 1, 1, 1, 1, 1, 1, 2}, {2, 1, 1, 2, 2, 2, 2, 2, 1, 2}, {0, 1, 1, 0, 0, 0, 0, 0, 1, 0}, {2, 1, 1, 2, 2, 2, 2, 2, 1, 2}, {2, 1, 1, 1, 1, 1, 1, 1, 1, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2}});
            this.xoffsets.add((byte)1);
            this.setType((short)0);
        }

        void setType(short t) {
            this.shape = t;
            int lastIdx = LIGHT_SOURCES.length - 1;
            if (this.shape != LIGHT_SOURCES[lastIdx]) {
                this.img = new BufferedImage(10, 9, 2);
                Graphics ig = this.img.getGraphics();
                Color trans = new Color(0, 0, 0, 0);
                byte idx = Globals.getIndex(this.shape, LIGHT_SOURCES);
                byte[][] def = this.defs.get(idx);
                for (int i = 0; i < def.length; ++i) {
                    for (int k = 0; k < def[0].length; ++k) {
                        if (def[i][k] == 0) {
                            ig.setColor(trans);
                            ig.drawRect(k, i, 0, 0);
                            continue;
                        }
                        if (def[i][k] != 1) continue;
                        ig.setColor(Visualizer.this.theme.getRayColor().darker());
                        ig.drawRect(k, i, 0, 0);
                    }
                }
                this.drawProtectedRegion();
            }
        }

        void delete() {
            if (this.valid) {
                Insets insets = Visualizer.this.border.getBorderInsets(Visualizer.this);
                short bx = (short)insets.left;
                short by = (short)insets.top;
                short px = (short)(this.pos[0] + bx);
                short py = (short)(this.pos[1] + by);
                for (int i = 0; i < this.pixBuf.length; ++i) {
                    for (int k = 0; k < this.pixBuf[0].length; ++k) {
                        Visualizer.this.bimg.setRGB(px + i - this.xOffset(), py - 4 + k, this.pixBuf[i][k]);
                    }
                }
                this.valid = false;
            }
        }

        void put(short x, short y) {
            Insets insets = Visualizer.this.border.getBorderInsets(Visualizer.this);
            short bx = (short)insets.left;
            short by = (short)insets.top;
            this.pos[0] = (short)Math.min(Visualizer.this.getWidth() - 2 * bx - 10 + this.xOffset(), x);
            this.pos[1] = (short)Math.min(Visualizer.this.getHeight() - 2 * by, y);
            short px = (short)(this.pos[0] + bx);
            short py = (short)(this.pos[1] + by);
            for (int i = 0; i < this.pixBuf.length; ++i) {
                for (int k = 0; k < this.pixBuf[0].length; ++k) {
                    this.pixBuf[i][k] = Visualizer.this.bimg.getRGB(px + i - this.xOffset(), py - 4 + k);
                }
            }
            this.drawProtectedRegion();
            this.valid = true;
        }

        void refresh() {
            this.setType(this.shape);
        }

        int xOffset() {
            byte idx = Globals.getIndex(this.shape, LIGHT_SOURCES);
            return idx < this.xoffsets.size() ? (int)this.xoffsets.get(idx).byteValue() : 0;
        }

        int width() {
            return this.pixBuf.length;
        }

        private void drawProtectedRegion() {
            byte idx = Globals.getIndex(this.shape, LIGHT_SOURCES);
            if (idx != LIGHT_SOURCES.length - 1) {
                byte[][] def = this.defs.get(idx);
                Graphics ig = this.img.getGraphics();
                for (int i = 0; i < def.length; ++i) {
                    for (int k = 0; k < def[0].length; ++k) {
                        if (def[i][k] != 2) continue;
                        ig.setColor(new Color(this.pixBuf[k][i]));
                        ig.drawRect(k, i, 0, 0);
                    }
                }
            }
        }

        boolean hit(short[] xy) {
            short dx = (short)(xy[0] - this.pos[0]);
            short dy = (short)(xy[1] - this.pos[1]);
            return dx * dx + dy * dy < 400;
        }

        void paint(Graphics g) {
            int lastIdx = LIGHT_SOURCES.length - 1;
            if (this.shape != LIGHT_SOURCES[lastIdx]) {
                g.drawImage(this.img, this.pos[0] - this.xOffset(), this.pos[1] - 4, null);
            }
        }
    }
}

