/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.ColorTheme;
import common.ICallback;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import lattice.IBox;
import mvc.Controller;
import mvc.IModelListener;
import mvc.LightPatternSelector;
import mvc.MainMenuBar;
import mvc.TouchButtonsOverlay;
import mvc.Visualizer;
import mvc.scan.ScanMenuBar;
import mvc.scan.ScanVisualizer;
import mvc.var.VariableMenuBar;
import mvc.var.VariableVisualizer;
import pattern.BaseLightPattern;

public final class View<T extends Number>
extends JFrame {
    private static final String TITLE_BASE = "FroZenLight";
    private final Controller<T> ctrl;
    private final Visualizer<T> reflVis;
    private ScanVisualizer<T> scanVis;
    private VariableVisualizer<T> varVis;
    private MainMenuBar<T> menuBar;
    private LightPatternSelector<T> lpSel;

    public View(final Controller<T> ctrl, ColorTheme ct, ICallback cb, byte win) {
        super(TITLE_BASE);
        boolean mu;
        boolean muf;
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        boolean scrs = win == 2;
        boolean bl = muf = win == 6;
        if (win == 1 || scrs || muf) {
            this.setUndecorated(true);
            this.setResizable(false);
        } else {
            rect = new Rectangle(Math.min(650, rect.width), Math.min(500, rect.height));
        }
        this.ctrl = ctrl;
        this.reflVis = new Visualizer<T>(ctrl, ct, cb, scrs);
        this.menuBar = new MainMenuBar(this, ct);
        boolean bl2 = mu = muf || win == 5;
        if (mu) {
            List<BaseLightPattern<T>> lps = ctrl.getModel().getMuseumPatterns();
            this.reflVis.setTouchOverlay(new TouchButtonsOverlay<T>(lps, this.menuBar));
        }
        this.initGUI(ct, !scrs && !mu, rect);
        ctrl.getModel().addModelListener(new IModelListener(){

            @Override
            public void modelChanged(byte event) {
                switch (event) {
                    case 10: {
                        if (View.this.getTitle().indexOf("-") == -1) break;
                        View.this.setTitle(View.TITLE_BASE);
                        break;
                    }
                    case 30: {
                        String descr = ctrl.getModel().getDescription();
                        if (descr == null || descr.compareTo("") == 0) break;
                        View.this.setTitle("FroZenLight - " + descr);
                    }
                }
            }
        });
    }

    private void initGUI(ColorTheme ct, boolean mb, Rectangle rect) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        if (mb) {
            Dimension d = this.menuBar.getPreferredSize();
            this.menuBar.setMinimumSize(new Dimension(10, d.height));
            gridbag.setConstraints(this.menuBar, c);
            this.getContentPane().add(this.menuBar);
            c.gridy = 1;
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag.setConstraints(this.reflVis, c);
        this.getContentPane().add(this.reflVis);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setSize(rect.width, rect.height);
        this.setVisible(true);
        this.reflVis.paintImmediately(this.reflVis.getVisibleRect());
        if (this.menuBar != null) {
            this.menuBar.paintImmediately(this.reflVis.getVisibleRect());
        }
    }

    public Visualizer<T> getReflectionVisualizer() {
        return this.reflVis;
    }

    public JFrame createScanView() {
        if (this.scanVis == null) {
            this.scanVis = new ScanVisualizer<T>(this.ctrl);
            JFrame scanViewFrame = new JFrame("Scanner");
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            scanViewFrame.getContentPane().setLayout(gridbag);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 1;
            final ScanMenuBar<T> scanMenuBar = new ScanMenuBar<T>(this.scanVis);
            Dimension d = scanMenuBar.getPreferredSize();
            scanMenuBar.setMinimumSize(new Dimension(40, d.height));
            gridbag.setConstraints(scanMenuBar, c);
            scanViewFrame.getContentPane().add(scanMenuBar);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 1;
            c.gridheight = 1;
            gridbag.setConstraints(this.scanVis, c);
            scanViewFrame.getContentPane().add(this.scanVis);
            scanViewFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    this.closeAction();
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    this.closeAction();
                }

                private void closeAction() {
                    View.this.ctrl.stopScan("Stopped on close");
                    if (View.this.scanVis != null) {
                        View.this.scanVis.onDelete();
                        scanMenuBar.onDelete();
                        View.this.scanVis = null;
                    }
                    if (View.this.varVis != null) {
                        View.this.varVis.setScannerTabEnabled(false);
                    }
                }
            });
            scanViewFrame.pack();
            scanViewFrame.setDefaultCloseOperation(2);
            scanViewFrame.setVisible(true);
            scanMenuBar.postInit();
            return scanViewFrame;
        }
        return null;
    }

    public ScanVisualizer<T> getScanVisualizer() {
        return this.scanVis;
    }

    public VariableVisualizer<T> getVariableVisualizer() {
        return this.varVis;
    }

    public Controller<T> getController() {
        return this.ctrl;
    }

    public JFrame createVariableView() {
        if (this.varVis == null) {
            this.varVis = new VariableVisualizer<T>(this.ctrl);
            if (this.scanVis != null) {
                this.varVis.setScannerTabEnabled(true);
                IBox box = this.scanVis.getPixelMap().getWorldBox();
                this.varVis.updateScannerFrameFields(box);
                this.varVis.updateScannerObsFields(this.scanVis.getObservables());
            }
            JFrame varViewFrame = new JFrame("Variables");
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            varViewFrame.getContentPane().setLayout(gridbag);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.gridwidth = 1;
            c.gridheight = 1;
            final VariableMenuBar<T> vmb = new VariableMenuBar<T>(this.varVis);
            Dimension d = vmb.getPreferredSize();
            vmb.setMinimumSize(new Dimension(10, d.height));
            gridbag.setConstraints(vmb, c);
            varViewFrame.getContentPane().add(vmb);
            c.fill = 1;
            c.insets = new Insets(10, 10, 10, 10);
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 1;
            c.gridheight = 1;
            gridbag.setConstraints(this.varVis, c);
            varViewFrame.getContentPane().add(this.varVis);
            varViewFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (View.this.varVis != null) {
                        View.this.varVis.onDelete();
                        vmb.onDelete();
                        View.this.varVis = null;
                    }
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    if (View.this.varVis != null) {
                        View.this.varVis.onDelete();
                        vmb.onDelete();
                        View.this.varVis = null;
                    }
                }
            });
            varViewFrame.pack();
            varViewFrame.setDefaultCloseOperation(2);
            varViewFrame.setVisible(true);
            return varViewFrame;
        }
        return null;
    }

    MainMenuBar<T> getMainMenuBar() {
        return this.menuBar;
    }

    public LightPatternSelector<T> getLightPatternSelector() {
        if (this.lpSel == null) {
            this.lpSel = new LightPatternSelector(this);
        }
        return this.lpSel;
    }

    public void setLightSource(short lsType) {
        this.reflVis.setLightSourceType(lsType);
    }

    public void setFullScreen() {
        this.dispose();
        this.setUndecorated(true);
        this.setResizable(false);
        Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setSize(rect.width, rect.height);
        this.setLocation(0, 0);
        this.setVisible(true);
        this.reflVis.repaint();
    }

    public void setMuseum() {
        this.getContentPane().remove(this.menuBar);
        List<BaseLightPattern<T>> lps = this.ctrl.getModel().getMuseumPatterns();
        this.reflVis.setTouchOverlay(new TouchButtonsOverlay<T>(lps, this.menuBar));
        this.reflVis.repaint();
    }
}

