/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.Globals;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lattice.Box2D;
import lattice.EllipseFloat;
import math.VecMathFloat;
import mvc.MainMenuBar;
import pattern.BaseLightPattern;

class TouchButtonsOverlay<T extends Number> {
    private final List<BaseLightPattern<T>> lightPatterns;
    private final MainMenuBar<T> menuBar;
    private final EllipseFloat frame;
    private Font font;
    private Color color;
    int hit_j = -1;
    int hit_i = -1;
    int hit_gr = -1;
    short themeIdx = 0;

    TouchButtonsOverlay(List<BaseLightPattern<T>> lps, MainMenuBar<T> mb) {
        this.lightPatterns = lps;
        Collections.sort(this.lightPatterns, new Comparator<BaseLightPattern<T>>(){

            @Override
            public int compare(BaseLightPattern<T> p1, BaseLightPattern<T> p2) {
                if (p1.getGridSize() < p2.getGridSize()) {
                    return -1;
                }
                if (p1.getGridSize() > p2.getGridSize()) {
                    return 1;
                }
                return 0;
            }
        });
        this.menuBar = mb;
        this.frame = new EllipseFloat(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)}, Float.valueOf(1.0f), new VecMathFloat());
        this.color = Color.LIGHT_GRAY;
    }

    void paintButtons(Graphics g, int w, int h, int bx, int by) {
        int d = (int)(Math.sqrt((w - bx) * (h - by)) / 16.0);
        if (this.font == null || this.font.getSize() != d / 5) {
            this.font = new Font(g.getFont().getName(), 0, d / 5);
        }
        g.setFont(this.font);
        g.setColor(this.color);
        this.paint(g, -d / 2 + 5, d, -d / 2 + 5, d, (int)((double)d * 0.8), 0);
        this.paint(g, w - 2 * bx + d / 2 - 5, -d, -d / 2 + 5, d, (int)((double)d * 0.8), 1);
        this.paint(g, -d / 2 + 5, d, h - 2 * by + d / 2 - 5, -d, (int)((double)d * 0.8), 2);
        this.paint(g, w - 2 * bx + d / 2 - 5, -d, h - 2 * by + d / 2 - 5, -d, (int)((double)d * 0.8), 3);
    }

    private void paint(Graphics g, int xs, int dx, int ys, int dy, int h, int gr) {
        Graphics2D g2D = (Graphics2D)g;
        FontMetrics fm = g.getFontMetrics();
        int sh = fm.getHeight();
        int pos = gr * 6;
        int[] cnt = new int[]{4, 2, 1};
        for (int j = 1; j <= 3; ++j) {
            for (int i = 1; i <= cnt[j - 1]; ++i) {
                if (this.hit_j == j && this.hit_i == i && this.hit_gr == gr) {
                    g.setColor(Color.pink);
                    this.hit_j = -1;
                    this.hit_i = -1;
                    this.hit_gr = -1;
                } else {
                    g.setColor(Color.DARK_GRAY);
                }
                g.fillRoundRect(xs + i * dx - h / 2, ys + j * dy - h / 2, h, h, 10, 10);
                g.setColor(this.color);
                g2D.setStroke(new BasicStroke(2.0f));
                g.drawRoundRect(xs + i * dx - h / 2, ys + j * dy - h / 2, h, h, 10, 10);
                g2D.setStroke(new BasicStroke(1.0f));
                if (i == cnt[0]) {
                    switch (gr) {
                        case 0: {
                            String s = "?";
                            int sw = fm.stringWidth(s);
                            int x0 = xs + i * dx;
                            int y0 = ys + j * dy;
                            g.drawString(s, x0 - sw, y0);
                            g2D.setStroke(new BasicStroke(2.0f));
                            g.drawPolyline(new int[]{x0 - 2 * sw, x0 - sw / 2, x0 + sw, x0 + 2 * sw, x0 + 2 * sw}, new int[]{y0 + sh, y0 + sh / 2, y0 + sh, y0, y0 - sh}, 5);
                            break;
                        }
                        case 1: {
                            int h1 = (int)(1.3 * (double)h);
                            g.fillOval(xs + i * dx - h1 / 4, ys + j * dy - h1 / 4, h1 / 2, h1 / 2);
                            String s = (Globals.IDX_SHAPE_SIZE + 1) * 10 + "%";
                            int sw = fm.stringWidth(s);
                            g.setColor(Color.DARK_GRAY);
                            g.drawString(s, xs + i * dx - sw / 2, ys + j * dy + sh / 2 - 2);
                            break;
                        }
                        case 2: {
                            g.fillRect(xs + i * dx - h / 4, ys + j * dy - h / 4, h / 4, h / 4);
                            g.setColor(this.color.brighter());
                            g.fillRect(xs + i * dx - h / 4, ys + j * dy, h / 4, h / 4);
                            g.setColor(this.color.darker());
                            g.fillRect(xs + i * dx, ys + j * dy - h / 4, h / 4, h / 4);
                            g.setColor(this.color.darker().darker());
                            g.fillRect(xs + i * dx, ys + j * dy, h / 4, h / 4);
                            g.setColor(this.color);
                            break;
                        }
                        case 3: {
                            for (int k = -h / 4; k <= h / 4; k += 2) {
                                g.drawLine(xs + i * dx - h / 4, ys + j * dy + k, xs + i * dx + h / 4 + 1, ys + j * dy + k);
                            }
                            break;
                        }
                    }
                    continue;
                }
                String s1 = "?";
                String s2 = "?";
                String s3 = "?";
                if (pos < this.lightPatterns.size()) {
                    BaseLightPattern<T> lp = this.lightPatterns.get(pos++);
                    String bnd = lp.getStartBndValType() == 0 ? "p" : "g";
                    bnd = bnd + (lp.getEndBndValType() == 0 ? "p" : "g");
                    s1 = lp.getGridSize() + " x " + lp.getGridSize();
                    s2 = lp.getCellSequence().size() + "";
                    s3 = bnd + " " + ((Number)lp.getMaxShapeSize()).intValue() + "%";
                }
                int sw1 = fm.stringWidth(s1);
                int sw2 = fm.stringWidth(s2);
                int sw3 = fm.stringWidth(s3);
                g.drawString(s1, xs + i * dx - sw1 / 2, ys + j * dy - sh / 2 - 2);
                g.drawString(s2, xs + i * dx - sw2 / 2, ys + j * dy + sh / 2 - 2);
                g.drawString(s3, xs + i * dx - sw3 / 2, ys + j * dy + 3 * sh / 2 - 2);
            }
        }
        g2D.setStroke(new BasicStroke(1.0f));
    }

    boolean handleButtonPress(int w, int h, int bx, int by, int xm, int ym) {
        int d = (int)(Math.sqrt(w * h) / 17.0);
        if (this.hit(-d / 2 + 5, d, -d / 2 + 5, d, (int)((double)d * 0.8), 0, xm, ym)) {
            return true;
        }
        if (this.hit(w - 2 * bx + d / 2 - 5, -d, -d / 2 + 5, d, (int)((double)d * 0.8), 1, xm, ym)) {
            return true;
        }
        if (this.hit(-d / 2 + 5, d, h - 2 * by + d / 2 - 5, -d, (int)((double)d * 0.8), 2, xm, ym)) {
            return true;
        }
        return this.hit(w - 2 * bx + d / 2 - 5, -d, h - 2 * by + d / 2 - 5, -d, (int)((double)d * 0.8), 3, xm, ym);
    }

    private boolean hit(int xs, int dx, int ys, int dy, int h, int gr, int xm, int ym) {
        int pos = gr * 6;
        int[] cnt = new int[]{4, 2, 1};
        for (int j = 1; j <= 3; ++j) {
            for (int i = 1; i <= cnt[j - 1]; ++i) {
                int x = xs + i * dx;
                int y = ys + j * dy;
                if (Math.abs(x - xm) < h / 2 && Math.abs(y - ym) < h / 2) {
                    this.hit_j = j;
                    this.hit_i = i;
                    this.hit_gr = gr;
                    if (i == cnt[0]) {
                        switch (gr) {
                            case 0: {
                                this.showPath();
                                break;
                            }
                            case 1: {
                                this.incRadius();
                                break;
                            }
                            case 2: {
                                this.changeTheme();
                                break;
                            }
                            case 3: {
                                this.animation();
                            }
                        }
                    } else {
                        this.selectPattern(pos);
                    }
                    return true;
                }
                if (i == cnt[0]) continue;
                ++pos;
            }
        }
        return false;
    }

    private void incRadius() {
        byte idx = (byte)((Globals.IDX_SHAPE_SIZE + 1) % Globals.SHAPE_SIZES.length);
        this.menuBar.setSelectedIdx(idx, this.menuBar.shapeSizeMenu, true);
    }

    private void selectPattern(int pos) {
        if (pos < this.lightPatterns.size()) {
            String name = this.lightPatterns.get(pos).getName();
            this.menuBar.setSelected(name, this.menuBar.patternMenu, true);
        }
    }

    private void changeTheme() {
        int c = this.menuBar.themeMenu.getItemCount();
        this.themeIdx = (short)(this.themeIdx + 1);
        this.menuBar.setSelectedIdx((short)(this.themeIdx % c), this.menuBar.themeMenu, true);
    }

    private void animation() {
        this.menuBar.setSelected("Medium", this.menuBar.animMenu, true);
    }

    private void showPath() {
        this.menuBar.setSelected("Show Defining Path", this.menuBar.patternMenu, true);
    }

    public Box2D<Float> getCanvas() {
        return this.frame;
    }

    public void setColor(Color c) {
        int rgb = -1;
        while (c.getRGB() != rgb && c.getRed() + c.getGreen() + c.getBlue() < 500) {
            rgb = c.getRGB();
            c = c.brighter();
        }
        this.color = c;
    }

    public void paintBackround(Graphics g, int w, int h, int bx, int by, Color c) {
        g.translate(bx, by);
        g.setColor(Color.black);
        g.fillRect(0, 0, w - 2 * bx, h - 2 * by);
        g.setColor(c);
        g.fillOval(0, 0, w - 2 * bx, h - 2 * by);
    }
}

