/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.FloatConverter;
import common.Log;
import java.util.ArrayList;
import java.util.List;
import lattice.Box2D;
import lattice.IBox;
import lattice.Ray;
import lattice.RayPolygon;
import lattice.ReflectionEngine;
import lattice.ShapeContainer;
import math.VecMath;
import mvc.Model;
import mvc.PixelMap;
import mvc.scan.Observables;
import mvc.scan.ScanListener;

public final class ScanSession<T extends Number> {
    private T[] sincos;
    private PixelMap<T> pixMap;
    private T yStart;
    private int col;
    private T dy;
    private int maxPos;
    private int pos = 0;
    private int processed = 0;
    private boolean active = false;
    private Model<T> model;
    boolean stop = false;
    ShapeContainer<T> tCtr;
    String msg;
    public Observables obs;

    public ScanSession(Model<T> model) {
        this.model = model;
    }

    void init(PixelMap<T> pmap, Observables o) {
        this.model.initScanSession(pmap, this);
        this.obs = o;
        this.pixMap = pmap;
        T dphi = pmap.xLengthPix2World((short)1);
        Log.getIstc().logln("Calculating sin/cos for incremental rotation dphi...");
        this.sincos = this.model.getMath().sincos((Number)dphi);
    }

    public IBox<T> getInitBox() {
        return this.pixMap.getWorldBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanObservables() {
        int i;
        List<ScanListener> scanListeners;
        VecMath<Number> tmath = this.model.getMath();
        Number[] dir = tmath.util.array(2);
        dir[0] = tmath.util.cast(-1);
        dir[1] = tmath.ZERO;
        Number[] start = tmath.util.array(2);
        start[0] = tmath.neg(this.model.getWorldBox().getCorner()[0]);
        List<ScanListener> list = scanListeners = this.model.getScanListeners();
        synchronized (list) {
            for (ScanListener sl : scanListeners) {
                sl.start();
            }
        }
        ArrayList<ScanRbl> rbls = new ArrayList<ScanRbl>();
        for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            ReflectionEngine<T> reflCalc = new ReflectionEngine<T>(tmath);
            reflCalc.setOutputType((byte)0);
            ShapeContainer<T> ctr = new ShapeContainer<T>(this.tCtr, tmath);
            RayPolygon poly = new RayPolygon(tmath.util, 8);
            Ray scanRay = new Ray((Number[])start.clone(), (Number[])dir.clone(), tmath.util);
            VecMath<Float> fmath = this.model.getFloatMath();
            Box2D fbox = new Box2D((Number[])((Float[])fmath.ZERO2D).clone(), (Number)Float.valueOf(2.0f), fmath);
            rbls.add(new ScanRbl(reflCalc, ctr, poly, scanRay, fbox));
        }
        this.maxPos = this.obs.reflCnt[0].length - 1;
        this.dy = this.pixMap.yLengthPix2World((short)1);
        this.yStart = this.pixMap.yPix2World((short)0);
        for (i = 0; i < rbls.size(); ++i) {
            if (i <= 0) continue;
            new Thread((Runnable)rbls.get(i)).start();
        }
        for (i = 0; i < this.obs.reflCnt.length && !this.stop; i = (int)((short)(i + 1))) {
            this.col = i;
            this.reset();
            int p22 = this.nextPos();
            while (p22 != -1 && !this.stop) {
                ((ScanRbl)rbls.get(0)).scan(p22);
                p22 = this.nextPos();
            }
            Observables p22 = this.obs;
            synchronized (p22) {
                while (this.processed < this.maxPos && !this.stop) {
                    try {
                        this.obs.wait();
                    }
                    catch (InterruptedException ctr) {}
                }
            }
            for (int k = 0; k < rbls.size(); ++k) {
                this.model.rotateGrid((Number[])this.sincos, ((ScanRbl)rbls.get(k)).ctr);
            }
        }
        this.stop = true;
        this.reset();
        List<ScanListener> list2 = scanListeners;
        synchronized (list2) {
            for (ScanListener sl : scanListeners) {
                sl.stop(this.msg);
            }
        }
    }

    synchronized int nextPosOrWait() {
        while (!this.active) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.pos > this.maxPos) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.nextPosOrWait();
        }
        return ++this.pos - 1;
    }

    synchronized int nextPos() {
        return this.pos > this.maxPos ? -1 : ++this.pos - 1;
    }

    synchronized void reset() {
        this.pos = 0;
        this.active = true;
        this.processed = 0;
        this.notifyAll();
    }

    private class ScanRbl
    implements Runnable {
        private ReflectionEngine<T> reflCalc;
        private ShapeContainer<T> ctr;
        private RayPolygon<T> poly;
        private Ray<T> scanRay;
        private IBox<Float> fbox;

        ScanRbl(ReflectionEngine<T> re, ShapeContainer<T> sc, RayPolygon<T> rp, Ray<T> r, IBox<Float> fb) {
            this.reflCalc = re;
            this.ctr = sc;
            this.poly = rp;
            this.scanRay = r;
            this.fbox = fb;
        }

        @Override
        public void run() {
            while (!ScanSession.this.stop) {
                this.scan(ScanSession.this.nextPosOrWait());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan(int row) {
            Number[] start = this.scanRay.getStart();
            VecMath<Number> tmath = ScanSession.this.model.getMath();
            start[1] = tmath.sub(ScanSession.this.yStart, tmath.mul(ScanSession.this.dy, row));
            this.reflCalc.calcDynamic(this.scanRay, this.ctr, this.poly, null);
            ScanSession.this.obs.reflCnt[((ScanSession)ScanSession.this).col][row] = this.poly.size();
            VecMath<Float> fmath = ScanSession.this.model.getFloatMath();
            FloatConverter tfltCvtr = new FloatConverter();
            ScanSession.this.obs.length[((ScanSession)ScanSession.this).col][row] = this.poly.calcLength(this.fbox, tfltCvtr, fmath);
            ScanSession.this.obs.obs1[((ScanSession)ScanSession.this).col][row] = (float)ScanSession.this.obs.reflCnt[ScanSession.this.col][row] / ScanSession.this.obs.length[ScanSession.this.col][row];
            List<ScanListener> scanListeners = ScanSession.this.model.getScanListeners();
            Observables observables = ScanSession.this.obs;
            synchronized (observables) {
                boolean maxChange = ScanSession.this.obs.length[ScanSession.this.col][row] > ScanSession.this.obs.maxLength;
                ScanSession.this.obs.maxLengthChanged |= maxChange;
                if (maxChange) {
                    ScanSession.this.obs.maxLength = ScanSession.this.obs.length[ScanSession.this.col][row];
                }
                maxChange = ScanSession.this.obs.reflCnt[ScanSession.this.col][row] > ScanSession.this.obs.maxReflCnt;
                ScanSession.this.obs.maxReflCntChanged |= maxChange;
                if (maxChange) {
                    ScanSession.this.obs.maxReflCnt = ScanSession.this.obs.reflCnt[ScanSession.this.col][row];
                }
                maxChange = ScanSession.this.obs.obs1[ScanSession.this.col][row] > ScanSession.this.obs.maxObs1;
                ScanSession.this.obs.maxObs1Changed |= maxChange;
                if (maxChange) {
                    ScanSession.this.obs.maxObs1 = ScanSession.this.obs.obs1[ScanSession.this.col][row];
                }
                for (ScanListener sl : scanListeners) {
                    sl.update(ScanSession.this.col, row);
                }
                if (++ScanSession.this.processed == ScanSession.this.maxPos || ScanSession.this.stop) {
                    ScanSession.this.obs.notify();
                }
            }
        }
    }
}

