/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import lattice.Box2D;
import mvc.PixelMapAbstract;

public final class PixelMapFloat
extends PixelMapAbstract<Float> {
    private float worldWidth;
    private float worldHeight;
    private float[] worldCorner;
    private float invWorldWidth;
    private float invWorldHeight;
    private float invCanvWidth;
    private float invCanvHeight;

    public PixelMapFloat(int w, int h, short bx, short by, Box2D<Float> world) {
        super(w, h, bx, by, world);
        this.invCanv();
        this.updateWorldVariables();
    }

    private void invCanv() {
        short cw = this.canvasWidth();
        short ch = this.canvasHeight();
        this.invCanvWidth = cw > 0 ? 1.0f / (float)cw : 1.0f;
        this.invCanvHeight = ch > 0 ? 1.0f / (float)ch : 1.0f;
    }

    private void updateWorldVariables() {
        this.worldWidth = ((Float[])this.box.getLengths())[0].floatValue();
        this.worldHeight = ((Float[])this.box.getLengths())[1].floatValue();
        this.invWorldWidth = 1.0f / this.worldWidth;
        this.invWorldHeight = 1.0f / this.worldHeight;
        this.worldCorner = new float[2];
        this.worldCorner[0] = ((Float[])this.box.getCorner())[0].floatValue();
        this.worldCorner[1] = ((Float[])this.box.getCorner())[1].floatValue();
    }

    @Override
    public short xWorld2Pix(Float x) {
        return (short)Math.round((x.floatValue() - this.worldCorner[0]) * this.invWorldWidth * (float)this.canvasWidth());
    }

    @Override
    public short yWorld2Pix(Float y) {
        float y1 = 1.0f - (y.floatValue() - this.worldCorner[1]) * this.invWorldHeight;
        return (short)Math.round(y1 * (float)this.canvasHeight());
    }

    @Override
    public short xLengthWorld2Pix(Float x) {
        return (short)Math.round(Math.abs(this.xWorld2Pix(Float.valueOf(0.0f)) - this.xWorld2Pix(x)));
    }

    @Override
    public short yLengthWorld2Pix(Float y) {
        return (short)Math.round(Math.abs(this.yWorld2Pix(Float.valueOf(0.0f)) - this.yWorld2Pix(y)));
    }

    @Override
    public Float xPix2World(short xpix) {
        float t1 = this.worldWidth * (float)xpix;
        return Float.valueOf(t1 * this.invCanvWidth + this.worldCorner[0]);
    }

    @Override
    public Float yPix2World(short ypix) {
        float t1 = this.worldHeight + this.worldCorner[1];
        float t2 = this.worldHeight * (float)ypix;
        return Float.valueOf(t1 - t2 * this.invCanvHeight);
    }

    @Override
    public void setSreenSize(short width, short height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.invCanv();
        }
    }

    @Override
    public void worldChanged(Box2D<Float> newBox) {
        super.worldChanged(newBox);
        this.updateWorldVariables();
    }

    @Override
    public Float xLengthPix2World(short x) {
        return Float.valueOf(Math.abs(this.xPix2World((short)0).floatValue() - this.xPix2World(x).floatValue()));
    }

    @Override
    public Float yLengthPix2World(short y) {
        return Float.valueOf(Math.abs(this.yPix2World((short)0).floatValue() - this.yPix2World(y).floatValue()));
    }

    @Override
    public void setBorder(short bx, short by) {
        super.setBorder(bx, by);
        this.invCanv();
    }
}

