/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import java.awt.Rectangle;
import lattice.Box2D;
import lattice.IBox;

public abstract class PixelMapAbstract<T extends Number> {
    private short borderX;
    private short borderY;
    protected int width;
    protected int height;
    protected final Box2D<T> box;

    public PixelMapAbstract(int w, int h, short bx, short by, Box2D<T> worldBox) {
        this.borderX = bx;
        this.borderY = by;
        this.width = w;
        this.height = h;
        this.box = worldBox;
    }

    public abstract short xWorld2Pix(T var1);

    public abstract short yWorld2Pix(T var1);

    public final void world2Pix(T[] xy, short[] ret) {
        ret[0] = this.xWorld2Pix(xy[0]);
        ret[1] = this.yWorld2Pix(xy[1]);
    }

    public abstract T xPix2World(short var1);

    public abstract T yPix2World(short var1);

    public final void pix2World(short xpix, short ypix, T[] ret) {
        ret[0] = this.xPix2World(xpix);
        ret[1] = this.yPix2World(ypix);
    }

    public final void pix2World(short[] pix, T[] ret) {
        ret[0] = this.xPix2World(pix[0]);
        ret[1] = this.yPix2World(pix[1]);
    }

    public abstract short xLengthWorld2Pix(T var1);

    public abstract short yLengthWorld2Pix(T var1);

    public abstract T xLengthPix2World(short var1);

    public abstract T yLengthPix2World(short var1);

    public final Rectangle box2Pix(Box2D<T> b) {
        short[] corner = new short[2];
        this.world2Pix(b.getCorner(), corner);
        this.toScreen(corner);
        short[] lengths = new short[]{this.xLengthWorld2Pix(b.getLengths()[0]), this.yLengthWorld2Pix(b.getLengths()[1])};
        return new Rectangle(corner[0], corner[1] - lengths[1], lengths[0], lengths[1]);
    }

    public final short toCanvasX(short s) {
        return (short)(s - this.borderX);
    }

    public final short toCanvasY(short s) {
        return (short)(s - this.borderY);
    }

    public final short[] toCanvas(short x, short y) {
        return new short[]{this.toCanvasX(x), this.toCanvasY(y)};
    }

    public final void clip2Canvas(short[] xy, short margin) {
        xy[0] = xy[0] < margin ? margin : xy[0];
        xy[0] = (short)(xy[0] > this.canvasWidth() - margin ? this.canvasWidth() - margin : xy[0]);
        xy[1] = xy[1] < margin ? margin : xy[1];
        xy[1] = (short)(xy[1] > this.canvasHeight() - margin ? this.canvasHeight() - margin : xy[1]);
    }

    public final short toScreenX(short s) {
        return (short)(s + this.borderX);
    }

    public final short toScreenY(short s) {
        return (short)(s + this.borderY);
    }

    public final void toScreen(short[] s) {
        s[0] = this.toScreenX(s[0]);
        s[1] = this.toScreenY(s[1]);
    }

    public final short canvasWidth() {
        return (short)(this.width - 2 * this.borderX);
    }

    public final short canvasHeight() {
        return (short)(this.height - 2 * this.borderY);
    }

    public abstract void setSreenSize(short var1, short var2);

    public void worldChanged(Box2D<T> newWorld) {
        this.box.setCorner(newWorld.getCorner());
        this.box.setLengths(newWorld.getLengths());
    }

    public final IBox<T> getWorldBox() {
        return this.box;
    }

    public void setBorder(short bx, short by) {
        this.borderX = bx;
        this.borderY = by;
    }
}

