/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import lattice.Box2D;
import math.VecMath;
import mvc.PixelMapAbstract;

public final class PixelMap<T extends Number>
extends PixelMapAbstract<T> {
    private final VecMath<T> math;
    private T invBoxWidth;
    private T invBoxHeight;
    private T invCanvHeight;
    private T invCanvWidth;

    public PixelMap(int w, int h, short bx, short by, Box2D<T> world, VecMath<T> math) {
        super(w, h, bx, by, world);
        this.math = math;
        this.invCanv();
        this.invBoxWidth = math.inv(this.box.getWidth());
        this.invBoxHeight = math.inv(this.box.getHeight());
    }

    private void invCanv() {
        short cw = this.canvasWidth();
        short ch = this.canvasHeight();
        this.invCanvWidth = cw > 0 ? this.math.inv(this.math.util.cast(cw)) : this.math.ONE;
        this.invCanvHeight = ch > 0 ? this.math.inv(this.math.util.cast(ch)) : this.math.ONE;
    }

    @Override
    public short xWorld2Pix(T x) {
        T x1 = this.math.mul(this.invBoxWidth, this.canvasWidth());
        Number x2 = this.math.sub((Number)x, this.box.getCorner()[0]);
        return this.math.mul((Number)x1, x2).shortValue();
    }

    @Override
    public short yWorld2Pix(T y) {
        Number y1 = this.math.sub((Number)this.math.ONE, this.math.mul(this.math.sub((Number)y, this.box.getCorner()[1]), (Number)this.invBoxHeight));
        return this.math.mul(y1, this.canvasHeight()).shortValue();
    }

    @Override
    public T xPix2World(short xpix) {
        Object t1 = this.math.mul(this.box.getWidth(), xpix);
        return (T)this.math.add((Number)this.math.mul(t1, this.invCanvWidth), this.box.getCorner()[0]);
    }

    @Override
    public T yPix2World(short ypix) {
        Number t1 = this.math.add((Number)this.box.getHeight(), this.box.getCorner()[1]);
        Object t2 = this.math.mul(this.box.getHeight(), ypix);
        return (T)this.math.sub(t1, (Number)this.math.mul(t2, this.invCanvHeight));
    }

    @Override
    public short xLengthWorld2Pix(T x) {
        return (short)Math.abs(this.xWorld2Pix(this.math.ZERO) - this.xWorld2Pix(x));
    }

    @Override
    public short yLengthWorld2Pix(T y) {
        return (short)Math.abs(this.yWorld2Pix(this.math.ZERO) - this.yWorld2Pix(y));
    }

    @Override
    public T xLengthPix2World(short x) {
        return this.math.abs(this.math.sub(this.xPix2World((short)0), this.xPix2World(x)));
    }

    @Override
    public T yLengthPix2World(short y) {
        return this.math.abs(this.math.sub(this.yPix2World((short)0), this.yPix2World(y)));
    }

    @Override
    public void setSreenSize(short width, short height) {
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.invCanv();
        }
    }

    @Override
    public void worldChanged(Box2D<T> newBox) {
        super.worldChanged(newBox);
        this.invBoxWidth = this.math.inv(this.box.getWidth());
        this.invBoxHeight = this.math.inv(this.box.getHeight());
    }

    @Override
    public void setBorder(short bx, short by) {
        super.setBorder(bx, by);
        this.invCanv();
    }
}

