/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.DoubleConverter;
import common.FileIO;
import common.FloatConverter;
import common.Globals;
import common.ICallback;
import common.IConverter;
import common.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lattice.Box2D;
import lattice.IBox;
import lattice.IShape;
import lattice.Ray;
import lattice.RayPolygon;
import lattice.ReflectionEngine;
import lattice.ShapeContainer;
import math.VecMath;
import math.VecMathDouble;
import math.VecMathFloat;
import mvc.IModelListener;
import mvc.PixelMap;
import mvc.ScanSession;
import mvc.scan.ScanListener;
import pattern.BaseLightPattern;
import pattern.CalculationRecords;
import pattern.ILightPattern;
import pattern.LightChar;

public final class Model<T extends Number>
implements ICallback {
    public static final int WORLD_SIDE_LENGTH = 3;
    public static final int GRID_SIDE_LENGTH = 2;
    public static final int GRID_CORNER_X = -1;
    public static final int GRID_CORNER_Y = -1;
    public static final byte GRID_ROTATE = 0;
    public static final byte GRID_RESIZE = 5;
    public static final byte SHAPE_RESIZE = 8;
    public static final byte RAY_NEW = 10;
    public static final byte RAY_UPDATE = 20;
    public static final byte RAY_FINISHED = 30;
    public static final byte MODEL_NEW = 40;
    public static final byte MODEL_WORLD_RESIZE = 50;
    public static final byte LIGHTPATTERNS_UPDATE = 60;
    public static final byte DYNAMIC_CALC = 0;
    public static final byte STATIC_CALC = 1;
    public final T[] LIGHT_SOURCE_DIR;
    private final Box2D<T> worldBox;
    private final IBox<T> ctrInitBox;
    private final VecMath<T> tmath;
    private final VecMath<Float> fmath;
    private final VecMath<Double> dmath;
    private final IConverter<T, Float> tfltCvtr;
    private final ShapeContainer<T> tShapeCtr;
    private final ReflectionEngine<T> calculator;
    private Ray<T> ray;
    private T angle;
    private final RayPolygon<T> rayPolygon;
    private final ArrayList<T> rayDataUpdate;
    private final LinkedList<IModelListener> modelListeners;
    private final LinkedList<ScanListener> scanListeners;
    private int lastSize = 0;
    private ScanSession<T> scanSession;
    private boolean update;
    private byte calcMode;

    public Model(T[] cor, short pts, T gap, T[] wh, VecMath<T> mt) {
        this.LIGHT_SOURCE_DIR = mt.util.array(2);
        this.LIGHT_SOURCE_DIR[0] = mt.util.cast(-1);
        this.LIGHT_SOURCE_DIR[1] = mt.ZERO;
        this.tmath = mt;
        this.fmath = new VecMathFloat();
        this.dmath = new VecMathDouble();
        this.tfltCvtr = new FloatConverter();
        this.tShapeCtr = new ShapeContainer(cor, pts, gap, this.tmath);
        this.calculator = new ReflectionEngine<T>(this.tmath);
        this.ctrInitBox = this.tShapeCtr.copy();
        Number[] boxcor = this.tmath.util.array(2);
        boxcor[0] = this.tmath.mul(this.tmath.neg(wh[0]), this.tmath.ONE_OVER_TWO);
        boxcor[1] = this.tmath.mul(this.tmath.neg(wh[1]), this.tmath.ONE_OVER_TWO);
        this.worldBox = new Box2D(boxcor, wh, this.tmath);
        this.angle = mt.ZERO;
        this.modelListeners = new LinkedList();
        this.scanListeners = new LinkedList();
        this.rayPolygon = new RayPolygon(mt.util, 8);
        this.rayDataUpdate = new ArrayList();
        this.update = true;
    }

    @Override
    public void call() {
        this.checkForRayDataUpdate(false);
    }

    public void setRay(Ray<T> r, String descr, byte cm) {
        this.ray = r;
        Number[] st = (Number[])this.ray.getStart().clone();
        this.tmath.diff(st, this.worldBox.getCorner(), st);
        if (!this.worldBox.containsLocal(st)) {
            this.worldBox.constrainLocal(st, st);
            this.tmath.add(st, this.worldBox.getCorner(), st);
            this.ray.setStart(st);
        }
        this.calcMode = cm;
        this.clearRayData();
        this.rayPolygon.setDescription(descr);
        this.fireEvent((byte)10);
    }

    public void setRay(Ray<T> r, byte cm) {
        this.setRay(r, null, cm);
    }

    public Ray<T> getRay() {
        return this.ray;
    }

    public String getDescription() {
        return this.rayPolygon.getDescription();
    }

    public void calculateReflections() {
        if (this.ray != null) {
            Model<T> cb = this.update ? this : null;
            switch (this.calcMode) {
                case 1: {
                    this.calculator.calcStatic(this.ray, this.tShapeCtr, this.rayPolygon, cb);
                    break;
                }
                case 0: {
                    this.calculator.calcDynamic(this.ray, this.tShapeCtr, this.rayPolygon, cb);
                }
            }
            this.checkForRayDataUpdate(true);
        }
    }

    public void setCalcMode(byte cm) {
        this.calcMode = cm;
    }

    void setCalculatorActive(boolean b) {
        this.calculator.setStopped(!b);
    }

    public IBox<T> getGridInitBound() {
        return this.ctrInitBox;
    }

    public T getGridGap() {
        return this.tShapeCtr.getGap();
    }

    public short getGridSize() {
        return (short)(this.tShapeCtr.getPoints() - 1);
    }

    public void setGridSize(short i) {
        if (this.tShapeCtr.getPoints() - 1 != i) {
            this.clearRayData();
            i = (short)(i + 1);
            this.tShapeCtr.setPoints(i);
            this.fireEvent((byte)5);
        }
    }

    public T calcGap(short gridSize) {
        Object s = this.tmath.util.copy(this.tmath.util.cast(gridSize), this.tmath.PRECISION);
        return (T)this.tmath.div(this.tShapeCtr.getLengths()[0], (Number)s);
    }

    public int getDecimalPlaces() {
        if (!this.rayPolygon.isObfuscated() && this.rayPolygon.getOutRay() == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.ceil(this.rayPolygon.getDigitLossHigh()) + 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(IModelListener ml) {
        LinkedList<IModelListener> linkedList = this.modelListeners;
        synchronized (linkedList) {
            this.modelListeners.add(ml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanListener(ScanListener sl) {
        LinkedList<ScanListener> linkedList = this.scanListeners;
        synchronized (linkedList) {
            this.scanListeners.add(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScanListener(ScanListener l) {
        LinkedList<ScanListener> linkedList = this.scanListeners;
        synchronized (linkedList) {
            this.scanListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(IModelListener ml) {
        LinkedList<IModelListener> linkedList = this.modelListeners;
        synchronized (linkedList) {
            this.modelListeners.remove(ml);
        }
    }

    public boolean isInGrid(T[] point) {
        return this.tShapeCtr.contains((Number[])point);
    }

    public void rotateGrid(T phi) {
        this.clearRayData();
        Number[] sinCos = this.tmath.sincos((Number)phi);
        this.rotateGrid(sinCos, this.tShapeCtr);
        this.angle = this.tmath.add(this.angle, phi);
        this.fireEvent((byte)0);
    }

    public void rotateGrid(T phi, T[] sinCosPhi) {
        this.clearRayData();
        this.rotateGrid((Number[])sinCosPhi, this.tShapeCtr);
        this.angle = this.tmath.add(this.angle, phi);
        this.fireEvent((byte)0);
    }

    public void rotateGrid(T[] sinCosPhi, ShapeContainer<T> ctr) {
        ctr.rotate((Number[])this.tmath.ZERO2D, null, (Number)sinCosPhi[0], (Number)sinCosPhi[1]);
    }

    public T getGridRotation() {
        return this.angle;
    }

    public void setGridRotation(T phi) {
        this.clearRayData();
        this.setGridRotation(phi, this.tShapeCtr);
        this.angle = phi;
        this.fireEvent((byte)0);
    }

    public void setGridRotation(T phi, T[] sincosphi) {
        this.clearRayData();
        this.setGridRotation((T)sincosphi, this.tShapeCtr);
        this.angle = phi;
        this.fireEvent((byte)0);
    }

    private void setGridRotation(T phi, ShapeContainer<T> ctr) {
        ctr.setBound(this.ctrInitBox.copy());
        ctr.rotate((Number[])this.tmath.ZERO2D, null, (Number)phi);
    }

    private void setGridRotation(T[] sincosphi, ShapeContainer<T> ctr) {
        ctr.setBound(this.ctrInitBox.copy());
        ctr.rotate((Number[])this.tmath.ZERO2D, null, (Number)sincosphi[0], (Number)sincosphi[1]);
    }

    public void setShape(IShape<T> s) {
        this.clearRayData();
        this.tShapeCtr.setShape(s);
        this.fireEvent((byte)8);
    }

    public IShape<T> getShape() {
        return this.tShapeCtr.getShape();
    }

    public IShape<T> getShape(T[] pt) {
        return this.tShapeCtr.getShape((Number[])pt);
    }

    public void setShapePercentSize(byte percent) {
        this.setShapePercentSize(this.tmath.util.cast(percent));
    }

    public void setShapePercentSize(T percent) {
        this.clearRayData();
        IShape<T> s = this.getShape();
        s.setSize(this.transformShapeSize(percent));
        this.setShape(s);
    }

    public T transformShapeSize(byte percent) {
        return this.transformShapeSize(this.tmath.util.cast(percent));
    }

    public T transformShapeSize(T percent) {
        return this.tmath.div(this.tmath.mul(this.getGridGap(), percent), this.tmath.util.cast(200));
    }

    public T getShapePercentSize() {
        T s = this.getShape().getSize();
        int pos = -this.tmath.util.getErrorScale(s = this.tmath.div(this.tmath.mul(s, this.tmath.util.cast(200)), this.getGridGap()));
        if (pos < Integer.MAX_VALUE) {
            return this.tmath.util.round(s, pos - 1);
        }
        return s;
    }

    public byte getShapeSizeIdx() {
        for (byte i = 0; i < Globals.SHAPE_SIZES.length; i = (byte)(i + 1)) {
            Object size = this.transformShapeSize(this.tmath.util.cast(Globals.SHAPE_SIZES[i]));
            if (this.tmath.cmp(size, this.getShape().getSize()) != 0) continue;
            return i;
        }
        return -1;
    }

    public T calcShapeSize(short gridSize) {
        IShape shape = this.getShape().copy();
        shape.scale(this.tmath.util.cast(this.getGridSize()));
        shape.scale(this.tmath.inv(this.tmath.util.cast(gridSize)));
        return shape.getSize();
    }

    public ShapeContainer<Double> getShapeContainerDouble() {
        return this.tShapeCtr.convert((IConverter)new DoubleConverter(), this.dmath);
    }

    public Iterator<IShape<Float>> getShapeIteratorFloat() {
        ShapeContainer<T> shapeContainer = this.tShapeCtr;
        shapeContainer.getClass();
        return shapeContainer.new ShapeContainer.ShapeIteratorFloat(this.tfltCvtr, this.fmath);
    }

    public Box2D<T> getWorldBox() {
        return this.worldBox;
    }

    public boolean updateWorldBox(Box2D<T> world) {
        boolean retVal = false;
        if (this.worldBox != world) {
            Number[] st;
            this.worldBox.setCorner(world.getCorner());
            this.worldBox.setLengths(world.getLengths());
            if (this.ray != null && !this.worldBox.contains(st = this.ray.getStart())) {
                this.setRay(this.ray, this.rayPolygon.getDescription(), (byte)1);
                retVal = true;
            }
        }
        this.fireEvent((byte)50);
        return retVal;
    }

    public VecMath<T> getMath() {
        return this.tmath;
    }

    public VecMath<Float> getFloatMath() {
        return this.fmath;
    }

    public VecMath<Double> getDoubleMath() {
        return this.dmath;
    }

    public ScanSession<T> getScanSession() {
        return this.scanSession;
    }

    public synchronized void getRayDataComplete(LinkedList<T> list) {
        if (this.rayPolygon.getInRay() != null) {
            list.add(this.rayPolygon.getInRay().getStart()[0]);
            list.add(this.rayPolygon.getInRay().getStart()[1]);
            for (int i = 0; 1 + Math.max(2 * i / 2 - 1, 0) < this.lastSize && i < this.rayPolygon.size(); ++i) {
                list.add(((Number[])this.rayPolygon.get(i))[0]);
                list.add(((Number[])this.rayPolygon.get(i))[1]);
            }
            Number[] point = this.tmath.util.array(2);
            if (this.rayPolygon.getOutRay() != null) {
                this.rayPolygon.getOutRay().getPoint((Number)this.tmath.TEN, point, this.tmath);
                list.add(point[0]);
                list.add(point[1]);
            }
        }
    }

    public synchronized void getRayDataUpdate(LinkedList<T> upd) {
        upd.addAll(this.rayDataUpdate);
    }

    private synchronized void checkForRayDataUpdate(boolean calcFinished) {
        int rayCount = this.rayPolygon.countRays();
        if (this.lastSize < rayCount) {
            this.rayDataUpdate.clear();
            if (this.lastSize == 0 && this.rayPolygon.getInRay() != null) {
                this.rayDataUpdate.add(this.rayPolygon.getInRay().getStart()[0]);
                this.rayDataUpdate.add(this.rayPolygon.getInRay().getStart()[1]);
            }
            for (int i = Math.max(this.lastSize - 2, 0); i < this.rayPolygon.size(); ++i) {
                this.rayDataUpdate.add(((Number[])this.rayPolygon.get(i))[0]);
                this.rayDataUpdate.add(((Number[])this.rayPolygon.get(i))[1]);
            }
            if (this.rayPolygon.getOutRay() != null) {
                Number[] sPoint = this.tmath.util.array(2);
                Number[] lgs = this.worldBox.getLengths();
                Number param = this.tmath.cmp(lgs[0], lgs[1]) >= 0 ? (Number)lgs[0] : (Number)lgs[1];
                param = this.tmath.mul(param, (Number)this.tmath.TWO);
                this.rayPolygon.getOutRay().getPoint(param, sPoint, this.tmath);
                this.rayDataUpdate.add(sPoint[0]);
                this.rayDataUpdate.add(sPoint[1]);
            }
            this.lastSize = rayCount;
            this.fireEvent((byte)20);
        }
        if (calcFinished) {
            this.fireEvent((byte)30);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(byte event) {
        LinkedList<IModelListener> linkedList = this.modelListeners;
        synchronized (linkedList) {
            for (IModelListener ml : this.modelListeners) {
                ml.modelChanged(event);
            }
        }
    }

    public void initScanSession(PixelMap<T> pmap, ScanSession<T> se) {
        ShapeContainer<T> ctr = new ShapeContainer<T>(this.tShapeCtr, this.tmath);
        ctr.setBound(this.ctrInitBox.copy());
        Number[] sinCosPhiStart = this.tmath.sincos((Number)pmap.xPix2World((short)0));
        Log.getIstc().logln("Rotating scan grid to phi start");
        ctr.rotate((Number[])this.tmath.ZERO2D, (Number[])this.tmath.ZERO2D, sinCosPhiStart[0], sinCosPhiStart[1]);
        se.tCtr = ctr;
        this.scanSession = se;
    }

    private void clearRayData() {
        this.rayPolygon.clear();
        this.rayDataUpdate.clear();
        this.lastSize = 0;
    }

    public void updateWhileCalc(boolean upd) {
        this.update = upd;
    }

    public List<IModelListener> getModelListeners() {
        return this.modelListeners;
    }

    public List<ScanListener> getScanListeners() {
        return this.scanListeners;
    }

    public int getReflectionCount() {
        int retVal = Math.max(this.rayPolygon.size(), 0);
        return this.rayPolygon.getOutRay() == null ? -retVal : retVal;
    }

    public float getLength() {
        IBox<Float> fbox = this.tShapeCtr.copy().convert(this.tfltCvtr, this.fmath);
        float retVal = this.rayPolygon.calcLength(fbox, this.tfltCvtr, this.fmath);
        return this.rayPolygon.getOutRay() == null && retVal != 0.0f ? -retVal : retVal;
    }

    public int getLoops() {
        int retVal = this.rayPolygon.countLoops();
        return this.rayPolygon.getOutRay() == null && retVal != 0 ? -retVal : retVal;
    }

    public List<BaseLightPattern<T>> getLightPatterns() {
        return new FileIO<T>(this.tmath).loadLightPatterns();
    }

    public List<BaseLightPattern<T>> getMuseumPatterns() {
        return new FileIO<T>(this.tmath).loadMuseum(this.getLightPatterns());
    }

    public void addLightPattern(ILightPattern<T> lp) {
        new FileIO<T>(this.tmath).save(lp);
        this.fireEvent((byte)60);
    }

    public void addRecords(CalculationRecords<T> rec, File f) {
        new FileIO<T>(this.tmath).save(rec, f);
    }

    public void addRecords(CalculationRecords<T> rec) {
        new FileIO<T>(this.tmath).save(rec);
    }

    public CalculationRecords<T> getRecords(String patternName) {
        return new FileIO<T>(this.tmath).loadRecords(patternName);
    }

    public CalculationRecords<T> getRecords(File f) {
        return new FileIO<T>(this.tmath).loadRecords(f);
    }

    public void deleteRecords(String patternName) {
        FileIO.deleteCalculationRecords(patternName);
    }

    public CalculationRecords<T> createRecord(String name, int p) {
        short s = this.getGridSize();
        CalculationRecords<Number> retVal = new CalculationRecords<Number>(name, s, this.tmath);
        T spz = this.getShapePercentSize();
        Number[] start = (Number[])this.getRay().getStart().clone();
        T phi = this.getGridRotation();
        if (p != -1) {
            start[1] = this.tmath.util.copy(start[1], p);
            phi = this.tmath.util.copy(phi, p);
        }
        retVal.add((Number)spz, this.tmath.util.round(start[0], 4), start[1], (Number)phi);
        return retVal;
    }

    public void setRecord(CalculationRecords.Record rec, short size) {
        if (size != -1) {
            this.setGridSize(size);
        }
        Object phi = this.tmath.util.copy(rec.getAngle(), this.tmath.PRECISION);
        this.setGridRotation(phi);
        if (rec.getShapeSize() != null) {
            Object s = this.tmath.util.copy(rec.getShapeSize(), this.tmath.PRECISION);
            this.setShapePercentSize(s);
        }
        Number[] start = this.tmath.util.array(2);
        start[0] = this.tmath.util.copy(rec.getDistance(), this.tmath.PRECISION);
        start[1] = this.tmath.util.copy(rec.getHeight(), this.tmath.PRECISION);
        Ray r = new Ray(start, this.LIGHT_SOURCE_DIR, this.tmath.util);
        String name = rec.getEnclosingType().getPatternName();
        this.setRay(r, name, (byte)1);
    }

    public void removeLightPattern(ILightPattern<T> lp) {
        FileIO.delete(lp);
        FileIO.deleteCalculationRecords(lp.getName());
        this.fireEvent((byte)60);
    }

    public LightChar[] getLightChars() {
        return new FileIO<T>(this.tmath).loadLightChars();
    }
}

