/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import calc.CalculatorView;
import calc.CalculatorVisualizer;
import common.ColorTheme;
import common.FileIO;
import common.Globals;
import common.Log;
import common.SelectTextItemListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileNameExtensionFilter;
import lattice.Ray;
import math.VecMath;
import mvc.CompoundBorder;
import mvc.Controller;
import mvc.IModelListener;
import mvc.LightCharBorder;
import mvc.LightCharTable;
import mvc.LightPatternSelector;
import mvc.Model;
import mvc.SimpleBorder;
import mvc.View;
import mvc.Visualizer;
import mvc.mgr.LightPatternManager;
import pattern.BaseLightPattern;
import pattern.CalculationRecords;
import pattern.LightChar;
import pattern.LightCharPattern;

public class MainMenuBar<T extends Number>
extends JMenuBar {
    static final String ANIM_PAT_ENTRY_SLOW = "Slow";
    static final String ANIM_PAT_ENTRY_MEDIUM = "Medium";
    static final String ANIM_PAT_ENTRY_FAST = "Fast";
    static final String ANIM_PAT_ENTRY_VERY_FAST = "Turbo";
    static final String SYMBOLS_ENTRY_BORDER = "Border...";
    private final View<T> view;
    private final ColorTheme[] themes;
    private boolean allowEvents;
    private final ArrayList<AbstractButton> animGroup;
    private CalculatorView<T> calcView;
    private Font smFont;
    private int threshold;
    JMenu precMenu;
    JMenu gridSizeMenu;
    JMenu shapeSizeMenu;
    JMenu animMenu;
    JMenu patternMenu;
    JMenu msgMenu;
    JMenu settingsMenu;
    JMenu mapMenu;
    JMenu themeMenu;
    private JMenuItem defItem;
    private JCheckBoxMenuItem sortItem;
    private final Color PINK;

    public MainMenuBar(View<T> vw, ColorTheme theme) {
        this.view = vw;
        this.allowEvents = true;
        this.animGroup = new ArrayList();
        List<ColorTheme> cts = new FileIO(null).loadColorThemes();
        cts.add(0, new ColorTheme());
        this.themes = cts.toArray(new ColorTheme[cts.size()]);
        Font f = this.getFont();
        this.smFont = new Font(f.getFontName(), f.getStyle(), f.getSize() - 1);
        this.threshold = 2;
        Color p = Color.pink;
        this.PINK = new Color(p.getRed(), p.getGreen() + 20, p.getBlue() + 20);
        this.initGUI(theme);
        Model<T> model = this.view.getController().getModel();
        model.addModelListener(new IModelListener(){

            @Override
            public void modelChanged(byte event) {
                switch (event) {
                    case 8: {
                        this.updateShapeSizeMenu();
                        break;
                    }
                    case 60: {
                        MainMenuBar.this.rebuildPatternMenu();
                        break;
                    }
                    case 40: {
                        if (MainMenuBar.this.calcView != null) {
                            MainMenuBar.this.calcView.getVisualizer().getModel().clearResults();
                        }
                        this.updateShapeSizeMenu();
                    }
                }
            }

            private void updateShapeSizeMenu() {
                Model ml = MainMenuBar.this.view.getController().getModel();
                byte selIdx = ml.getShapeSizeIdx();
                MainMenuBar.this.setSelectedIdx(selIdx, MainMenuBar.this.shapeSizeMenu, false);
                Globals.IDX_SHAPE_SIZE = selIdx;
            }
        });
    }

    private void initGUI(ColorTheme theme) {
        VecMath<T> math = this.view.getController().getModel().getMath();
        FileIO<T> fileIO = new FileIO<T>(math);
        this.patternMenu = new JMenu("Patterns");
        this.defItem = new JMenuItem("Show Defining Path");
        this.configure(this.defItem);
        this.defItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Controller ctrl = MainMenuBar.this.view.getController();
                if (ctrl.isRotAnimRun()) {
                    return;
                }
                if (ctrl.isPatAnimRun()) {
                    return;
                }
                ctrl.waitForCalculatorRelease();
                LightPatternSelector sel = MainMenuBar.this.view.getLightPatternSelector();
                BaseLightPattern blp = sel.getSelected();
                if (blp != null) {
                    MainMenuBar.this.view.getReflectionVisualizer().requestDefPath(blp);
                    MainMenuBar.this.view.getReflectionVisualizer().repaint();
                }
            }
        });
        this.rebuildPatternMenu();
        this.add(this.patternMenu);
        this.settingsMenu = new JMenu("Settings");
        this.gridSizeMenu = new JMenu("Grid Size");
        this.configure(this.gridSizeMenu);
        this.rebuildGridSizeMenu((short)-1, false);
        this.shapeSizeMenu = new JMenu("Radius");
        this.configure(this.shapeSizeMenu);
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MainMenuBar.this.allowEvents && e.getStateChange() == 1) {
                    for (int i = 0; i < MainMenuBar.this.shapeSizeMenu.getItemCount(); i = (int)((byte)(i + 1))) {
                        if (MainMenuBar.this.shapeSizeMenu.getItem(i) == e.getSource()) continue;
                        MainMenuBar.this.shapeSizeMenu.getItem(i).setSelected(false);
                    }
                    String n = ((JMenuItem)e.getSource()).getText();
                    String num = n.substring(0, n.indexOf("%")).trim();
                    byte b = Byte.parseByte(num);
                    Controller ctrl = MainMenuBar.this.view.getController();
                    float speed = 0.0f;
                    byte speed2 = 2;
                    int pos = -1;
                    if (ctrl.isRotAnimRun()) {
                        speed = ctrl.getRotAnimSpeed();
                        ctrl.stopRotAnim();
                    } else if (ctrl.isPatAnimRun()) {
                        pos = ctrl.getPatAnimPos();
                        speed2 = ctrl.getPatAnimSpeed();
                        ctrl.stopPatAnim();
                    }
                    ctrl.stopCalculation();
                    ctrl.waitForCalculatorRelease();
                    ctrl.getModel().setShapePercentSize(b);
                    Ray ray = ctrl.getModel().getRay();
                    ctrl.getModel().setRay(ray, (byte)1);
                    if (speed != 0.0f) {
                        ctrl.startRotAnim(speed);
                    } else if (pos != -1) {
                        ctrl.startPatAnim(pos, (short)-1, speed2);
                    } else {
                        ctrl.startCalculation();
                    }
                }
            }
        };
        for (int i = 0; i < Globals.SHAPE_SIZES.length; i = (int)((byte)(i + 1))) {
            short s = Globals.SHAPE_SIZES[i];
            JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(s + " %");
            this.configure(rbmi);
            if (i == Globals.IDX_SHAPE_SIZE) {
                rbmi.setSelected(true);
            }
            rbmi.addItemListener(il);
            this.shapeSizeMenu.add(rbmi);
        }
        il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MainMenuBar.this.allowEvents && e.getStateChange() == 1) {
                    String txt = ((JMenuItem)e.getSource()).getText();
                    short p = Short.parseShort(txt.trim());
                    Controller ctrl = MainMenuBar.this.view.getController();
                    float speed = 0.0f;
                    byte speed2 = 2;
                    int pos = -1;
                    if (ctrl.isRotAnimRun()) {
                        speed = ctrl.getRotAnimSpeed();
                        ctrl.stopRotAnim();
                    } else if (ctrl.isPatAnimRun()) {
                        pos = ctrl.getPatAnimPos();
                        speed2 = ctrl.getPatAnimSpeed();
                        ctrl.stopPatAnim();
                    }
                    ctrl.stopCalculation();
                    ctrl.stopScan("Stopped on precision change");
                    ctrl.waitForCalculatorRelease();
                    MainMenuBar.this.view.getController().setPrecision(p);
                    if (speed != 0.0f) {
                        ctrl.startRotAnim(speed);
                    } else if (pos != -1) {
                        ctrl.startPatAnim(pos, (short)-1, speed2);
                    } else {
                        ctrl.startCalculation();
                    }
                    Globals.IDX_PREC = Globals.getIndex(p, Globals.PRECISIONS);
                }
            }
        };
        ButtonGroup bg = new ButtonGroup();
        this.precMenu = new JMenu("Precision");
        this.configure(this.precMenu);
        for (int i = 0; i < Globals.PRECISIONS.length; i = (int)((short)(i + 1))) {
            short p = Globals.PRECISIONS[i];
            JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(p + "");
            this.configure(rbmi);
            if (i == Globals.IDX_PREC) {
                rbmi.setSelected(true);
            }
            rbmi.addItemListener(il);
            this.precMenu.add(rbmi);
            bg.add(rbmi);
        }
        JCheckBoxMenuItem autoPItem = new JCheckBoxMenuItem("Automatic Precision");
        this.configure(autoPItem);
        autoPItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Globals.AUTO_PREC = ie.getStateChange() == 1;
            }
        });
        autoPItem.setSelected(true);
        JCheckBoxMenuItem autoRItem = new JCheckBoxMenuItem("Automatic Radius");
        this.configure(autoRItem);
        autoRItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Globals.AUTO_RADIUS = ie.getStateChange() == 1;
            }
        });
        autoRItem.setSelected(true);
        JCheckBoxMenuItem muItem = new JCheckBoxMenuItem("Museum");
        this.configure(muItem);
        muItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                MainMenuBar.this.view.setMuseum();
            }
        });
        JCheckBoxMenuItem fsItem = new JCheckBoxMenuItem("Museum (Fullscreen)");
        this.configure(fsItem);
        fsItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                MainMenuBar.this.view.setMuseum();
                MainMenuBar.this.view.setFullScreen();
            }
        });
        this.themeMenu = new JMenu("Theme");
        this.configure(this.themeMenu);
        bg = new ButtonGroup();
        for (ColorTheme ct : this.themes) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ct.getName());
            this.configure(item);
            if (ct.getName().compareTo(theme.getName()) == 0) {
                item.setSelected(true);
            }
            item.addItemListener(new ThemeListener(ct));
            this.themeMenu.add(item);
            bg.add(item);
        }
        JMenu lightSourceMenu = new JMenu("Light Source");
        this.configure(lightSourceMenu);
        String[] lightSources = new String[]{"Laser 1", "Laser 2", "Laser 3", "Invisible"};
        bg = new ButtonGroup();
        int i = 0;
        while (i < lightSources.length) {
            JCheckBoxMenuItem lsItem = this.createCheckBox(lightSources[i]);
            if (i == 0) {
                lsItem.setSelected(true);
            }
            final int j = i++;
            lsItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        MainMenuBar.this.view.setLightSource(Visualizer.LIGHT_SOURCES[j]);
                    }
                }
            });
            lightSourceMenu.add(lsItem);
            bg.add(lsItem);
        }
        final JCheckBoxMenuItem varItem = this.createCheckBox("Variables...");
        varItem.addItemListener(new ItemListener(){
            JFrame vf;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    this.vf = MainMenuBar.this.view.createVariableView();
                    this.vf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent we) {
                            varItem.setSelected(false);
                            vf = null;
                        }

                        @Override
                        public void windowClosing(WindowEvent we) {
                            varItem.setSelected(false);
                            vf = null;
                        }
                    });
                } else if (this.vf != null) {
                    this.vf.dispose();
                }
            }
        });
        this.sortItem = this.createCheckBox("Size Sort Patterns");
        this.sortItem.setSelected(true);
        this.sortItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                MainMenuBar.this.rebuildPatternMenu();
            }
        });
        JMenu thresholdMenu = new JMenu("Group Patterns");
        this.configure(thresholdMenu);
        bg = new ButtonGroup();
        for (int i2 = 1; i2 < 6; ++i2) {
            JCheckBoxMenuItem treshItem = this.createCheckBox(i2 + "");
            if (i2 - 1 == this.threshold) {
                treshItem.setSelected(true);
            }
            treshItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        String txt = ((JMenuItem)ie.getSource()).getText();
                        MainMenuBar.this.threshold = Integer.parseInt(txt) - 1;
                        MainMenuBar.this.rebuildPatternMenu();
                    }
                }
            });
            thresholdMenu.add(treshItem);
            bg.add(treshItem);
        }
        this.settingsMenu.add(this.gridSizeMenu);
        this.settingsMenu.add(this.shapeSizeMenu);
        this.settingsMenu.add(this.precMenu);
        this.settingsMenu.add(autoPItem);
        this.settingsMenu.add(autoRItem);
        this.settingsMenu.add(varItem);
        this.settingsMenu.add(new JSeparator());
        this.settingsMenu.add(this.themeMenu);
        this.settingsMenu.add(lightSourceMenu);
        this.settingsMenu.add(new JSeparator());
        this.settingsMenu.add(this.sortItem);
        this.settingsMenu.add(thresholdMenu);
        this.add(this.settingsMenu);
        JMenu utilMenu = new JMenu("Util");
        JCheckBoxMenuItem calcItem = this.createCheckBox("Calculator...");
        calcItem.addItemListener(new CalculatorListener(calcItem));
        this.mapMenu = new JMenu("Symbols of Light");
        this.configure(this.mapMenu);
        JCheckBoxMenuItem borderMapItem = this.createCheckBox(SYMBOLS_ENTRY_BORDER);
        borderMapItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    Controller ctrl = MainMenuBar.this.view.getController();
                    LightChar[] lcs = ctrl.getModel().getLightChars();
                    VecMath mt = ctrl.getModel().getMath();
                    VecMath<Float> fmt = ctrl.getModel().getFloatMath();
                    LightCharBorder b1 = new LightCharBorder(lcs, mt, fmt);
                    ColorTheme th = MainMenuBar.this.view.getReflectionVisualizer().getTheme();
                    SimpleBorder b2 = new SimpleBorder(5, th.getBorderColor());
                    CompoundBorder b3 = new CompoundBorder(b1, b2);
                    MainMenuBar.this.view.getReflectionVisualizer().setBorder(b3);
                } else {
                    ColorTheme th = MainMenuBar.this.view.getReflectionVisualizer().getTheme();
                    SimpleBorder b = new SimpleBorder(5, th.getBorderColor());
                    MainMenuBar.this.view.getReflectionVisualizer().setBorder(b);
                }
            }
        });
        final JCheckBoxMenuItem tableMapItem = this.createCheckBox("Table...");
        tableMapItem.addItemListener(new ItemListener(){
            JFrame frame;

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.frame = new JFrame("FroZenLight - Characters of Light");
                    Model model = MainMenuBar.this.view.getController().getModel();
                    LightChar[] lc = model.getLightChars();
                    Controller ctrl = MainMenuBar.this.view.getController();
                    VecMath mt = ctrl.getModel().getMath();
                    VecMath<Float> fmt = ctrl.getModel().getFloatMath();
                    final LightCharTable lcm = new LightCharTable(lc, mt, fmt);
                    this.frame.add(lcm);
                    this.frame.pack();
                    this.frame.setSize(500, 500);
                    this.frame.setVisible(true);
                    this.frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            tableMapItem.setSelected(false);
                            lcm.dispose();
                        }

                        @Override
                        public void windowClosing(WindowEvent e) {
                            tableMapItem.setSelected(false);
                            lcm.dispose();
                        }
                    });
                } else {
                    if (this.frame != null) {
                        this.frame.dispose();
                    }
                    this.frame = null;
                }
            }
        });
        this.mapMenu.add(borderMapItem);
        this.mapMenu.add(tableMapItem);
        final JCheckBoxMenuItem managerItem = this.createCheckBox("Pattern Manager...");
        managerItem.addItemListener(new ItemListener(){
            JFrame frame;

            @Override
            public void itemStateChanged(ItemEvent ie) {
                if (ie.getStateChange() == 1) {
                    this.frame = new LightPatternManager(MainMenuBar.this.view.getController());
                    this.frame.pack();
                    this.frame.setSize(600, 400);
                    this.frame.setVisible(true);
                    this.frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            managerItem.setSelected(false);
                        }

                        @Override
                        public void windowClosing(WindowEvent e) {
                            managerItem.setSelected(false);
                        }
                    });
                } else {
                    if (this.frame != null) {
                        this.frame.dispose();
                    }
                    this.frame = null;
                }
            }
        });
        final JCheckBoxMenuItem scannerItem = this.createCheckBox("Scanner...");
        scannerItem.addItemListener(new ItemListener(){
            JFrame vf;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    this.vf = MainMenuBar.this.view.createScanView();
                    this.vf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent we) {
                            scannerItem.setSelected(false);
                            vf = null;
                        }

                        @Override
                        public void windowClosing(WindowEvent we) {
                            scannerItem.setSelected(false);
                            vf = null;
                        }
                    });
                } else if (this.vf != null) {
                    this.vf.dispose();
                }
            }
        });
        final JCheckBoxMenuItem logItem = this.createCheckBox("Logs...");
        logItem.addItemListener(new ItemListener(){
            JFrame vf;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    this.vf = new JFrame("Logs");
                    Log.getIstc().initGUI();
                    this.vf.getContentPane().add(Log.getIstc());
                    this.vf.setSize(400, 300);
                    this.vf.setVisible(true);
                    this.vf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent we) {
                            logItem.setSelected(false);
                            if (vf != null) {
                                vf.getContentPane().remove(0);
                            }
                            vf = null;
                        }

                        @Override
                        public void windowClosing(WindowEvent we) {
                            logItem.setSelected(false);
                            if (vf != null) {
                                vf.getContentPane().remove(0);
                            }
                            vf = null;
                        }
                    });
                    this.vf.repaint();
                } else if (this.vf != null) {
                    this.vf.dispose();
                    Log.getIstc().deleteGUI();
                }
            }
        });
        JMenuItem exitMenu = new JMenuItem("Exit");
        exitMenu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                System.exit(0);
            }
        });
        JMenu recordItem = new JMenu("Record");
        this.configure(recordItem);
        JMenuItem printItem = new JMenuItem("Print");
        this.configure(printItem);
        printItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Controller ctrl = MainMenuBar.this.view.getController();
                if (ctrl.isRotAnimRun()) {
                    ctrl.stopRotAnim();
                } else if (ctrl.isPatAnimRun()) {
                    ctrl.stopPatAnim();
                }
                ctrl.waitForCalculatorRelease();
                Model model = MainMenuBar.this.view.getController().getModel();
                String txt = model.createRecord("", -1).toString();
                Log.getIstc().log(txt);
            }
        });
        JMenuItem saveItem = new JMenuItem("Save As...");
        this.configure(saveItem);
        saveItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Controller ctrl = MainMenuBar.this.view.getController();
                if (ctrl.isRotAnimRun()) {
                    ctrl.stopRotAnim();
                } else if (ctrl.isPatAnimRun()) {
                    ctrl.stopPatAnim();
                }
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Text File (*.txt)", "txt");
                fc.setFileFilter(filter);
                fc.setDialogTitle("Save Record");
                fc.setSelectedFile(new File("record.txt"));
                int retVal = fc.showOpenDialog(MainMenuBar.this.getParent());
                if (retVal == 0) {
                    ctrl.waitForCalculatorRelease();
                    Model model = MainMenuBar.this.view.getController().getModel();
                    CalculationRecords recs = model.createRecord("", -1);
                    File file = fc.getSelectedFile();
                    if (file != null) {
                        model.addRecords(recs, file);
                    }
                }
            }
        });
        JMenuItem loadItem = new JMenuItem("Load...");
        this.configure(loadItem);
        loadItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                Controller ctrl = MainMenuBar.this.view.getController();
                if (ctrl.isRotAnimRun()) {
                    ctrl.stopRotAnim();
                } else if (ctrl.isPatAnimRun()) {
                    ctrl.stopPatAnim();
                }
                JFileChooser fc = new JFileChooser("record.txt");
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Text file (*.txt)", "txt");
                fc.setDialogTitle("Load Record");
                fc.setFileFilter(filter);
                int retVal = fc.showOpenDialog(MainMenuBar.this.getParent());
                if (retVal != 0) {
                    return;
                }
                File file = fc.getSelectedFile();
                if (file == null) {
                    return;
                }
                CalculationRecords recs = ctrl.getModel().getRecords(file);
                ctrl.waitForCalculatorRelease();
                if (recs != null) {
                    CalculationRecords.Record rec = recs.getRecord(0);
                    VecMath mt = ctrl.getModel().getMath();
                    Object h = mt.util.parse(rec.getHeight().toString());
                    int p = mt.util.precision(h);
                    if (Globals.adjustPrecision(p)) {
                        MainMenuBar.this.setSelectedIdx(Globals.IDX_PREC, MainMenuBar.this.precMenu, true);
                    }
                }
                Model model = MainMenuBar.this.view.getController().getModel();
                model.setRecord(recs.getRecord(0), recs.getGridSize());
                ctrl.startCalculation();
            }
        });
        recordItem.add(printItem);
        recordItem.add(saveItem);
        recordItem.add(loadItem);
        utilMenu.add(this.mapMenu);
        utilMenu.add(new JSeparator());
        utilMenu.add(managerItem);
        utilMenu.add(calcItem);
        utilMenu.add(scannerItem);
        utilMenu.add(logItem);
        utilMenu.add(recordItem);
        utilMenu.add(new JSeparator());
        utilMenu.add(fsItem);
        utilMenu.add(muItem);
        utilMenu.add(new JSeparator());
        utilMenu.add(exitMenu);
        this.add(utilMenu);
        this.animMenu = new JMenu("Animation");
        JMenuItem rotHeader = new JMenuItem("Rotation");
        this.configureHeader(rotHeader);
        JRadioButtonMenuItem piItem = new JRadioButtonMenuItem("1   pi/min");
        this.configure(piItem);
        piItem.addItemListener(new AnimRotListener(Math.PI));
        JRadioButtonMenuItem piDiv2Item = new JRadioButtonMenuItem("1/2 pi/min");
        this.configure(piDiv2Item);
        piDiv2Item.addItemListener(new AnimRotListener(1.5707963267948966));
        JRadioButtonMenuItem piDiv4Item = new JRadioButtonMenuItem("1/4 pi/min");
        this.configure(piDiv4Item);
        piDiv4Item.addItemListener(new AnimRotListener(0.7853981633974483));
        JRadioButtonMenuItem piDiv8Item = new JRadioButtonMenuItem("1/8 pi/min");
        this.configure(piDiv8Item);
        piDiv8Item.addItemListener(new AnimRotListener(0.39269908169872414));
        JMenuItem patHeader = new JMenuItem("Symmetric Patterns");
        this.configureHeader(patHeader);
        JRadioButtonMenuItem patterns1 = new JRadioButtonMenuItem(ANIM_PAT_ENTRY_SLOW);
        this.configure(patterns1);
        patterns1.addItemListener(new AnimPatListener(1));
        JRadioButtonMenuItem patterns2 = new JRadioButtonMenuItem(ANIM_PAT_ENTRY_MEDIUM);
        this.configure(patterns2);
        patterns2.addItemListener(new AnimPatListener(2));
        JRadioButtonMenuItem patterns3 = new JRadioButtonMenuItem(ANIM_PAT_ENTRY_FAST);
        this.configure(patterns3);
        patterns3.addItemListener(new AnimPatListener(3));
        JRadioButtonMenuItem patterns4 = new JRadioButtonMenuItem(ANIM_PAT_ENTRY_VERY_FAST);
        this.configure(patterns4);
        patterns4.addItemListener(new AnimPatListener(4));
        this.animMenu.add(rotHeader);
        this.animMenu.add(piItem);
        this.animMenu.add(piDiv2Item);
        this.animMenu.add(piDiv4Item);
        this.animMenu.add(piDiv8Item);
        this.animMenu.add(patHeader);
        this.animMenu.add(patterns1);
        this.animMenu.add(patterns2);
        this.animMenu.add(patterns3);
        this.animMenu.add(patterns4);
        this.animGroup.add(piItem);
        this.animGroup.add(piDiv2Item);
        this.animGroup.add(piDiv4Item);
        this.animGroup.add(piDiv8Item);
        this.animGroup.add(patterns1);
        this.animGroup.add(patterns2);
        this.animGroup.add(patterns3);
        this.animGroup.add(patterns4);
        this.add(this.animMenu);
        JMenu infoMenu = new JMenu("?");
        JCheckBoxMenuItem helpItem = this.createCheckBox("Help...");
        String text = fileIO.loadInfoText("Main");
        il = new SelectTextItemListener(helpItem, "Help", text, 570, 600);
        helpItem.addItemListener(il);
        JCheckBoxMenuItem aboutItem = this.createCheckBox("About...");
        text = fileIO.loadInfoText("About");
        il = new SelectTextItemListener(aboutItem, "About", text, 350, 300);
        aboutItem.addItemListener(il);
        infoMenu.add(helpItem);
        infoMenu.add(aboutItem);
        this.add(infoMenu);
    }

    void rebuildGridSizeMenu(short grs, boolean fireEvent) {
        this.allowEvents = fireEvent;
        int l = Globals.GRID_SIZES.length;
        Globals.addGridSize(grs);
        if (l < Globals.GRID_SIZES.length) {
            Globals.IDX_GRID_SIZE = Globals.getIndex(grs, Globals.GRID_SIZES);
        }
        this.gridSizeMenu.removeAll();
        ItemListener il = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MainMenuBar.this.allowEvents && e.getStateChange() == 1) {
                    String n = ((JMenuItem)e.getSource()).getText();
                    short s = Short.parseShort(n.substring(0, n.indexOf("x")));
                    Controller ctrl = MainMenuBar.this.view.getController();
                    if (ctrl.getModel().getGridSize() != s) {
                        float speed1 = 0.0f;
                        byte speed2 = 2;
                        int pos = -1;
                        if (ctrl.isRotAnimRun()) {
                            speed1 = ctrl.getRotAnimSpeed();
                            ctrl.stopRotAnim();
                        } else if (ctrl.isPatAnimRun()) {
                            pos = ctrl.getPatAnimPos();
                            speed2 = ctrl.getPatAnimSpeed();
                            ctrl.stopPatAnim();
                        }
                        ctrl.stopCalculation();
                        ctrl.waitForCalculatorRelease();
                        Globals.IDX_GRID_SIZE = Globals.getIndex(s, Globals.GRID_SIZES);
                        ctrl.getModel().setGridSize(s);
                        Ray ray = MainMenuBar.this.view.getController().getModel().getRay();
                        ctrl.getModel().setRay(ray, (byte)1);
                        if (speed1 != 0.0f) {
                            ctrl.startRotAnim(speed1);
                        } else if (pos != -1) {
                            ctrl.startPatAnim(-1, s, speed2);
                        } else {
                            ctrl.startCalculation();
                        }
                    }
                }
            }
        };
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < Globals.GRID_SIZES.length; i = (int)((short)(i + 1))) {
            short gs = Globals.GRID_SIZES[i];
            JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(gs + "x" + gs);
            this.configure(rbmi);
            rbmi.addItemListener(il);
            if (i == Globals.IDX_GRID_SIZE) {
                rbmi.setSelected(true);
            }
            this.gridSizeMenu.add(rbmi);
            bg.add(rbmi);
        }
        JMenuItem rbmi = new JMenuItem("other...");
        this.configure(rbmi);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MainMenuBar.this.allowEvents) {
                    short size;
                    String txt = "Enter the desired grid size:";
                    String value = JOptionPane.showInputDialog(MainMenuBar.this.view, (Object)txt);
                    try {
                        int idx = value.indexOf("x");
                        if (idx != -1) {
                            value = value.substring(0, idx);
                        }
                        size = Short.parseShort(value);
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    MainMenuBar.this.rebuildGridSizeMenu(size, true);
                }
            }
        };
        rbmi.addActionListener(al);
        this.gridSizeMenu.add(rbmi);
        this.allowEvents = true;
    }

    private void rebuildPatternMenu() {
        this.patternMenu.removeAll();
        Controller<T> ctrl = this.view.getController();
        Model<T> model = ctrl.getModel();
        List<BaseLightPattern<T>> patterns = model.getLightPatterns();
        JMenuItem menuItem = new JMenuItem("Symmetric");
        this.configureHeader(menuItem);
        this.patternMenu.add(menuItem);
        Iterator<BaseLightPattern<T>> iter = patterns.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof LightCharPattern)) continue;
            iter.remove();
        }
        this.cluster(patterns);
        patterns = model.getLightPatterns();
        JMenuItem menuItem2 = new JMenuItem("Symbol Sequence");
        this.configureHeader(menuItem2);
        this.patternMenu.add(menuItem2);
        iter = patterns.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof LightCharPattern) continue;
            iter.remove();
        }
        this.cluster(patterns);
        this.patternMenu.add(new JSeparator());
        this.patternMenu.add(this.defItem);
    }

    private void cluster(List<BaseLightPattern<T>> patterns) {
        boolean sizeSort;
        ArrayList<String[]> classes = new ArrayList<String[]>();
        boolean bl = sizeSort = this.sortItem != null ? this.sortItem.isSelected() : true;
        if (!sizeSort) {
            char[] az = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
            for (int i = 0; i < az.length; i += 2) {
                classes.add(new String[]{az[i] + "", az[i + 1] + ""});
            }
        } else {
            HashSet<Integer> sizesSet = new HashSet<Integer>();
            for (BaseLightPattern<T> p : patterns) {
                sizesSet.add(Integer.valueOf(p.getGridSize()));
            }
            ArrayList sortedSizes = new ArrayList(sizesSet);
            Collections.sort(sortedSizes);
            for (int i = 0; i < sortedSizes.size(); ++i) {
                classes.add(new String[]{sortedSizes.get(i) + ""});
            }
        }
        if (patterns == null) {
            patterns = new ArrayList<BaseLightPattern<T>>();
        }
        for (int i = 0; i < classes.size(); ++i) {
            String start = ((String[])classes.get(i))[0];
            String end = ((String[])classes.get(i))[((String[])classes.get(i)).length > 1 ? 1 : 0];
            ArrayList<BaseLightPattern<T>> tmpList = new ArrayList<BaseLightPattern<T>>();
            for (BaseLightPattern<T> p : patterns) {
                if (sizeSort) {
                    if (p.getGridSize() != Short.parseShort(end)) continue;
                    this.sortedInsert(p, tmpList);
                    continue;
                }
                String n = p.getName();
                if (n.compareToIgnoreCase(start) < 0 || n.compareToIgnoreCase(end) >= 0 && !n.startsWith(end)) continue;
                this.sortedInsert(p, tmpList);
            }
            if (tmpList.size() <= 0) continue;
            JMenu menu = null;
            if (tmpList.size() > this.threshold) {
                String text = sizeSort ? start : start + " - " + end;
                menu = new JMenu(text);
                menu.setFont(this.smFont);
                this.configure(menu);
                this.patternMenu.add(menu);
            }
            for (int j = 0; j < tmpList.size(); ++j) {
                final BaseLightPattern lp = (BaseLightPattern)tmpList.get(j);
                String name = lp.getName();
                if (sizeSort && tmpList.size() < this.threshold + 1) {
                    name = lp.getGridSize() > 9 ? lp.getGridSize() + ": " + name : lp.getGridSize() + ":  " + name;
                }
                JMenuItem menuItem = new JMenuItem(name);
                this.configure(menuItem);
                MouseAdapter l = new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent me) {
                        LightPatternSelector sel = MainMenuBar.this.view.getLightPatternSelector();
                        sel.select(null, lp, lp.isStoreCalcEnabled());
                    }
                };
                menuItem.addMouseListener(l);
                if (tmpList.size() > this.threshold) {
                    menu.add(menuItem);
                    continue;
                }
                this.patternMenu.add(menuItem);
            }
        }
    }

    private JCheckBoxMenuItem createCheckBox(String txt) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(txt){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height -= 3;
                return d;
            }
        };
        mi.setFont(this.smFont);
        return mi;
    }

    private void configureHeader(JMenuItem mi) {
        this.configure(mi);
        mi.setBackground(new Color(165, 165, 165));
        mi.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    private void configure(JMenuItem mi) {
        mi.setFont(this.smFont);
        int h = mi.getPreferredSize().height - 3;
        int w = mi.getPreferredSize().width + 10;
        mi.setPreferredSize(new Dimension(w, h));
        if (mi instanceof JMenu) {
            mi.setForeground(this.PINK);
        }
    }

    private void sortedInsert(BaseLightPattern<T> p, List<BaseLightPattern<T>> list) {
        int k;
        for (k = 0; k < list.size() && list.get(k).getName().compareTo(p.getName()) <= 0; ++k) {
        }
        list.add(k, p);
    }

    void deselectAnimationButtonGroup(AbstractButton skip) {
        for (AbstractButton b : this.animGroup) {
            if (skip == b || !b.isSelected()) continue;
            b.setSelected(false);
        }
    }

    void setSelectedIdx(short idx, JMenu menu, boolean fireEvent) {
        this.allowEvents = fireEvent;
        for (int i = 0; i < menu.getItemCount(); i = (int)((byte)(i + 1))) {
            if (menu.getItem(i) == null || !menu.getItem(i).isSelected()) continue;
            menu.getItem(i).setSelected(false);
        }
        if (idx != -1) {
            ((JRadioButtonMenuItem)menu.getItem(idx)).setSelected(true);
        }
        this.allowEvents = true;
    }

    public void setSelected(String entry, JMenu menu, boolean fireEvent) {
        JMenuItem it;
        int i;
        this.allowEvents = fireEvent;
        boolean entryFound = false;
        for (i = 0; i < menu.getItemCount(); i = (int)((byte)(i + 1))) {
            it = menu.getItem(i);
            if (it == null) continue;
            if (it instanceof JMenu) {
                this.setSelected(entry, (JMenu)it, fireEvent);
                continue;
            }
            if (it.getText().indexOf(entry) < 0) continue;
            entryFound = true;
            break;
        }
        if (entryFound) {
            for (i = 0; i < menu.getItemCount(); i = (int)((byte)(i + 1))) {
                it = menu.getItem(i);
                if (it == null) continue;
                if (it.getText().indexOf(entry) >= 0) {
                    if (it instanceof JRadioButtonMenuItem) {
                        it.setSelected(true);
                        continue;
                    }
                    MouseListener[] mls = it.getMouseListeners();
                    mls[mls.length - 1].mouseReleased(null);
                    continue;
                }
                if (!it.isSelected()) continue;
                it.setSelected(false);
            }
        }
        this.allowEvents = true;
    }

    private final class AnimPatListener
    implements ItemListener {
        private byte speed;

        AnimPatListener(byte speeeed) {
            this.speed = speeeed;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                MainMenuBar.this.deselectAnimationButtonGroup((AbstractButton)ie.getSource());
                MainMenuBar.this.view.getController().startPatAnim(-1, (short)-1, this.speed);
            } else {
                MainMenuBar.this.view.getController().stopPatAnim();
            }
        }
    }

    private final class CalculatorListener
    implements ItemListener {
        private final JMenuItem item;

        CalculatorListener(JMenuItem item) {
            this.item = item;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Model model = MainMenuBar.this.view.getController().getModel();
                VecMath math = model.getMath();
                CalculatorVisualizer cvis = new CalculatorVisualizer(math);
                MainMenuBar.this.calcView = new CalculatorView(cvis);
                MainMenuBar.this.calcView.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent we) {
                        CalculatorListener.this.item.setSelected(false);
                        MainMenuBar.this.calcView.removeWindowListener(this);
                        MainMenuBar.this.calcView = null;
                    }

                    @Override
                    public void windowClosing(WindowEvent we) {
                        CalculatorListener.this.item.setSelected(false);
                        MainMenuBar.this.calcView.removeWindowListener(this);
                        MainMenuBar.this.calcView = null;
                    }
                });
            } else {
                MainMenuBar.this.calcView.dispose();
            }
        }
    }

    private final class ThemeListener
    implements ItemListener {
        private final ColorTheme theme;

        public ThemeListener(ColorTheme t) {
            this.theme = t;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                MainMenuBar.this.view.getReflectionVisualizer().setTheme(this.theme);
                MainMenuBar.this.view.getReflectionVisualizer().repaint();
            }
        }
    }

    private final class AnimRotListener
    implements ItemListener {
        private final double phi;

        public AnimRotListener(double phi) {
            this.phi = phi;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                MainMenuBar.this.deselectAnimationButtonGroup((AbstractButton)ie.getSource());
                MainMenuBar.this.view.getController().startRotAnim(this.phi);
            } else {
                MainMenuBar.this.view.getController().stopRotAnim();
            }
        }
    }
}

