/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.Globals;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import math.VecMath;
import mvc.Controller;
import mvc.MainMenuBar;
import mvc.Model;
import mvc.View;
import pattern.BaseLightPattern;
import pattern.CalculationRecords;
import pattern.ILightPattern;
import pattern.LightPatternSolver;
import pattern.ProgressVisualizer;

public final class LightPatternSelector<T extends Number> {
    private final View<T> view;
    private boolean calculating;
    private BaseLightPattern<T> selectedBlp;

    public LightPatternSelector(View<T> v) {
        this.view = v;
    }

    public void select(Component src, BaseLightPattern<T> lp, boolean useRecords) {
        if (!this.calculating) {
            this.calculating = true;
            this.selectedBlp = lp;
            SelectPatternRunnable selPatRun = new SelectPatternRunnable(src, lp, useRecords);
            Thread t = new Thread(selPatRun);
            t.setPriority(1);
            t.start();
        }
    }

    private void sel(Component src, final BaseLightPattern<T> lp, boolean useRec) {
        boolean precOk;
        Model<T> model;
        MainMenuBar<T> menuBar = this.view.getMainMenuBar();
        menuBar.deselectAnimationButtonGroup(null);
        boolean changeSize = false;
        Controller<T> ctrl = this.view.getController();
        T percentSize = ctrl.getModel().getShapePercentSize();
        CalculationRecords<Number> rec = null;
        int selRec = -1;
        if (useRec && (rec = (model = ctrl.getModel()).getRecords(lp.getName())) != null) {
            StringBuffer msg = new StringBuffer();
            VecMath<T> mt = model.getMath();
            for (int i = 0; i < rec.getRecords().size(); ++i) {
                Object s = rec.getRecords().get(i).getShapeSize();
                if (mt.cmp(mt.abs(mt.sub(percentSize, s)), mt.EPSILON10) <= 0) {
                    selRec = i;
                    break;
                }
                msg.append("    ").append(i).append(")  r = ");
                String num = model.getMath().util.toPlainString(s);
                if (num.length() > 16) {
                    num = num.substring(0, 16) + "...";
                }
                msg.append(num).append(" %\n");
            }
            msg.append("\n");
            if (selRec == -1) {
                msg.insert(0, "available for the pattern " + lp.getName() + " :\n\n");
                msg.insert(0, "Stored results of previous calculations are ");
                msg.append("Enter the line number of an already calculated ");
                msg.append("radius r or leave the field empty to make a new ");
                msg.append("calculation for the current radius.");
                JTextPane tp = new JTextPane();
                tp.setText(msg.toString());
                int h = tp.getFontMetrics(tp.getFont()).getHeight();
                Dimension dim = new Dimension(300, 130 + rec.getRecords().size() * h);
                tp.setPreferredSize(dim);
                tp.setBackground(this.view.getBackground());
                String line = JOptionPane.showInputDialog(this.view, (Object)tp);
                if (line == null) {
                    this.calculating = false;
                    return;
                }
                line = line.replace(")", "");
                try {
                    selRec = Short.parseShort(line.trim());
                    if (0 <= selRec && selRec < rec.getRecords().size()) {
                        changeSize = true;
                    } else {
                        selRec = -1;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (selRec != -1) {
            percentSize = rec.getRecords().get(selRec).getShapeSize();
        } else if (lp.getMaxShapeSize() != null) {
            model = ctrl.getModel();
            T maxPercentSize = lp.getMaxShapeSize();
            if (model.getMath().cmp(maxPercentSize, percentSize) < 0) {
                int choice = 0;
                if (!Globals.AUTO_RADIUS) {
                    String p1 = model.getMath().util.toPlainString(maxPercentSize);
                    Object p2Val1 = model.getMath().util.round(percentSize, 16);
                    Object p2Val2 = model.getMath().util.round(percentSize, 32);
                    String tail = "";
                    if (model.getMath().cmp(p2Val1, p2Val2) != 0) {
                        tail = "...";
                    }
                    String p2 = model.getMath().util.toPlainString(p2Val1) + tail;
                    String msg = "The maximum radius rmax=" + p1 + "% of the pattern " + lp.getName() + " is smaller than the selected radius" + " r=" + p2 + "%. Do you wan't to select the maximum" + " pattern radius?";
                    JTextPane tp = new JTextPane();
                    tp.setText(msg);
                    tp.setPreferredSize(new Dimension(300, 100));
                    tp.setBackground(this.view.getBackground());
                    choice = JOptionPane.showConfirmDialog(this.view, tp);
                }
                if (choice == 2) {
                    this.calculating = false;
                    return;
                }
                if (choice == 0) {
                    percentSize = maxPercentSize;
                    changeSize = true;
                }
            }
        }
        this.setCursor(src, 3);
        this.setParameters(lp, percentSize);
        short curPrec = Globals.PRECISIONS[Globals.IDX_PREC];
        short lowPrec = Globals.PRECISIONS[Math.max(Globals.IDX_PREC - 1, 0)];
        int maxAc = lp.getAccuracyUpperBound();
        boolean precHighOk = curPrec >= maxAc;
        boolean precLowOk = Globals.IDX_PREC == 0 || lowPrec <= maxAc;
        boolean bl = precOk = curPrec >= maxAc && lowPrec <= maxAc;
        if (!precHighOk || !precLowOk) {
            int prec_idx = 0;
            while (Globals.PRECISIONS[prec_idx] < maxAc) {
                prec_idx = (byte)(prec_idx + 1);
            }
            short reqPrec = Globals.PRECISIONS[prec_idx];
            int choice = 0;
            if (!Globals.AUTO_PREC) {
                String msg = "The pattern " + lp.getName() + " requires a precision of " + maxAc + " digits. " + "The current precision is " + curPrec + " digits. ";
                msg = !precHighOk ? msg + "Increase precision to " + reqPrec + " digits?" : msg + "Lower precision to " + reqPrec + " digits?";
                JTextPane tp = new JTextPane();
                tp.setText(msg);
                tp.setPreferredSize(new Dimension(300, 90));
                tp.setBackground(this.view.getBackground());
                choice = JOptionPane.showConfirmDialog(this.view, tp);
            }
            if (choice == 2) {
                this.setCursor(src, 0);
                this.calculating = false;
                return;
            }
            if (choice == 0) {
                Globals.IDX_PREC = (byte)prec_idx;
                menuBar.setSelectedIdx(Globals.IDX_PREC, menuBar.precMenu, false);
                ctrl.stopCalculation();
                ctrl.waitForCalculatorRelease();
                ctrl.stopScan("Stopped on precision change");
                ctrl.setPrecision(reqPrec);
                if (!changeSize) {
                    percentSize = ctrl.getModel().getShapePercentSize();
                }
                this.setParameters(lp, percentSize);
                precOk = true;
            }
        }
        Number phi = null;
        if (selRec != -1) {
            phi = (Number)rec.getRecords().get(selRec).getAngle();
        } else {
            Window progVis = null;
            if (lp.estimateCalcTime() >= 1) {
                progVis = new ProgressVisualizer(lp.getName(), this.view);
                lp.setProgressListener((LightPatternSolver.IProgressListener)((Object)progVis));
                progVis.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        lp.stopCalc();
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        lp.stopCalc();
                    }
                });
            }
            phi = (Number)lp.getRotation();
            if (progVis != null) {
                progVis.dispose();
            }
        }
        if (phi != null) {
            Model<T> model2 = ctrl.getModel();
            VecMath<T> math = model2.getMath();
            Number phiExt = math.util.copy(phi, math.PRECISION);
            Number[] sinCosPhi = math.sincos(phiExt);
            ctrl.waitForCalculatorRelease();
            if (changeSize) {
                short pSize;
                short ps = ((Number)percentSize).shortValue();
                byte idx = Globals.getIndex(ps, Globals.SHAPE_SIZES);
                if (idx != -1 && math.cmp(percentSize, math.util.cast(pSize = Globals.SHAPE_SIZES[idx])) == 0) {
                    Globals.IDX_SHAPE_SIZE = idx;
                    menuBar.setSelectedIdx(idx, menuBar.shapeSizeMenu, false);
                }
                model2.setShapePercentSize(percentSize);
            }
            if ((Globals.IDX_GRID_SIZE = Globals.getIndex(lp.getGridSize(), Globals.GRID_SIZES)) != -1) {
                JMenu gsm = menuBar.gridSizeMenu;
                menuBar.setSelectedIdx(Globals.IDX_GRID_SIZE, gsm, false);
            } else {
                menuBar.rebuildGridSizeMenu(lp.getGridSize(), false);
            }
            model2.setGridSize(lp.getGridSize());
            model2.setGridRotation(phiExt, sinCosPhi);
            Number worldX = model2.getWorldBox().getCorner()[0];
            worldX = math.add(worldX, model2.getWorldBox().getLengths()[0]);
            Number[] st = null;
            if (selRec != -1) {
                st = math.util.array(2);
                st[0] = rec.getRecords().get(selRec).getDistance();
                st[1] = rec.getRecords().get(selRec).getHeight();
            } else {
                st = lp.getStart(worldX, phi, sinCosPhi);
                st[0] = math.util.round(st[0], 3);
            }
            st[0] = math.util.copy(st[0], math.PRECISION);
            st[1] = math.util.copy(st[1], math.PRECISION);
            model2.getRay().setStart(st);
            model2.setRay(model2.getRay(), lp.getName(), (byte)1);
            ctrl.startCalculation();
            if (useRec && selRec == -1 && precOk) {
                if (rec == null) {
                    rec = new CalculationRecords<T>(lp.getName(), lp.getGridSize(), math);
                }
                Number h = math.util.copy(st[1], maxAc);
                Object angle = math.util.copy(phi, maxAc);
                rec.add((Number)percentSize, math.util.round(st[0], 4), h, (Number)angle);
                model2.addRecords(rec);
            }
        }
        this.setCursor(src, 0);
        this.calculating = false;
    }

    private void setCursor(Component src, int cursor) {
        if (src != null) {
            src.setCursor(Cursor.getPredefinedCursor(cursor));
        }
        this.view.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    private void setParameters(ILightPattern<T> pattern, T percentSize) {
        Model<T> model = this.view.getController().getModel();
        VecMath<T> mt = model.getMath();
        T gap = model.calcGap(pattern.getGridSize());
        T size = mt.mul(percentSize, gap);
        size = mt.div(size, mt.util.cast(200));
        Number[] cor = (Number[])model.getGridInitBound().getCorner().clone();
        pattern.setParameters(cor, (Number)gap, (Number)size);
    }

    public BaseLightPattern<T> getSelected() {
        return this.selectedBlp;
    }

    private class SelectPatternRunnable
    implements Runnable {
        private final BaseLightPattern<T> pattern;
        private final boolean useRecords;
        private final Component src;

        public SelectPatternRunnable(Component src, BaseLightPattern<T> lp, boolean ur) {
            this.src = src;
            this.pattern = lp;
            this.useRecords = ur;
        }

        @Override
        public void run() {
            LightPatternSelector.this.sel(this.src, this.pattern, this.useRecords);
        }
    }
}

