/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import math.VecMath;
import mvc.LightCharMap;
import pattern.LightChar;

public class LightCharTable<T extends Number>
extends JPanel {
    private final LightCharMap<T> map;

    public LightCharTable(LightChar[] lcs, VecMath<T> mt, VecMath<Float> fmt) {
        this.map = new LightCharMap<T>(lcs, mt, fmt);
        this.setBackground(new Color(50, 50, 50));
        Color c = this.getBackground().brighter().brighter();
        this.setBorder(new MatteBorder(10, 10, 10, 10, c));
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.map.refreshComp == null) {
            this.map.refreshComp = this;
        }
        int w = this.getWidth() - 20;
        int h = this.getHeight() - 20;
        float fSize = (float)Math.sqrt(w * h / (2 * this.map.lChars.length));
        int rows = Math.round((float)h / fSize);
        int cols = Math.round((float)w / fSize);
        int iSize = (int)((float)Math.round(fSize) * 0.8f);
        if (cols % 2 == 1) {
            --cols;
            ++rows;
            iSize = (int)((float)Math.round(fSize) * 0.7f);
        }
        if (this.map.iconSize != iSize || this.map.iconMap.size() != this.map.lChars.length) {
            this.map.buildIcons(iSize);
            this.map.iconSize = iSize;
        }
        float rSize = (float)h * 1.0f / (float)rows;
        float cSize = (float)w * 1.0f / (float)cols;
        g.translate(10, 10);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        float cGap = (cSize - (float)this.map.iconSize) / 2.0f;
        float rGap = (rSize - (float)this.map.iconSize) / 2.0f;
        int idx = 0;
        for (int col = 0; col < cols; col += 2) {
            for (int row = 0; row < rows; ++row) {
                LightChar lc;
                ImageIcon icon;
                if (idx >= this.map.lChars.length || (icon = this.map.iconMap.get((lc = this.map.lChars[idx++]).getChar())) == null) continue;
                icon.paintIcon(this, g, (int)((float)col * cSize + cGap), (int)((float)row * rSize + rGap));
            }
        }
        FontRenderContext rctx = ((Graphics2D)g).getFontRenderContext();
        Font font = g.getFont();
        int fntsz = font.getSize() * this.map.iconSize / 25;
        g.setFont(new Font(font.getFontName(), font.getStyle(), fntsz));
        Rectangle2D bnd = g.getFont().getStringBounds("Q", rctx);
        int bs = (int)((bnd.getHeight() + bnd.getWidth()) * (double)0.9f);
        idx = 0;
        Color dcol = g.getColor().darker();
        Color bcol = g.getColor().brighter().brighter();
        for (int col = 1; col < cols; col += 2) {
            for (int row = 0; row < rows; ++row) {
                if (idx >= this.map.lChars.length) continue;
                LightChar lc = this.map.lChars[idx++];
                int x1 = (int)(((double)(col - 1) + 0.5) * (double)cSize);
                int y1 = (int)(((double)row + 0.5) * (double)rSize);
                int x2 = (int)(((double)col + 0.5) * (double)cSize);
                int y2 = (int)(((double)row + 0.5) * (double)rSize);
                g.setColor(bcol);
                g.fillOval(x2 - bs / 2, y2 - bs / 2, bs, bs);
                int vx = x2 - x1;
                int vy = y2 - y1;
                x1 = (int)((double)x1 + 0.6 * (double)vx);
                y1 = (int)((double)y1 + 0.6 * (double)vy);
                x2 = (int)((double)x2 - 0.2 * (double)vx);
                y2 = (int)((double)y2 - 0.2 * (double)vy);
                g.drawLine(x1, y1, x2, y2);
                g.setColor(dcol);
                bnd = g.getFont().getStringBounds(lc.getChar(), rctx);
                float cGap2 = (float)(((double)cSize - bnd.getWidth()) / 2.0);
                float rGap2 = (float)(((double)rSize - bnd.getHeight()) / 2.0);
                int sx = (int)((float)col * cSize + cGap2);
                int sy = (int)((float)row * rSize + rGap2);
                int sy2 = (int)((double)sy + bnd.getHeight() * 3.0 / 4.0 + 2.0);
                g.drawString(lc.getChar(), sx, sy2);
            }
        }
        g.translate(-10, -10);
    }

    public void dispose() {
        this.map.dispose();
    }
}

