/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import lattice.Box2D;
import lattice.Circle;
import lattice.Ray;
import lattice.RayPolygon;
import lattice.ReflectionEngine;
import lattice.ShapeContainer;
import math.Util;
import math.VecMath;
import mvc.PixelMapFloat;
import pattern.BaseLightPattern;
import pattern.LightChar;

public class LightCharMap<T extends Number> {
    static final byte ICON_INI_SIZE = 25;
    private static final byte SHAPE_SIZE = 40;
    private static HashMap<String, float[]> polyMap;
    private boolean calculate = true;
    private final VecMath<T> math;
    private final VecMath<Float> fmath;
    final HashMap<String, ImageIcon> iconMap;
    final LightChar[] lChars;
    int iconSize;
    protected Component refreshComp;
    byte finished = 0;

    public LightCharMap(LightChar[] lcs, VecMath<T> mt, VecMath<Float> fmt) {
        this.math = mt;
        this.fmath = fmt;
        this.lChars = lcs;
        Arrays.sort(this.lChars);
        this.iconMap = new HashMap();
        this.iconSize = 25;
        if (polyMap == null) {
            Log.getIstc().enableLogging(false);
            polyMap = new HashMap();
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int k = 0; k < LightCharMap.this.lChars.length && LightCharMap.this.calculate; k += 2) {
                        polyMap.put(LightCharMap.this.lChars[k].getChar(), LightCharMap.this.calcPolygon(LightCharMap.this.lChars[k]));
                    }
                    LightCharMap.this.refresh();
                    LightCharMap.this.finished = (byte)(LightCharMap.this.finished + 1);
                    if (LightCharMap.this.finished == 2) {
                        Log.getIstc().enableLogging(true);
                    }
                }
            });
            Thread t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int k = LightCharMap.this.lChars.length - 1; k > 0 && LightCharMap.this.calculate; k -= 2) {
                        polyMap.put(LightCharMap.this.lChars[k].getChar(), LightCharMap.this.calcPolygon(LightCharMap.this.lChars[k]));
                        LightCharMap.this.refresh();
                    }
                    LightCharMap.this.finished = (byte)(LightCharMap.this.finished + 1);
                    if (LightCharMap.this.finished == 2) {
                        Log.getIstc().enableLogging(true);
                    }
                }
            });
            t1.start();
            t2.start();
        }
    }

    private void refresh() {
        if (this.refreshComp != null) {
            this.refreshComp.repaint();
        }
    }

    void buildIcons(int size) {
        float gap2 = 25.0f;
        Number[] corner2 = new Float[]{Float.valueOf(-gap2), Float.valueOf(-gap2)};
        Box2D box = new Box2D(corner2, (Number)Float.valueOf(gap2 * 2.0f), this.fmath);
        PixelMapFloat pixMap = new PixelMapFloat(size, size, 0, 0, box);
        for (int k = 0; k < this.lChars.length && this.calculate; ++k) {
            ImageIcon ic;
            LightChar lc = this.lChars[k];
            if (polyMap.get(lc.getChar()) == null || (ic = this.iconMap.get(lc.getChar())) != null && ic.getIconWidth() == size) continue;
            BufferedImage bimg = new BufferedImage(size, size, 1);
            Graphics2D ig = bimg.createGraphics();
            ig.setColor(Color.black);
            ig.fillRect(0, 0, size, size);
            ig.setColor(Color.white);
            ig.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float[] polygon = polyMap.get(lc.getChar());
            for (int i = 0; i < polygon.length - 2; i += 2) {
                short[] p1 = new short[2];
                short[] p2 = new short[2];
                Number[] pt = new Float[]{Float.valueOf(polygon[i]), Float.valueOf(polygon[i + 1])};
                pixMap.world2Pix(pt, p1);
                pt = new Float[]{Float.valueOf(polygon[i + 2]), Float.valueOf(polygon[i + 3])};
                pixMap.world2Pix(pt, p2);
                ig.drawLine(p1[0], p1[1], p2[0], p2[1]);
            }
            ig.dispose();
            bimg.flush();
            ImageIcon icon = new ImageIcon(bimg);
            this.iconMap.put(lc.getChar(), icon);
        }
    }

    private float[] calcPolygon(LightChar lc) {
        BaseLightPattern<T> blp = new BaseLightPattern<T>(this.math);
        blp.setMaxShapeSize(this.math.HUNDRED);
        blp.setGridSize((short)2);
        blp.setPropagating(true);
        blp.setLogging(false);
        List<short[]> cells = lc.getCellSequence();
        blp.setCellSequence(new ArrayList<short[]>(cells));
        blp.setStartIndex(cells.size());
        blp.setInitialGradients(new ArrayList<Float>(lc.getInitialGradients()));
        Util ut = this.math.util;
        if (lc.getOrientation() == LightChar.VERTICAL) {
            if (cells.get(0)[0] == 1) {
                blp.getInitialGradients().set(0, Float.valueOf(-0.2f));
                blp.setStartBndVal(ut.copy(ut.cast(-0.3), this.math.PRECISION));
                blp.setStartBndValType((byte)1);
            } else {
                blp.getInitialGradients().set(0, Float.valueOf(0.2f));
                blp.setStartBndVal(ut.copy(ut.cast(0.3), this.math.PRECISION));
                blp.setStartBndValType((byte)2);
            }
            if (cells.get(cells.size() - 1)[0] == 1) {
                blp.getInitialGradients().set(cells.size() - 1, Float.valueOf(0.2f));
                blp.setEndBndVal(ut.copy(ut.cast(0.3), this.math.PRECISION));
                blp.setEndBndValType((byte)2);
            } else {
                blp.getInitialGradients().set(cells.size() - 1, Float.valueOf(-0.2f));
                blp.setEndBndVal(ut.copy(ut.cast(-0.3), this.math.PRECISION));
                blp.setEndBndValType((byte)1);
            }
        } else {
            if (cells.get(0)[1] == 0) {
                blp.setStartBndVal(ut.copy(this.math.MINUS_ONE, this.math.PRECISION));
            } else {
                blp.setStartBndVal(ut.copy(this.math.ONE, this.math.PRECISION));
            }
            if (cells.get(cells.size() - 1)[1] == 0) {
                blp.setEndBndVal(ut.copy(this.math.ONE, this.math.PRECISION));
            } else {
                blp.setEndBndVal(ut.copy(this.math.MINUS_ONE, this.math.PRECISION));
            }
            blp.setStartBndValType((byte)1);
            blp.setEndBndValType((byte)1);
        }
        Object gap = ut.cast(25);
        Object r = this.math.mul(this.math.div(gap, ut.cast(200)), 40);
        Circle shape = new Circle((Number[])this.math.ZERO2D.clone(), r, this.math);
        Number[] corner = ut.array(2);
        corner[0] = this.math.neg(gap);
        corner[1] = this.math.neg(gap);
        blp.setParameters((Number[])corner.clone(), (Number)gap, (Number)r);
        T phi = blp.getRotation();
        phi = this.math.util.copy(phi, blp.getAccuracy());
        Number[] sinCos = this.math.sincos((Number)phi);
        Number[] start = blp.getStart((Number)gap, (Number)phi, sinCos);
        Number[] dir = ut.array(2);
        dir[0] = this.math.MINUS_ONE;
        dir[1] = this.math.ZERO;
        Ray ray = new Ray(start, dir, ut);
        ShapeContainer shapeCtr = new ShapeContainer((Number[])corner.clone(), 3, gap, this.math);
        shapeCtr.setShape(shape);
        shapeCtr.rotate((Number[])this.math.ZERO2D, null, sinCos[0], sinCos[1]);
        RayPolygon rayPoly = new RayPolygon(ut, 8);
        ReflectionEngine engine = new ReflectionEngine(this.math);
        engine.calcStatic(ray, shapeCtr, rayPoly, null);
        if (lc.getOrientation() != LightChar.VERTICAL) {
            Number[] st = (Number[])((Number[])rayPoly.get(0)).clone();
            this.math.scaleAdd(st, (Number)this.math.neg(this.math.FIVE), rayPoly.getInRay().getDir(), st);
            ((ArrayList)rayPoly).add(0, st);
            Number[] end = (Number[])((Number[])rayPoly.get(rayPoly.size() - 1)).clone();
            this.math.scaleAdd(end, (Number)this.math.FIVE, rayPoly.getOutRay().getDir(), end);
            ((ArrayList)rayPoly).add(end);
        }
        float[] poly = new float[2 * rayPoly.size()];
        for (int i = 0; i < rayPoly.size(); ++i) {
            this.math.rotate2D((Number[])rayPoly.get(i), (Number[])this.math.ZERO2D, this.math.neg(sinCos[0]), sinCos[1]);
            poly[2 * i] = ((Number[])rayPoly.get(i))[0].floatValue();
            poly[2 * i + 1] = ((Number[])rayPoly.get(i))[1].floatValue();
        }
        return poly;
    }

    public void dispose() {
        this.calculate = false;
    }
}

