/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import math.VecMath;
import mvc.IFZLBorder;
import mvc.LightCharMap;
import pattern.LightChar;

public class LightCharBorder<T extends Number>
extends LightCharMap<T>
implements IFZLBorder {
    private final float SHRINK = 0.6f;

    public LightCharBorder(LightChar[] lcs, VecMath<T> mt, VecMath<Float> fmt) {
        super(lcs, mt, fmt);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int cols;
        float fSize = (c.getWidth() + c.getHeight()) / (this.lChars.length / 2 + 2);
        int rows = Math.round((float)c.getHeight() / fSize);
        if (rows + (cols = Math.round((float)c.getWidth() / fSize)) - 2 > this.lChars.length / 2) {
            if (rows > cols) {
                --rows;
            } else {
                --cols;
            }
        }
        int rSize = (int)(1.3800000548362732 * (double)c.getHeight() * 1.0 / (double)rows);
        int cSize = (int)(1.3800000548362732 * (double)c.getWidth() * 1.0 / (double)cols);
        return new Insets(rSize, cSize, rSize, cSize);
    }

    @Override
    public void drawBorder(Component c, Graphics g) {
        int cols;
        int rows;
        float fSize;
        int iSize;
        if (this.refreshComp == null) {
            this.refreshComp = c;
        }
        if (this.iconSize != (iSize = (int)((float)Math.round(fSize = (float)((c.getWidth() + c.getHeight()) / (this.lChars.length / 2 + 2))) * 0.8f)) || this.iconMap.size() != this.lChars.length) {
            this.buildIcons(iSize);
            this.iconSize = iSize;
        }
        if ((rows = Math.round((float)c.getHeight() / fSize)) + (cols = Math.round((float)c.getWidth() / fSize)) - 2 > this.lChars.length / 2) {
            if (rows > cols) {
                --rows;
            } else {
                --cols;
            }
        }
        float rSize = (float)c.getHeight() * 1.0f / (float)rows;
        float cSize = (float)c.getWidth() * 1.0f / (float)cols;
        int dy = (int)(1.3800000548362732 * (double)rSize);
        int dx = (int)(1.3800000548362732 * (double)cSize);
        g.setColor(new Color(60, 60, 60));
        g.fillRect(0, 0, c.getWidth(), dy);
        g.fillRect(0, c.getHeight() - dy, c.getWidth(), dy);
        g.fillRect(0, dy, dx, c.getHeight() - 2 * dy);
        g.fillRect(c.getWidth() - dx, dy, dx, c.getHeight() - 2 * dy);
        float cGap = (cSize - (float)this.iconSize) / 2.0f;
        float rGap = (rSize - (float)this.iconSize) / 2.0f;
        ArrayList<int[]> cells = new ArrayList<int[]>();
        int col = 0;
        while (col < cols) {
            cells.add(new int[]{col++, 0});
        }
        int row = 1;
        while (row < rows) {
            cells.add(new int[]{cols - 1, row++});
        }
        col = cols - 2;
        while (col >= 0) {
            cells.add(new int[]{col--, rows - 1});
        }
        row = rows - 2;
        while (row >= 0) {
            cells.add(new int[]{0, row--});
        }
        int idx = 0;
        for (int i = 0; i < cells.size(); ++i) {
            LightChar lc;
            int col2 = ((int[])cells.get(i))[0];
            int row2 = ((int[])cells.get(i))[1];
            if (idx >= this.lChars.length || this.iconMap.get((lc = this.lChars[idx++]).getChar()) == null) continue;
            ImageIcon icon = (ImageIcon)this.iconMap.get(lc.getChar());
            icon.paintIcon(c, g, (int)((float)col2 * cSize + cGap), (int)((float)row2 * rSize + rGap));
        }
        float rSize2 = ((float)c.getHeight() - 1.2f * rSize) / (float)rows;
        float cSize2 = ((float)c.getWidth() - 1.2f * cSize) / (float)cols;
        FontRenderContext rctx = ((Graphics2D)g).getFontRenderContext();
        Font font = g.getFont();
        int fntsz = (int)((float)font.getSize() * 0.05f * (float)this.iconSize);
        g.setFont(new Font(font.getFontName(), font.getStyle(), fntsz));
        Rectangle2D bnd = g.getFont().getStringBounds("Q", rctx);
        int bs = (int)((bnd.getHeight() + bnd.getWidth()) * (double)0.9f);
        idx = 0;
        Color dcol = g.getColor().darker();
        Color bcol = g.getColor().brighter().brighter();
        bcol = new Color(bcol.getRed(), bcol.getGreen(), bcol.getBlue(), 130);
        for (int i = 0; i < cells.size(); ++i) {
            int col3 = ((int[])cells.get(i))[0];
            int row3 = ((int[])cells.get(i))[1];
            if (idx >= this.lChars.length) continue;
            LightChar lc = this.lChars[idx++];
            int x1 = (int)(((double)col3 + 0.5) * (double)cSize);
            int y1 = (int)(((double)row3 + 0.5) * (double)rSize);
            int x2 = (int)(((double)col3 + 0.5) * (double)cSize2 + (double)(0.6f * cSize));
            int y2 = (int)(((double)row3 + 0.5) * (double)rSize2 + (double)(0.6f * rSize));
            g.setColor(bcol);
            g.fillOval(x2 - bs / 2, y2 - bs / 2, bs, bs);
            int vx = x2 - x1;
            int vy = y2 - y1;
            x1 = (int)((double)x1 + 0.4 * (double)vx);
            y1 = (int)((double)y1 + 0.4 * (double)vy);
            x2 = (int)((double)x2 - 0.2 * (double)vx);
            y2 = (int)((double)y2 - 0.2 * (double)vy);
            g.drawLine(x1, y1, x2, y2);
            g.setColor(dcol);
            bnd = g.getFont().getStringBounds(lc.getChar(), rctx);
            float cGap2 = (float)(((double)cSize2 - bnd.getWidth()) / 2.0);
            float rGap2 = (float)(((double)rSize2 - bnd.getHeight()) / 2.0);
            int sx = (int)((float)col3 * cSize2 + cGap2 + 0.6f * cSize);
            int sy = (int)((float)row3 * rSize2 + rGap2 + 0.6f * rSize);
            int sy2 = (int)((double)sy + bnd.getHeight() * 3.0 / 4.0 + 2.0);
            g.drawString(lc.getChar(), sx, sy2);
        }
    }

    @Override
    public void setColor(Color c) {
    }
}

