/*
 * Decompiled with CFR 0.152.
 */
package mvc;

import common.ColorTheme;
import common.FileIO;
import common.Globals;
import common.ICallback;
import common.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lattice.Box2D;
import lattice.Circle;
import lattice.IBox;
import lattice.Ray;
import math.Util;
import math.VecMath;
import mvc.AnimatePatterns;
import mvc.AnimateRotation;
import mvc.IModelListener;
import mvc.MainMenuBar;
import mvc.Model;
import mvc.PixelMap;
import mvc.ScanSession;
import mvc.View;
import mvc.Visualizer;
import mvc.scan.Observables;
import mvc.scan.ScanListener;
import pattern.BaseLightPattern;
import pattern.CalculationRecords;
import pattern.LightChar;
import pattern.LightCharPattern;
import pattern.LightPatternSolver;

public final class Controller<T extends Number> {
    public static final byte WIN_YES = 0;
    public static final byte WIN_FULLSCREEN = 1;
    public static final byte WIN_SCREENSAVER = 2;
    public static final byte WIN_MUSEUM = 5;
    public static final byte WIN_MUSEUM_FULL = 6;
    public static final byte WIN_NO_FILE = 3;
    public static final byte WIN_NO_PRINT = 4;
    public static final short UPDATE_DELAY = 200;
    private static final short ANIM_STEPS_PER_SEC = 15;
    private final View<T> view;
    private Model<T> model;
    private ScanRunnable scanRun;
    private final CalcReflectionsRunnable calcRun = new CalcReflectionsRunnable();
    private AnimateRotation<T> animRotRun;
    private AnimatePatterns<T> animPatRun;

    public Controller(VecMath<T> math, T radius, BaseLightPattern<T> blp, CalculationRecords.Record rec, ColorTheme ct, byte win) {
        this.model = this.buildModel(math, radius, null);
        this.initModel(math, blp, rec);
        if (Controller.hasWindow(win)) {
            ICallback cb = new ICallback(){
                int ctr = 0;

                @Override
                public void call() {
                    if (0 == this.ctr++) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String d = Controller.this.model.getDescription();
                                Controller.this.model.setRay(Controller.this.model.getRay(), d, (byte)1);
                                Controller.this.startCalculation();
                            }
                        });
                    }
                }
            };
            this.view = new View(this, ct, cb, win);
        } else {
            this.view = null;
        }
    }

    public void setPrecision(int precision) {
        Log.getIstc().logln("Precision set to " + precision + ". Rebuilding model...");
        VecMath<T> math = this.model.getMath();
        math.setPrecision(precision);
        List<IModelListener> modelListeners = this.model.getModelListeners();
        List<ScanListener> scanListeners = this.model.getScanListeners();
        T ps = this.model.getShapePercentSize();
        T angle = this.model.getGridRotation();
        this.model = this.buildModel(math, ps, angle);
        for (IModelListener ml : modelListeners) {
            this.model.addModelListener(ml);
            ml.modelChanged((byte)40);
        }
        for (ScanListener sl : scanListeners) {
            this.model.addScanListener(sl);
        }
        this.initModel(math, null, null);
        Log.getIstc().logln("... rebuilding model finished.");
    }

    private Model<T> buildModel(VecMath<T> math, T oldPercentSize, T angle) {
        Visualizer<T> rv;
        Number[] gridCorner = math.util.array(2);
        gridCorner[0] = math.util.cast(-1);
        gridCorner[1] = math.util.cast(-1);
        Number[] worldLengths = null;
        if (this.view != null && (rv = this.view.getReflectionVisualizer()) != null && rv.getPixelMap() != null) {
            short h = rv.getPixelMap().canvasHeight();
            short w = rv.getPixelMap().canvasWidth();
            worldLengths = this.createNewWorld(w, h, math).getLengths();
        }
        if (worldLengths == null) {
            worldLengths = math.util.array(2);
            worldLengths[0] = math.util.cast(3);
            worldLengths[1] = math.util.cast(3);
        }
        short points = (short)(Globals.GRID_SIZES[Globals.IDX_GRID_SIZE] + 1);
        Object size = math.util.copy(math.util.cast(points - 1), math.PRECISION);
        Object gap = math.div(math.util.cast(2), size);
        Model m = new Model(gridCorner, points, gap, worldLengths, math);
        m.setShape(new Circle((Number[])math.ZERO2D.clone(), math.ONE, math));
        if (Globals.IDX_SHAPE_SIZE != -1) {
            short shapeSize = Globals.SHAPE_SIZES[Globals.IDX_SHAPE_SIZE];
            m.setShapePercentSize((byte)shapeSize);
        } else {
            Object ps = math.util.expand(oldPercentSize, math.PRECISION);
            m.setShapePercentSize(ps);
        }
        if (angle != null) {
            Object phi = math.util.expand(angle, math.PRECISION);
            m.setGridRotation(phi);
        }
        return m;
    }

    Box2D<T> createNewWorld(int w, int h, VecMath<T> mt) {
        Object msl = mt.util.cast(3);
        Box2D newWorld = new Box2D(mt.util.array(2), mt.ONE, mt);
        if (w <= h) {
            newWorld.setLength(msl, (byte)0);
            Object newLength = mt.mul(msl, mt.util.cast(h));
            Object w_t = mt.util.copy(mt.util.cast(w), mt.PRECISION);
            newLength = mt.div(newLength, w_t);
            newWorld.setLength(newLength, (byte)1);
            Number[] corner = mt.util.array(2);
            corner[0] = mt.mul(mt.neg(msl), mt.ONE_OVER_TWO);
            corner[1] = mt.mul(mt.neg(newLength), mt.ONE_OVER_TWO);
            newWorld.setCorner(corner);
        } else {
            newWorld.setLength(msl, (byte)1);
            Object newLength = mt.mul(msl, mt.util.cast(w));
            Object h_t = mt.util.copy(mt.util.cast(h), mt.PRECISION);
            newLength = mt.div(newLength, h_t);
            newWorld.setLength(newLength, (byte)0);
            Number[] corner = mt.util.array(2);
            corner[0] = mt.mul(mt.neg(newLength), mt.ONE_OVER_TWO);
            corner[1] = mt.mul(mt.neg(msl), mt.ONE_OVER_TWO);
            newWorld.setCorner(corner);
        }
        return newWorld;
    }

    private void initModel(VecMath<T> mt, BaseLightPattern<T> blp, CalculationRecords.Record rec) {
        Number[] start = null;
        if (rec != null) {
            this.model.setRecord(rec, (short)-1);
        } else if (blp != null) {
            IBox<T> gib = this.model.getGridInitBound();
            Number[] corner = (Number[])gib.getCorner().clone();
            short size = blp.getGridSize();
            T gap = this.model.calcGap(size);
            T r = this.model.calcShapeSize(size);
            T maxSize = mt.mul((Number)blp.getMaxShapeSize(), (Number)gap);
            if (mt.cmp((Number)r, (Number)(maxSize = mt.div((Number)maxSize, (Number)mt.util.cast(200)))) > 0) {
                Log.getIstc().log("Warning: The max. radius of pattern " + blp.getName() + " is lower than the current radius.\n");
            }
            blp.setParameters(corner, (Number)gap, (Number)r);
            short curPrec = Globals.PRECISIONS[Globals.IDX_PREC];
            int maxAc = blp.getAccuracyUpperBound();
            if (curPrec < maxAc) {
                Log.getIstc().log("Warning: Current precision is to low for pattern " + blp.getName() + ".\n");
            }
            Object phi = mt.util.copy(blp.getRotation(), mt.PRECISION);
            Number[] sinCosPhi = this.model.getMath().sincos((Number)phi);
            this.model.setGridRotation((Number)phi, sinCosPhi);
            Number worldX = this.model.getWorldBox().getCorner()[0];
            worldX = mt.add(worldX, this.model.getWorldBox().getLengths()[0]);
            start = blp.getStart(worldX, (Number)phi, sinCosPhi);
            start[0] = mt.util.copy(start[0], mt.PRECISION);
            start[1] = mt.util.copy(start[1], mt.PRECISION);
            Ray ray = new Ray(start, this.model.LIGHT_SOURCE_DIR, mt.util);
            this.model.setRay(ray, blp.getName(), (byte)1);
        } else {
            Util ut = mt.util;
            start = ut.array(2);
            Number worldWidth = this.model.getWorldBox().getLengths()[0];
            start[0] = ut.round(mt.div(worldWidth, (Number)mt.TWO), 2);
            start[0] = ut.expand(start[0], mt.PRECISION);
            start[1] = ut.expand(mt.util.parse("-0.214"), mt.PRECISION);
            Ray ray = new Ray(start, this.model.LIGHT_SOURCE_DIR, mt.util);
            this.model.setRay(ray, (byte)1);
        }
    }

    public Model<T> getModel() {
        return this.model;
    }

    public View<T> getView() {
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRotAnim(double phiPerMinute) {
        if (this.animRotRun == null) {
            this.animRotRun = new AnimateRotation(this);
        }
        if (!this.animRotRun.run) {
            AnimateRotation<T> animateRotation = this.animRotRun;
            synchronized (animateRotation) {
                float dPhi = (float)phiPerMinute / 900.0f;
                int pause = 66;
                this.animRotRun.setPhi(dPhi);
                this.animRotRun.pause = pause;
                this.animRotRun.run = true;
                Thread t = new Thread(this.animRotRun);
                t.setPriority(1);
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRotAnim() {
        if (this.animRotRun != null) {
            this.animRotRun.run = false;
        }
        AnimateRotation<T> animateRotation = this.animRotRun;
        synchronized (animateRotation) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPatAnim(int startIdx, short gridSize, byte speed) {
        if (this.animPatRun == null) {
            this.animPatRun = new AnimatePatterns(this, startIdx, gridSize);
        }
        this.animPatRun.speed = speed;
        if (!this.animPatRun.run2) {
            AnimatePatterns<T> animatePatterns = this.animPatRun;
            synchronized (animatePatterns) {
                this.animPatRun.run2 = true;
                Thread t = new Thread(this.animPatRun);
                t.setPriority(1);
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPatAnim() {
        if (this.animPatRun != null) {
            this.animPatRun.run2 = false;
            this.animPatRun.run = false;
        }
        AnimatePatterns<T> animatePatterns = this.animPatRun;
        synchronized (animatePatterns) {
            this.animPatRun = null;
        }
    }

    public float getRotAnimSpeed() {
        if (this.animRotRun != null) {
            return this.animRotRun.getPhi() * 60.0f * 15.0f;
        }
        return 0.0f;
    }

    public int getPatAnimPos() {
        if (this.animPatRun != null) {
            return this.animPatRun.idx;
        }
        return -1;
    }

    public byte getPatAnimSpeed() {
        if (this.animPatRun != null) {
            return this.animPatRun.speed;
        }
        return -1;
    }

    public boolean isRotAnimRun() {
        if (this.animRotRun != null) {
            return this.animRotRun.run;
        }
        return false;
    }

    public boolean isPatAnimRun() {
        if (this.animPatRun != null) {
            return this.animPatRun.run2;
        }
        return false;
    }

    public void setRayLater(Ray<T> r) {
        if (this.isRotAnimRun()) {
            this.animRotRun.rayCache.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan(Observables obs, PixelMap<T> pmap) {
        if (this.scanRun == null) {
            this.scanRun = new ScanRunnable();
        }
        ScanRunnable scanRunnable = this.scanRun;
        synchronized (scanRunnable) {
            this.scanRun.session.stop = false;
            this.scanRun.session.msg = null;
            this.scanRun.obs = obs;
            this.scanRun.pmap = pmap;
            Thread t = new Thread(this.scanRun);
            t.setPriority(1);
            t.start();
        }
    }

    public void stopScan(String msg) {
        if (this.scanRun != null) {
            this.scanRun.session.stop = true;
            this.scanRun.session.msg = msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopCalculation() {
        Model<T> model = this.model;
        synchronized (model) {
            if (this.calcRun.requestRun) {
                this.model.setCalculatorActive(false);
                return true;
            }
        }
        return false;
    }

    public void startCalculation() {
        if (!this.calcRun.requestRun) {
            this.calcRun.requestRun = true;
            Thread t = new Thread(this.calcRun);
            t.setPriority(1);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCalculatorRelease() {
        CalcReflectionsRunnable calcReflectionsRunnable = this.calcRun;
        synchronized (calcReflectionsRunnable) {
            while (this.calcRun.requestRun) {
                try {
                    this.calcRun.wait();
                }
                catch (Exception e) {
                    Log.getIstc().log(e);
                }
            }
            return;
        }
    }

    public static <T extends Number> void launch(VecMath<T> mt, String radius, String pattern, String theme, String text, String record, byte anim, byte win, boolean info) {
        ColorTheme ct;
        BaseLightPattern<T> blp;
        CalculationRecords.Record rec;
        Number r;
        short size;
        FileIO<T> fileio;
        block34: {
            fileio = new FileIO<T>(mt, null);
            if (!Controller.hasWindow(win)) {
                anim = (byte)-1;
                if (record != null) {
                    System.out.println("Error: Incompatible options.");
                    System.exit(1);
                }
            } else if (win != 2) {
                String home = System.getProperty("user.home");
                fileio.setUserCfgDir(home + File.separator + ".frozenlight");
                Controller.install(win, fileio);
            }
            if (anim != -1) {
                pattern = null;
                text = null;
                record = null;
            }
            size = -1;
            r = radius != null ? (Number)((Number)mt.util.parse(radius)) : (Number)null;
            rec = null;
            blp = null;
            try {
                CalculationRecords<Number> recs;
                if (text != null) {
                    LightChar[] lcs = fileio.loadLightChars();
                    String s = text.substring(0, Math.min(text.length(), 20));
                    blp = new LightCharPattern<T>("Text: " + s + "...", text, lcs, mt);
                    size = blp.getGridSize();
                    break block34;
                }
                if (pattern != null) {
                    blp = fileio.loadLightPattern(pattern);
                    if (blp != null) {
                        size = blp.getGridSize();
                        if (r == null && mt.cmp(r = (Number)mt.util.parse("50"), (Number)blp.getMaxShapeSize()) > 0) {
                            r = blp.getMaxShapeSize();
                        }
                        if ((recs = fileio.loadRecords(pattern)) != null) {
                            rec = recs.getRecord(r);
                        }
                        break block34;
                    }
                    throw new Exception("Error: Pattern " + pattern + " not found");
                }
                if (record == null) break block34;
                recs = fileio.loadRecords(new File(record));
                if (recs != null) {
                    rec = recs.getRecord(0);
                    size = recs.getGridSize();
                    break block34;
                }
                throw new Exception("Error: Record " + record + " not found");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.exit(1);
            }
        }
        if (r == null) {
            r = (Number)mt.util.parse("50");
        }
        Globals.IDX_SHAPE_SIZE = (byte)-1;
        if (mt.cmp(r, (Number)mt.util.parse(r.byteValue() + "")) == 0) {
            byte idx;
            Globals.IDX_SHAPE_SIZE = idx = Globals.getIndex(r.byteValue(), Globals.SHAPE_SIZES);
        }
        Controller.adjustPrecision(mt, blp, rec, r);
        mt.enableTables();
        if (size != -1) {
            short idx = Globals.getIndex(size, Globals.GRID_SIZES);
            if (idx == -1) {
                Globals.addGridSize(size);
            }
            Globals.IDX_GRID_SIZE = Globals.getIndex(size, Globals.GRID_SIZES);
        }
        if ((ct = fileio.loadColorTheme(theme)) == null) {
            ct = new ColorTheme();
        }
        if (info) {
            System.out.println("Calculating pattern " + blp.getName() + "...");
            System.out.println("Estimated time: " + blp.estimateCalcTime() + " sec\n");
            blp.setProgressListener(new ConsoleProgress());
        }
        Controller<Number> c = new Controller<Number>(mt, r, blp, rec, ct, win);
        if (blp != null) {
            CalculationRecords<T> recs;
            if (win == 3) {
                recs = c.model.getRecords(blp.getName());
                if (recs == null) {
                    recs = c.model.createRecord(blp.getName(), mt.PRECISION);
                }
                c.model.addRecords(recs);
                System.exit(0);
            } else if (win == 4) {
                recs = c.model.createRecord(blp.getName(), mt.PRECISION);
                List<CalculationRecords.Record> recList = recs.getRecords();
                while (recList.size() > 1) {
                    recList.remove(0);
                }
                recs.setRecords(recList);
                System.out.println(recs.toString());
                System.exit(0);
            }
        }
        MainMenuBar<Number> mb = c.getView().getMainMenuBar();
        if (anim != -1) {
            if (win != 2) {
                switch (anim) {
                    case 1: {
                        mb.setSelected("Slow", mb.animMenu, true);
                        break;
                    }
                    case 2: {
                        mb.setSelected("Medium", mb.animMenu, true);
                        break;
                    }
                    case 3: {
                        mb.setSelected("Fast", mb.animMenu, true);
                        break;
                    }
                    case 4: {
                        mb.setSelected("Turbo", mb.animMenu, true);
                    }
                }
            } else {
                c.startPatAnim(0, (short)-1, anim);
            }
        }
    }

    static <T extends Number> void adjustPrecision(VecMath<T> mt, BaseLightPattern<T> blp, CalculationRecords.Record rec, T r) {
        int prec = -1;
        if (rec != null) {
            Object h = mt.util.parse(rec.getHeight().toString());
            prec = mt.util.precision(h);
        } else if (blp != null) {
            Number[] corner = mt.util.array(2);
            corner[0] = mt.util.cast(-1);
            corner[1] = mt.util.cast(-1);
            short size = blp.getGridSize();
            Object s = mt.util.copy(mt.util.cast(size), mt.PRECISION);
            Object gap = mt.div(mt.util.cast(2), s);
            Object gapOverTwo = mt.div(gap, mt.TWO);
            Object rp = mt.util.copy(mt.div(r, mt.HUNDRED), mt.PRECISION);
            Object r0 = mt.mul(gapOverTwo, rp);
            blp.setParameters(corner, (Number)gap, (Number)r0);
            prec = blp.getAccuracyUpperBound();
        }
        if (prec != -1) {
            Globals.adjustPrecision(prec);
            mt.setPrecision(Globals.PRECISIONS[Globals.IDX_PREC]);
        }
    }

    private static <T extends Number> void install(byte win, FileIO<T> fileio) {
        if (!FileIO.checkUserConfigDir()) {
            PrintStream ps;
            ByteArrayOutputStream baos;
            String txt;
            try {
                FileIO.createUserConfigDir();
            }
            catch (Exception e) {
                txt = "Installation Error. ";
                txt = txt + "Can't create the following directories:\n\n";
                txt = txt + FileIO.getUserCfgDir() + "\n";
                txt = txt + FileIO.getUserPatternDir() + "\n";
                txt = txt + FileIO.getUserRecordDir() + "\n\n";
                txt = txt + "Error message: " + e.getMessage() + "\n";
                baos = new ByteArrayOutputStream();
                ps = new PrintStream(baos);
                e.printStackTrace(ps);
                txt = txt + new String(baos.toByteArray());
                if (Controller.hasWindow(win)) {
                    JOptionPane.showMessageDialog(null, txt);
                } else {
                    System.err.println(txt);
                }
                System.exit(1);
            }
            try {
                fileio.installUserConfigs();
            }
            catch (Exception e) {
                txt = "Installation Error. Can't copy the ";
                txt = txt + "lightpatterns and records into the directories:\n\n";
                txt = txt + FileIO.getUserPatternDir() + "\n";
                txt = txt + FileIO.getUserRecordDir() + "\n\n";
                txt = txt + "Error message: " + e.getMessage() + "\n";
                baos = new ByteArrayOutputStream();
                ps = new PrintStream(baos);
                e.printStackTrace(ps);
                txt = txt + new String(baos.toByteArray());
                if (Controller.hasWindow(win)) {
                    JOptionPane.showMessageDialog(null, txt);
                }
                System.err.println(txt);
            }
        }
    }

    private static boolean hasWindow(byte win) {
        return win == 0 || win == 2 || win == 1 || win == 5 || win == 6;
    }

    final class CalcReflectionsRunnable
    implements Runnable {
        private boolean requestRun = false;

        CalcReflectionsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CalcReflectionsRunnable calcReflectionsRunnable = this;
            synchronized (calcReflectionsRunnable) {
                try {
                    Controller.this.model.calculateReflections();
                }
                catch (Exception e) {
                    Log.getIstc().log(e);
                }
                Model model = Controller.this.model;
                synchronized (model) {
                    Controller.this.model.setCalculatorActive(true);
                    this.requestRun = false;
                }
                this.notify();
            }
        }
    }

    final class ScanRunnable
    implements Runnable {
        ScanSession<T> session;
        PixelMap<T> pmap;
        Observables obs;
        int maxPrecision;

        ScanRunnable() {
            this.session = new ScanSession(Controller.this.model);
        }

        @Override
        public synchronized void run() {
            this.session.init(this.pmap, this.obs);
            this.session.scanObservables();
        }
    }

    static final class ConsoleProgress
    implements LightPatternSolver.IProgressListener {
        int k = 0;

        ConsoleProgress() {
        }

        @Override
        public void updateAccuracy(int digits, int maxDigits) {
            int l = (int)((float)digits * 100.0f / (float)maxDigits);
            if (l > 97) {
                System.out.print("");
            }
            while (l > this.k) {
                if (this.k == 0) {
                    System.out.print("o = 2% : ");
                } else {
                    if (this.k % 2 == 0) {
                        System.out.print("o");
                    }
                    if (this.k % 10 == 0) {
                        System.out.print(" ");
                    }
                }
                if (++this.k != 100) continue;
                System.out.print("o\n");
            }
        }
    }
}

